/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.Statistics;

public class ColumnEncoderRecode
extends ColumnEncoder {
    private static final long serialVersionUID = 8213163881283341874L;
    public static boolean SORT_RECODE_MAP = false;
    private HashMap<String, Long> _rcdMap = new HashMap();
    private HashSet<Object> _rcdMapPart = null;

    public ColumnEncoderRecode(int colID) {
        super(colID);
    }

    public ColumnEncoderRecode() {
        this(-1);
    }

    private ColumnEncoderRecode(int colID, HashMap<String, Long> rcdMap) {
        super(colID);
        this._rcdMap = rcdMap;
    }

    public static String constructRecodeMapEntry(String token, Long code) {
        StringBuilder sb = new StringBuilder(token.length() + 16);
        return ColumnEncoderRecode.constructRecodeMapEntry(token, code, sb);
    }

    private static String constructRecodeMapEntry(String token, Long code, StringBuilder sb) {
        sb.setLength(0);
        return sb.append(token).append("\u00b7").append(code).toString();
    }

    public static String[] splitRecodeMapEntry(String value) {
        int pos = value.lastIndexOf("\u00b7");
        return new String[]{value.substring(0, pos), value.substring(pos + 1)};
    }

    public HashMap<String, Long> getCPRecodeMaps() {
        return this._rcdMap;
    }

    public HashSet<Object> getCPRecodeMapsPartial() {
        return this._rcdMapPart;
    }

    public void sortCPRecodeMaps() {
        ColumnEncoderRecode.sortCPRecodeMaps(this._rcdMap);
    }

    private static void sortCPRecodeMaps(HashMap<String, Long> map) {
        Object[] keys = map.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        map.clear();
        for (Object key : keys) {
            ColumnEncoderRecode.putCode(map, (String)key);
        }
    }

    private static void makeRcdMap(CacheBlock in, HashMap<String, Long> map, int colID, int startRow, int blk) {
        for (int row = startRow; row < UtilFunctions.getEndIndex(in.getNumRows(), startRow, blk); ++row) {
            String key = in.getString(row, colID - 1);
            if (key == null || key.isEmpty() || map.containsKey(key)) continue;
            ColumnEncoderRecode.putCode(map, key);
        }
        if (SORT_RECODE_MAP) {
            ColumnEncoderRecode.sortCPRecodeMaps(map);
        }
    }

    private long lookupRCDMap(String key) {
        Long tmp = this._rcdMap.get(key);
        return tmp != null ? tmp : -1L;
    }

    @Override
    protected ColumnEncoder.TransformType getTransformType() {
        return ColumnEncoder.TransformType.RECODE;
    }

    @Override
    public void build(CacheBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        ColumnEncoderRecode.makeRcdMap(in, this._rcdMap, this._colID, 0, in.getNumRows());
        if (DMLScript.STATISTICS) {
            Statistics.incTransformRecodeBuildTime(System.nanoTime() - t0);
        }
    }

    @Override
    public Callable<Object> getBuildTask(CacheBlock in) {
        return new ColumnRecodeBuildTask(this, in);
    }

    @Override
    public Callable<Object> getPartialBuildTask(CacheBlock in, int startRow, int blockSize, HashMap<Integer, Object> ret) {
        return new RecodePartialBuildTask(in, this._colID, startRow, blockSize, ret);
    }

    @Override
    public Callable<Object> getPartialMergeBuildTask(HashMap<Integer, ?> ret) {
        return new RecodeMergePartialBuildTask(this, ret);
    }

    protected static void putCode(HashMap<String, Long> map, String key) {
        map.put(key, Long.valueOf(map.size() + 1));
    }

    @Override
    protected double getCode(CacheBlock in, int r) {
        String key;
        String okey = in.getString(r, this._colID - 1);
        String string = key = okey != null ? okey.toString() : null;
        if (key == null || key.isEmpty()) {
            return Double.NaN;
        }
        long code = this.lookupRCDMap(key);
        return code < 0L ? Double.NaN : (double)code;
    }

    @Override
    public void prepareBuildPartial() {
        if (this._rcdMapPart == null) {
            this._rcdMapPart = new HashSet();
        }
    }

    @Override
    public void buildPartial(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        for (int i = 0; i < in.getNumRows(); ++i) {
            this._rcdMapPart.add(in.get(i, this._colID - 1));
        }
        this._rcdMapPart.remove(null);
        this._rcdMapPart.remove("");
    }

    @Override
    protected ColumnEncoder.ColumnApplyTask<? extends ColumnEncoder> getSparseTask(CacheBlock in, MatrixBlock out, int outputCol, int startRow, int blk) {
        return new RecodeSparseApplyTask(this, in, out, outputCol, startRow, blk);
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (!(other instanceof ColumnEncoderRecode)) {
            super.mergeAt(other);
            return;
        }
        assert (other._colID == this._colID);
        ColumnEncoderRecode otherRec = (ColumnEncoderRecode)other;
        HashMap<String, Long> otherMap = otherRec._rcdMap;
        if (otherMap != null) {
            for (Map.Entry<String, Long> entry : otherMap.entrySet()) {
                if (this.lookupRCDMap(entry.getKey()) != -1L) continue;
                ColumnEncoderRecode.putCode(this._rcdMap, entry.getKey());
            }
        }
    }

    public int getNumDistinctValues() {
        return this._rcdMap.size();
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        if (!this.isApplicable()) {
            return meta;
        }
        meta.ensureAllocatedColumns(this.getNumDistinctValues());
        StringBuilder sb = new StringBuilder();
        int rowID = 0;
        for (Map.Entry<String, Long> e : this._rcdMap.entrySet()) {
            meta.set(rowID++, this._colID - 1, ColumnEncoderRecode.constructRecodeMapEntry(e.getKey(), e.getValue(), sb));
        }
        meta.getColumnMetadata(this._colID - 1).setNumDistinct(this.getNumDistinctValues());
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        this._rcdMap = meta.getRecodeMap(this._colID - 1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this._rcdMap.size());
        for (Map.Entry<String, Long> e : this._rcdMap.entrySet()) {
            out.writeUTF(e.getKey());
            out.writeLong(e.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        int size = in.readInt();
        for (int j = 0; j < size; ++j) {
            String key = in.readUTF();
            Long value = in.readLong();
            this._rcdMap.put(key, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnEncoderRecode that = (ColumnEncoderRecode)o;
        return Objects.equals(this._rcdMap, that._rcdMap);
    }

    public int hashCode() {
        return Objects.hash(this._rcdMap);
    }

    public HashMap<String, Long> getRcdMap() {
        return this._rcdMap;
    }

    private static class ColumnRecodeBuildTask
    implements Callable<Object> {
        private final ColumnEncoderRecode _encoder;
        private final CacheBlock _input;

        protected ColumnRecodeBuildTask(ColumnEncoderRecode encoder, CacheBlock input) {
            this._encoder = encoder;
            this._input = input;
        }

        @Override
        public Void call() throws Exception {
            this._encoder.build(this._input);
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "<ColId: " + this._encoder._colID + ">";
        }
    }

    private static class RecodeMergePartialBuildTask
    implements Callable<Object> {
        private final HashMap<Integer, ?> _partialMaps;
        private final ColumnEncoderRecode _encoder;

        private RecodeMergePartialBuildTask(ColumnEncoderRecode encoderRecode, HashMap<Integer, ?> partialMaps) {
            this._partialMaps = partialMaps;
            this._encoder = encoderRecode;
        }

        @Override
        public Object call() throws Exception {
            long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            HashMap<String, Long> rcdMap = this._encoder.getRcdMap();
            this._partialMaps.forEach((start_row, map) -> ((HashMap)map).forEach((k, v) -> {
                if (!rcdMap.containsKey((String)k)) {
                    ColumnEncoderRecode.putCode(rcdMap, (String)k);
                }
            }));
            this._encoder._rcdMap = rcdMap;
            if (DMLScript.STATISTICS) {
                Statistics.incTransformRecodeBuildTime(System.nanoTime() - t0);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "<ColId: " + this._encoder._colID + ">";
        }
    }

    private static class RecodePartialBuildTask
    implements Callable<Object> {
        private final CacheBlock _input;
        private final int _blockSize;
        private final int _startRow;
        private final int _colID;
        private final HashMap<Integer, Object> _partialMaps;

        protected RecodePartialBuildTask(CacheBlock input, int colID, int startRow, int blocksize, HashMap<Integer, Object> partialMaps) {
            this._input = input;
            this._blockSize = blocksize;
            this._colID = colID;
            this._startRow = startRow;
            this._partialMaps = partialMaps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HashMap<String, Long> call() throws Exception {
            long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            HashMap partialMap = new HashMap();
            ColumnEncoderRecode.makeRcdMap(this._input, partialMap, this._colID, this._startRow, this._blockSize);
            HashMap<Integer, Object> hashMap = this._partialMaps;
            synchronized (hashMap) {
                this._partialMaps.put(this._startRow, partialMap);
            }
            if (DMLScript.STATISTICS) {
                Statistics.incTransformRecodeBuildTime(System.nanoTime() - t0);
            }
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "<Start row: " + this._startRow + "; Block size: " + this._blockSize + ">";
        }
    }

    private static class RecodeSparseApplyTask
    extends ColumnEncoder.ColumnApplyTask<ColumnEncoderRecode> {
        public RecodeSparseApplyTask(ColumnEncoderRecode encoder, CacheBlock input, MatrixBlock out, int outputCol) {
            super(encoder, input, out, outputCol);
        }

        protected RecodeSparseApplyTask(ColumnEncoderRecode encoder, CacheBlock input, MatrixBlock out, int outputCol, int startRow, int blk) {
            super(encoder, input, out, outputCol, startRow, blk);
        }

        @Override
        public Object call() throws Exception {
            long t0;
            long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            if (this._out.getSparseBlock() == null) {
                return null;
            }
            ((ColumnEncoderRecode)this._encoder).applySparse(this._input, this._out, this._outputCol, this._startRow, this._blk);
            if (DMLScript.STATISTICS) {
                Statistics.incTransformRecodeApplyTime(System.nanoTime() - t0);
            }
            return null;
        }

        @Override
        public String toString() {
            String str = this.getClass().getSimpleName() + "<ColId: " + ((ColumnEncoderRecode)this._encoder)._colID + ">";
            if (this._blk != -1) {
                str = str + "<Sr: " + this._startRow + ">";
            }
            return str;
        }
    }
}

