/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.concurrent.Executors;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.TriggerRDDOperationsTask;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class PrefetchCPInstruction
extends UnaryCPInstruction {
    private PrefetchCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Prefetch, op, in, out, opcode, istr);
    }

    public static PrefetchCPInstruction parseInstruction(String str) {
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new PrefetchCPInstruction(null, in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        ec.setVariable(this.output.getName(), ec.getMatrixObject(this.input1));
        if (SparkUtils.triggerRDDPool == null) {
            SparkUtils.triggerRDDPool = Executors.newCachedThreadPool();
        }
        SparkUtils.triggerRDDPool.submit(new TriggerRDDOperationsTask(ec.getMatrixObject(this.output)));
    }
}

