/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.decode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.decode.Decoder;

public class DecoderComposite
extends Decoder {
    private static final long serialVersionUID = 5790600547144743716L;
    private List<Decoder> _decoders = null;

    protected DecoderComposite(Types.ValueType[] schema, List<Decoder> decoders) {
        super(schema, null);
        this._decoders = decoders;
    }

    @Override
    public FrameBlock decode(MatrixBlock in, FrameBlock out) {
        for (Decoder decoder : this._decoders) {
            out = decoder.decode(in, out);
        }
        return out;
    }

    @Override
    public Decoder subRangeDecoder(int colStart, int colEnd, int dummycodedOffset) {
        ArrayList<Decoder> subRangeDecoders = new ArrayList<Decoder>();
        for (Decoder decoder : this._decoders) {
            Decoder subDecoder = decoder.subRangeDecoder(colStart, colEnd, dummycodedOffset);
            if (subDecoder == null) continue;
            subRangeDecoders.add(subDecoder);
        }
        return new DecoderComposite(Arrays.copyOfRange(this._schema, colStart - 1, colEnd - 1), subRangeDecoders);
    }

    @Override
    public void updateIndexRanges(long[] beginDims, long[] endDims) {
        for (Decoder dec : this._decoders) {
            dec.updateIndexRanges(beginDims, endDims);
        }
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        for (Decoder decoder : this._decoders) {
            decoder.initMetaData(meta);
        }
    }
}

