/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.Stack;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.util.UtilFunctions;

public class LineageItem {
    private static IDSequence _idSeq = new IDSequence();
    private final long _id;
    private final String _opcode;
    private final String _data;
    private final LineageItem[] _inputs;
    private int _hash = 0;
    private boolean _visited = true;
    public static final String dedupItemOpcode = "dedup";

    public LineageItem() {
        this("");
    }

    public LineageItem(String data) {
        this(_idSeq.getNextID(), data);
    }

    public LineageItem(long id, String data) {
        this(id, data, "", null);
    }

    public LineageItem(String data, String opcode) {
        this(_idSeq.getNextID(), data, opcode, null);
    }

    public LineageItem(String opcode, LineageItem[] inputs) {
        this(_idSeq.getNextID(), "", opcode, inputs);
    }

    public LineageItem(String data, String opcode, LineageItem[] inputs) {
        this(_idSeq.getNextID(), data, opcode, inputs);
    }

    public LineageItem(LineageItem li) {
        this(_idSeq.getNextID(), li);
    }

    public LineageItem(long id, LineageItem li) {
        this(id, li._data, li._opcode, li._inputs);
    }

    public LineageItem(long id, String data, String opcode) {
        this(id, data, opcode, null);
    }

    public LineageItem(long id, String data, String opcode, LineageItem[] inputs) {
        this._id = id;
        this._opcode = opcode;
        this._data = data;
        this._inputs = inputs;
        this._hash = this.hashCode();
    }

    public LineageItem[] getInputs() {
        return this._inputs;
    }

    public void setInput(int i, LineageItem item) {
        this._inputs[i] = item;
        this._hash = 0;
    }

    public String getData() {
        return this._data;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public void setVisited() {
        this.setVisited(true);
    }

    public void setVisited(boolean flag) {
        this._visited = flag;
    }

    public long getId() {
        return this._id;
    }

    public String getOpcode() {
        return this._opcode;
    }

    public LineageItemType getType() {
        if (this._opcode.startsWith(dedupItemOpcode)) {
            return LineageItemType.Dedup;
        }
        if (this.isLeaf() && this.isInstruction()) {
            return LineageItemType.Creation;
        }
        if (this.isLeaf() && !this.isInstruction()) {
            return LineageItemType.Literal;
        }
        if (!this.isLeaf() && this.isInstruction()) {
            return LineageItemType.Instruction;
        }
        throw new DMLRuntimeException("An inner node could not be a literal!");
    }

    public String toString() {
        return LineageItemUtils.explainSingleLineageItem(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LineageItem)) {
            return false;
        }
        this.resetVisitStatusNR();
        boolean ret = this.equalsLI((LineageItem)o);
        this.resetVisitStatusNR();
        return ret;
    }

    private boolean equalsLI(LineageItem that) {
        if (this.isVisited() || this == that) {
            return true;
        }
        boolean ret = this._opcode.equals(that._opcode);
        ret &= this._data.equals(that._data);
        if ((ret &= this.hashCode() == that.hashCode()) && this._inputs != null && this._inputs.length == that._inputs.length) {
            for (int i = 0; i < this._inputs.length; ++i) {
                ret &= this._inputs[i].equalsLI(that._inputs[i]);
            }
        }
        this.setVisited();
        return ret;
    }

    public int hashCode() {
        if (this._hash == 0) {
            int h = UtilFunctions.intHashCode(this._opcode.hashCode(), this._data.hashCode());
            if (this._inputs != null) {
                for (LineageItem li : this._inputs) {
                    h = UtilFunctions.intHashCodeRobust(li.hashCode(), h);
                }
            }
            this._hash = h;
        }
        return this._hash;
    }

    public LineageItem deepCopy() {
        if (this.isLeaf()) {
            return new LineageItem(this);
        }
        LineageItem[] copyInputs = new LineageItem[this.getInputs().length];
        for (int i = 0; i < this._inputs.length; ++i) {
            copyInputs[i] = this._inputs[i].deepCopy();
        }
        return new LineageItem(this._opcode, copyInputs);
    }

    public boolean isLeaf() {
        return this._inputs == null || this._inputs.length == 0;
    }

    public boolean isInstruction() {
        return !this._opcode.isEmpty();
    }

    public boolean isDedup() {
        return this._opcode.startsWith(dedupItemOpcode);
    }

    public void resetVisitStatusNR() {
        Stack<LineageItem> q = new Stack<LineageItem>();
        q.push(this);
        while (!q.empty()) {
            LineageItem tmp = (LineageItem)q.pop();
            if (!tmp.isVisited()) continue;
            if (tmp.getInputs() != null) {
                for (LineageItem li : tmp.getInputs()) {
                    q.push(li);
                }
            }
            tmp.setVisited(false);
        }
    }

    public static void resetVisitStatusNR(LineageItem[] lis) {
        if (lis != null) {
            for (LineageItem liRoot : lis) {
                liRoot.resetVisitStatusNR();
            }
        }
    }

    @Deprecated
    public void resetVisitStatus() {
        if (!this.isVisited()) {
            return;
        }
        if (this._inputs != null) {
            for (LineageItem li : this.getInputs()) {
                li.resetVisitStatus();
            }
        }
        this.setVisited(false);
    }

    @Deprecated
    public static void resetVisitStatus(LineageItem[] lis) {
        if (lis != null) {
            for (LineageItem liRoot : lis) {
                liRoot.resetVisitStatus();
            }
        }
    }

    public static void resetIDSequence() {
        _idSeq.reset(-1L);
    }

    public static enum LineageItemType {
        Literal,
        Creation,
        Instruction,
        Dedup;

    }
}

