/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.parser.ConditionalPredicate;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatement;

public class WhileStatementBlock
extends StatementBlock {
    private Hop _predicateHops;
    private Lop _predicateLops = null;
    private boolean _requiresPredicateRecompile = false;

    @Override
    public VariableSet validate(DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        boolean bl;
        if (this._statements.size() > 1) {
            this.raiseValidateError("WhileStatementBlock should have only 1 statement (while statement)", conditional);
        }
        WhileStatement wstmt = (WhileStatement)this._statements.get(0);
        ConditionalPredicate predicate = wstmt.getConditionalPredicate();
        VariableSet origVarsBeforeBody = new VariableSet();
        for (String string : ids.getVariableNames()) {
            DataIdentifier origId = ids.getVariable(string);
            DataIdentifier copyId = new DataIdentifier(origId);
            origVarsBeforeBody.addVariable(string, copyId);
        }
        for (String string : this._updated.getVariableNames()) {
            if (!constVars.containsKey(string)) continue;
            constVars.remove(string);
        }
        predicate.getPredicate().validateExpression(ids.getVariables(), constVars, conditional);
        ArrayList<StatementBlock> body = wstmt.getBody();
        this._dmlProg = dmlProg;
        for (StatementBlock sb : body) {
            ids = sb.validate(dmlProg, ids, constVars, true);
            constVars = sb.getConstOut();
        }
        if (!body.isEmpty()) {
            this._constVarsIn.putAll(body.get(0).getConstIn());
            this._constVarsOut.putAll(body.get(body.size() - 1).getConstOut());
        }
        boolean bl2 = false;
        for (String key : this._updated.getVariableNames()) {
            DataIdentifier startVersion = origVarsBeforeBody.getVariable(key);
            DataIdentifier endVersion = ids.getVariable(key);
            if (startVersion == null || endVersion == null) continue;
            if (!startVersion.getOutput().getDataType().equals((Object)endVersion.getOutput().getDataType())) {
                this.raiseValidateError("WhileStatementBlock has unsupported conditional data type change of variable '" + key + "' in loop body.", conditional);
            }
            long startVersionDim1 = startVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)startVersion).getOrigDim1() : startVersion.getDim1();
            long endVersionDim1 = endVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)endVersion).getOrigDim1() : endVersion.getDim1();
            long startVersionDim2 = startVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)startVersion).getOrigDim2() : startVersion.getDim2();
            long endVersionDim2 = endVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)endVersion).getOrigDim2() : endVersion.getDim2();
            boolean sizeUnchanged = startVersionDim1 == endVersionDim1 && startVersionDim2 == endVersionDim2;
            boolean nnzUnchanged = false;
            if (sizeUnchanged && nnzUnchanged) continue;
            bl = true;
            DataIdentifier recVersion = new DataIdentifier(endVersion);
            if (!sizeUnchanged) {
                recVersion.setDimensions(-1L, -1L);
            }
            if (!nnzUnchanged) {
                recVersion.setNnz(-1L);
            }
            origVarsBeforeBody.addVariable(key, recVersion);
        }
        if (bl) {
            ids = origVarsBeforeBody;
            for (String var : this._updated.getVariableNames()) {
                if (!constVars.containsKey(var)) continue;
                constVars.remove(var);
            }
            predicate.getPredicate().validateExpression(ids.getVariables(), constVars, conditional);
            body = wstmt.getBody();
            this._dmlProg = dmlProg;
            for (StatementBlock sb : body) {
                ids = sb.validate(dmlProg, ids, constVars, true);
                constVars = sb.getConstOut();
            }
            if (!body.isEmpty()) {
                this._constVarsIn.putAll(body.get(0).getConstIn());
                this._constVarsOut.putAll(body.get(body.size() - 1).getConstOut());
            }
        }
        return ids;
    }

    @Override
    public VariableSet initializeforwardLV(VariableSet activeInPassed) {
        WhileStatement wstmt = (WhileStatement)this._statements.get(0);
        if (this._statements.size() > 1) {
            throw new LanguageException(((Statement)this._statements.get(0)).printErrorLocation() + "WhileStatementBlock should have only 1 statement (while statement)");
        }
        this._read = new VariableSet();
        this._read.addVariables(wstmt.getConditionalPredicate().variablesRead());
        this._updated.addVariables(wstmt.getConditionalPredicate().variablesUpdated());
        this._gen = new VariableSet();
        this._gen.addVariables(wstmt.getConditionalPredicate().variablesRead());
        VariableSet current = new VariableSet();
        current.addVariables(activeInPassed);
        for (StatementBlock sb : wstmt.getBody()) {
            current = sb.initializeforwardLV(current);
            for (String varName : sb._gen.getVariableNames()) {
                if (this._kill.getVariableNames().contains(varName)) continue;
                this._gen.addVariable(varName, sb._gen.getVariable(varName));
            }
            this._read.addVariables(sb._read);
            this._updated.addVariables(sb._updated);
            if (sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) continue;
            this._kill.addVariables(sb._kill);
        }
        for (String varName : this._updated.getVariableNames()) {
            if (activeInPassed.containsVariable(varName)) continue;
            this._warnSet.addVariable(varName, this._updated.getVariable(varName));
        }
        this._liveOut = new VariableSet();
        this._liveOut.addVariables(current);
        this._liveOut.addVariables(this._updated);
        return this._liveOut;
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet loPassed) {
        WhileStatement wstmt = (WhileStatement)this._statements.get(0);
        VariableSet lo = new VariableSet();
        lo.addVariables(loPassed);
        int numBlocks = wstmt.getBody().size();
        for (int i = numBlocks - 1; i >= 0; --i) {
            lo = wstmt.getBody().get(i).analyze(lo);
        }
        VariableSet loReturn = new VariableSet();
        loReturn.addVariables(lo);
        return loReturn;
    }

    public void setPredicateHops(Hop hops) {
        this._predicateHops = hops;
    }

    public Hop getPredicateHops() {
        return this._predicateHops;
    }

    public Lop getPredicateLops() {
        return this._predicateLops;
    }

    public void setPredicateLops(Lop predicateLops) {
        this._predicateLops = predicateLops;
    }

    @Override
    public VariableSet analyze(VariableSet loPassed) {
        VariableSet predVars = new VariableSet();
        predVars.addVariables(((WhileStatement)this._statements.get(0)).getConditionalPredicate().variablesRead());
        predVars.addVariables(((WhileStatement)this._statements.get(0)).getConditionalPredicate().variablesUpdated());
        VariableSet candidateLO = new VariableSet();
        candidateLO.addVariables(loPassed);
        candidateLO.addVariables(this._gen);
        candidateLO.addVariables(predVars);
        VariableSet origLiveOut = new VariableSet();
        origLiveOut.addVariables(this._liveOut);
        origLiveOut.addVariables(predVars);
        origLiveOut.addVariables(this._gen);
        this._liveOut = new VariableSet();
        for (String string : candidateLO.getVariableNames()) {
            if (!origLiveOut.containsVariable(string)) continue;
            this._liveOut.addVariable(string, candidateLO.getVariable(string));
        }
        this.initializebackwardLV(this._liveOut);
        VariableSet finalWarnSet = new VariableSet();
        for (String varName : this._warnSet.getVariableNames()) {
            if (!this._liveOut.containsVariable(varName)) continue;
            finalWarnSet.addVariable(varName, this._warnSet.getVariable(varName));
        }
        this._warnSet = finalWarnSet;
        for (String varName : this._warnSet.getVariableNames()) {
            LOG.warn(this._warnSet.getVariable(varName).printWarningLocation() + "Initialization of " + varName + " depends on while execution");
        }
        this._liveIn = new VariableSet();
        this._liveIn.addVariables(this._liveOut);
        this._liveIn.addVariables(this._gen);
        VariableSet variableSet = new VariableSet();
        variableSet.addVariables(this._liveIn);
        return variableSet;
    }

    public boolean updatePredicateRecompilationFlag() {
        this._requiresPredicateRecompile = ConfigurationManager.isDynamicRecompilation() && Recompiler.requiresRecompilation(this.getPredicateHops());
        return this._requiresPredicateRecompile;
    }

    public boolean requiresPredicateRecompilation() {
        return this._requiresPredicateRecompile;
    }
}

