/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.ParWorker;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForUtils;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.stat.StatisticMonitor;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableBlock;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableCell;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.utils.Statistics;

public class RemoteDPParWorkerReducer
extends ParWorker
implements Reducer<LongWritable, Writable, Writable, Writable> {
    private String _inputVar = null;
    private String _iterVar = null;
    private ParForProgramBlock.PDataPartitionFormat _dpf = null;
    private OutputInfo _info = null;
    private int _rlen = -1;
    private int _clen = -1;
    private int _brlen = -1;
    private int _bclen = -1;
    private MatrixBlock _partition = null;
    private boolean _tSparseCol = false;
    protected String _stringID = null;
    protected OutputCollector<Writable, Writable> _out = null;
    protected Reporter _report = null;

    public void reduce(LongWritable key, Iterator<Writable> valueList, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this._out = out;
        this._report = reporter;
        this._partition = this._info == OutputInfo.BinaryBlockOutputInfo ? this.collectBinaryBlock(valueList) : this.collectBinaryCellInput(valueList);
        LOG.trace("execute RemoteDPParWorkerReducer " + this._stringID + " (" + this._workerID + ")");
        try {
            MatrixObject mo = this._ec.getMatrixObject(this._inputVar);
            mo.setInMemoryPartition(this._partition);
            Task lTask = new Task(this._iterVar, Task.TaskType.SET);
            lTask.addIteration(new IntObject(key.get()));
            this.executeTask(lTask);
        }
        catch (Exception ex) {
            throw new IOException("ParFOR: Failed to execute task.", ex);
        }
        RemoteParForUtils.incrementParForMRCounters(this._report, 1L, 1L);
    }

    public void configure(JobConf job) {
        this._dpf = MRJobConfiguration.getPartitioningFormat(job);
        MatrixCharacteristics mc = MRJobConfiguration.getPartitionedMatrixSize(job);
        ParForProgramBlock.PartitionFormat pf = new ParForProgramBlock.PartitionFormat(this._dpf, MRJobConfiguration.getPartitioningSizeN(job));
        this._rlen = (int)pf.getNumRows(mc);
        this._clen = (int)pf.getNumColumns(mc);
        this._brlen = mc.getRowsPerBlock();
        this._bclen = mc.getColsPerBlock();
        this._iterVar = MRJobConfiguration.getPartitioningItervar(job);
        this._inputVar = MRJobConfiguration.getPartitioningMatrixvar(job);
        this._info = MRJobConfiguration.getPartitioningOutputInfo(job);
        this._tSparseCol = MRJobConfiguration.getPartitioningTransposedCol(job);
        this._partition = this._tSparseCol ? new MatrixBlock(this._clen, this._rlen, true) : new MatrixBlock(this._rlen, this._clen, false);
        String taskID = job.get(MRConfigurationNames.MR_TASK_ID);
        LOG.trace("configure RemoteDPParWorkerReducer " + taskID);
        try {
            this._stringID = taskID;
            this._workerID = IDHandler.extractIntID(this._stringID);
            if (!InfrastructureAnalyzer.isLocalMode(job)) {
                ConfigurationManager.setCachedJobConf(job);
            }
            String in = MRJobConfiguration.getProgramBlocks(job);
            ParForBody body = ProgramConverter.parseParForBody(in, (int)this._workerID);
            this._childBlocks = body.getChildBlocks();
            this._ec = body.getEc();
            this._resultVars = body.getResultVariables();
            if (!CacheableData.isCachingActive()) {
                String uuid = IDHandler.createDistributedUniqueID();
                LocalFileUtils.createWorkingDirectoryWithUUID(uuid);
                CacheableData.initCaching(uuid);
            }
            if (!CacheableData.cacheEvictionLocalFilePrefix.contains("_")) {
                CacheableData.cacheEvictionLocalFilePrefix = CacheableData.cacheEvictionLocalFilePrefix + "_" + this._workerID;
            }
            super.pinResultVariables();
            boolean cpCaching = MRJobConfiguration.getParforCachingConfig(job);
            if (!cpCaching) {
                CacheableData.disableCaching();
            }
            this._numTasks = 0L;
            this._numIters = 0L;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        StatisticMonitor.disableStatMonitoring();
        if (DMLScript.STATISTICS && !InfrastructureAnalyzer.isLocalMode(job)) {
            Statistics.reset();
        }
    }

    public void close() throws IOException {
        try {
            RemoteParForUtils.exportResultVariables(this._workerID, this._ec.getVariables(), this._resultVars, this._out);
            RemoteParForUtils.incrementParForMRCounters(this._report, 0L, 0L);
            JobConf job = ConfigurationManager.getCachedJobConf();
            if (DMLScript.STATISTICS && !InfrastructureAnalyzer.isLocalMode(job)) {
                LOG.info("\nSystemML Statistics:\nHeavy hitter instructions (name, time, count):\n" + Statistics.getHeavyHitters(DMLScript.STATISTICS_COUNT));
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        RemoteParForUtils.cleanupWorkingDirectories();
        CacheableData.enableCaching();
    }

    private MatrixBlock collectBinaryBlock(Iterator<Writable> valueList) throws IOException {
        try {
            this._partition.reset(this._rlen, this._clen);
            while (valueList.hasNext()) {
                PairWritableBlock pairValue = (PairWritableBlock)valueList.next();
                int row_offset = (int)(pairValue.indexes.getRowIndex() - 1L) * this._brlen;
                int col_offset = (int)(pairValue.indexes.getColumnIndex() - 1L) * this._bclen;
                MatrixBlock block = pairValue.block;
                if (!this._partition.isInSparseFormat()) {
                    this._partition.copy(row_offset, row_offset + block.getNumRows() - 1, col_offset, col_offset + block.getNumColumns() - 1, pairValue.block, false);
                    continue;
                }
                this._partition.appendToSparse(pairValue.block, row_offset, col_offset);
            }
            this.cleanupCollectedMatrixPartition(this._partition.isInSparseFormat());
        }
        catch (DMLRuntimeException ex) {
            throw new IOException(ex);
        }
        return this._partition;
    }

    private MatrixBlock collectBinaryCellInput(Iterator<Writable> valueList) throws IOException {
        if (this._tSparseCol) {
            this._partition.reset(this._clen, this._rlen);
        } else {
            this._partition.reset(this._rlen, this._clen);
        }
        switch (this._dpf) {
            case ROW_WISE: {
                while (valueList.hasNext()) {
                    PairWritableCell pairValue = (PairWritableCell)valueList.next();
                    if (pairValue.indexes.getColumnIndex() < 0L) continue;
                    this._partition.quickSetValue(0, (int)pairValue.indexes.getColumnIndex() - 1, pairValue.cell.getValue());
                }
                break;
            }
            case COLUMN_WISE: {
                while (valueList.hasNext()) {
                    PairWritableCell pairValue = (PairWritableCell)valueList.next();
                    if (pairValue.indexes.getRowIndex() < 0L) continue;
                    if (this._tSparseCol) {
                        this._partition.appendValue(0, (int)pairValue.indexes.getRowIndex() - 1, pairValue.cell.getValue());
                        continue;
                    }
                    this._partition.quickSetValue((int)pairValue.indexes.getRowIndex() - 1, 0, pairValue.cell.getValue());
                }
                break;
            }
            default: {
                throw new IOException("Partition format not yet supported in fused partition-execute: " + (Object)((Object)this._dpf));
            }
        }
        this.cleanupCollectedMatrixPartition(this._tSparseCol);
        return this._partition;
    }

    private void cleanupCollectedMatrixPartition(boolean sort) throws IOException {
        if (this._partition.isInSparseFormat() && sort) {
            this._partition.sortSparseRows();
        }
        if (!this._partition.isInSparseFormat()) {
            this._partition.recomputeNonZeros();
        }
        try {
            this._partition.examSparsity();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

