/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Stat;
import org.apache.sysml.runtime.controlprogram.parfor.stat.StatisticMonitor;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.IntObject;

public abstract class ParWorker {
    protected static final Log LOG = LogFactory.getLog(ParWorker.class.getName());
    protected long _workerID = -1L;
    protected ArrayList<ProgramBlock> _childBlocks = null;
    protected ExecutionContext _ec = null;
    protected ArrayList<ParForStatementBlock.ResultVar> _resultVars = null;
    protected boolean _monitor = false;
    protected long _numTasks = -1L;
    protected long _numIters = -1L;

    public ExecutionContext getExecutionContext() {
        return this._ec;
    }

    public ParWorker() {
    }

    public ParWorker(long ID, ParForBody body, boolean monitor) {
        this._workerID = ID;
        if (body != null) {
            this._childBlocks = body.getChildBlocks();
            this._ec = body.getEc();
            this._resultVars = body.getResultVariables();
        }
        this._monitor = monitor;
        this._numTasks = 0L;
        this._numIters = 0L;
    }

    public LocalVariableMap getVariables() {
        return this._ec.getVariables();
    }

    public long getExecutedTasks() {
        return this._numTasks;
    }

    public long getExecutedIterations() {
        return this._numIters;
    }

    protected void pinResultVariables() {
        for (ParForStatementBlock.ResultVar var : this._resultVars) {
            Data dat = this._ec.getVariable(var._name);
            if (!(dat instanceof MatrixObject)) continue;
            ((MatrixObject)dat).enableCleanup(false);
        }
    }

    protected void executeTask(Task task) throws DMLRuntimeException {
        LOG.trace("EXECUTE PARFOR_WORKER ID=" + this._workerID + " for task " + task.toCompactString());
        switch (task.getType()) {
            case SET: {
                this.executeSetTask(task);
                break;
            }
            case RANGE: {
                this.executeRangeTask(task);
            }
        }
    }

    private void executeSetTask(Task task) throws DMLRuntimeException {
        Timing time1 = null;
        Timing time2 = null;
        if (this._monitor) {
            time1 = new Timing(true);
            time2 = new Timing(true);
        }
        String lVarName = task.getVarName();
        for (IntObject indexVal : task.getIterations()) {
            this._ec.setVariable(lVarName, indexVal);
            for (ProgramBlock pb : this._childBlocks) {
                pb.execute(this._ec);
            }
            ++this._numIters;
            if (!this._monitor) continue;
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_ITER_T, time1.stop());
        }
        ++this._numTasks;
        if (this._monitor) {
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_TASKSIZE, task.size());
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_TASK_T, time2.stop());
        }
    }

    private void executeRangeTask(Task task) throws DMLRuntimeException {
        Timing time1 = null;
        Timing time2 = null;
        if (this._monitor) {
            time1 = new Timing(true);
            time2 = new Timing(true);
        }
        List<IntObject> tmp = task.getIterations();
        String lVarName = task.getVarName();
        long lFrom = tmp.get(0).getLongValue();
        long lTo = tmp.get(1).getLongValue();
        long lIncr = tmp.get(2).getLongValue();
        for (long i = lFrom; i <= lTo; i += lIncr) {
            this._ec.setVariable(lVarName, new IntObject(i));
            for (ProgramBlock pb : this._childBlocks) {
                pb.execute(this._ec);
            }
            ++this._numIters;
            if (!this._monitor) continue;
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_ITER_T, time1.stop());
        }
        ++this._numTasks;
        if (this._monitor) {
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_TASKSIZE, task.size());
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_TASK_T, time2.stop());
        }
    }
}

