/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.Collection;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.LocalTaskQueue;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.ParWorker;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Stat;
import org.apache.sysml.runtime.controlprogram.parfor.stat.StatisticMonitor;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;

public class LocalParWorker
extends ParWorker
implements Runnable {
    protected LocalTaskQueue<Task> _taskQueue = null;
    protected Collection<String> _fnNames = null;
    protected CompilerConfig _cconf = null;
    protected boolean _stopped = false;
    protected int _max_retry = -1;

    public LocalParWorker(long ID, LocalTaskQueue<Task> q, ParForBody body, CompilerConfig cconf, int max_retry, boolean monitor) {
        super(ID, body, monitor);
        this._taskQueue = q;
        this._cconf = cconf;
        this._stopped = false;
        this._max_retry = max_retry;
    }

    public void setFunctionNames(Collection<String> fnNames) {
        this._fnNames = fnNames;
    }

    public Collection<String> getFunctionNames() {
        return this._fnNames;
    }

    @Override
    public void run() {
        Timing time1;
        Timing timing = time1 = this._monitor ? new Timing(true) : null;
        if (OptimizerUtils.isSparkExecutionMode() && SparkExecutionContext.isSparkContextCreated()) {
            SparkExecutionContext sec = (SparkExecutionContext)this._ec;
            sec.setThreadLocalSchedulerPool("parforPool" + this._workerID);
        }
        if (DMLScript.USE_ACCELERATOR) {
            try {
                this._ec.getGPUContext(0).initializeThread();
            }
            catch (DMLRuntimeException e) {
                LOG.error("Error executing task because of failure in GPU backend: ", e);
                LOG.error("Stopping LocalParWorker.");
                return;
            }
        }
        ConfigurationManager.setLocalConfig(this._cconf);
        Task lTask = null;
        block6: while (!this._stopped) {
            block14: {
                try {
                    lTask = this._taskQueue.dequeueTask();
                    if (lTask == LocalTaskQueue.NO_MORE_TASKS) {
                    }
                    break block14;
                }
                catch (Exception ex) {
                    LOG.warn("Error reading from task queue: " + ex.getMessage());
                    LOG.warn("Stopping LocalParWorker.");
                }
                break;
            }
            boolean success = false;
            int retrys = this._max_retry;
            while (!success) {
                try {
                    this.executeTask(lTask);
                    success = true;
                }
                catch (Exception ex) {
                    LOG.error("Failed to execute " + lTask.toString() + ", retry:" + retrys, ex);
                    if (retrys > 0) {
                        --retrys;
                        continue;
                    }
                    LOG.error("Error executing task: ", ex);
                    LOG.error("Stopping LocalParWorker.");
                    continue block6;
                }
            }
        }
        if (OptimizerUtils.isSparkExecutionMode() && SparkExecutionContext.isSparkContextCreated()) {
            SparkExecutionContext sec = (SparkExecutionContext)this._ec;
            sec.cleanupThreadLocalSchedulerPool();
        }
        if (this._monitor) {
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_NUMTASKS, this._numTasks);
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_NUMITERS, this._numIters);
            StatisticMonitor.putPWStat(this._workerID, Stat.PARWRK_EXEC_T, time1.stop());
        }
    }
}

