/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Binary;
import org.apache.sysml.lops.BinaryScalar;
import org.apache.sysml.lops.CSVReBlock;
import org.apache.sysml.lops.Checkpoint;
import org.apache.sysml.lops.Compression;
import org.apache.sysml.lops.ConvolutionTransform;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.Nary;
import org.apache.sysml.lops.ParameterizedBuiltin;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.ReBlock;
import org.apache.sysml.lops.Ternary;
import org.apache.sysml.lops.Transform;
import org.apache.sysml.lops.Unary;
import org.apache.sysml.lops.UnaryCP;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class Hop
implements ParseInfo {
    protected static final Log LOG = LogFactory.getLog(Hop.class.getName());
    public static final long CPThreshold = 2000L;
    private static IDSequence _seqHopID = new IDSequence();
    protected final long _ID;
    protected String _name;
    protected Expression.DataType _dataType;
    protected Expression.ValueType _valueType;
    protected boolean _visited = false;
    protected long _dim1 = -1L;
    protected long _dim2 = -1L;
    protected long _rows_in_block = -1L;
    protected long _cols_in_block = -1L;
    protected long _nnz = -1L;
    protected MatrixObject.UpdateType _updateType = MatrixObject.UpdateType.COPY;
    protected ArrayList<Hop> _parent = new ArrayList();
    protected ArrayList<Hop> _input = new ArrayList();
    protected LopProperties.ExecType _etype = null;
    protected LopProperties.ExecType _etypeForced = null;
    protected double _outputMemEstimate = -1.0;
    protected double _memEstimate = -1.0;
    protected double _processingMemEstimate = 0.0;
    protected double _spBroadcastMemEstimate = 0.0;
    protected boolean _requiresRecompile = false;
    protected boolean _requiresReblock = false;
    protected boolean _requiresCompression = false;
    protected boolean _requiresCheckpoint = false;
    protected boolean _outputEmptyBlocks = true;
    private Lop _lops = null;
    protected static final HashMap<DataOpTypes, Data.OperationTypes> HopsData2Lops = new HashMap();
    protected static final HashMap<AggOp, Aggregate.OperationTypes> HopsAgg2Lops;
    protected static final HashMap<ReOrgOp, Transform.OperationTypes> HopsTransf2Lops;
    protected static final HashMap<ConvOp, ConvolutionTransform.OperationTypes> HopsConv2Lops;
    protected static final HashMap<Direction, PartialAggregate.DirectionTypes> HopsDirection2Lops;
    protected static final HashMap<OpOp2, Binary.OperationTypes> HopsOpOp2LopsB;
    protected static final HashMap<OpOp2, BinaryScalar.OperationTypes> HopsOpOp2LopsBS;
    protected static final HashMap<OpOp2, Unary.OperationTypes> HopsOpOp2LopsU;
    protected static final HashMap<OpOp1, Unary.OperationTypes> HopsOpOp1LopsU;
    protected static final HashMap<OpOp1, UnaryCP.OperationTypes> HopsOpOp1LopsUS;
    protected static final HashMap<OpOp3, Ternary.OperationType> HopsOpOp3Lops;
    protected static final HashMap<OpOpN, Nary.OperationType> HopsOpOpNLops;
    protected static final HashMap<OpOp1, String> HopsOpOp12String;
    protected static final HashMap<ParamBuiltinOp, ParameterizedBuiltin.OperationTypes> HopsParameterizedBuiltinLops;
    protected static final HashMap<OpOp2, String> HopsOpOp2String;
    protected static final HashMap<OpOp3, String> HopsOpOp3String;
    protected static final HashMap<OpOp4, String> HopsOpOp4String;
    protected static final HashMap<Direction, String> HopsDirection2String;
    protected static final HashMap<AggOp, String> HopsAgg2String;
    protected static final HashMap<ReOrgOp, String> HopsTransf2String;
    protected static final HashMap<DataOpTypes, String> HopsData2String;
    public int _beginLine;
    public int _beginColumn;
    public int _endLine;
    public int _endColumn;
    public String _filename;
    public String _text;

    protected Hop() {
        this._ID = Hop.getNextHopID();
    }

    public Hop(String l, Expression.DataType dt, Expression.ValueType vt) {
        this();
        this.setName(l);
        this.setDataType(dt);
        this.setValueType(vt);
    }

    private static long getNextHopID() {
        return _seqHopID.getNextID();
    }

    public long getHopID() {
        return this._ID;
    }

    public abstract void checkArity() throws HopsException;

    public LopProperties.ExecType getExecType() {
        return this._etype;
    }

    public void resetExecType() {
        this._etype = null;
    }

    public LopProperties.ExecType getForcedExecType() {
        return this._etypeForced;
    }

    public void setForcedExecType(LopProperties.ExecType etype) {
        this._etypeForced = etype;
    }

    public abstract boolean allowsAllExecTypes();

    public boolean isTransposeSafe() {
        return false;
    }

    public void checkAndSetForcedPlatform() {
        if (DMLScript.USE_ACCELERATOR && DMLScript.FORCE_ACCELERATOR && this.isGPUEnabled()) {
            this._etypeForced = LopProperties.ExecType.GPU;
        } else if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE) {
            if (OptimizerUtils.isMemoryBasedOptLevel() && DMLScript.USE_ACCELERATOR && this.isGPUEnabled()) {
                this._etypeForced = this.findExecTypeByMemEstimate();
                if (this._etypeForced != LopProperties.ExecType.CP && this._etypeForced != LopProperties.ExecType.GPU) {
                    this._etypeForced = LopProperties.ExecType.CP;
                }
            } else {
                this._etypeForced = LopProperties.ExecType.CP;
            }
        } else if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HADOOP) {
            this._etypeForced = LopProperties.ExecType.MR;
        } else if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SPARK) {
            this._etypeForced = LopProperties.ExecType.SPARK;
        }
    }

    public void checkAndSetInvalidCPDimsAndSize() {
        if (this._etype == LopProperties.ExecType.CP || this._etype == LopProperties.ExecType.GPU) {
            boolean invalid;
            boolean bl = invalid = !this.hasValidCPDimsAndSize();
            if (invalid) {
                if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HYBRID) {
                    this._etype = LopProperties.ExecType.MR;
                } else if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK) {
                    this._etype = LopProperties.ExecType.SPARK;
                }
            }
        }
    }

    public boolean hasValidCPDimsAndSize() {
        boolean invalid = !OptimizerUtils.isValidCPDimensions(this._dim1, this._dim2);
        for (Hop in : this.getInput()) {
            invalid |= !OptimizerUtils.isValidCPDimensions(in._dim1, in._dim2);
        }
        return !invalid;
    }

    public boolean hasMatrixInputWithDifferentBlocksizes() {
        for (Hop c : this.getInput()) {
            if (c.getDataType() != Expression.DataType.MATRIX || this.getRowsInBlock() == c.getRowsInBlock() && this.getColsInBlock() == c.getColsInBlock()) continue;
            return true;
        }
        return false;
    }

    public void setOutputBlocksizes(long brlen, long bclen) {
        this.setRowsInBlock(brlen);
        this.setColsInBlock(bclen);
    }

    public void setRequiresReblock(boolean flag) {
        this._requiresReblock = flag;
    }

    public boolean requiresReblock() {
        return this._requiresReblock;
    }

    public void setRequiresCheckpoint(boolean flag) {
        this._requiresCheckpoint = flag;
    }

    public boolean requiresCheckpoint() {
        return this._requiresCheckpoint;
    }

    public void setRequiresCompression(boolean flag) {
        this._requiresCompression = flag;
    }

    public boolean requiresCompression() {
        return this._requiresCompression;
    }

    public void constructAndSetLopsDataFlowProperties() throws HopsException {
        this.constructAndSetReblockLopIfRequired();
        this.constructAndSetCompressionLopIfRequired();
        this.constructAndSetCheckpointLopIfRequired();
    }

    private void constructAndSetReblockLopIfRequired() throws HopsException {
        LopProperties.ExecType et = LopProperties.ExecType.CP;
        if (DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SINGLE_NODE && this.getDataType() != Expression.DataType.SCALAR) {
            LopProperties.ExecType execType = et = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        }
        if (this._requiresReblock && et != LopProperties.ExecType.CP) {
            Lop input = this.getLops();
            Lop reblock = null;
            try {
                reblock = this instanceof DataOp && ((DataOp)this).getDataOpType() == DataOpTypes.PERSISTENTREAD && ((DataOp)this).getInputFormatType() == FileFormatTypes.CSV ? new CSVReBlock(input, this.getRowsInBlock(), this.getColsInBlock(), this.getDataType(), this.getValueType(), et) : new ReBlock(input, this.getRowsInBlock(), this.getColsInBlock(), this.getDataType(), this.getValueType(), this._outputEmptyBlocks, et);
            }
            catch (LopsException ex) {
                throw new HopsException(ex);
            }
            this.setOutputDimensions(reblock);
            this.setLineNumbers(reblock);
            this.setLops(reblock);
        }
    }

    private void constructAndSetCheckpointLopIfRequired() throws HopsException {
        LopProperties.ExecType et = LopProperties.ExecType.CP;
        if (OptimizerUtils.isSparkExecutionMode() && this.getDataType() != Expression.DataType.SCALAR) {
            et = OptimizerUtils.isHybridExecutionMode() && this.hasValidCPDimsAndSize() && !OptimizerUtils.exceedsCachingThreshold(this.getDim2(), this._outputMemEstimate) || this._etypeForced == LopProperties.ExecType.CP ? LopProperties.ExecType.CP : LopProperties.ExecType.SPARK;
        }
        if (this._requiresCheckpoint && et != LopProperties.ExecType.CP) {
            try {
                boolean serializedStorage = false;
                if (this.getDataType() == Expression.DataType.MATRIX && this.dimsKnown(true)) {
                    double matrixPSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(this._dim1, this._dim2, this._rows_in_block, this._cols_in_block, this._nnz);
                    double dataCache = SparkExecutionContext.getDataMemoryBudget(true, true);
                    serializedStorage = MatrixBlock.evalSparseFormatInMemory(this._dim1, this._dim2, this._nnz) && matrixPSize > dataCache && OptimizerUtils.getSparsity(this._dim1, this._dim2, this._nnz) < 4.0E-5;
                } else if (!this.dimsKnown(true)) {
                    this.setRequiresRecompile();
                }
                Lop input = this.getLops();
                Checkpoint chkpoint = new Checkpoint(input, this.getDataType(), this.getValueType(), serializedStorage ? Checkpoint.getSerializeStorageLevelString() : Checkpoint.getDefaultStorageLevelString());
                this.setOutputDimensions(chkpoint);
                this.setLineNumbers(chkpoint);
                this.setLops(chkpoint);
            }
            catch (LopsException ex) {
                throw new HopsException(ex);
            }
        }
    }

    private void constructAndSetCompressionLopIfRequired() throws HopsException {
        LopProperties.ExecType et = LopProperties.ExecType.CP;
        if (OptimizerUtils.isSparkExecutionMode() && this.getDataType() != Expression.DataType.SCALAR) {
            et = OptimizerUtils.isHybridExecutionMode() && 2.0 * this._outputMemEstimate < OptimizerUtils.getLocalMemBudget() || this._etypeForced == LopProperties.ExecType.CP ? LopProperties.ExecType.CP : LopProperties.ExecType.SPARK;
        }
        if (this._requiresCompression) {
            try {
                Compression compress = new Compression(this.getLops(), this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(compress);
                this.setLineNumbers(compress);
                this.setLops(compress);
            }
            catch (LopsException ex) {
                throw new HopsException(ex);
            }
        }
    }

    public static Lop createOffsetLop(Hop hop, boolean repCols) throws HopsException, LopsException {
        Lop offset = null;
        offset = ConfigurationManager.isDynamicRecompilation() && hop.dimsKnown() ? Data.createLiteralLop(Expression.ValueType.INT, String.valueOf(repCols ? hop.getDim2() : hop.getDim1())) : new UnaryCP(hop.constructLops(), repCols ? UnaryCP.OperationTypes.NCOL : UnaryCP.OperationTypes.NROW, Expression.DataType.SCALAR, Expression.ValueType.INT);
        offset.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
        offset.setAllPositions(hop.getFilename(), hop.getBeginLine(), hop.getBeginColumn(), hop.getEndLine(), hop.getEndColumn());
        return offset;
    }

    public void setOutputEmptyBlocks(boolean flag) {
        this._outputEmptyBlocks = flag;
    }

    public boolean isOutputEmptyBlocks() {
        return this._outputEmptyBlocks;
    }

    protected double getOutputSize() {
        return this._outputMemEstimate;
    }

    protected double getInputSize() {
        double sum = 0.0;
        int len = this._input.size();
        for (int i = 0; i < len; ++i) {
            Hop hi = this._input.get(i);
            double hmout = hi.getOutputMemEstimate();
            if (hmout > 1048576.0) {
                boolean flag = false;
                for (int j = 0; j < i; ++j) {
                    flag |= hi == this._input.get(j);
                }
                hmout = flag ? 0.0 : hmout;
            }
            sum += hmout;
        }
        return sum;
    }

    protected double getInputOutputSize() {
        double sum = 0.0;
        sum += this._outputMemEstimate;
        sum += this._processingMemEstimate;
        return sum += this.getInputSize();
    }

    protected double getInputSize(int pos) {
        double ret = 0.0;
        if (this._input.size() > pos) {
            ret = this._input.get((int)pos)._outputMemEstimate;
        }
        return ret;
    }

    protected double getIntermediateSize() {
        return this._processingMemEstimate;
    }

    public double getMemEstimate() {
        if (OptimizerUtils.isMemoryBasedOptLevel()) {
            if (!this.isMemEstimated()) {
                this.computeMemEstimate(new MemoTable());
            }
            return this._memEstimate;
        }
        return -1.0;
    }

    public void setMemEstimate(double mem) {
        this._memEstimate = mem;
    }

    public void clearMemEstimate() {
        this._memEstimate = -1.0;
    }

    public boolean isMemEstimated() {
        return this._memEstimate != -1.0;
    }

    public double getInputMemEstimate() {
        return this.getInputSize();
    }

    public double getOutputMemEstimate() {
        return this.getOutputSize();
    }

    public double getIntermediateMemEstimate() {
        return this.getIntermediateSize();
    }

    public double getSpBroadcastSize() {
        return this._spBroadcastMemEstimate;
    }

    public void computeMemEstimate(MemoTable memo) {
        long lnnz;
        long[] wstats = null;
        switch (this.getDataType()) {
            case SCALAR: {
                if (this.getValueType() == Expression.ValueType.DOUBLE) {
                    this._outputMemEstimate = 8.0;
                    break;
                }
                this._outputMemEstimate = this.computeOutputMemEstimate(this._dim1, this._dim2, this._nnz);
                break;
            }
            case FRAME: 
            case MATRIX: {
                if (this.dimsKnown(true)) {
                    this._outputMemEstimate = this.computeOutputMemEstimate(this._dim1, this._dim2, this._nnz);
                    break;
                }
                if (memo.hasInputStatistics(this)) {
                    wstats = this.inferOutputCharacteristics(memo);
                    if (wstats != null && wstats[0] >= 0L && wstats[1] >= 0L) {
                        lnnz = wstats[2] >= 0L ? wstats[2] : wstats[0] * wstats[1];
                        this._outputMemEstimate = this.computeOutputMemEstimate(wstats[0], wstats[1], lnnz);
                        memo.memoizeStatistics(this.getHopID(), wstats[0], wstats[1], wstats[2]);
                        break;
                    }
                    if (this.dimsKnown()) {
                        lnnz = this._dim1 * this._dim2;
                        this._outputMemEstimate = this.computeOutputMemEstimate(this._dim1, this._dim2, lnnz);
                        break;
                    }
                    this._outputMemEstimate = OptimizerUtils.DEFAULT_SIZE;
                    break;
                }
                if (this.dimsKnown()) {
                    lnnz = this._dim1 * this._dim2;
                    this._outputMemEstimate = this.computeOutputMemEstimate(this._dim1, this._dim2, lnnz);
                    break;
                }
                this._outputMemEstimate = OptimizerUtils.DEFAULT_SIZE;
                break;
            }
            case OBJECT: 
            case UNKNOWN: {
                this._outputMemEstimate = OptimizerUtils.DEFAULT_SIZE;
            }
        }
        if (this.dimsKnown(true)) {
            this._processingMemEstimate = this.computeIntermediateMemEstimate(this._dim1, this._dim2, this._nnz);
        } else if (wstats != null) {
            lnnz = wstats[2] >= 0L ? wstats[2] : wstats[0] * wstats[1];
            this._processingMemEstimate = this.computeIntermediateMemEstimate(wstats[0], wstats[1], lnnz);
        } else if (this.dimsKnown()) {
            lnnz = this._dim1 * this._dim2;
            this._processingMemEstimate = this.computeIntermediateMemEstimate(this._dim1, this._dim2, lnnz);
        }
        this._memEstimate = this.getInputOutputSize();
    }

    protected abstract long[] inferOutputCharacteristics(MemoTable var1);

    public void refreshMemEstimates(MemoTable memo) {
        if (this.isVisited()) {
            return;
        }
        for (Hop h : this.getInput()) {
            h.refreshMemEstimates(memo);
        }
        this.computeMemEstimate(memo);
        this.setVisited();
    }

    protected LopProperties.ExecType findExecTypeByMemEstimate() {
        LopProperties.ExecType et = null;
        char c = ' ';
        double memEst = this.getMemEstimate();
        if (memEst < OptimizerUtils.getLocalMemBudget()) {
            et = DMLScript.USE_ACCELERATOR && this.isGPUEnabled() && memEst < (double)GPUContextPool.initialGPUMemBudget() ? LopProperties.ExecType.GPU : LopProperties.ExecType.CP;
        } else {
            if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HYBRID) {
                et = LopProperties.ExecType.MR;
            } else if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK) {
                et = LopProperties.ExecType.SPARK;
            }
            c = '*';
        }
        if (LOG.isDebugEnabled()) {
            String s = String.format("  %c %-5s %-8s (%s,%s)  %s", new Object[]{Character.valueOf(c), this.getHopID(), this.getOpString(), OptimizerUtils.toMB(this._outputMemEstimate), OptimizerUtils.toMB(this._memEstimate), et});
            LOG.debug(s);
        }
        return et;
    }

    public ArrayList<Hop> getParent() {
        return this._parent;
    }

    public ArrayList<Hop> getInput() {
        return this._input;
    }

    public void addInput(Hop h) {
        this._input.add(h);
        h._parent.add(this);
    }

    public long getRowsInBlock() {
        return this._rows_in_block;
    }

    public void setRowsInBlock(long rowsInBlock) {
        this._rows_in_block = rowsInBlock;
    }

    public long getColsInBlock() {
        return this._cols_in_block;
    }

    public void setColsInBlock(long colsInBlock) {
        this._cols_in_block = colsInBlock;
    }

    public void setNnz(long nnz) {
        this._nnz = nnz;
    }

    public long getNnz() {
        return this._nnz;
    }

    public void setUpdateType(MatrixObject.UpdateType update) {
        this._updateType = update;
    }

    public MatrixObject.UpdateType getUpdateType() {
        return this._updateType;
    }

    public abstract Lop constructLops() throws HopsException, LopsException;

    protected abstract LopProperties.ExecType optFindExecType() throws HopsException;

    public abstract String getOpString();

    public abstract boolean isGPUEnabled();

    protected abstract double computeOutputMemEstimate(long var1, long var3, long var5);

    protected abstract double computeIntermediateMemEstimate(long var1, long var3, long var5);

    protected boolean isVector() {
        return this.dimsKnown() && (this._dim1 == 1L || this._dim2 == 1L);
    }

    protected boolean areDimsBelowThreshold() {
        return this.dimsKnown() && this._dim1 <= 2000L && this._dim2 <= 2000L;
    }

    public boolean dimsKnown() {
        return this._dataType == Expression.DataType.SCALAR || (this._dataType == Expression.DataType.MATRIX || this._dataType == Expression.DataType.FRAME) && this._dim1 >= 0L && this._dim2 >= 0L;
    }

    public boolean dimsKnown(boolean includeNnz) {
        return this.rowsKnown() && this.colsKnown() && (this._dataType.isScalar() || !includeNnz || this._nnz >= 0L);
    }

    public boolean dimsKnownAny() {
        return this.rowsKnown() || this.colsKnown();
    }

    public boolean rowsKnown() {
        return this._dataType.isScalar() || this._dim1 >= 0L;
    }

    public boolean colsKnown() {
        return this._dataType.isScalar() || this._dim2 >= 0L;
    }

    public static void resetVisitStatus(ArrayList<Hop> hops) {
        if (hops != null) {
            for (Hop hopRoot : hops) {
                hopRoot.resetVisitStatus();
            }
        }
    }

    public static void resetVisitStatus(ArrayList<Hop> hops, boolean force) {
        if (!force) {
            Hop.resetVisitStatus(hops);
        } else {
            HashSet<Long> memo = new HashSet<Long>();
            if (hops != null) {
                for (Hop hopRoot : hops) {
                    hopRoot.resetVisitStatusForced(memo);
                }
            }
        }
    }

    public void resetVisitStatus() {
        if (!this.isVisited()) {
            return;
        }
        for (Hop h : this.getInput()) {
            h.resetVisitStatus();
        }
        this.setVisited(false);
    }

    public void resetVisitStatusForced(HashSet<Long> memo) {
        if (memo.contains(this.getHopID())) {
            return;
        }
        for (Hop h : this.getInput()) {
            h.resetVisitStatusForced(memo);
        }
        this.setVisited(false);
        memo.add(this.getHopID());
    }

    public static void resetRecompilationFlag(ArrayList<Hop> hops, LopProperties.ExecType et, Recompiler.ResetType reset) {
        Hop.resetVisitStatus(hops);
        for (Hop hopRoot : hops) {
            hopRoot.resetRecompilationFlag(et, reset);
        }
    }

    public static void resetRecompilationFlag(Hop hops, LopProperties.ExecType et, Recompiler.ResetType reset) {
        hops.resetVisitStatus();
        hops.resetRecompilationFlag(et, reset);
    }

    private void resetRecompilationFlag(LopProperties.ExecType et, Recompiler.ResetType reset) {
        if (this.isVisited()) {
            return;
        }
        for (Hop h : this.getInput()) {
            h.resetRecompilationFlag(et, reset);
        }
        if (!(et != null && this.getExecType() != et && this.getExecType() != null || reset != Recompiler.ResetType.RESET && (reset != Recompiler.ResetType.RESET_KNOWN_DIMS || !this.dimsKnown()) || this._requiresCheckpoint && this.getLops() instanceof Checkpoint && !this.dimsKnown(true))) {
            this._requiresRecompile = false;
        }
        this.setVisited();
    }

    public long getDim1() {
        return this._dim1;
    }

    public void setDim1(long dim1) {
        this._dim1 = dim1;
    }

    public long getDim2() {
        return this._dim2;
    }

    public void setDim2(long dim2) {
        this._dim2 = dim2;
    }

    public long getLength() {
        return this._dim1 * this._dim2;
    }

    public double getSparsity() {
        return OptimizerUtils.getSparsity(this._dim1, this._dim2, this._nnz);
    }

    protected void setOutputDimensions(Lop lop) throws HopsException {
        lop.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz(), this.getUpdateType());
    }

    public Lop getLops() {
        return this._lops;
    }

    public void setLops(Lop lops) {
        this._lops = lops;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public Expression.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(Expression.DataType dt) {
        this._dataType = dt;
    }

    public boolean isScalar() {
        return this._dataType.isScalar();
    }

    public boolean isMatrix() {
        return this._dataType.isMatrix();
    }

    public void setVisited() {
        this.setVisited(true);
    }

    public void setVisited(boolean flag) {
        this._visited = flag;
    }

    public void setName(String _name) {
        this._name = _name;
    }

    public String getName() {
        return this._name;
    }

    public Expression.ValueType getValueType() {
        return this._valueType;
    }

    public void setValueType(Expression.ValueType vt) {
        this._valueType = vt;
    }

    public static String getBinaryOpCode(OpOp2 op) {
        return HopsOpOp2String.get((Object)op);
    }

    public static OpOp2 getOpOp2ForOuterVectorOperation(String op) {
        if ("+".equals(op)) {
            return OpOp2.PLUS;
        }
        if ("-".equals(op)) {
            return OpOp2.MINUS;
        }
        if ("*".equals(op)) {
            return OpOp2.MULT;
        }
        if ("/".equals(op)) {
            return OpOp2.DIV;
        }
        if ("%%".equals(op)) {
            return OpOp2.MODULUS;
        }
        if ("%/%".equals(op)) {
            return OpOp2.INTDIV;
        }
        if ("min".equals(op)) {
            return OpOp2.MIN;
        }
        if ("max".equals(op)) {
            return OpOp2.MAX;
        }
        if ("<=".equals(op)) {
            return OpOp2.LESSEQUAL;
        }
        if ("<".equals(op)) {
            return OpOp2.LESS;
        }
        if (">=".equals(op)) {
            return OpOp2.GREATEREQUAL;
        }
        if (">".equals(op)) {
            return OpOp2.GREATER;
        }
        if ("==".equals(op)) {
            return OpOp2.EQUAL;
        }
        if ("!=".equals(op)) {
            return OpOp2.NOTEQUAL;
        }
        if ("|".equals(op)) {
            return OpOp2.OR;
        }
        if ("xor".equals(op)) {
            return OpOp2.XOR;
        }
        if ("&".equals(op)) {
            return OpOp2.AND;
        }
        if ("log".equals(op)) {
            return OpOp2.LOG;
        }
        if ("^".equals(op)) {
            return OpOp2.POW;
        }
        if ("bitwAnd".equals(op)) {
            return OpOp2.BITWAND;
        }
        if ("bitwOr".equals(op)) {
            return OpOp2.BITWOR;
        }
        if ("bitwXor".equals(op)) {
            return OpOp2.BITWXOR;
        }
        if ("bitwShiftL".equals(op)) {
            return OpOp2.BITWSHIFTL;
        }
        if ("bitwShiftR".equals(op)) {
            return OpOp2.BITWSHIFTR;
        }
        return null;
    }

    public boolean requiresRecompile() {
        return this._requiresRecompile;
    }

    public void setRequiresRecompile() {
        this._requiresRecompile = true;
    }

    protected void setRequiresRecompileIfNecessary() {
        boolean caseCodegen;
        LopProperties.ExecType REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        boolean caseRemote = !this.dimsKnown(true) && this._etype == REMOTE;
        boolean caseLocal = !this.dimsKnown() && this._etypeForced == LopProperties.ExecType.CP;
        boolean bl = caseCodegen = !this.dimsKnown() && ConfigurationManager.isCodegenEnabled();
        if (ConfigurationManager.isDynamicRecompilation() && (caseRemote || caseLocal || caseCodegen)) {
            this.setRequiresRecompile();
        }
    }

    public abstract void refreshSizeInformation();

    protected void refreshRowsParameterInformation(Hop input) {
        long size = Hop.computeSizeInformation(input);
        this.setDim1(size);
    }

    protected void refreshColsParameterInformation(Hop input) {
        long size = Hop.computeSizeInformation(input);
        this.setDim2(size);
    }

    public static long computeSizeInformation(Hop input) {
        long ret = -1L;
        try {
            long tmp = OptimizerUtils.rEvalSimpleLongExpression(input, new HashMap<Long, Long>());
            if (tmp != Long.MAX_VALUE) {
                ret = tmp;
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to compute size information.", ex);
            ret = -1L;
        }
        return ret;
    }

    public void refreshRowsParameterInformation(Hop input, LocalVariableMap vars) {
        this.setDim1(this.computeSizeInformation(input, vars));
    }

    public void refreshRowsParameterInformation(Hop input, LocalVariableMap vars, HashMap<Long, Long> memo) {
        this.setDim1(this.computeSizeInformation(input, vars, memo));
    }

    public void refreshColsParameterInformation(Hop input, LocalVariableMap vars) {
        this.setDim2(this.computeSizeInformation(input, vars));
    }

    public void refreshColsParameterInformation(Hop input, LocalVariableMap vars, HashMap<Long, Long> memo) {
        this.setDim2(this.computeSizeInformation(input, vars, memo));
    }

    public long computeSizeInformation(Hop input, LocalVariableMap vars) {
        return this.computeSizeInformation(input, vars, new HashMap<Long, Long>());
    }

    public long computeSizeInformation(Hop input, LocalVariableMap vars, HashMap<Long, Long> memo) {
        long ret = -1L;
        try {
            long tmp = OptimizerUtils.rEvalSimpleLongExpression(input, memo, vars);
            if (tmp != Long.MAX_VALUE) {
                ret = tmp;
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to compute size information.", ex);
            ret = -1L;
        }
        return ret;
    }

    public double computeBoundsInformation(Hop input) {
        double ret = Double.MAX_VALUE;
        try {
            ret = OptimizerUtils.rEvalSimpleDoubleExpression(input, new HashMap<Long, Double>());
        }
        catch (Exception ex) {
            LOG.error("Failed to compute bounds information.", ex);
            ret = Double.MAX_VALUE;
        }
        return ret;
    }

    public double computeBoundsInformation(Hop input, LocalVariableMap vars) {
        return this.computeBoundsInformation(input, vars, new HashMap<Long, Double>());
    }

    public double computeBoundsInformation(Hop input, LocalVariableMap vars, HashMap<Long, Double> memo) {
        double ret = Double.MAX_VALUE;
        try {
            ret = OptimizerUtils.rEvalSimpleDoubleExpression(input, memo, vars);
        }
        catch (Exception ex) {
            LOG.error("Failed to compute bounds information.", ex);
            ret = Double.MAX_VALUE;
        }
        return ret;
    }

    protected long computeDimParameterInformation(Hop input, MemoTable memo) {
        long dim;
        long ret = -1L;
        if (input instanceof UnaryOp) {
            MatrixCharacteristics mc;
            if (((UnaryOp)input).getOp() == OpOp1.NROW) {
                MatrixCharacteristics mc2 = memo.getAllInputStats(input.getInput().get(0));
                if (mc2.rowsKnown()) {
                    ret = mc2.getRows();
                }
            } else if (((UnaryOp)input).getOp() == OpOp1.NCOL && (mc = memo.getAllInputStats(input.getInput().get(0))).colsKnown()) {
                ret = mc.getCols();
            }
        } else if (input instanceof LiteralOp) {
            ret = UtilFunctions.parseToLong(input.getName());
        } else if (input instanceof BinaryOp && (dim = this.rEvalSimpleBinaryLongExpression(input, new HashMap<Long, Long>(), memo)) != Long.MAX_VALUE) {
            ret = dim;
        }
        return ret;
    }

    protected long rEvalSimpleBinaryLongExpression(Hop root, HashMap<Long, Long> valMemo, MemoTable memo) {
        if (valMemo.containsKey(root.getHopID())) {
            return valMemo.get(root.getHopID());
        }
        long ret = Long.MAX_VALUE;
        if (root instanceof LiteralOp) {
            long dim = UtilFunctions.parseToLong(root.getName());
            if (dim != -1L) {
                ret = dim;
            }
        } else if (root instanceof UnaryOp) {
            UnaryOp uroot = (UnaryOp)root;
            long dim = -1L;
            if (uroot.getOp() == OpOp1.NROW) {
                MatrixCharacteristics mc = memo.getAllInputStats(uroot.getInput().get(0));
                dim = mc.getRows();
            } else if (uroot.getOp() == OpOp1.NCOL) {
                MatrixCharacteristics mc = memo.getAllInputStats(uroot.getInput().get(0));
                dim = mc.getCols();
            }
            if (dim != -1L) {
                ret = dim;
            }
        } else if (root instanceof BinaryOp && OptimizerUtils.ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION) {
            BinaryOp broot = (BinaryOp)root;
            long lret = this.rEvalSimpleBinaryLongExpression(broot.getInput().get(0), valMemo, memo);
            long rret = this.rEvalSimpleBinaryLongExpression(broot.getInput().get(1), valMemo, memo);
            if (lret != Long.MAX_VALUE && rret != Long.MAX_VALUE) {
                switch (broot.getOp()) {
                    case PLUS: {
                        ret = lret + rret;
                        break;
                    }
                    case MULT: {
                        ret = lret * rret;
                        break;
                    }
                    case MIN: {
                        ret = Math.min(lret, rret);
                        break;
                    }
                    case MAX: {
                        ret = Math.max(lret, rret);
                        break;
                    }
                    default: {
                        ret = Long.MAX_VALUE;
                        break;
                    }
                }
            } else if (broot.getOp() == OpOp2.MIN && ((double)lret != Double.MAX_VALUE || (double)rret != Double.MAX_VALUE)) {
                ret = Math.min(lret, rret);
            }
        }
        valMemo.put(root.getHopID(), ret);
        return ret;
    }

    protected void clone(Hop that, boolean withRefs) throws CloneNotSupportedException {
        if (withRefs) {
            throw new CloneNotSupportedException("Hops deep copy w/ lops/inputs/parents not supported.");
        }
        this._name = that._name;
        this._dataType = that._dataType;
        this._valueType = that._valueType;
        this._visited = that._visited;
        this._dim1 = that._dim1;
        this._dim2 = that._dim2;
        this._rows_in_block = that._rows_in_block;
        this._cols_in_block = that._cols_in_block;
        this._nnz = that._nnz;
        this._updateType = that._updateType;
        this._parent = new ArrayList(this._parent.size());
        this._input = new ArrayList(this._input.size());
        this._lops = null;
        this._etype = that._etype;
        this._etypeForced = that._etypeForced;
        this._outputMemEstimate = that._outputMemEstimate;
        this._memEstimate = that._memEstimate;
        this._processingMemEstimate = that._processingMemEstimate;
        this._requiresRecompile = that._requiresRecompile;
        this._requiresReblock = that._requiresReblock;
        this._requiresCheckpoint = that._requiresCheckpoint;
        this._requiresCompression = that._requiresCompression;
        this._outputEmptyBlocks = that._outputEmptyBlocks;
        this._beginLine = that._beginLine;
        this._beginColumn = that._beginColumn;
        this._endLine = that._endLine;
        this._endColumn = that._endColumn;
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public abstract boolean compare(Hop var1);

    @Override
    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    @Override
    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    @Override
    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    @Override
    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    @Override
    public void setFilename(String passed) {
        this._filename = passed;
    }

    @Override
    public void setText(String text) {
        this._text = text;
    }

    @Override
    public int getBeginLine() {
        return this._beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this._beginColumn;
    }

    @Override
    public int getEndLine() {
        return this._endLine;
    }

    @Override
    public int getEndColumn() {
        return this._endColumn;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public String getText() {
        return this._text;
    }

    public String printErrorLocation() {
        if (this._filename != null) {
            return "ERROR: " + this._filename + " line " + this._beginLine + ", column " + this._beginColumn + " -- ";
        }
        return "ERROR: line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    protected void setLineNumbers(Lop lop) {
        lop.setAllPositions(this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
    }

    public void setParseInfo(ParseInfo parseInfo) {
        this._beginLine = parseInfo.getBeginLine();
        this._beginColumn = parseInfo.getBeginColumn();
        this._endLine = parseInfo.getEndLine();
        this._endColumn = parseInfo.getEndColumn();
        this._text = parseInfo.getText();
        this._filename = parseInfo.getFilename();
    }

    static {
        HopsData2Lops.put(DataOpTypes.PERSISTENTREAD, Data.OperationTypes.READ);
        HopsData2Lops.put(DataOpTypes.PERSISTENTWRITE, Data.OperationTypes.WRITE);
        HopsData2Lops.put(DataOpTypes.TRANSIENTWRITE, Data.OperationTypes.WRITE);
        HopsData2Lops.put(DataOpTypes.TRANSIENTREAD, Data.OperationTypes.READ);
        HopsAgg2Lops = new HashMap();
        HopsAgg2Lops.put(AggOp.SUM, Aggregate.OperationTypes.KahanSum);
        HopsAgg2Lops.put(AggOp.SUM_SQ, Aggregate.OperationTypes.KahanSumSq);
        HopsAgg2Lops.put(AggOp.TRACE, Aggregate.OperationTypes.KahanTrace);
        HopsAgg2Lops.put(AggOp.MIN, Aggregate.OperationTypes.Min);
        HopsAgg2Lops.put(AggOp.MAX, Aggregate.OperationTypes.Max);
        HopsAgg2Lops.put(AggOp.MAXINDEX, Aggregate.OperationTypes.MaxIndex);
        HopsAgg2Lops.put(AggOp.MININDEX, Aggregate.OperationTypes.MinIndex);
        HopsAgg2Lops.put(AggOp.PROD, Aggregate.OperationTypes.Product);
        HopsAgg2Lops.put(AggOp.MEAN, Aggregate.OperationTypes.Mean);
        HopsAgg2Lops.put(AggOp.VAR, Aggregate.OperationTypes.Var);
        HopsTransf2Lops = new HashMap();
        HopsTransf2Lops.put(ReOrgOp.TRANSPOSE, Transform.OperationTypes.Transpose);
        HopsTransf2Lops.put(ReOrgOp.REV, Transform.OperationTypes.Rev);
        HopsTransf2Lops.put(ReOrgOp.DIAG, Transform.OperationTypes.Diag);
        HopsTransf2Lops.put(ReOrgOp.RESHAPE, Transform.OperationTypes.Reshape);
        HopsTransf2Lops.put(ReOrgOp.SORT, Transform.OperationTypes.Sort);
        HopsConv2Lops = new HashMap();
        HopsConv2Lops.put(ConvOp.MAX_POOLING, ConvolutionTransform.OperationTypes.MAX_POOLING);
        HopsConv2Lops.put(ConvOp.MAX_POOLING_BACKWARD, ConvolutionTransform.OperationTypes.MAX_POOLING_BACKWARD);
        HopsConv2Lops.put(ConvOp.AVG_POOLING, ConvolutionTransform.OperationTypes.AVG_POOLING);
        HopsConv2Lops.put(ConvOp.AVG_POOLING_BACKWARD, ConvolutionTransform.OperationTypes.AVG_POOLING_BACKWARD);
        HopsConv2Lops.put(ConvOp.DIRECT_CONV2D, ConvolutionTransform.OperationTypes.DIRECT_CONV2D);
        HopsConv2Lops.put(ConvOp.BIAS_ADD, ConvolutionTransform.OperationTypes.BIAS_ADD);
        HopsConv2Lops.put(ConvOp.BIAS_MULTIPLY, ConvolutionTransform.OperationTypes.BIAS_MULTIPLY);
        HopsConv2Lops.put(ConvOp.DIRECT_CONV2D_BACKWARD_FILTER, ConvolutionTransform.OperationTypes.DIRECT_CONV2D_BACKWARD_FILTER);
        HopsConv2Lops.put(ConvOp.DIRECT_CONV2D_BACKWARD_DATA, ConvolutionTransform.OperationTypes.DIRECT_CONV2D_BACKWARD_DATA);
        HopsDirection2Lops = new HashMap();
        HopsDirection2Lops.put(Direction.RowCol, PartialAggregate.DirectionTypes.RowCol);
        HopsDirection2Lops.put(Direction.Col, PartialAggregate.DirectionTypes.Col);
        HopsDirection2Lops.put(Direction.Row, PartialAggregate.DirectionTypes.Row);
        HopsOpOp2LopsB = new HashMap();
        HopsOpOp2LopsB.put(OpOp2.PLUS, Binary.OperationTypes.ADD);
        HopsOpOp2LopsB.put(OpOp2.MINUS, Binary.OperationTypes.SUBTRACT);
        HopsOpOp2LopsB.put(OpOp2.MULT, Binary.OperationTypes.MULTIPLY);
        HopsOpOp2LopsB.put(OpOp2.DIV, Binary.OperationTypes.DIVIDE);
        HopsOpOp2LopsB.put(OpOp2.MODULUS, Binary.OperationTypes.MODULUS);
        HopsOpOp2LopsB.put(OpOp2.INTDIV, Binary.OperationTypes.INTDIV);
        HopsOpOp2LopsB.put(OpOp2.MINUS1_MULT, Binary.OperationTypes.MINUS1_MULTIPLY);
        HopsOpOp2LopsB.put(OpOp2.LESS, Binary.OperationTypes.LESS_THAN);
        HopsOpOp2LopsB.put(OpOp2.LESSEQUAL, Binary.OperationTypes.LESS_THAN_OR_EQUALS);
        HopsOpOp2LopsB.put(OpOp2.GREATER, Binary.OperationTypes.GREATER_THAN);
        HopsOpOp2LopsB.put(OpOp2.GREATEREQUAL, Binary.OperationTypes.GREATER_THAN_OR_EQUALS);
        HopsOpOp2LopsB.put(OpOp2.EQUAL, Binary.OperationTypes.EQUALS);
        HopsOpOp2LopsB.put(OpOp2.NOTEQUAL, Binary.OperationTypes.NOT_EQUALS);
        HopsOpOp2LopsB.put(OpOp2.MIN, Binary.OperationTypes.MIN);
        HopsOpOp2LopsB.put(OpOp2.MAX, Binary.OperationTypes.MAX);
        HopsOpOp2LopsB.put(OpOp2.AND, Binary.OperationTypes.AND);
        HopsOpOp2LopsB.put(OpOp2.XOR, Binary.OperationTypes.XOR);
        HopsOpOp2LopsB.put(OpOp2.OR, Binary.OperationTypes.OR);
        HopsOpOp2LopsB.put(OpOp2.SOLVE, Binary.OperationTypes.SOLVE);
        HopsOpOp2LopsB.put(OpOp2.POW, Binary.OperationTypes.POW);
        HopsOpOp2LopsB.put(OpOp2.LOG, Binary.OperationTypes.NOTSUPPORTED);
        HopsOpOp2LopsB.put(OpOp2.BITWAND, Binary.OperationTypes.BW_AND);
        HopsOpOp2LopsB.put(OpOp2.BITWOR, Binary.OperationTypes.BW_OR);
        HopsOpOp2LopsB.put(OpOp2.BITWXOR, Binary.OperationTypes.BW_XOR);
        HopsOpOp2LopsB.put(OpOp2.BITWSHIFTL, Binary.OperationTypes.BW_SHIFTL);
        HopsOpOp2LopsB.put(OpOp2.BITWSHIFTR, Binary.OperationTypes.BW_SHIFTR);
        HopsOpOp2LopsBS = new HashMap();
        HopsOpOp2LopsBS.put(OpOp2.PLUS, BinaryScalar.OperationTypes.ADD);
        HopsOpOp2LopsBS.put(OpOp2.MINUS, BinaryScalar.OperationTypes.SUBTRACT);
        HopsOpOp2LopsBS.put(OpOp2.MULT, BinaryScalar.OperationTypes.MULTIPLY);
        HopsOpOp2LopsBS.put(OpOp2.DIV, BinaryScalar.OperationTypes.DIVIDE);
        HopsOpOp2LopsBS.put(OpOp2.MODULUS, BinaryScalar.OperationTypes.MODULUS);
        HopsOpOp2LopsBS.put(OpOp2.INTDIV, BinaryScalar.OperationTypes.INTDIV);
        HopsOpOp2LopsBS.put(OpOp2.LESS, BinaryScalar.OperationTypes.LESS_THAN);
        HopsOpOp2LopsBS.put(OpOp2.LESSEQUAL, BinaryScalar.OperationTypes.LESS_THAN_OR_EQUALS);
        HopsOpOp2LopsBS.put(OpOp2.GREATER, BinaryScalar.OperationTypes.GREATER_THAN);
        HopsOpOp2LopsBS.put(OpOp2.GREATEREQUAL, BinaryScalar.OperationTypes.GREATER_THAN_OR_EQUALS);
        HopsOpOp2LopsBS.put(OpOp2.EQUAL, BinaryScalar.OperationTypes.EQUALS);
        HopsOpOp2LopsBS.put(OpOp2.NOTEQUAL, BinaryScalar.OperationTypes.NOT_EQUALS);
        HopsOpOp2LopsBS.put(OpOp2.MIN, BinaryScalar.OperationTypes.MIN);
        HopsOpOp2LopsBS.put(OpOp2.MAX, BinaryScalar.OperationTypes.MAX);
        HopsOpOp2LopsBS.put(OpOp2.AND, BinaryScalar.OperationTypes.AND);
        HopsOpOp2LopsBS.put(OpOp2.OR, BinaryScalar.OperationTypes.OR);
        HopsOpOp2LopsBS.put(OpOp2.XOR, BinaryScalar.OperationTypes.XOR);
        HopsOpOp2LopsBS.put(OpOp2.LOG, BinaryScalar.OperationTypes.LOG);
        HopsOpOp2LopsBS.put(OpOp2.POW, BinaryScalar.OperationTypes.POW);
        HopsOpOp2LopsBS.put(OpOp2.PRINT, BinaryScalar.OperationTypes.PRINT);
        HopsOpOp2LopsBS.put(OpOp2.BITWAND, BinaryScalar.OperationTypes.BW_AND);
        HopsOpOp2LopsBS.put(OpOp2.BITWOR, BinaryScalar.OperationTypes.BW_OR);
        HopsOpOp2LopsBS.put(OpOp2.BITWXOR, BinaryScalar.OperationTypes.BW_XOR);
        HopsOpOp2LopsBS.put(OpOp2.BITWSHIFTL, BinaryScalar.OperationTypes.BW_SHIFTL);
        HopsOpOp2LopsBS.put(OpOp2.BITWSHIFTR, BinaryScalar.OperationTypes.BW_SHIFTR);
        HopsOpOp2LopsU = new HashMap();
        HopsOpOp2LopsU.put(OpOp2.PLUS, Unary.OperationTypes.ADD);
        HopsOpOp2LopsU.put(OpOp2.MINUS, Unary.OperationTypes.SUBTRACT);
        HopsOpOp2LopsU.put(OpOp2.MULT, Unary.OperationTypes.MULTIPLY);
        HopsOpOp2LopsU.put(OpOp2.DIV, Unary.OperationTypes.DIVIDE);
        HopsOpOp2LopsU.put(OpOp2.MODULUS, Unary.OperationTypes.MODULUS);
        HopsOpOp2LopsU.put(OpOp2.INTDIV, Unary.OperationTypes.INTDIV);
        HopsOpOp2LopsU.put(OpOp2.MINUS1_MULT, Unary.OperationTypes.MINUS1_MULTIPLY);
        HopsOpOp2LopsU.put(OpOp2.LESSEQUAL, Unary.OperationTypes.LESS_THAN_OR_EQUALS);
        HopsOpOp2LopsU.put(OpOp2.LESS, Unary.OperationTypes.LESS_THAN);
        HopsOpOp2LopsU.put(OpOp2.GREATEREQUAL, Unary.OperationTypes.GREATER_THAN_OR_EQUALS);
        HopsOpOp2LopsU.put(OpOp2.GREATER, Unary.OperationTypes.GREATER_THAN);
        HopsOpOp2LopsU.put(OpOp2.EQUAL, Unary.OperationTypes.EQUALS);
        HopsOpOp2LopsU.put(OpOp2.NOTEQUAL, Unary.OperationTypes.NOT_EQUALS);
        HopsOpOp2LopsU.put(OpOp2.AND, Unary.OperationTypes.AND);
        HopsOpOp2LopsU.put(OpOp2.OR, Unary.OperationTypes.OR);
        HopsOpOp2LopsU.put(OpOp2.XOR, Unary.OperationTypes.XOR);
        HopsOpOp2LopsU.put(OpOp2.MAX, Unary.OperationTypes.MAX);
        HopsOpOp2LopsU.put(OpOp2.MIN, Unary.OperationTypes.MIN);
        HopsOpOp2LopsU.put(OpOp2.LOG, Unary.OperationTypes.LOG);
        HopsOpOp2LopsU.put(OpOp2.POW, Unary.OperationTypes.POW);
        HopsOpOp2LopsU.put(OpOp2.MINUS_NZ, Unary.OperationTypes.SUBTRACT_NZ);
        HopsOpOp2LopsU.put(OpOp2.LOG_NZ, Unary.OperationTypes.LOG_NZ);
        HopsOpOp2LopsU.put(OpOp2.BITWAND, Unary.OperationTypes.BW_AND);
        HopsOpOp2LopsU.put(OpOp2.BITWOR, Unary.OperationTypes.BW_OR);
        HopsOpOp2LopsU.put(OpOp2.BITWXOR, Unary.OperationTypes.BW_XOR);
        HopsOpOp2LopsU.put(OpOp2.BITWSHIFTL, Unary.OperationTypes.BW_SHIFTL);
        HopsOpOp2LopsU.put(OpOp2.BITWSHIFTR, Unary.OperationTypes.BW_SHIFTR);
        HopsOpOp1LopsU = new HashMap();
        HopsOpOp1LopsU.put(OpOp1.NOT, Unary.OperationTypes.NOT);
        HopsOpOp1LopsU.put(OpOp1.ABS, Unary.OperationTypes.ABS);
        HopsOpOp1LopsU.put(OpOp1.SIN, Unary.OperationTypes.SIN);
        HopsOpOp1LopsU.put(OpOp1.COS, Unary.OperationTypes.COS);
        HopsOpOp1LopsU.put(OpOp1.TAN, Unary.OperationTypes.TAN);
        HopsOpOp1LopsU.put(OpOp1.ASIN, Unary.OperationTypes.ASIN);
        HopsOpOp1LopsU.put(OpOp1.ACOS, Unary.OperationTypes.ACOS);
        HopsOpOp1LopsU.put(OpOp1.ATAN, Unary.OperationTypes.ATAN);
        HopsOpOp1LopsU.put(OpOp1.SINH, Unary.OperationTypes.SINH);
        HopsOpOp1LopsU.put(OpOp1.COSH, Unary.OperationTypes.COSH);
        HopsOpOp1LopsU.put(OpOp1.TANH, Unary.OperationTypes.TANH);
        HopsOpOp1LopsU.put(OpOp1.SIGN, Unary.OperationTypes.SIGN);
        HopsOpOp1LopsU.put(OpOp1.SQRT, Unary.OperationTypes.SQRT);
        HopsOpOp1LopsU.put(OpOp1.EXP, Unary.OperationTypes.EXP);
        HopsOpOp1LopsU.put(OpOp1.LOG, Unary.OperationTypes.LOG);
        HopsOpOp1LopsU.put(OpOp1.ROUND, Unary.OperationTypes.ROUND);
        HopsOpOp1LopsU.put(OpOp1.CEIL, Unary.OperationTypes.CEIL);
        HopsOpOp1LopsU.put(OpOp1.FLOOR, Unary.OperationTypes.FLOOR);
        HopsOpOp1LopsU.put(OpOp1.CUMSUM, Unary.OperationTypes.CUMSUM);
        HopsOpOp1LopsU.put(OpOp1.CUMPROD, Unary.OperationTypes.CUMPROD);
        HopsOpOp1LopsU.put(OpOp1.CUMMIN, Unary.OperationTypes.CUMMIN);
        HopsOpOp1LopsU.put(OpOp1.CUMMAX, Unary.OperationTypes.CUMMAX);
        HopsOpOp1LopsU.put(OpOp1.INVERSE, Unary.OperationTypes.INVERSE);
        HopsOpOp1LopsU.put(OpOp1.CHOLESKY, Unary.OperationTypes.CHOLESKY);
        HopsOpOp1LopsU.put(OpOp1.CAST_AS_SCALAR, Unary.OperationTypes.NOTSUPPORTED);
        HopsOpOp1LopsU.put(OpOp1.CAST_AS_MATRIX, Unary.OperationTypes.NOTSUPPORTED);
        HopsOpOp1LopsU.put(OpOp1.SPROP, Unary.OperationTypes.SPROP);
        HopsOpOp1LopsU.put(OpOp1.SIGMOID, Unary.OperationTypes.SIGMOID);
        HopsOpOp1LopsU.put(OpOp1.LOG_NZ, Unary.OperationTypes.LOG_NZ);
        HopsOpOp1LopsU.put(OpOp1.CAST_AS_MATRIX, Unary.OperationTypes.CAST_AS_MATRIX);
        HopsOpOp1LopsU.put(OpOp1.CAST_AS_FRAME, Unary.OperationTypes.CAST_AS_FRAME);
        HopsOpOp1LopsUS = new HashMap();
        HopsOpOp1LopsUS.put(OpOp1.NOT, UnaryCP.OperationTypes.NOT);
        HopsOpOp1LopsUS.put(OpOp1.ABS, UnaryCP.OperationTypes.ABS);
        HopsOpOp1LopsUS.put(OpOp1.SIN, UnaryCP.OperationTypes.SIN);
        HopsOpOp1LopsUS.put(OpOp1.COS, UnaryCP.OperationTypes.COS);
        HopsOpOp1LopsUS.put(OpOp1.TAN, UnaryCP.OperationTypes.TAN);
        HopsOpOp1LopsUS.put(OpOp1.ASIN, UnaryCP.OperationTypes.ASIN);
        HopsOpOp1LopsUS.put(OpOp1.ACOS, UnaryCP.OperationTypes.ACOS);
        HopsOpOp1LopsUS.put(OpOp1.ATAN, UnaryCP.OperationTypes.ATAN);
        HopsOpOp1LopsUS.put(OpOp1.SINH, UnaryCP.OperationTypes.SINH);
        HopsOpOp1LopsUS.put(OpOp1.COSH, UnaryCP.OperationTypes.COSH);
        HopsOpOp1LopsUS.put(OpOp1.TANH, UnaryCP.OperationTypes.TANH);
        HopsOpOp1LopsUS.put(OpOp1.SQRT, UnaryCP.OperationTypes.SQRT);
        HopsOpOp1LopsUS.put(OpOp1.EXP, UnaryCP.OperationTypes.EXP);
        HopsOpOp1LopsUS.put(OpOp1.LOG, UnaryCP.OperationTypes.LOG);
        HopsOpOp1LopsUS.put(OpOp1.CAST_AS_SCALAR, UnaryCP.OperationTypes.CAST_AS_SCALAR);
        HopsOpOp1LopsUS.put(OpOp1.CAST_AS_MATRIX, UnaryCP.OperationTypes.CAST_AS_MATRIX);
        HopsOpOp1LopsUS.put(OpOp1.CAST_AS_FRAME, UnaryCP.OperationTypes.CAST_AS_FRAME);
        HopsOpOp1LopsUS.put(OpOp1.CAST_AS_DOUBLE, UnaryCP.OperationTypes.CAST_AS_DOUBLE);
        HopsOpOp1LopsUS.put(OpOp1.CAST_AS_INT, UnaryCP.OperationTypes.CAST_AS_INT);
        HopsOpOp1LopsUS.put(OpOp1.CAST_AS_BOOLEAN, UnaryCP.OperationTypes.CAST_AS_BOOLEAN);
        HopsOpOp1LopsUS.put(OpOp1.NROW, UnaryCP.OperationTypes.NROW);
        HopsOpOp1LopsUS.put(OpOp1.NCOL, UnaryCP.OperationTypes.NCOL);
        HopsOpOp1LopsUS.put(OpOp1.LENGTH, UnaryCP.OperationTypes.LENGTH);
        HopsOpOp1LopsUS.put(OpOp1.PRINT, UnaryCP.OperationTypes.PRINT);
        HopsOpOp1LopsUS.put(OpOp1.ASSERT, UnaryCP.OperationTypes.ASSERT);
        HopsOpOp1LopsUS.put(OpOp1.ROUND, UnaryCP.OperationTypes.ROUND);
        HopsOpOp1LopsUS.put(OpOp1.CEIL, UnaryCP.OperationTypes.CEIL);
        HopsOpOp1LopsUS.put(OpOp1.FLOOR, UnaryCP.OperationTypes.FLOOR);
        HopsOpOp1LopsUS.put(OpOp1.STOP, UnaryCP.OperationTypes.STOP);
        HopsOpOp3Lops = new HashMap();
        HopsOpOp3Lops.put(OpOp3.PLUS_MULT, Ternary.OperationType.PLUS_MULT);
        HopsOpOp3Lops.put(OpOp3.MINUS_MULT, Ternary.OperationType.MINUS_MULT);
        HopsOpOp3Lops.put(OpOp3.IFELSE, Ternary.OperationType.IFELSE);
        HopsOpOpNLops = new HashMap();
        HopsOpOpNLops.put(OpOpN.PRINTF, Nary.OperationType.PRINTF);
        HopsOpOpNLops.put(OpOpN.CBIND, Nary.OperationType.CBIND);
        HopsOpOpNLops.put(OpOpN.RBIND, Nary.OperationType.RBIND);
        HopsOpOpNLops.put(OpOpN.EVAL, Nary.OperationType.EVAL);
        HopsOpOp12String = new HashMap();
        HopsOpOp12String.put(OpOp1.ABS, "abs");
        HopsOpOp12String.put(OpOp1.CAST_AS_SCALAR, "castAsScalar");
        HopsOpOp12String.put(OpOp1.COS, "cos");
        HopsOpOp12String.put(OpOp1.EIGEN, "eigen");
        HopsOpOp12String.put(OpOp1.SVD, "svd");
        HopsOpOp12String.put(OpOp1.EXP, "exp");
        HopsOpOp12String.put(OpOp1.IQM, "iqm");
        HopsOpOp12String.put(OpOp1.MEDIAN, "median");
        HopsOpOp12String.put(OpOp1.LENGTH, "length");
        HopsOpOp12String.put(OpOp1.LOG, "log");
        HopsOpOp12String.put(OpOp1.NCOL, "ncol");
        HopsOpOp12String.put(OpOp1.NOT, "!");
        HopsOpOp12String.put(OpOp1.NROW, "nrow");
        HopsOpOp12String.put(OpOp1.PRINT, "print");
        HopsOpOp12String.put(OpOp1.ASSERT, "assert");
        HopsOpOp12String.put(OpOp1.ROUND, "round");
        HopsOpOp12String.put(OpOp1.SIN, "sin");
        HopsOpOp12String.put(OpOp1.SQRT, "sqrt");
        HopsOpOp12String.put(OpOp1.TAN, "tan");
        HopsOpOp12String.put(OpOp1.ASIN, "asin");
        HopsOpOp12String.put(OpOp1.ACOS, "acos");
        HopsOpOp12String.put(OpOp1.ATAN, "atan");
        HopsOpOp12String.put(OpOp1.SINH, "sinh");
        HopsOpOp12String.put(OpOp1.COSH, "cosh");
        HopsOpOp12String.put(OpOp1.TANH, "tanh");
        HopsOpOp12String.put(OpOp1.STOP, "stop");
        HopsOpOp12String.put(OpOp1.INVERSE, "inv");
        HopsOpOp12String.put(OpOp1.SPROP, "sprop");
        HopsOpOp12String.put(OpOp1.SIGMOID, "sigmoid");
        HopsParameterizedBuiltinLops = new HashMap();
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.CDF, ParameterizedBuiltin.OperationTypes.CDF);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.INVCDF, ParameterizedBuiltin.OperationTypes.INVCDF);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.RMEMPTY, ParameterizedBuiltin.OperationTypes.RMEMPTY);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.REPLACE, ParameterizedBuiltin.OperationTypes.REPLACE);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.REXPAND, ParameterizedBuiltin.OperationTypes.REXPAND);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.TRANSFORMAPPLY, ParameterizedBuiltin.OperationTypes.TRANSFORMAPPLY);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.TRANSFORMDECODE, ParameterizedBuiltin.OperationTypes.TRANSFORMDECODE);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.TRANSFORMCOLMAP, ParameterizedBuiltin.OperationTypes.TRANSFORMCOLMAP);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.TRANSFORMMETA, ParameterizedBuiltin.OperationTypes.TRANSFORMMETA);
        HopsParameterizedBuiltinLops.put(ParamBuiltinOp.TOSTRING, ParameterizedBuiltin.OperationTypes.TOSTRING);
        HopsOpOp2String = new HashMap();
        HopsOpOp2String.put(OpOp2.PLUS, "+");
        HopsOpOp2String.put(OpOp2.MINUS, "-");
        HopsOpOp2String.put(OpOp2.MINUS_NZ, "-nz");
        HopsOpOp2String.put(OpOp2.MINUS1_MULT, "-1*");
        HopsOpOp2String.put(OpOp2.MULT, "*");
        HopsOpOp2String.put(OpOp2.DIV, "/");
        HopsOpOp2String.put(OpOp2.MODULUS, "%%");
        HopsOpOp2String.put(OpOp2.INTDIV, "%/%");
        HopsOpOp2String.put(OpOp2.MIN, "min");
        HopsOpOp2String.put(OpOp2.MAX, "max");
        HopsOpOp2String.put(OpOp2.LESSEQUAL, "<=");
        HopsOpOp2String.put(OpOp2.LESS, "<");
        HopsOpOp2String.put(OpOp2.GREATEREQUAL, ">=");
        HopsOpOp2String.put(OpOp2.GREATER, ">");
        HopsOpOp2String.put(OpOp2.EQUAL, "==");
        HopsOpOp2String.put(OpOp2.NOTEQUAL, "!=");
        HopsOpOp2String.put(OpOp2.OR, "|");
        HopsOpOp2String.put(OpOp2.AND, "&");
        HopsOpOp2String.put(OpOp2.LOG, "log");
        HopsOpOp2String.put(OpOp2.LOG_NZ, "log_nz");
        HopsOpOp2String.put(OpOp2.POW, "^");
        HopsOpOp2String.put(OpOp2.CONCAT, "concat");
        HopsOpOp2String.put(OpOp2.INVALID, "?");
        HopsOpOp2String.put(OpOp2.QUANTILE, "quantile");
        HopsOpOp2String.put(OpOp2.INTERQUANTILE, "interquantile");
        HopsOpOp2String.put(OpOp2.IQM, "IQM");
        HopsOpOp2String.put(OpOp2.MEDIAN, "median");
        HopsOpOp2String.put(OpOp2.CENTRALMOMENT, "cm");
        HopsOpOp2String.put(OpOp2.COVARIANCE, "cov");
        HopsOpOp2String.put(OpOp2.CBIND, "cbind");
        HopsOpOp2String.put(OpOp2.RBIND, "rbind");
        HopsOpOp2String.put(OpOp2.SOLVE, "solve");
        HopsOpOp2String.put(OpOp2.XOR, "xor");
        HopsOpOp2String.put(OpOp2.BITWAND, "bitwAnd");
        HopsOpOp2String.put(OpOp2.BITWOR, "bitwOr");
        HopsOpOp2String.put(OpOp2.BITWXOR, "bitwXor");
        HopsOpOp2String.put(OpOp2.BITWSHIFTL, "bitwShiftL");
        HopsOpOp2String.put(OpOp2.BITWSHIFTR, "bitwShiftR");
        HopsOpOp3String = new HashMap();
        HopsOpOp3String.put(OpOp3.QUANTILE, "quantile");
        HopsOpOp3String.put(OpOp3.INTERQUANTILE, "interquantile");
        HopsOpOp3String.put(OpOp3.CTABLE, "ctable");
        HopsOpOp3String.put(OpOp3.CENTRALMOMENT, "cm");
        HopsOpOp3String.put(OpOp3.COVARIANCE, "cov");
        HopsOpOp3String.put(OpOp3.PLUS_MULT, "+*");
        HopsOpOp3String.put(OpOp3.MINUS_MULT, "-*");
        HopsOpOp3String.put(OpOp3.IFELSE, "ifelse");
        HopsOpOp4String = new HashMap();
        HopsOpOp4String.put(OpOp4.WSLOSS, "wsloss");
        HopsOpOp4String.put(OpOp4.WSIGMOID, "wsigmoid");
        HopsOpOp4String.put(OpOp4.WCEMM, "wcemm");
        HopsOpOp4String.put(OpOp4.WDIVMM, "wdivmm");
        HopsOpOp4String.put(OpOp4.WUMM, "wumm");
        HopsDirection2String = new HashMap();
        HopsDirection2String.put(Direction.RowCol, "RC");
        HopsDirection2String.put(Direction.Col, "C");
        HopsDirection2String.put(Direction.Row, "R");
        HopsAgg2String = new HashMap();
        HopsAgg2String.put(AggOp.SUM, "+");
        HopsAgg2String.put(AggOp.SUM_SQ, "sq+");
        HopsAgg2String.put(AggOp.PROD, "*");
        HopsAgg2String.put(AggOp.MIN, "min");
        HopsAgg2String.put(AggOp.MAX, "max");
        HopsAgg2String.put(AggOp.MAXINDEX, "maxindex");
        HopsAgg2String.put(AggOp.MININDEX, "minindex");
        HopsAgg2String.put(AggOp.TRACE, "trace");
        HopsAgg2String.put(AggOp.MEAN, "mean");
        HopsAgg2String.put(AggOp.VAR, "var");
        HopsTransf2String = new HashMap();
        HopsTransf2String.put(ReOrgOp.TRANSPOSE, "t");
        HopsTransf2String.put(ReOrgOp.DIAG, "diag");
        HopsTransf2String.put(ReOrgOp.RESHAPE, "rshape");
        HopsTransf2String.put(ReOrgOp.SORT, "sort");
        HopsData2String = new HashMap();
        HopsData2String.put(DataOpTypes.PERSISTENTREAD, "PRead");
        HopsData2String.put(DataOpTypes.PERSISTENTWRITE, "PWrite");
        HopsData2String.put(DataOpTypes.TRANSIENTWRITE, "TWrite");
        HopsData2String.put(DataOpTypes.TRANSIENTREAD, "TRead");
    }

    public static enum Direction {
        RowCol,
        Row,
        Col;

    }

    public static enum DataOpTypes {
        PERSISTENTREAD,
        PERSISTENTWRITE,
        TRANSIENTREAD,
        TRANSIENTWRITE,
        FUNCTIONOUTPUT;

    }

    public static enum FileFormatTypes {
        TEXT,
        BINARY,
        MM,
        CSV;

    }

    public static enum ParamBuiltinOp {
        INVALID,
        CDF,
        INVCDF,
        GROUPEDAGG,
        RMEMPTY,
        REPLACE,
        REXPAND,
        TRANSFORMAPPLY,
        TRANSFORMDECODE,
        TRANSFORMCOLMAP,
        TRANSFORMMETA,
        TOSTRING;

    }

    public static enum DataGenMethod {
        RAND,
        SEQ,
        SINIT,
        SAMPLE,
        INVALID;

    }

    public static enum ConvOp {
        MAX_POOLING,
        MAX_POOLING_BACKWARD,
        AVG_POOLING,
        AVG_POOLING_BACKWARD,
        DIRECT_CONV2D,
        DIRECT_CONV2D_BACKWARD_FILTER,
        DIRECT_CONV2D_BACKWARD_DATA,
        BIAS_ADD,
        BIAS_MULTIPLY;

    }

    public static enum ReOrgOp {
        TRANSPOSE,
        DIAG,
        RESHAPE,
        SORT,
        REV;

    }

    public static enum AggOp {
        SUM,
        SUM_SQ,
        MIN,
        MAX,
        TRACE,
        PROD,
        MEAN,
        VAR,
        MAXINDEX,
        MININDEX;

    }

    public static enum OpOpN {
        PRINTF,
        CBIND,
        RBIND,
        EVAL;

    }

    public static enum OpOp4 {
        WSLOSS,
        WSIGMOID,
        WDIVMM,
        WCEMM,
        WUMM;

    }

    public static enum OpOp3 {
        QUANTILE,
        INTERQUANTILE,
        CTABLE,
        CENTRALMOMENT,
        COVARIANCE,
        PLUS_MULT,
        MINUS_MULT,
        IFELSE;

    }

    public static enum OpOp2 {
        PLUS,
        MINUS,
        MULT,
        DIV,
        MODULUS,
        INTDIV,
        LESS,
        LESSEQUAL,
        GREATER,
        GREATEREQUAL,
        EQUAL,
        NOTEQUAL,
        MIN,
        MAX,
        AND,
        OR,
        XOR,
        LOG,
        POW,
        PRINT,
        CONCAT,
        QUANTILE,
        INTERQUANTILE,
        IQM,
        CENTRALMOMENT,
        COVARIANCE,
        CBIND,
        RBIND,
        SOLVE,
        MEDIAN,
        INVALID,
        MINUS_NZ,
        LOG_NZ,
        MINUS1_MULT,
        BITWAND,
        BITWOR,
        BITWXOR,
        BITWSHIFTL,
        BITWSHIFTR;

    }

    public static enum OpOp1 {
        NOT,
        ABS,
        SIN,
        COS,
        TAN,
        ASIN,
        ACOS,
        ATAN,
        SINH,
        COSH,
        TANH,
        SIGN,
        SQRT,
        LOG,
        EXP,
        CAST_AS_SCALAR,
        CAST_AS_MATRIX,
        CAST_AS_FRAME,
        CAST_AS_DOUBLE,
        CAST_AS_INT,
        CAST_AS_BOOLEAN,
        PRINT,
        ASSERT,
        EIGEN,
        NROW,
        NCOL,
        LENGTH,
        ROUND,
        IQM,
        STOP,
        CEIL,
        FLOOR,
        MEDIAN,
        INVERSE,
        CHOLESKY,
        SVD,
        CUMSUM,
        CUMPROD,
        CUMMIN,
        CUMMAX,
        SPROP,
        SIGMOID,
        LOG_NZ;

    }

    public static interface MultiThreadedHop {
        public void setMaxNumThreads(int var1);

        public int getMaxNumThreads();
    }
}

