/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import java.io.IOException;
import java.util.Iterator;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;
import org.apache.sysml.udf.Scalar;

public class MultiInputCbind
extends PackageFunction {
    private static final long serialVersionUID = -4266180315672563097L;
    private Matrix ret;
    private MatrixBlock retMB;
    long numRetRows;
    long numRetCols;
    boolean spagetize;

    @Override
    public int getNumFunctionOutputs() {
        return 1;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        if (pos == 0) {
            return this.ret;
        }
        throw new RuntimeException("MultiInputCbind produces only one output");
    }

    @Override
    public void execute() {
        int numInputs = Integer.parseInt(((Scalar)this.getFunctionInput(0)).getValue());
        this.spagetize = Boolean.parseBoolean(((Scalar)this.getFunctionInput(1)).getValue());
        try {
            this.numRetCols = 0L;
            if (this.spagetize) {
                MatrixBlock in = (MatrixBlock)((Matrix)this.getFunctionInput(2)).getMatrixObject().acquireRead();
                this.numRetRows = in.getNumRows() * in.getNumColumns();
                this.numRetCols = numInputs;
                ((Matrix)this.getFunctionInput(2)).getMatrixObject().release();
            } else {
                for (int inputID = 2; inputID < numInputs + 2; ++inputID) {
                    MatrixBlock in = (MatrixBlock)((Matrix)this.getFunctionInput(inputID)).getMatrixObject().acquireRead();
                    this.numRetRows = in.getNumRows();
                    this.numRetCols += (long)in.getNumColumns();
                    ((Matrix)this.getFunctionInput(inputID)).getMatrixObject().release();
                }
            }
        }
        catch (CacheException e) {
            throw new RuntimeException("Error while executing MultiInputCbind", e);
        }
        this.allocateOutput();
        double[] retData = this.retMB.getDenseBlockValues();
        try {
            int startColumn = 0;
            for (int inputID = 2; inputID < numInputs + 2; ++inputID) {
                int outputColIndex;
                MatrixBlock in = (MatrixBlock)((Matrix)this.getFunctionInput(inputID)).getMatrixObject().acquireRead();
                if (this.spagetize && (long)(in.getNumRows() * in.getNumColumns()) != this.numRetRows) {
                    throw new RuntimeException("Expected the inputs to be of same size when spagetization is turned on.");
                }
                int inputNumCols = in.getNumColumns();
                if (in.isInSparseFormat()) {
                    Iterator<IJV> iter = in.getSparseBlockIterator();
                    while (iter.hasNext()) {
                        int outputRowIndex;
                        IJV ijv = iter.next();
                        if (this.spagetize) {
                            outputRowIndex = ijv.getI() * inputNumCols + ijv.getJ();
                            outputColIndex = inputID - 2;
                            retData[outputRowIndex * this.retMB.getNumColumns() + outputColIndex] = ijv.getV();
                            continue;
                        }
                        outputRowIndex = ijv.getI();
                        outputColIndex = ijv.getJ() + startColumn;
                        retData[outputRowIndex * this.retMB.getNumColumns() + outputColIndex] = ijv.getV();
                    }
                } else {
                    double[] denseBlock = in.getDenseBlockValues();
                    if (denseBlock != null) {
                        if (this.spagetize) {
                            int j = inputID - 2;
                            int i = 0;
                            while ((long)i < this.numRetRows) {
                                retData[(int)((long)i * this.numRetCols + (long)j)] = denseBlock[i];
                                ++i;
                            }
                        } else {
                            for (int i = 0; i < this.retMB.getNumRows(); ++i) {
                                for (int j = 0; j < inputNumCols; ++j) {
                                    outputColIndex = j + startColumn;
                                    retData[(int)((long)i * this.numRetCols + (long)outputColIndex)] = denseBlock[i * inputNumCols + j];
                                }
                            }
                        }
                    }
                }
                ((Matrix)this.getFunctionInput(inputID)).getMatrixObject().release();
                startColumn += inputNumCols;
            }
        }
        catch (CacheException e) {
            throw new RuntimeException("Error while executing MultiInputCbind", e);
        }
        this.retMB.recomputeNonZeros();
        try {
            this.retMB.examSparsity();
            this.ret.setMatrixDoubleArray(this.retMB, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException("Error while executing MultiInputCbind", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing MultiInputCbind", e);
        }
    }

    private void allocateOutput() {
        String dir = this.createOutputFilePathAndName("TMP");
        this.ret = new Matrix(dir, this.numRetRows, this.numRetCols, Matrix.ValueType.Double);
        this.retMB = new MatrixBlock((int)this.numRetRows, (int)this.numRetCols, false);
        this.retMB.allocateDenseBlock();
    }
}

