/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.algorithms.kmeans.Get_sample_maps_output;

public class Kmeans
extends Script {
    public Kmeans() {
        String string = "scripts/algorithms/Kmeans.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Get_sample_maps_output get_sample_maps(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/Kmeans.dml') as mlcontextns;[sample_maps, sample_col_map, sample_block_size] = mlcontextns::get_sample_maps(num_records, num_samples, approx_sample_size);";
        Script script = new Script(string);
        script.in("num_records", object).in("num_samples", object2).in("approx_sample_size", object3).out("sample_maps").out("sample_col_map").out("sample_block_size");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("sample_maps");
        Matrix matrix2 = mLResults.getMatrix("sample_col_map");
        long l = mLResults.getLong("sample_block_size");
        Get_sample_maps_output get_sample_maps_output = new Get_sample_maps_output(matrix, matrix2, l);
        return get_sample_maps_output;
    }

    public String get_sample_maps__docs() {
        String string = "get_sample_maps = function (int num_records, int num_samples, int approx_sample_size)\n    return (Matrix[double] sample_maps, Matrix[double] sample_col_map, int sample_block_size)\n{\n    if (approx_sample_size < num_records) {\n        # Input value \"approx_sample_size\" is the average sample size; increase it by ~10 std.dev's\n        # to get the sample block size (to allocate space):\n        sample_block_size = as.integer (approx_sample_size + round (10 * sqrt (approx_sample_size)));\n        num_rows = sample_block_size * num_samples;\n        \n        # Generate all samples in parallel by converting uniform random values into random\n        # integer skip-ahead intervals and prefix-summing them:\n        sample_rec_ids = Rand (rows = sample_block_size, cols = num_samples, min = 0.0, max = 1.0);\n        sample_rec_ids = round (log (sample_rec_ids) / log (1.0 - approx_sample_size / num_records) + 0.5);\n        # Prob [k-1 < log(uniform)/log(1-p) < k] = p*(1-p)^(k-1) = Prob [k-1 zeros before a one]\n        sample_rec_ids = cumsum (sample_rec_ids);  #  (skip to next one) --> (skip to i-th one)\n        \n        # Replace all sample record ids over \"num_records\" (i.e. out of range) by \"num_records + 1\":\n        is_sample_rec_id_within_range = (sample_rec_ids <= num_records);\n        sample_rec_ids = sample_rec_ids * is_sample_rec_id_within_range \n                       + (num_records + 1) * (1 - is_sample_rec_id_within_range);\n        \n        # Rearrange all samples (and their out-of-range indicators) into one column-vector:\n        sample_rec_ids = \n            matrix (sample_rec_ids, rows = num_rows, cols = 1, byrow = FALSE);\n        is_row_in_samples = \n            matrix (is_sample_rec_id_within_range, rows = num_rows, cols = 1, byrow = FALSE);\n\n        # Use contingency table to create the \"sample_maps\" matrix that is a vertical concatenation\n        # of 0-1-matrices, one per sample, each with 1s at (i, sample_record[i]) and 0s elsewhere:\n        sample_maps_raw = table (seq (1, num_rows), sample_rec_ids);\n        max_rec_id = ncol (sample_maps_raw);\n        if (max_rec_id >= num_records) {\n            sample_maps = sample_maps_raw [, 1 : num_records];\n        } else {\n            sample_maps = matrix (0, rows = num_rows, cols = num_records);        \n            sample_maps [, 1 : max_rec_id] = sample_maps_raw;\n        }\n        \n        # Create a 0-1-matrix that maps each sample column ID into all row positions of the\n        # corresponding sample; map out-of-sample-range positions to row id = num_rows + 1:\n        sample_positions = (num_rows + 1) - is_row_in_samples * seq (num_rows, 1, -1);\n        # Column ID positions = 1, 1, ..., 1, 2, 2, ..., 2, . . . , n_c, n_c, ..., n_c:\n        col_positions = round (0.5 + seq (0, num_rows - 1, 1) / sample_block_size);\n        sample_col_map = table (sample_positions, col_positions);\n        # Remove the out-of-sample-range positions by cutting off the last row:\n        sample_col_map = sample_col_map [1 : (num_rows), ];\n        \n    } else {\n        one_per_record = matrix (1, rows = num_records, cols = 1);\n        sample_block_size = num_records;\n        sample_maps    = matrix (0, rows = (num_records * num_samples), cols = num_records);\n        sample_col_map = matrix (0, rows = (num_records * num_samples), cols = num_samples);\n        for (i in 1:num_samples) {\n            sample_maps    [(num_records * (i - 1) + 1) : (num_records * i),  ] = diag (one_per_record);\n            sample_col_map [(num_records * (i - 1) + 1) : (num_records * i), i] = one_per_record;\n}   }   }\n";
        return string;
    }

    public String get_sample_maps__source() {
        String string = "get_sample_maps = function (int num_records, int num_samples, int approx_sample_size)\n    return (Matrix[double] sample_maps, Matrix[double] sample_col_map, int sample_block_size)\n{\n    if (approx_sample_size < num_records) {\n        # Input value \"approx_sample_size\" is the average sample size; increase it by ~10 std.dev's\n        # to get the sample block size (to allocate space):\n        sample_block_size = as.integer (approx_sample_size + round (10 * sqrt (approx_sample_size)));\n        num_rows = sample_block_size * num_samples;\n        \n        # Generate all samples in parallel by converting uniform random values into random\n        # integer skip-ahead intervals and prefix-summing them:\n        sample_rec_ids = Rand (rows = sample_block_size, cols = num_samples, min = 0.0, max = 1.0);\n        sample_rec_ids = round (log (sample_rec_ids) / log (1.0 - approx_sample_size / num_records) + 0.5);\n        # Prob [k-1 < log(uniform)/log(1-p) < k] = p*(1-p)^(k-1) = Prob [k-1 zeros before a one]\n        sample_rec_ids = cumsum (sample_rec_ids);  #  (skip to next one) --> (skip to i-th one)\n        \n        # Replace all sample record ids over \"num_records\" (i.e. out of range) by \"num_records + 1\":\n        is_sample_rec_id_within_range = (sample_rec_ids <= num_records);\n        sample_rec_ids = sample_rec_ids * is_sample_rec_id_within_range \n                       + (num_records + 1) * (1 - is_sample_rec_id_within_range);\n        \n        # Rearrange all samples (and their out-of-range indicators) into one column-vector:\n        sample_rec_ids = \n            matrix (sample_rec_ids, rows = num_rows, cols = 1, byrow = FALSE);\n        is_row_in_samples = \n            matrix (is_sample_rec_id_within_range, rows = num_rows, cols = 1, byrow = FALSE);\n\n        # Use contingency table to create the \"sample_maps\" matrix that is a vertical concatenation\n        # of 0-1-matrices, one per sample, each with 1s at (i, sample_record[i]) and 0s elsewhere:\n        sample_maps_raw = table (seq (1, num_rows), sample_rec_ids);\n        max_rec_id = ncol (sample_maps_raw);\n        if (max_rec_id >= num_records) {\n            sample_maps = sample_maps_raw [, 1 : num_records];\n        } else {\n            sample_maps = matrix (0, rows = num_rows, cols = num_records);        \n            sample_maps [, 1 : max_rec_id] = sample_maps_raw;\n        }\n        \n        # Create a 0-1-matrix that maps each sample column ID into all row positions of the\n        # corresponding sample; map out-of-sample-range positions to row id = num_rows + 1:\n        sample_positions = (num_rows + 1) - is_row_in_samples * seq (num_rows, 1, -1);\n        # Column ID positions = 1, 1, ..., 1, 2, 2, ..., 2, . . . , n_c, n_c, ..., n_c:\n        col_positions = round (0.5 + seq (0, num_rows - 1, 1) / sample_block_size);\n        sample_col_map = table (sample_positions, col_positions);\n        # Remove the out-of-sample-range positions by cutting off the last row:\n        sample_col_map = sample_col_map [1 : (num_rows), ];\n        \n    } else {\n        one_per_record = matrix (1, rows = num_records, cols = 1);\n        sample_block_size = num_records;\n        sample_maps    = matrix (0, rows = (num_records * num_samples), cols = num_records);\n        sample_col_map = matrix (0, rows = (num_records * num_samples), cols = num_samples);\n        for (i in 1:num_samples) {\n            sample_maps    [(num_records * (i - 1) + 1) : (num_records * i),  ] = diag (one_per_record);\n            sample_col_map [(num_records * (i - 1) + 1) : (num_records * i), i] = one_per_record;\n}   }   }\n";
        return string;
    }
}

