/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.File;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.io.MatrixReaderFactory;
import org.apache.sysml.runtime.io.ReaderBinaryBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRBaseForCommonInstructions;
import org.apache.sysml.runtime.util.DataConverter;

public class DistributedCacheInput {
    public static final long PARTITION_SIZE = 4000000L;
    private Path _localFilePath = null;
    private long _rlen = -1L;
    private long _clen = -1L;
    private int _brlen = -1;
    private int _bclen = -1;
    private ParForProgramBlock.PDataPartitionFormat _pformat = null;
    private IndexedMatrixValue[][] dataBlocks = null;

    public DistributedCacheInput(Path p, long rows, long cols, int brlen, int bclen, ParForProgramBlock.PDataPartitionFormat pformat) {
        this._localFilePath = p;
        this._rlen = rows;
        this._clen = cols;
        this._brlen = brlen;
        this._bclen = bclen;
        this._pformat = pformat;
    }

    public long getNumRows() {
        return this._rlen;
    }

    public long getNumCols() {
        return this._clen;
    }

    public int getNumRowsPerBlock() {
        return this._brlen;
    }

    public int getNumColsPerBlock() {
        return this._bclen;
    }

    public void reset() {
        this._localFilePath = null;
        this._rlen = -1L;
        this._clen = -1L;
        this._brlen = -1;
        this._bclen = -1;
        this._pformat = null;
    }

    public IndexedMatrixValue getDataBlock(int rowBlockIndex, int colBlockIndex) throws DMLRuntimeException {
        if (this.dataBlocks == null || this.dataBlocks[rowBlockIndex - 1][colBlockIndex - 1] == null) {
            this.readDataBlocks(rowBlockIndex, colBlockIndex);
        }
        return this.dataBlocks[rowBlockIndex - 1][colBlockIndex - 1];
    }

    public double[] getRowVectorArray() throws DMLRuntimeException {
        double[] ret = new double[(int)this._clen];
        int j = 0;
        while ((long)j < this._clen) {
            MatrixBlock mb = (MatrixBlock)this.getDataBlock(1, (int)Math.ceil((double)(j + 1) / (double)this._bclen)).getValue();
            double[] mbtmp = DataConverter.convertToDoubleVector(mb, false);
            System.arraycopy(mbtmp, 0, ret, j, mbtmp.length);
            j += this._bclen;
        }
        return ret;
    }

    public double[] getColumnVectorArray() throws DMLRuntimeException {
        double[] ret = new double[(int)this._rlen];
        int j = 0;
        while ((long)j < this._rlen) {
            MatrixBlock mb = (MatrixBlock)this.getDataBlock((int)Math.ceil((double)(j + 1) / (double)this._brlen), 1).getValue();
            double[] mbtmp = DataConverter.convertToDoubleVector(mb, false);
            System.arraycopy(mbtmp, 0, ret, j, mbtmp.length);
            j += this._brlen;
        }
        return ret;
    }

    private void readDataBlocks(int rowBlockIndex, int colBlockIndex) throws DMLRuntimeException {
        String fname = this._localFilePath.toString();
        if (this.isPartitioned()) {
            fname = this.getPartitionFileName(rowBlockIndex, colBlockIndex);
        }
        try {
            ReaderBinaryBlock reader = (ReaderBinaryBlock)MatrixReaderFactory.createMatrixReader(InputInfo.BinaryBlockInputInfo);
            reader.setLocalFS(!MRBaseForCommonInstructions.isJobLocal);
            ArrayList<IndexedMatrixValue> tmp = reader.readIndexedMatrixBlocksFromHDFS(fname, this._rlen, this._clen, this._brlen, this._bclen);
            int rowBlocks = (int)Math.ceil((double)this._rlen / (double)this._brlen);
            int colBlocks = (int)Math.ceil((double)this._clen / (double)this._bclen);
            if (this.dataBlocks == null) {
                this.dataBlocks = new IndexedMatrixValue[rowBlocks][colBlocks];
            }
            for (IndexedMatrixValue val : tmp) {
                MatrixIndexes idx = val.getIndexes();
                this.dataBlocks[(int)idx.getRowIndex() - 1][(int)idx.getColumnIndex() - 1] = val;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    private boolean isPartitioned() {
        return this._pformat != ParForProgramBlock.PDataPartitionFormat.NONE;
    }

    private String getPartitionFileName(int rowBlockIndex, int colBlockIndex) throws DMLRuntimeException {
        long partition = -1L;
        switch (this._pformat) {
            case ROW_BLOCK_WISE_N: {
                long numRowBlocks = (long)Math.ceil(4000000.0 / (double)this._clen / (double)this._brlen);
                partition = (long)(rowBlockIndex - 1) / numRowBlocks + 1L;
                break;
            }
            case COLUMN_BLOCK_WISE_N: {
                long numColBlocks = (long)Math.ceil(4000000.0 / (double)this._rlen / (double)this._bclen);
                partition = (long)(colBlockIndex - 1) / numColBlocks + 1L;
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported partition format for distributed cache input: " + (Object)((Object)this._pformat));
            }
        }
        return this._localFilePath.toString() + File.separator + partition;
    }
}

