/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.ReaderBinaryBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlockMCSR;
import org.apache.sysml.runtime.matrix.data.SparseRow;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.CommonThreadPool;

public class ReaderBinaryBlockParallel
extends ReaderBinaryBlock {
    private static int _numThreads = 1;

    public ReaderBinaryBlockParallel(boolean localFS) {
        super(localFS);
        _numThreads = OptimizerUtils.getParallelBinaryReadParallelism();
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int brlen, int bclen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = ReaderBinaryBlockParallel.createOutputMatrixBlock(rlen, clen, brlen, bclen, estnnz, true, true);
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path((this._localFS ? "file:///" : "") + fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ReaderBinaryBlockParallel.checkValidInputFile(fs, path);
        int numThreads = OptimizerUtils.getParallelBinaryReadParallelism();
        long numBlocks = (long)Math.ceil((double)rlen / (double)brlen);
        ReaderBinaryBlockParallel.readBinaryBlockMatrixFromHDFS(path, job, fs, ret, rlen, clen, brlen, bclen, (long)numThreads <= numBlocks);
        ret.examSparsity();
        return ret;
    }

    private static void readBinaryBlockMatrixFromHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean syncBlock) throws IOException, DMLRuntimeException {
        MRJobConfiguration.addBinaryBlockSerializationFramework((Configuration)job);
        try {
            ExecutorService pool = CommonThreadPool.get(_numThreads);
            ArrayList<ReadFileTask> tasks = new ArrayList<ReadFileTask>();
            for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
                ReadFileTask t = new ReadFileTask(lpath, job, dest, rlen, clen, brlen, bclen, syncBlock);
                tasks.add(t);
            }
            List rt = pool.invokeAll(tasks);
            long lnnz = 0L;
            for (Future task : rt) {
                lnnz += ((Long)task.get()).longValue();
            }
            dest.setNonZeros(lnnz);
            if (dest.isInSparseFormat() && clen > (long)bclen) {
                ReaderBinaryBlockParallel.sortSparseRowsParallel(dest, rlen, _numThreads, pool);
            }
            pool.shutdown();
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of binary block input.", e);
        }
    }

    private static class ReadFileTask
    implements Callable<Object> {
        private final Path _path;
        private final JobConf _job;
        private final MatrixBlock _dest;
        private final long _rlen;
        private final long _clen;
        private final int _brlen;
        private final int _bclen;
        private final boolean _syncBlocks;

        public ReadFileTask(Path path, JobConf job, MatrixBlock dest, long rlen, long clen, int brlen, int bclen, boolean syncBlocks) {
            this._path = path;
            this._job = job;
            this._dest = dest;
            this._rlen = rlen;
            this._clen = clen;
            this._brlen = brlen;
            this._bclen = bclen;
            this._syncBlocks = syncBlocks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            boolean sparse = this._dest.isInSparseFormat();
            MatrixIndexes key = new MatrixIndexes();
            MatrixBlock value = ReaderBinaryBlock.getReuseBlock(this._brlen, this._bclen, sparse);
            long lnnz = 0L;
            SequenceFile.Reader reader = new SequenceFile.Reader((Configuration)this._job, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)this._path)});
            try {
                while (reader.next((Writable)key, (Writable)value)) {
                    if (value.isEmptyBlock(false)) continue;
                    int row_offset = (int)(key.getRowIndex() - 1L) * this._brlen;
                    int col_offset = (int)(key.getColumnIndex() - 1L) * this._bclen;
                    int rows = value.getNumRows();
                    int cols = value.getNumColumns();
                    if (row_offset + rows < 0 || (long)(row_offset + rows) > this._rlen || col_offset + cols < 0 || (long)(col_offset + cols) > this._clen) {
                        throw new IOException("Matrix block [" + (row_offset + 1) + ":" + (row_offset + rows) + "," + (col_offset + 1) + ":" + (col_offset + cols) + "] out of overall matrix range [1:" + this._rlen + ",1:" + this._clen + "].");
                    }
                    if (sparse) {
                        if ((long)cols < this._clen) {
                            SparseBlock sblock = this._dest.getSparseBlock();
                            if (sblock instanceof SparseBlockMCSR && sblock.get(row_offset) != null) {
                                if (this._syncBlocks) {
                                    SparseRow sparseRow = sblock.get(row_offset);
                                    synchronized (sparseRow) {
                                        this._dest.appendToSparse(value, row_offset, col_offset);
                                    }
                                } else {
                                    for (int i = 0; i < rows; ++i) {
                                        SparseRow sparseRow = sblock.get(row_offset + i);
                                        synchronized (sparseRow) {
                                            this._dest.appendRowToSparse(sblock, value, i, row_offset, col_offset, true);
                                            continue;
                                        }
                                    }
                                }
                            } else {
                                MatrixBlock matrixBlock = this._dest;
                                synchronized (matrixBlock) {
                                    this._dest.appendToSparse(value, row_offset, col_offset);
                                }
                            }
                        } else {
                            this._dest.appendToSparse(value, row_offset, col_offset);
                        }
                    } else {
                        this._dest.copy(row_offset, row_offset + rows - 1, col_offset, col_offset + cols - 1, value, false);
                    }
                    lnnz += value.getNonZeros();
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)reader);
            }
            return lnnz;
        }
    }
}

