/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.TernaryOperator;

public class TernaryInstruction
extends MRInstruction {
    private final CPOperand input1;
    private final CPOperand input2;
    private final CPOperand input3;
    private final CPOperand output;
    private final byte ixinput1;
    private final byte ixinput2;
    private final byte ixinput3;
    private final byte ixoutput;
    private final MatrixBlock m1;
    private final MatrixBlock m2;
    private final MatrixBlock m3;

    private TernaryInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String istr) {
        super(MRInstruction.MRType.Ternary, op, Byte.parseByte(out.getName()));
        this.instString = istr;
        this.input1 = in1;
        this.input2 = in2;
        this.input3 = in3;
        this.output = out;
        this.ixinput1 = (byte)(this.input1.isMatrix() ? (int)Byte.parseByte(this.input1.getName()) : -1);
        this.ixinput2 = (byte)(this.input2.isMatrix() ? (int)Byte.parseByte(this.input2.getName()) : -1);
        this.ixinput3 = (byte)(this.input3.isMatrix() ? (int)Byte.parseByte(this.input3.getName()) : -1);
        this.ixoutput = (byte)(this.output.isMatrix() ? (int)Byte.parseByte(this.output.getName()) : -1);
        this.m1 = this.input1.isMatrix() ? null : new MatrixBlock(Double.parseDouble(this.input1.getName()));
        this.m2 = this.input2.isMatrix() ? null : new MatrixBlock(Double.parseDouble(this.input2.getName()));
        this.m3 = this.input3.isMatrix() ? null : new MatrixBlock(Double.parseDouble(this.input3.getName()));
    }

    public static TernaryInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 4);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        TernaryOperator op = InstructionUtils.parseTernaryOperator(opcode);
        return new TernaryInstruction(op, in1, in2, in3, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        MatrixBlock lm3;
        MatrixBlock lm1 = this.input1.isMatrix() ? (MatrixBlock)cachedValues.getFirst(this.ixinput1).getValue() : this.m1;
        MatrixBlock lm2 = this.input2.isMatrix() ? (MatrixBlock)cachedValues.getFirst(this.ixinput2).getValue() : this.m2;
        MatrixBlock matrixBlock = lm3 = this.input3.isMatrix() ? (MatrixBlock)cachedValues.getFirst(this.ixinput3).getValue() : this.m3;
        MatrixIndexes ixin = this.input1.isMatrix() ? cachedValues.getFirst(this.ixinput1).getIndexes() : (this.input2.isMatrix() ? cachedValues.getFirst(this.ixinput2).getIndexes() : cachedValues.getFirst(this.ixinput3).getIndexes());
        IndexedMatrixValue out = new IndexedMatrixValue(new MatrixIndexes(), new MatrixBlock());
        out.getIndexes().setIndexes(ixin);
        TernaryOperator op = (TernaryOperator)this.optr;
        lm1.ternaryOperations(op, lm2, lm3, (MatrixBlock)out.getValue());
        cachedValues.add(this.ixoutput, out);
    }

    @Override
    public byte[] getInputIndexes() {
        byte[] tmp = this.getAllIndexes();
        return Arrays.copyOfRange(tmp, 0, tmp.length - 1);
    }

    @Override
    public byte[] getAllIndexes() {
        return ArrayUtils.toPrimitive((Byte[])((Byte[])Arrays.stream(new CPOperand[]{this.input1, this.input2, this.input3, this.output}).filter(in -> in.isMatrix()).map(in -> Byte.parseByte(in.getName())).toArray(Byte[]::new)));
    }
}

