/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.MatrixMatrixRelationalBinaryGPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.ScalarMatrixRelationalBinaryGPUInstruction;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class RelationalBinaryGPUInstruction
extends GPUInstruction {
    protected CPOperand _input1;
    protected CPOperand _input2;
    protected CPOperand _output;

    protected RelationalBinaryGPUInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.RelationalBinary;
        this._input1 = in1;
        this._input2 = in2;
        this._output = out;
    }

    public static RelationalBinaryGPUInstruction parseInstruction(String str) throws DMLRuntimeException {
        BinaryOperator operator;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        Expression.DataType dt1 = in1.getDataType();
        Expression.DataType dt2 = in2.getDataType();
        Expression.DataType dt3 = out.getDataType();
        Operator operator2 = dt1 != dt2 ? InstructionUtils.parseScalarBinaryOperator(opcode, dt1 == Expression.DataType.SCALAR) : (operator = InstructionUtils.parseBinaryOperator(opcode));
        if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.MATRIX && dt3 == Expression.DataType.MATRIX) {
            return new MatrixMatrixRelationalBinaryGPUInstruction(operator, in1, in2, out, opcode, str);
        }
        if (dt3 == Expression.DataType.MATRIX && (dt1 == Expression.DataType.SCALAR && dt2 == Expression.DataType.MATRIX || dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.SCALAR)) {
            return new ScalarMatrixRelationalBinaryGPUInstruction(operator, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("Unsupported GPU RelationalBinaryGPUInstruction.");
    }
}

