/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.opt;

import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.cost.CostEstimationWrapper;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.controlprogram.parfor.opt.CostEstimator;
import org.apache.sysml.runtime.controlprogram.parfor.opt.CostEstimatorHops;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreePlanMappingAbstract;

public class CostEstimatorRuntime
extends CostEstimator {
    private final CostEstimatorHops _costMem;
    private final OptTreePlanMappingAbstract _map;
    private final ExecutionContext _ec;

    public CostEstimatorRuntime(OptTreePlanMappingAbstract map, LocalVariableMap vars) {
        this._costMem = new CostEstimatorHops(map);
        this._map = map;
        this._ec = ExecutionContextFactory.createContext();
        this._ec.setVariables(vars);
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node) throws DMLRuntimeException {
        if (measure == CostEstimator.TestMeasure.MEMORY_USAGE) {
            return this._costMem.getLeafNodeEstimate(measure, node);
        }
        LopProperties.ExecType REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        return this.getLeafNodeEstimate(measure, node, node.isCPOnly() ? LopProperties.ExecType.CP : REMOTE);
    }

    @Override
    public double getLeafNodeEstimate(CostEstimator.TestMeasure measure, OptNode node, LopProperties.ExecType et) throws DMLRuntimeException {
        boolean isCP;
        if (measure == CostEstimator.TestMeasure.MEMORY_USAGE) {
            return this._costMem.getLeafNodeEstimate(measure, node, et);
        }
        double ret = 5.0;
        boolean bl = isCP = et == LopProperties.ExecType.CP || et == null;
        if (!node.isLeaf() && isCP) {
            ProgramBlock pb = (ProgramBlock)this._map.getMappedProg(node.getID())[1];
            ret = CostEstimationWrapper.getTimeEstimate(pb, this._ec, true);
        }
        return ret;
    }
}

