/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMergeTaggedMatrixIndexes;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixBlock;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixCell;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.FastStringTokenizer;
import org.apache.sysml.runtime.util.UtilFunctions;

public class ResultMergeRemoteMapper
implements Mapper<Writable, Writable, Writable, Writable> {
    private ResultMergeMapper _mapper;

    public void map(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
        this._mapper.processKeyValue(key, value, out, reporter);
    }

    public void configure(JobConf job) {
        InputInfo ii = MRJobConfiguration.getResultMergeInputInfo(job);
        long[] tmp = MRJobConfiguration.getResultMergeMatrixCharacteristics(job);
        String compareFname = MRJobConfiguration.getResultMergeInfoCompareFilename(job);
        String currentFname = job.get(MRConfigurationNames.MR_MAP_INPUT_FILE);
        byte tag = 0;
        tag = currentFname.startsWith(compareFname) ? (byte)99 : 100;
        if (ii == InputInfo.TextCellInputInfo) {
            this._mapper = new ResultMergeMapperTextCell(tag);
        } else if (ii == InputInfo.BinaryCellInputInfo) {
            this._mapper = new ResultMergeMapperBinaryCell(tag);
        } else if (ii == InputInfo.BinaryBlockInputInfo) {
            this._mapper = new ResultMergeMapperBinaryBlock(tag, tmp[0], tmp[1], tmp[2], tmp[3]);
        } else {
            throw new RuntimeException("Unable to configure mapper with unknown input info: " + ii.toString());
        }
    }

    public void close() throws IOException {
    }

    protected static class ResultMergeMapperBinaryBlock
    extends ResultMergeMapper {
        private ResultMergeTaggedMatrixIndexes _objKey = new ResultMergeTaggedMatrixIndexes();
        private TaggedMatrixBlock _objValue = new TaggedMatrixBlock();
        private long _rlen = -1L;
        private long _clen = -1L;
        private long _brlen = -1L;
        private long _bclen = -1L;

        protected ResultMergeMapperBinaryBlock(byte tag, long rlen, long clen, long brlen, long bclen) {
            super(tag);
            this._objKey.setTag(this._tag);
            this._objValue.setTag(this._tag);
            this._rlen = rlen;
            this._clen = clen;
            this._brlen = brlen;
            this._bclen = bclen;
        }

        @Override
        protected void processKeyValue(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            MatrixIndexes inkey = (MatrixIndexes)key;
            MatrixBlock inval = (MatrixBlock)value;
            if (inval.getNumRows() != UtilFunctions.computeBlockSize(this._rlen, inkey.getRowIndex(), this._brlen)) {
                throw new IOException("Invalid number of rows for block " + inkey + ": " + inval.getNumRows());
            }
            if (inval.getNumColumns() != UtilFunctions.computeBlockSize(this._clen, inkey.getColumnIndex(), this._bclen)) {
                throw new IOException("Invalid number of columns for block " + inkey + ": " + inval.getNumColumns());
            }
            this._objKey.getIndexes().setIndexes(inkey);
            this._objValue.setBaseObject(inval);
            out.collect((Object)this._objKey, (Object)this._objValue);
        }
    }

    protected static class ResultMergeMapperBinaryCell
    extends ResultMergeMapper {
        private TaggedMatrixCell _objValue = new TaggedMatrixCell();

        protected ResultMergeMapperBinaryCell(byte tag) {
            super(tag);
            this._objValue.setTag(this._tag);
        }

        @Override
        protected void processKeyValue(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            this._objValue.setBaseObject((MatrixCell)value);
            out.collect((Object)key, (Object)this._objValue);
        }
    }

    protected static class ResultMergeMapperTextCell
    extends ResultMergeMapper {
        private MatrixIndexes _objKey = new MatrixIndexes();
        private MatrixCell _objValueHelp = new MatrixCell();
        private TaggedMatrixCell _objValue = new TaggedMatrixCell();
        private FastStringTokenizer _st;

        protected ResultMergeMapperTextCell(byte tag) {
            super(tag);
            this._objValue.setTag(this._tag);
            this._st = new FastStringTokenizer(' ');
        }

        @Override
        protected void processKeyValue(Writable key, Writable value, OutputCollector<Writable, Writable> out, Reporter reporter) throws IOException {
            this._st.reset(value.toString());
            long row = this._st.nextLong();
            long col = this._st.nextLong();
            double lvalue = this._st.nextDouble();
            this._objKey.setIndexes(row, col);
            this._objValueHelp.setValue(lvalue);
            this._objValue.setBaseObject(this._objValueHelp);
            out.collect((Object)this._objKey, (Object)this._objValue);
        }
    }

    private static abstract class ResultMergeMapper {
        protected byte _tag = 0;

        protected ResultMergeMapper(byte tag) {
            this._tag = tag;
        }

        protected abstract void processKeyValue(Writable var1, Writable var2, OutputCollector<Writable, Writable> var3, Reporter var4) throws IOException;
    }
}

