/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.ColGroup;
import org.apache.sysml.runtime.compress.ColGroupDDC;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.compress.utils.ConverterUtils;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;

public class ColGroupDDC1
extends ColGroupDDC {
    private static final long serialVersionUID = 5204955589230760157L;
    private byte[] _data;

    public ColGroupDDC1() {
    }

    public ColGroupDDC1(int[] colIndices, int numRows, UncompressedBitmap ubm) {
        super(colIndices, numRows, ubm);
        this._data = new byte[numRows];
        int numVals = ubm.getNumValues();
        int numCols = ubm.getNumColumns();
        if (ubm.getNumOffsets() < (long)numRows * (long)numCols) {
            int zeroIx = this.containsAllZeroValue();
            if (zeroIx < 0) {
                zeroIx = numVals;
                this._values = Arrays.copyOf(this._values, this._values.length + numCols);
            }
            Arrays.fill(this._data, (byte)zeroIx);
        }
        for (int i = 0; i < numVals; ++i) {
            int[] tmpList = ubm.getOffsetsList(i).extractValues();
            int tmpListSize = ubm.getNumOffsets(i);
            for (int k = 0; k < tmpListSize; ++k) {
                this._data[tmpList[k]] = (byte)i;
            }
        }
    }

    public ColGroupDDC1(int[] colIndices, int numRows, double[] values, byte[] data) {
        super(colIndices, numRows, values);
        this._data = data;
    }

    @Override
    public ColGroup.CompressionType getCompType() {
        return ColGroup.CompressionType.DDC1;
    }

    @Override
    protected double getData(int r) {
        return this._values[this._data[r] & 0xFF];
    }

    @Override
    protected double getData(int r, int colIx) {
        return this._values[(this._data[r] & 0xFF) * this.getNumCols() + colIx];
    }

    @Override
    protected void setData(int r, int code) {
        this._data[r] = (byte)code;
    }

    @Override
    protected int getCode(int r) {
        return this._data[r] & 0xFF;
    }

    public void recodeData(HashMap<Double, Integer> map) {
        int numVals = this.getNumValues();
        byte[] lookup = new byte[numVals];
        for (int k = 0; k < numVals; ++k) {
            lookup[k] = map.get(this._values[k]).byteValue();
        }
        for (int i = 0; i < this._numRows; ++i) {
            this._data[i] = lookup[this._data[i] & 0xFF];
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.write(out, false);
    }

    @Override
    public void write(DataOutput out, boolean skipDict) throws IOException {
        int i;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        out.writeInt(this._numRows);
        out.writeInt(numCols);
        out.writeInt(numVals);
        for (i = 0; i < this._colIndexes.length; ++i) {
            out.writeInt(this._colIndexes[i]);
        }
        if (!skipDict) {
            for (i = 0; i < this._values.length; ++i) {
                out.writeDouble(this._values[i]);
            }
        }
        for (i = 0; i < this._numRows; ++i) {
            out.writeByte(this._data[i]);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.readFields(in, false);
    }

    @Override
    public void readFields(DataInput in, boolean skipDict) throws IOException {
        int i;
        this._numRows = in.readInt();
        int numCols = in.readInt();
        int numVals = in.readInt();
        this._colIndexes = new int[numCols];
        for (i = 0; i < numCols; ++i) {
            this._colIndexes[i] = in.readInt();
        }
        if (!skipDict || numCols != 1) {
            this._values = new double[numVals * numCols];
            for (i = 0; i < numVals * numCols; ++i) {
                this._values[i] = in.readDouble();
            }
        }
        this._data = new byte[this._numRows];
        for (i = 0; i < this._numRows; ++i) {
            this._data[i] = in.readByte();
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = 12L;
        ret += (long)(4 * this._colIndexes.length);
        ret += (long)(8 * this._values.length);
        return ret += (long)(1 * this._data.length);
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        if (this._data != null) {
            size += (long)this._data.length;
        }
        return size;
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        int ncol = this.getNumCols();
        for (int i = rl; i < ru; ++i) {
            for (int j = 0; j < ncol; ++j) {
                target.appendValue(i, this._colIndexes[j], this._values[(this._data[i] & 0xFF) * ncol + j]);
            }
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int nrow = this.getNumRows();
        int ncol = this.getNumCols();
        double[] c = target.getDenseBlockValues();
        int nnz = 0;
        for (int i = 0; i < nrow; ++i) {
            c[i] = this._values[(this._data[i] & 0xFF) * ncol + colpos];
            nnz += c[i] != 0.0 ? 1 : 0;
        }
        target.setNonZeros(nnz);
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this.getCounts(0, this.getNumRows(), counts);
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        int numVals = this.getNumValues();
        Arrays.fill(counts, 0, numVals, 0);
        for (int i = rl; i < ru; ++i) {
            int n = this._data[i] & 0xFF;
            counts[n] = counts[n] + 1;
        }
        return counts;
    }

    @Override
    protected void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int ncol = this.getNumCols();
        int numVals = this.getNumValues();
        int[] counts = new int[numVals];
        int k = 0;
        int valOff = 0;
        while (k < numVals) {
            for (int j = 0; j < ncol; ++j) {
                int n = k;
                counts[n] = counts[n] + (this._values[valOff + j] != 0.0 ? 1 : 0);
            }
            ++k;
            valOff += ncol;
        }
        for (int i = rl; i < ru; ++i) {
            int n = i - rl;
            rnnz[n] = rnnz[n] + counts[this._data[i] & 0xFF];
        }
    }

    @Override
    public void rightMultByVector(MatrixBlock vector, MatrixBlock result, int rl, int ru) throws DMLRuntimeException {
        double[] b = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlockValues();
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] sb = new double[numCols];
        for (int j = 0; j < numCols; ++j) {
            sb[j] = b[this._colIndexes[j]];
        }
        double[] vals = this.preaggValues(numVals, sb);
        for (int i = rl; i < ru; ++i) {
            int n = i;
            c[n] = c[n] + vals[this._data[i] & 0xFF];
        }
    }

    public static void rightMultByVector(ColGroupDDC1[] grps, MatrixBlock vector, MatrixBlock result, int rl, int ru) throws DMLRuntimeException {
        int j;
        double[] b = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlockValues();
        double[][] vals = new double[grps.length][];
        for (int i = 0; i < grps.length; ++i) {
            double[] sb = new double[grps[i].getNumCols()];
            for (j = 0; j < sb.length; ++j) {
                sb[j] = b[grps[i]._colIndexes[j]];
            }
            vals[i] = grps[i].preaggValues(grps[i].getNumValues(), sb, true);
        }
        int blksz = 2048;
        for (int bi = rl; bi < ru; bi += blksz) {
            for (j = 0; j < grps.length; ++j) {
                for (int i = bi; i < Math.min(bi + blksz, ru); ++i) {
                    int n = i;
                    c[n] = c[n] + vals[j][grps[j]._data[i] & 0xFF];
                }
            }
        }
    }

    @Override
    public void leftMultByRowVector(MatrixBlock vector, MatrixBlock result) throws DMLRuntimeException {
        double[] a = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlockValues();
        int nrow = this.getNumRows();
        int numVals = this.getNumValues();
        double[] vals = ColGroupDDC1.allocDVector(numVals, true);
        for (int i = 0; i < nrow; ++i) {
            int n = this._data[i] & 0xFF;
            vals[n] = vals[n] + a[i];
        }
        this.postScaling(vals, c);
    }

    @Override
    public void leftMultByRowVector(ColGroupDDC a, MatrixBlock result) throws DMLRuntimeException {
        double[] c = result.getDenseBlockValues();
        int nrow = this.getNumRows();
        int numVals = this.getNumValues();
        double[] vals = ColGroupDDC1.allocDVector(numVals, true);
        for (int i = 0; i < nrow; ++i) {
            int n = this._data[i] & 0xFF;
            vals[n] = vals[n] + a.getData(i);
        }
        this.postScaling(vals, c);
    }

    @Override
    protected void computeSum(MatrixBlock result, KahanFunction kplus) {
        int ncol = this.getNumCols();
        int numVals = this.getNumValues();
        int[] counts = this.getCounts();
        KahanObject kbuff = new KahanObject(result.quickGetValue(0, 0), result.quickGetValue(0, 1));
        int k = 0;
        int valOff = 0;
        while (k < numVals) {
            int cntk = counts[k];
            for (int j = 0; j < ncol; ++j) {
                kplus.execute3(kbuff, this._values[valOff + j], cntk);
            }
            ++k;
            valOff += ncol;
        }
        result.quickSetValue(0, 0, kbuff._sum);
        result.quickSetValue(0, 1, kbuff._correction);
    }

    @Override
    protected void computeRowSums(MatrixBlock result, KahanFunction kplus, int rl, int ru) {
        DenseBlock c = result.getDenseBlock();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        KahanPlus kplus2 = KahanPlus.getKahanPlusFnObject();
        double[] vals = this.sumAllValues(kplus, kbuff, false);
        for (int i = rl; i < ru; ++i) {
            double[] cvals = c.values(i);
            int cix = c.pos(i);
            kbuff.set(cvals[cix], cvals[cix + 1]);
            kplus2.execute2(kbuff, vals[this._data[i] & 0xFF]);
            cvals[cix] = kbuff._sum;
            cvals[cix + 1] = kbuff._correction;
        }
    }

    public static void computeRowSums(ColGroupDDC1[] grps, MatrixBlock result, KahanFunction kplus, int rl, int ru) throws DMLRuntimeException {
        DenseBlock c = result.getDenseBlock();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        KahanPlus kplus2 = KahanPlus.getKahanPlusFnObject();
        double[][] vals = new double[grps.length][];
        for (int i = 0; i < grps.length; ++i) {
            vals[i] = grps[i].sumAllValues(kplus, kbuff);
        }
        int blksz = 1024;
        double[] tmpAgg = new double[blksz];
        for (int bi = rl; bi < ru; bi += blksz) {
            Arrays.fill(tmpAgg, 0.0);
            for (int j = 0; j < grps.length; ++j) {
                double[] valsj = vals[j];
                byte[] dataj = grps[j]._data;
                for (int i = bi; i < Math.min(bi + blksz, ru); ++i) {
                    int n = i - bi;
                    tmpAgg[n] = tmpAgg[n] + valsj[dataj[i] & 0xFF];
                }
            }
            for (int i = bi; i < Math.min(bi + blksz, ru); ++i) {
                double[] cvals = c.values(i);
                int cix = c.pos(i);
                kbuff.set(cvals[cix], cvals[cix + 1]);
                kplus2.execute2(kbuff, tmpAgg[i - bi]);
                cvals[cix] = kbuff._sum;
                cvals[cix + 1] = kbuff._correction;
            }
        }
    }

    @Override
    public ColGroup scalarOperation(ScalarOperator op) throws DMLRuntimeException {
        return new ColGroupDDC1(this._colIndexes, this._numRows, this.applyScalarOp(op), this._data);
    }
}

