/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.recompile;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.api.jmlc.JMLCUtils;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.codegen.SpoofCompiler;
import org.apache.sysml.hops.recompile.LiteralReplacement;
import org.apache.sysml.hops.recompile.RecompileStatus;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriter;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.Dag;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataExpression;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.opt.OptTreeConverter;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.RandInstruction;
import org.apache.sysml.runtime.instructions.mr.SeqInstruction;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.utils.JSONHelper;
import org.apache.wink.json4j.JSONObject;

public class Recompiler {
    private static final Log LOG = LogFactory.getLog((String)Recompiler.class.getName());
    private static final long CP_REBLOCK_THRESHOLD_SIZE = 0x40000000L;
    private static final long CP_CSV_REBLOCK_UNKNOWN_THRESHOLD_SIZE = 0x40000000L;
    private static ThreadLocal<ProgramRewriter> _rewriter = new ThreadLocal<ProgramRewriter>(){

        @Override
        protected ProgramRewriter initialValue() {
            return new ProgramRewriter(false, true);
        }
    };

    public static void reinitRecompiler() {
        _rewriter.set(new ProgramRewriter(false, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag(StatementBlock sb, ArrayList<Hop> hops, LocalVariableMap vars, RecompileStatus status, boolean inplace, boolean replaceLit, long tid) throws DMLRuntimeException, HopsException, LopsException {
        ArrayList<Instruction> newInst = null;
        ArrayList<Hop> arrayList = hops;
        synchronized (arrayList) {
            newInst = Recompiler.recompile(sb, hops, vars, status, inplace, replaceLit, true, false, false, null, tid);
        }
        if (tid != 0L) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (vars.getRegisteredOutputs() != null) {
            newInst = JMLCUtils.cleanupRuntimeInstructions(newInst, vars.getRegisteredOutputs());
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainDAG(sb, hops, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag(Hop hop, LocalVariableMap vars, RecompileStatus status, boolean inplace, boolean replaceLit, long tid) throws DMLRuntimeException, HopsException, LopsException {
        ArrayList<Instruction> newInst = null;
        Hop hop2 = hop;
        synchronized (hop2) {
            newInst = Recompiler.recompile(null, new ArrayList<Hop>(Arrays.asList(hop)), vars, status, inplace, replaceLit, true, false, true, null, tid);
        }
        if (tid != 0L) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainPred(hop, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag2Forced(StatementBlock sb, ArrayList<Hop> hops, long tid, LopProperties.ExecType et) throws DMLRuntimeException, HopsException, LopsException {
        ArrayList<Instruction> newInst = null;
        ArrayList<Hop> arrayList = hops;
        synchronized (arrayList) {
            newInst = Recompiler.recompile(sb, hops, null, null, true, false, false, true, false, et, tid);
        }
        if (tid != 0L) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainDAG(sb, hops, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDag2Forced(Hop hop, long tid, LopProperties.ExecType et) throws DMLRuntimeException, HopsException, LopsException {
        ArrayList<Instruction> newInst = null;
        Hop hop2 = hop;
        synchronized (hop2) {
            newInst = Recompiler.recompile(null, new ArrayList<Hop>(Arrays.asList(hop)), null, null, true, false, false, true, true, et, tid);
        }
        if (tid != 0L) {
            newInst = ProgramConverter.createDeepCopyInstructionSet(newInst, tid, -1, null, null, null, false, false);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainPred(hop, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDagInstructions(StatementBlock sb, ArrayList<Hop> hops) throws DMLRuntimeException, HopsException, LopsException {
        ArrayList<Instruction> newInst = null;
        ArrayList<Hop> arrayList = hops;
        synchronized (arrayList) {
            newInst = Recompiler.recompile(sb, hops, null, null, true, false, false, false, false, null, 0L);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainDAG(sb, hops, newInst);
        }
        return newInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Instruction> recompileHopsDagInstructions(Hop hop) throws DMLRuntimeException, HopsException, LopsException {
        ArrayList<Instruction> newInst = null;
        Hop hop2 = hop;
        synchronized (hop2) {
            newInst = Recompiler.recompile(null, new ArrayList<Hop>(Arrays.asList(hop)), null, null, true, false, false, false, true, null, 0L);
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            Recompiler.logExplainPred(hop, newInst);
        }
        return newInst;
    }

    private static ArrayList<Instruction> recompile(StatementBlock sb, ArrayList<Hop> hops, LocalVariableMap vars, RecompileStatus status, boolean inplace, boolean replaceLit, boolean updateStats, boolean forceEt, boolean pred, LopProperties.ExecType et, long tid) throws HopsException, LopsException, DMLRuntimeException {
        if (!inplace) {
            hops = Recompiler.deepCopyHopsDag(hops);
        } else {
            Hop.resetVisitStatus(hops);
            for (Hop hop : hops) {
                Recompiler.rClearLops(hop);
            }
        }
        if (!inplace && replaceLit) {
            Hop.resetVisitStatus(hops);
            for (Hop hop : hops) {
                Recompiler.rReplaceLiterals(hop, vars, false);
            }
        }
        if (forceEt) {
            Hop.resetVisitStatus(hops);
            for (Hop hop : hops) {
                Recompiler.rSetExecType(hop, et);
            }
            Hop.resetVisitStatus(hops);
        }
        if (updateStats) {
            Hop.resetVisitStatus(hops);
            for (Hop hop : hops) {
                Recompiler.rUpdateStatistics(hop, vars);
            }
            if (!inplace) {
                _rewriter.get().rewriteHopDAG(hops, null);
                Hop.resetVisitStatus(hops);
                for (Hop hop : hops) {
                    Recompiler.rUpdateStatistics(hop, vars);
                }
            }
            Hop.resetVisitStatus(hops);
            MemoTable memo = new MemoTable();
            memo.init(hops, status);
            Hop.resetVisitStatus(hops);
            for (Hop hopRoot : hops) {
                hopRoot.refreshMemEstimates(memo);
            }
            memo.extract(hops, status);
        }
        if (ConfigurationManager.isCodegenEnabled() && (!forceEt || et != null)) {
            if (inplace) {
                hops = Recompiler.deepCopyHopsDag(hops);
            }
            Hop.resetVisitStatus(hops);
            hops = SpoofCompiler.optimize(hops, status == null || !status.isInitialCodegen());
        }
        Dag<Lop> dag = new Dag<Lop>();
        for (Hop hopRoot : hops) {
            Lop lops = hopRoot.constructLops();
            lops.addToDag(dag);
        }
        ArrayList<Instruction> arrayList = dag.getJobs(sb, ConfigurationManager.getDMLConfig());
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_HOPS) {
            if (pred) {
                Recompiler.logExplainPred(hops.get(0), arrayList);
            } else {
                Recompiler.logExplainDAG(sb, hops, arrayList);
            }
        }
        return arrayList;
    }

    private static void logExplainDAG(StatementBlock sb, ArrayList<Hop> hops, ArrayList<Instruction> inst) throws DMLRuntimeException {
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_HOPS) {
            LOG.info((Object)("EXPLAIN RECOMPILE \nGENERIC (lines " + sb.getBeginLine() + "-" + sb.getEndLine() + "):\n" + Explain.explainHops(hops, 1)));
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            LOG.info((Object)("EXPLAIN RECOMPILE \nGENERIC (lines " + sb.getBeginLine() + "-" + sb.getEndLine() + "):\n" + Explain.explain(inst, 1)));
        }
    }

    private static void logExplainPred(Hop hops, ArrayList<Instruction> inst) throws DMLRuntimeException {
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_HOPS) {
            LOG.info((Object)("EXPLAIN RECOMPILE \nPRED (line " + hops.getBeginLine() + "):\n" + Explain.explain(hops, 1)));
        }
        if (DMLScript.EXPLAIN == Explain.ExplainType.RECOMPILE_RUNTIME) {
            LOG.info((Object)("EXPLAIN RECOMPILE \nPRED (line " + hops.getBeginLine() + "):\n" + Explain.explain(inst, 1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recompileProgramBlockHierarchy(ArrayList<ProgramBlock> pbs, LocalVariableMap vars, long tid, ResetType resetRecompile) throws DMLRuntimeException {
        try {
            RecompileStatus status = new RecompileStatus();
            ArrayList<ProgramBlock> arrayList = pbs;
            synchronized (arrayList) {
                for (ProgramBlock pb : pbs) {
                    Recompiler.rRecompileProgramBlock(pb, vars, status, tid, resetRecompile);
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to recompile program block hierarchy.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recompileProgramBlockHierarchy2Forced(ArrayList<ProgramBlock> pbs, long tid, HashSet<String> fnStack, LopProperties.ExecType et) throws DMLRuntimeException {
        try {
            ArrayList<ProgramBlock> arrayList = pbs;
            synchronized (arrayList) {
                for (ProgramBlock pb : pbs) {
                    Recompiler.rRecompileProgramBlock2Forced(pb, tid, fnStack, et);
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to recompile program block hierarchy to CP.", ex);
        }
    }

    public static void recompileProgramBlockInstructions(ProgramBlock pb) throws HopsException, LopsException, DMLRuntimeException, IOException {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            WhileStatementBlock wsb = (WhileStatementBlock)pb.getStatementBlock();
            if (wsb != null && wsb.getPredicateHops() != null) {
                wpb.setPredicate(Recompiler.recompileHopsDagInstructions(wsb.getPredicateHops()));
            }
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            IfStatementBlock isb = (IfStatementBlock)pb.getStatementBlock();
            if (isb != null && isb.getPredicateHops() != null) {
                ipb.setPredicate(Recompiler.recompileHopsDagInstructions(isb.getPredicateHops()));
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            ForStatementBlock fsb = (ForStatementBlock)pb.getStatementBlock();
            if (fsb != null && fsb.getFromHops() != null) {
                fpb.setFromInstructions(Recompiler.recompileHopsDagInstructions(fsb.getFromHops()));
            }
            if (fsb != null && fsb.getToHops() != null) {
                fpb.setToInstructions(Recompiler.recompileHopsDagInstructions(fsb.getToHops()));
            }
            if (fsb != null && fsb.getIncrementHops() != null) {
                fpb.setIncrementInstructions(Recompiler.recompileHopsDagInstructions(fsb.getIncrementHops()));
            }
        } else {
            StatementBlock sb = pb.getStatementBlock();
            if (sb != null && sb.getHops() != null) {
                pb.setInstructions(Recompiler.recompileHopsDagInstructions(sb, sb.getHops()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requiresRecompilation(ArrayList<Hop> hops) {
        if (hops == null) {
            return false;
        }
        ArrayList<Hop> arrayList = hops;
        synchronized (arrayList) {
            Hop.resetVisitStatus(hops);
            return hops.stream().anyMatch(h -> Recompiler.rRequiresRecompile(h));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requiresRecompilation(Hop hop) {
        if (hop == null) {
            return false;
        }
        Hop hop2 = hop;
        synchronized (hop2) {
            hop.resetVisitStatus();
            return Recompiler.rRequiresRecompile(hop);
        }
    }

    public static ArrayList<Hop> deepCopyHopsDag(List<Hop> hops) throws HopsException {
        ArrayList<Hop> ret = new ArrayList<Hop>(hops.size());
        try {
            HashMap<Long, Hop> memo = new HashMap<Long, Hop>();
            for (Hop hopRoot : hops) {
                ret.add(Recompiler.rDeepCopyHopsDag(hopRoot, memo));
            }
        }
        catch (Exception ex) {
            throw new HopsException(ex);
        }
        return ret;
    }

    public static Hop deepCopyHopsDag(Hop hops) throws HopsException {
        Hop ret = null;
        try {
            HashMap<Long, Hop> memo = new HashMap<Long, Hop>();
            ret = Recompiler.rDeepCopyHopsDag(hops, memo);
        }
        catch (Exception ex) {
            throw new HopsException(ex);
        }
        return ret;
    }

    private static Hop rDeepCopyHopsDag(Hop hop, HashMap<Long, Hop> memo) throws CloneNotSupportedException {
        Hop ret = memo.get(hop.getHopID());
        if (ret == null) {
            ret = (Hop)hop.clone();
            for (Hop in : hop.getInput()) {
                Hop tmp = Recompiler.rDeepCopyHopsDag(in, memo);
                ret.getInput().add(tmp);
                tmp.getParent().add(ret);
            }
            memo.put(hop.getHopID(), ret);
        }
        return ret;
    }

    public static void updateFunctionNames(ArrayList<Hop> hops, long pid) {
        Hop.resetVisitStatus(hops);
        for (Hop hopRoot : hops) {
            Recompiler.rUpdateFunctionNames(hopRoot, pid);
        }
    }

    public static void rUpdateFunctionNames(Hop hop, long pid) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof FunctionOp && ((FunctionOp)hop).getFunctionType() != FunctionOp.FunctionType.MULTIRETURN_BUILTIN) {
            FunctionOp fop = (FunctionOp)hop;
            fop.setFunctionName(fop.getFunctionName() + "_t" + pid);
        }
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                Recompiler.rUpdateFunctionNames(c, pid);
            }
        }
        hop.setVisited();
    }

    private static void rRecompileProgramBlock(ProgramBlock pb, LocalVariableMap vars, RecompileStatus status, long tid, ResetType resetRecompile) throws HopsException, DMLRuntimeException, LopsException, IOException {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            WhileStatementBlock wsb = (WhileStatementBlock)wpb.getStatementBlock();
            Recompiler.recompileWhilePredicate(wpb, wsb, vars, status, tid, resetRecompile);
            Recompiler.removeUpdatedScalars(vars, wsb);
            LocalVariableMap oldVars = (LocalVariableMap)vars.clone();
            RecompileStatus oldStatus = (RecompileStatus)status.clone();
            for (ProgramBlock pb2 : wpb.getChildBlocks()) {
                Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldVars, vars, (StatementBlock)wsb) | Recompiler.reconcileUpdatedCallVarsLoops(oldStatus, status, (StatementBlock)wsb)) {
                Recompiler.recompileWhilePredicate(wpb, wsb, vars, status, tid, resetRecompile);
                for (ProgramBlock pb2 : wpb.getChildBlocks()) {
                    Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
                }
            }
            Recompiler.removeUpdatedScalars(vars, wsb);
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            IfStatementBlock isb = (IfStatementBlock)ipb.getStatementBlock();
            Recompiler.recompileIfPredicate(ipb, isb, vars, status, tid, resetRecompile);
            LocalVariableMap oldVars = (LocalVariableMap)vars.clone();
            LocalVariableMap varsElse = (LocalVariableMap)vars.clone();
            RecompileStatus oldStatus = (RecompileStatus)status.clone();
            RecompileStatus statusElse = (RecompileStatus)status.clone();
            for (ProgramBlock pb2 : ipb.getChildBlocksIfBody()) {
                Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
            }
            for (ProgramBlock pb2 : ipb.getChildBlocksElseBody()) {
                Recompiler.rRecompileProgramBlock(pb2, varsElse, statusElse, tid, resetRecompile);
            }
            Recompiler.reconcileUpdatedCallVarsIf(oldVars, vars, varsElse, (StatementBlock)isb);
            Recompiler.reconcileUpdatedCallVarsIf(oldStatus, status, statusElse, (StatementBlock)isb);
            Recompiler.removeUpdatedScalars(vars, ipb.getStatementBlock());
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            ForStatementBlock fsb = (ForStatementBlock)fpb.getStatementBlock();
            Recompiler.recompileForPredicates(fpb, fsb, vars, status, tid, resetRecompile);
            Recompiler.removeUpdatedScalars(vars, fpb.getStatementBlock());
            LocalVariableMap oldVars = (LocalVariableMap)vars.clone();
            RecompileStatus oldStatus = (RecompileStatus)status.clone();
            for (ProgramBlock pb2 : fpb.getChildBlocks()) {
                Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldVars, vars, (StatementBlock)fsb) | Recompiler.reconcileUpdatedCallVarsLoops(oldStatus, status, (StatementBlock)fsb)) {
                Recompiler.recompileForPredicates(fpb, fsb, vars, status, tid, resetRecompile);
                for (ProgramBlock pb2 : fpb.getChildBlocks()) {
                    Recompiler.rRecompileProgramBlock(pb2, vars, status, tid, resetRecompile);
                }
            }
            Recompiler.removeUpdatedScalars(vars, fpb.getStatementBlock());
        } else if (!(pb instanceof FunctionProgramBlock)) {
            StatementBlock sb = pb.getStatementBlock();
            ArrayList<Instruction> tmp = pb.getInstructions();
            if (sb == null) {
                return;
            }
            tmp = Recompiler.recompileHopsDag(sb, sb.getHops(), vars, status, true, false, tid);
            pb.setInstructions(tmp);
            Recompiler.extractDAGOutputStatistics(sb.getHops(), vars);
            if (!Recompiler.containsRootFunctionOp(sb.getHops()) && resetRecompile.isReset()) {
                Hop.resetRecompilationFlag(sb.getHops(), LopProperties.ExecType.CP, resetRecompile);
                sb.updateRecompilationFlag();
            }
        }
    }

    public static boolean reconcileUpdatedCallVarsLoops(LocalVariableMap oldCallVars, LocalVariableMap callVars, StatementBlock sb) {
        boolean requiresRecompile = false;
        for (String varname : sb.variablesUpdated().getVariableNames()) {
            Data dat1 = oldCallVars.get(varname);
            Data dat2 = callVars.get(varname);
            if (dat1 == null || !(dat1 instanceof MatrixObject) || dat2 == null || !(dat2 instanceof MatrixObject)) continue;
            MatrixObject moOld = (MatrixObject)dat1;
            MatrixObject mo = (MatrixObject)dat2;
            MatrixCharacteristics mcOld = moOld.getMatrixCharacteristics();
            MatrixCharacteristics mc = mo.getMatrixCharacteristics();
            if (mcOld.getRows() == mc.getRows() && mcOld.getCols() == mc.getCols() && mcOld.getNonZeros() == mc.getNonZeros()) continue;
            long ldim1 = mc.getRows();
            long ldim2 = mc.getCols();
            long lnnz = mc.getNonZeros();
            if (mcOld.getRows() != mc.getRows()) {
                ldim1 = -1L;
                requiresRecompile = true;
            }
            if (mcOld.getCols() != mc.getCols()) {
                ldim2 = -1L;
                requiresRecompile = true;
            }
            if (mcOld.getNonZeros() != mc.getNonZeros()) {
                lnnz = -1L;
                requiresRecompile = true;
            }
            MatrixObject moNew = Recompiler.createOutputMatrix(ldim1, ldim2, lnnz);
            callVars.put(varname, moNew);
        }
        return requiresRecompile;
    }

    public static boolean reconcileUpdatedCallVarsLoops(RecompileStatus oldCallStatus, RecompileStatus callStatus, StatementBlock sb) {
        boolean requiresRecompile = false;
        for (String varname : sb.variablesUpdated().getVariableNames()) {
            MatrixCharacteristics dat1 = oldCallStatus.getTWriteStats().get(varname);
            MatrixCharacteristics dat2 = callStatus.getTWriteStats().get(varname);
            if (dat1 == null || dat2 == null) continue;
            MatrixCharacteristics mcOld = dat1;
            MatrixCharacteristics mc = dat2;
            if (mcOld.getRows() == mc.getRows() && mcOld.getCols() == mc.getCols() && mcOld.getNonZeros() == mc.getNonZeros()) continue;
            long ldim1 = mc.getRows();
            long ldim2 = mc.getCols();
            long lnnz = mc.getNonZeros();
            if (mcOld.getRows() != mc.getRows()) {
                ldim1 = -1L;
                requiresRecompile = true;
            }
            if (mcOld.getCols() != mc.getCols()) {
                ldim2 = -1L;
                requiresRecompile = true;
            }
            if (mcOld.getNonZeros() != mc.getNonZeros()) {
                lnnz = -1L;
                requiresRecompile = true;
            }
            MatrixCharacteristics moNew = new MatrixCharacteristics(ldim1, ldim2, -1, -1, lnnz);
            callStatus.getTWriteStats().put(varname, moNew);
        }
        return requiresRecompile;
    }

    public static LocalVariableMap reconcileUpdatedCallVarsIf(LocalVariableMap oldCallVars, LocalVariableMap callVarsIf, LocalVariableMap callVarsElse, StatementBlock sb) {
        for (String varname : sb.variablesUpdated().getVariableNames()) {
            Data origVar = oldCallVars.get(varname);
            Data ifVar = callVarsIf.get(varname);
            Data elseVar = callVarsElse.get(varname);
            Data dat1 = null;
            Data dat2 = null;
            if (ifVar != null && elseVar != null) {
                dat1 = ifVar;
                dat2 = elseVar;
            } else if (ifVar != null && elseVar == null) {
                dat1 = origVar;
                dat2 = ifVar;
            } else {
                dat1 = origVar;
                dat2 = elseVar;
            }
            if (dat1 == null || !(dat1 instanceof MatrixObject) || dat2 == null || !(dat1 instanceof MatrixObject) || !(dat2 instanceof MatrixObject)) continue;
            MatrixObject moOld = (MatrixObject)dat1;
            MatrixObject mo = (MatrixObject)dat2;
            MatrixCharacteristics mcOld = moOld.getMatrixCharacteristics();
            MatrixCharacteristics mc = mo.getMatrixCharacteristics();
            if (mcOld.getRows() == mc.getRows() && mcOld.getCols() == mc.getCols() && mcOld.getNonZeros() == mc.getNonZeros()) continue;
            long ldim1 = mc.getRows();
            long ldim2 = mc.getCols();
            long lnnz = mc.getNonZeros();
            if (mcOld.getRows() != mc.getRows()) {
                ldim1 = -1L;
            }
            if (mcOld.getCols() != mc.getCols()) {
                ldim2 = -1L;
            }
            if (mcOld.getNonZeros() != mc.getNonZeros()) {
                lnnz = -1L;
            }
            MatrixObject moNew = Recompiler.createOutputMatrix(ldim1, ldim2, lnnz);
            callVarsIf.put(varname, moNew);
        }
        return callVarsIf;
    }

    public static RecompileStatus reconcileUpdatedCallVarsIf(RecompileStatus oldStatus, RecompileStatus callStatusIf, RecompileStatus callStatusElse, StatementBlock sb) {
        for (String varname : sb.variablesUpdated().getVariableNames()) {
            MatrixCharacteristics origVar = oldStatus.getTWriteStats().get(varname);
            MatrixCharacteristics ifVar = callStatusIf.getTWriteStats().get(varname);
            MatrixCharacteristics elseVar = callStatusElse.getTWriteStats().get(varname);
            MatrixCharacteristics dat1 = null;
            MatrixCharacteristics dat2 = null;
            if (ifVar != null && elseVar != null) {
                dat1 = ifVar;
                dat2 = elseVar;
            } else if (ifVar != null && elseVar == null) {
                dat1 = origVar;
                dat2 = ifVar;
            } else {
                dat1 = origVar;
                dat2 = elseVar;
            }
            if (dat1 == null || dat2 == null) continue;
            MatrixCharacteristics mcOld = dat1;
            MatrixCharacteristics mc = dat2;
            if (mcOld.getRows() == mc.getRows() && mcOld.getCols() == mc.getCols() && mcOld.getNonZeros() == mc.getNonZeros()) continue;
            long ldim1 = mcOld.getRows() >= 0L && mc.getRows() >= 0L ? Math.max(mcOld.getRows(), mc.getRows()) : -1L;
            long ldim2 = mcOld.getCols() >= 0L && mc.getCols() >= 0L ? Math.max(mcOld.getCols(), mc.getCols()) : -1L;
            long lnnz = mcOld.getNonZeros() >= 0L && mc.getNonZeros() >= 0L ? Math.max(mcOld.getNonZeros(), mc.getNonZeros()) : -1L;
            MatrixCharacteristics mcNew = new MatrixCharacteristics(ldim1, ldim2, -1, -1, lnnz);
            callStatusIf.getTWriteStats().put(varname, mcNew);
        }
        return callStatusIf;
    }

    private static boolean containsRootFunctionOp(ArrayList<Hop> hops) {
        boolean ret = false;
        for (Hop h : hops) {
            if (!(h instanceof FunctionOp)) continue;
            ret |= true;
        }
        return ret;
    }

    private static MatrixObject createOutputMatrix(long dim1, long dim2, long nnz) {
        MatrixObject moOut = new MatrixObject(Expression.ValueType.DOUBLE, null);
        int blksz = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mc = new MatrixCharacteristics(dim1, dim2, blksz, blksz, nnz);
        MetaDataFormat meta = new MetaDataFormat(mc, null, null);
        moOut.setMetaData(meta);
        return moOut;
    }

    private static void recompileIfPredicate(IfProgramBlock ipb, IfStatementBlock isb, LocalVariableMap vars, RecompileStatus status, long tid, ResetType resetRecompile) throws DMLRuntimeException, HopsException, LopsException, IOException {
        if (isb == null) {
            return;
        }
        Hop hops = isb.getPredicateHops();
        if (hops != null) {
            ArrayList<Instruction> tmp = Recompiler.recompileHopsDag(hops, vars, status, true, false, tid);
            ipb.setPredicate(tmp);
            if (resetRecompile.isReset()) {
                Hop.resetRecompilationFlag(hops, LopProperties.ExecType.CP, resetRecompile);
                isb.updatePredicateRecompilationFlag();
            }
        }
    }

    private static void recompileWhilePredicate(WhileProgramBlock wpb, WhileStatementBlock wsb, LocalVariableMap vars, RecompileStatus status, long tid, ResetType resetRecompile) throws DMLRuntimeException, HopsException, LopsException, IOException {
        if (wsb == null) {
            return;
        }
        Hop hops = wsb.getPredicateHops();
        if (hops != null) {
            ArrayList<Instruction> tmp = Recompiler.recompileHopsDag(hops, vars, status, true, false, tid);
            wpb.setPredicate(tmp);
            if (resetRecompile.isReset()) {
                Hop.resetRecompilationFlag(hops, LopProperties.ExecType.CP, resetRecompile);
                wsb.updatePredicateRecompilationFlag();
            }
        }
    }

    private static void recompileForPredicates(ForProgramBlock fpb, ForStatementBlock fsb, LocalVariableMap vars, RecompileStatus status, long tid, ResetType resetRecompile) throws DMLRuntimeException, HopsException, LopsException, IOException {
        if (fsb != null) {
            Hop fromHops = fsb.getFromHops();
            Hop toHops = fsb.getToHops();
            Hop incrHops = fsb.getIncrementHops();
            if (resetRecompile.isReset()) {
                ArrayList<Instruction> tmp;
                if (fromHops != null) {
                    tmp = Recompiler.recompileHopsDag(fromHops, vars, status, true, false, tid);
                    fpb.setFromInstructions(tmp);
                    Hop.resetRecompilationFlag(fromHops, LopProperties.ExecType.CP, resetRecompile);
                }
                if (toHops != null) {
                    tmp = Recompiler.recompileHopsDag(toHops, vars, status, true, false, tid);
                    fpb.setToInstructions(tmp);
                    Hop.resetRecompilationFlag(toHops, LopProperties.ExecType.CP, resetRecompile);
                }
                if (incrHops != null) {
                    tmp = Recompiler.recompileHopsDag(incrHops, vars, status, true, false, tid);
                    fpb.setIncrementInstructions(tmp);
                    Hop.resetRecompilationFlag(incrHops, LopProperties.ExecType.CP, resetRecompile);
                }
                fsb.updatePredicateRecompilationFlags();
            } else {
                ArrayList<Instruction> tmp;
                if (fromHops != null) {
                    tmp = Recompiler.recompileHopsDag(fromHops, vars, status, true, false, tid);
                    fpb.setFromInstructions(tmp);
                }
                if (toHops != null) {
                    tmp = Recompiler.recompileHopsDag(toHops, vars, status, true, false, tid);
                    fpb.setToInstructions(tmp);
                }
                if (incrHops != null) {
                    tmp = Recompiler.recompileHopsDag(incrHops, vars, status, true, false, tid);
                    fpb.setIncrementInstructions(tmp);
                }
            }
        }
    }

    private static void rRecompileProgramBlock2Forced(ProgramBlock pb, long tid, HashSet<String> fnStack, LopProperties.ExecType et) throws HopsException, DMLRuntimeException, LopsException, IOException {
        block13: {
            ArrayList<Instruction> tmp;
            block16: {
                block15: {
                    block14: {
                        block12: {
                            if (!(pb instanceof WhileProgramBlock)) break block12;
                            WhileProgramBlock pbTmp = (WhileProgramBlock)pb;
                            WhileStatementBlock sbTmp = (WhileStatementBlock)pbTmp.getStatementBlock();
                            if (sbTmp != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsMRJobInstruction(pbTmp.getPredicate(), true, true))) {
                                pbTmp.setPredicate(Recompiler.recompileHopsDag2Forced(sbTmp.getPredicateHops(), tid, et));
                            }
                            for (ProgramBlock pb2 : pbTmp.getChildBlocks()) {
                                Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                            }
                            break block13;
                        }
                        if (!(pb instanceof IfProgramBlock)) break block14;
                        IfProgramBlock pbTmp = (IfProgramBlock)pb;
                        IfStatementBlock sbTmp = (IfStatementBlock)pbTmp.getStatementBlock();
                        if (sbTmp != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsMRJobInstruction(pbTmp.getPredicate(), true, true))) {
                            pbTmp.setPredicate(Recompiler.recompileHopsDag2Forced(sbTmp.getPredicateHops(), tid, et));
                        }
                        for (ProgramBlock pb2 : pbTmp.getChildBlocksIfBody()) {
                            Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                        }
                        for (ProgramBlock pb2 : pbTmp.getChildBlocksElseBody()) {
                            Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                        }
                        break block13;
                    }
                    if (!(pb instanceof ForProgramBlock)) break block15;
                    ForProgramBlock pbTmp = (ForProgramBlock)pb;
                    ForStatementBlock sbTmp = (ForStatementBlock)pbTmp.getStatementBlock();
                    if (sbTmp != null && sbTmp.getFromHops() != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsMRJobInstruction(pbTmp.getFromInstructions(), true, true))) {
                        pbTmp.setFromInstructions(Recompiler.recompileHopsDag2Forced(sbTmp.getFromHops(), tid, et));
                    }
                    if (sbTmp != null && sbTmp.getToHops() != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsMRJobInstruction(pbTmp.getToInstructions(), true, true))) {
                        pbTmp.setToInstructions(Recompiler.recompileHopsDag2Forced(sbTmp.getToHops(), tid, et));
                    }
                    if (sbTmp != null && sbTmp.getIncrementHops() != null && (et != LopProperties.ExecType.CP || OptTreeConverter.containsMRJobInstruction(pbTmp.getIncrementInstructions(), true, true))) {
                        pbTmp.setIncrementInstructions(Recompiler.recompileHopsDag2Forced(sbTmp.getIncrementHops(), tid, et));
                    }
                    for (ProgramBlock pb2 : pbTmp.getChildBlocks()) {
                        Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                    }
                    break block13;
                }
                if (!(pb instanceof FunctionProgramBlock)) break block16;
                FunctionProgramBlock tmp2 = (FunctionProgramBlock)pb;
                for (ProgramBlock pb2 : tmp2.getChildBlocks()) {
                    Recompiler.rRecompileProgramBlock2Forced(pb2, tid, fnStack, et);
                }
                break block13;
            }
            StatementBlock sb = pb.getStatementBlock();
            if (sb != null) {
                tmp = pb.getInstructions();
                tmp = Recompiler.recompileHopsDag2Forced(sb, sb.getHops(), tid, et);
                pb.setInstructions(tmp);
            }
            if (!OptTreeConverter.containsFunctionCallInstruction(pb)) break block13;
            tmp = pb.getInstructions();
            for (Instruction inst : tmp) {
                if (!(inst instanceof FunctionCallCPInstruction)) continue;
                FunctionCallCPInstruction func = (FunctionCallCPInstruction)inst;
                String fname = func.getFunctionName();
                String fnamespace = func.getNamespace();
                String fKey = DMLProgram.constructFunctionKey(fnamespace, fname);
                if (fnStack.contains(fKey)) continue;
                fnStack.add(fKey);
                FunctionProgramBlock fpb = pb.getProgram().getFunctionProgramBlock(fnamespace, fname);
                Recompiler.rRecompileProgramBlock2Forced(fpb, tid, fnStack, et);
            }
        }
    }

    public static void removeUpdatedScalars(LocalVariableMap callVars, StatementBlock sb) {
        if (sb != null) {
            for (String varname : sb.variablesUpdated().getVariables().keySet()) {
                Data dat = callVars.get(varname);
                if (dat == null || dat.getDataType() != Expression.DataType.SCALAR) continue;
                callVars.remove(varname);
            }
        }
    }

    public static void extractDAGOutputStatistics(ArrayList<Hop> hops, LocalVariableMap vars) {
        Recompiler.extractDAGOutputStatistics(hops, vars, true);
    }

    public static void extractDAGOutputStatistics(ArrayList<Hop> hops, LocalVariableMap vars, boolean overwrite) {
        for (Hop hop : hops) {
            Recompiler.extractDAGOutputStatistics(hop, vars, overwrite);
        }
    }

    public static void extractDAGOutputStatistics(Hop hop, LocalVariableMap vars, boolean overwrite) {
        if (hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.TRANSIENTWRITE) {
            String varName = hop.getName();
            if (!vars.keySet().contains(varName) || overwrite) {
                if (hop.getDataType() == Expression.DataType.MATRIX) {
                    MatrixObject mo = new MatrixObject(Expression.ValueType.DOUBLE, null);
                    MatrixCharacteristics mc = new MatrixCharacteristics(hop.getDim1(), hop.getDim2(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), hop.getNnz());
                    MetaDataFormat meta = new MetaDataFormat(mc, null, null);
                    mo.setMetaData(meta);
                    vars.put(varName, mo);
                } else if (hop.getDataType() == Expression.DataType.SCALAR) {
                    if (hop.getInput().size() == 1 && hop.getInput().get(0) instanceof LiteralOp) {
                        ScalarObject constant = HopRewriteUtils.getScalarObject((LiteralOp)hop.getInput().get(0));
                        if (constant != null) {
                            vars.put(varName, constant);
                        }
                    } else if (hop.getInput().size() == 1 && hop.getInput().get(0) instanceof DataOp) {
                        DataOp dop = (DataOp)hop.getInput().get(0);
                        String dopvarname = dop.getName();
                        if (dop.isRead() && vars.keySet().contains(dopvarname)) {
                            ScalarObject constant = (ScalarObject)vars.get(dopvarname);
                            vars.put(varName, constant);
                        }
                    } else if (hop.getInput().size() == 1 && hop.getInput().get(0) instanceof UnaryOp && (((UnaryOp)hop.getInput().get(0)).getOp() == Hop.OpOp1.NROW || ((UnaryOp)hop.getInput().get(0)).getOp() == Hop.OpOp1.NCOL)) {
                        UnaryOp uop = (UnaryOp)hop.getInput().get(0);
                        if (uop.getOp() == Hop.OpOp1.NROW && uop.getInput().get(0).getDim1() > 0L) {
                            vars.put(varName, new IntObject(uop.getInput().get(0).getDim1()));
                        } else if (uop.getOp() == Hop.OpOp1.NCOL && uop.getInput().get(0).getDim2() > 0L) {
                            vars.put(varName, new IntObject(uop.getInput().get(0).getDim2()));
                        }
                    } else {
                        vars.remove(varName);
                    }
                }
            } else {
                ScalarObject constant;
                Data dat = vars.get(varName);
                if (dat instanceof MatrixObject) {
                    MatrixObject mo = (MatrixObject)dat;
                    MatrixCharacteristics mc = mo.getMatrixCharacteristics();
                    if (OptimizerUtils.estimateSizeExactSparsity(mc.getRows(), mc.getCols(), mc.getNonZeros() >= 0L ? (double)mc.getNonZeros() / (double)mc.getRows() / (double)mc.getCols() : 1.0) < OptimizerUtils.estimateSize(hop.getDim1(), hop.getDim2())) {
                        mc.setDimension(hop.getDim1(), hop.getDim2());
                        mc.setNonZeros(hop.getNnz());
                    }
                } else if (hop.getInput().size() == 1 && hop.getInput().get(0) instanceof LiteralOp && (constant = HopRewriteUtils.getScalarObject((LiteralOp)hop.getInput().get(0))) != null) {
                    vars.put(varName, constant);
                }
            }
        }
    }

    private static boolean rRequiresRecompile(Hop hop) {
        boolean ret = hop.requiresRecompile();
        if (hop.isVisited()) {
            return ret;
        }
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                if (ret |= Recompiler.rRequiresRecompile(c)) break;
            }
        }
        hop.setVisited();
        return ret;
    }

    public static void rClearLops(Hop hop) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof LiteralOp) {
            if (hop.getLops() != null) {
                hop.getLops().getOutputs().clear();
            }
        } else {
            hop.resetExecType();
            hop.setLops(null);
            if (hop.getInput() != null) {
                for (Hop c : hop.getInput()) {
                    Recompiler.rClearLops(c);
                }
            }
        }
        hop.setVisited();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rUpdateStatistics(Hop hop, LocalVariableMap vars) throws DMLRuntimeException {
        Hop d;
        if (hop.isVisited()) {
            return;
        }
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                Recompiler.rUpdateStatistics(c, vars);
            }
        }
        boolean updatedSizeExpr = false;
        if (hop instanceof DataOp && ((DataOp)hop).getDataOpType() != Hop.DataOpTypes.PERSISTENTREAD) {
            d = (DataOp)hop;
            String varName = d.getName();
            if (vars.keySet().contains(varName)) {
                Data dat = vars.get(varName);
                if (dat instanceof MatrixObject) {
                    MatrixObject mo = (MatrixObject)dat;
                    d.setDim1(mo.getNumRows());
                    d.setDim2(mo.getNumColumns());
                    d.setNnz(mo.getNnz());
                } else if (dat instanceof FrameObject) {
                    FrameObject fo = (FrameObject)dat;
                    d.setDim1(fo.getNumRows());
                    d.setDim2(fo.getNumColumns());
                }
            }
        } else if (hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD && !hop.dimsKnown() && ((DataOp)hop).getInputFormatType() != Hop.FileFormatTypes.CSV && !ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_READ_WRITE_METADATA)) {
            DataOp dop = (DataOp)hop;
            Recompiler.tryReadMetaDataFileMatrixCharacteristics(dop);
        } else if (hop instanceof DataGenOp) {
            d = (DataGenOp)hop;
            HashMap<String, Integer> params = ((DataGenOp)d).getParamIndexMap();
            if (((DataGenOp)d).getOp() == Hop.DataGenMethod.RAND || ((DataGenOp)d).getOp() == Hop.DataGenMethod.SINIT || ((DataGenOp)d).getOp() == Hop.DataGenMethod.SAMPLE) {
                boolean initUnknown = !d.dimsKnown();
                int ix1 = params.get("rows");
                int ix2 = params.get("cols");
                HashMap<Long, Long> memo = new HashMap<Long, Long>();
                d.refreshRowsParameterInformation(d.getInput().get(ix1), vars, memo);
                d.refreshColsParameterInformation(d.getInput().get(ix2), vars, memo);
                updatedSizeExpr = initUnknown & d.dimsKnown();
            } else {
                if (((DataGenOp)d).getOp() != Hop.DataGenMethod.SEQ) throw new DMLRuntimeException("Unexpected data generation method: " + (Object)((Object)((DataGenOp)d).getOp()));
                boolean initUnknown = !d.dimsKnown();
                int ix1 = params.get("from");
                int ix2 = params.get("to");
                int ix3 = params.get("incr");
                HashMap<Long, Double> memo = new HashMap<Long, Double>();
                double from = d.computeBoundsInformation(d.getInput().get(ix1), vars, memo);
                double to = d.computeBoundsInformation(d.getInput().get(ix2), vars, memo);
                double incr = d.computeBoundsInformation(d.getInput().get(ix3), vars, memo);
                if (from != Double.MAX_VALUE && to != Double.MAX_VALUE) {
                    incr *= from > to && incr > 0.0 || from < to && incr < 0.0 ? -1.0 : 1.0;
                }
                if (from != Double.MAX_VALUE && to != Double.MAX_VALUE && incr != Double.MAX_VALUE) {
                    d.setDim1(UtilFunctions.getSeqLength(from, to, incr));
                    d.setDim2(1L);
                    ((DataGenOp)d).setIncrementValue(incr);
                }
                updatedSizeExpr = initUnknown & d.dimsKnown();
            }
        } else if (hop instanceof ReorgOp && ((ReorgOp)hop).getOp() == Hop.ReOrgOp.RESHAPE) {
            d = (ReorgOp)hop;
            boolean initUnknown = !d.dimsKnown();
            HashMap<Long, Long> memo = new HashMap<Long, Long>();
            d.refreshRowsParameterInformation(d.getInput().get(1), vars, memo);
            d.refreshColsParameterInformation(d.getInput().get(2), vars, memo);
            updatedSizeExpr = initUnknown & d.dimsKnown();
        } else if (hop instanceof IndexingOp) {
            IndexingOp iop = (IndexingOp)hop;
            Hop input2 = iop.getInput().get(1);
            Hop input3 = iop.getInput().get(2);
            Hop input4 = iop.getInput().get(3);
            Hop input5 = iop.getInput().get(4);
            boolean initUnknown = !iop.dimsKnown();
            HashMap<Long, Double> memo = new HashMap<Long, Double>();
            double rl = iop.computeBoundsInformation(input2, vars, memo);
            double ru = iop.computeBoundsInformation(input3, vars, memo);
            double cl = iop.computeBoundsInformation(input4, vars, memo);
            double cu = iop.computeBoundsInformation(input5, vars, memo);
            if (rl != Double.MAX_VALUE && ru != Double.MAX_VALUE) {
                iop.setDim1((long)(ru - rl + 1.0));
            }
            if (cl != Double.MAX_VALUE && cu != Double.MAX_VALUE) {
                iop.setDim2((long)(cu - cl + 1.0));
            }
            updatedSizeExpr = initUnknown & iop.dimsKnown();
        }
        if (!updatedSizeExpr) {
            hop.refreshSizeInformation();
        }
        hop.setVisited();
    }

    public static void rReplaceLiterals(Hop hop, LocalVariableMap vars, boolean scalarsOnly) throws DMLRuntimeException {
        LiteralReplacement.rReplaceLiterals(hop, vars, scalarsOnly);
    }

    public static void rSetExecType(Hop hop, LopProperties.ExecType etype) {
        if (hop.isVisited()) {
            return;
        }
        hop.setForcedExecType(etype);
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                Recompiler.rSetExecType(c, etype);
            }
        }
        hop.setVisited();
    }

    public static boolean checkCPReblock(MRJobInstruction inst, MatrixObject[] inputs) throws DMLRuntimeException, IOException {
        String[] instParts;
        String shuffleInst;
        boolean ret = true;
        boolean localMode = InfrastructureAnalyzer.isLocalMode();
        String rdInst = inst.getIv_randInstructions();
        String rrInst = inst.getIv_recordReaderInstructions();
        String mapInst = inst.getIv_instructionsInMapper();
        String aggInst = inst.getIv_aggInstructions();
        String otherInst = inst.getIv_otherInstructions();
        if (rdInst != null && rdInst.length() > 0 || rrInst != null && rrInst.length() > 0 || mapInst != null && mapInst.length() > 0 || aggInst != null && aggInst.length() > 0 || otherInst != null && otherInst.length() > 0) {
            ret = false;
        }
        if (ret) {
            shuffleInst = inst.getIv_shuffleInstructions();
            for (String rblk : instParts = shuffleInst.split("\u2021")) {
                if (InstructionUtils.getOpCode(rblk).equals("rblk") || InstructionUtils.getOpCode(rblk).equals("csvrblk")) continue;
                ret = false;
                break;
            }
        }
        if (ret) {
            shuffleInst = inst.getIv_shuffleInstructions();
            for (String rblk : instParts = shuffleInst.split("\u2021")) {
                if (!InstructionUtils.getOpCode(rblk).equals("rblk") || !rblk.endsWith("false")) continue;
                ret = false;
                break;
            }
        }
        if (ret) {
            for (MatrixObject mo : inputs) {
                long rows = mo.getNumRows();
                long cols = mo.getNumColumns();
                if (rows == -1L || cols == -1L) {
                    Path path = new Path(mo.getFileName());
                    long size = MapReduceTool.getFilesizeOnHDFS(path);
                    if (size <= 0x40000000L && !(1.073741824E9 > OptimizerUtils.getLocalMemBudget())) continue;
                    ret = false;
                    break;
                }
                long nnz = mo.getNnz();
                double sp = OptimizerUtils.getSparsity(rows, cols, nnz);
                double mem = MatrixBlock.estimateSizeInMemory(rows, cols, sp);
                if (OptimizerUtils.isValidCPDimensions(rows, cols) && OptimizerUtils.isValidCPMatrixSize(rows, cols, sp) && !(mem >= OptimizerUtils.getLocalMemBudget())) continue;
                ret = false;
                break;
            }
        }
        if (ret && !localMode) {
            for (MatrixObject mo : inputs) {
                long cpThreshold;
                Path path;
                long fileSize;
                MetaDataFormat iimd = (MetaDataFormat)mo.getMetaData();
                if (iimd.getInputInfo() != InputInfo.TextCellInputInfo && iimd.getInputInfo() != InputInfo.MatrixMarketInputInfo && iimd.getInputInfo() != InputInfo.CSVInputInfo && iimd.getInputInfo() != InputInfo.BinaryCellInputInfo || mo.isDirty() || (fileSize = MapReduceTool.getFilesizeOnHDFS(path = new Path(mo.getFileName()))) <= (cpThreshold = 0x40000000L * (long)OptimizerUtils.getParallelTextReadParallelism())) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean checkCPReblock(ExecutionContext ec, String varin) throws DMLRuntimeException {
        CacheableData<?> obj = ec.getCacheableData(varin);
        MatrixCharacteristics mc = ec.getMatrixCharacteristics(varin);
        long rows = mc.getRows();
        long cols = mc.getCols();
        long nnz = mc.getNonZeros();
        if (!ConfigurationManager.isDynamicRecompilation() || !OptimizerUtils.isHybridExecutionMode()) {
            return false;
        }
        MetaDataFormat iimd = (MetaDataFormat)obj.getMetaData();
        if (obj.getRDDHandle() != null && iimd.getInputInfo() != InputInfo.BinaryBlockInputInfo && iimd.getInputInfo() != InputInfo.BinaryCellInputInfo) {
            return false;
        }
        if (rows <= 0L || cols <= 0L) {
            try {
                long size = MapReduceTool.getFilesizeOnHDFS(new Path(obj.getFileName()));
                return (double)size < OptimizerUtils.getLocalMemBudget() && size < 0x40000000L * (long)OptimizerUtils.getParallelTextReadParallelism();
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new DMLRuntimeException(ex);
            }
        }
        double sp = OptimizerUtils.getSparsity(rows, cols, nnz);
        double mem = MatrixBlock.estimateSizeInMemory(rows, cols, sp);
        if (!OptimizerUtils.isValidCPDimensions(rows, cols) || !OptimizerUtils.isValidCPMatrixSize(rows, cols, sp) || mem >= OptimizerUtils.getLocalMemBudget()) {
            return false;
        }
        long estFilesize = (long)(3.5 * mem);
        long cpThreshold = 0x40000000L * (long)OptimizerUtils.getParallelTextReadParallelism();
        return estFilesize < cpThreshold;
    }

    public static boolean checkCPDataGen(MRJobInstruction inst, String updatedRandInst) throws DMLRuntimeException {
        boolean ret = true;
        String shuffleInst = inst.getIv_shuffleInstructions();
        String rrInst = inst.getIv_recordReaderInstructions();
        String mapInst = inst.getIv_instructionsInMapper();
        String aggInst = inst.getIv_aggInstructions();
        String otherInst = inst.getIv_otherInstructions();
        if (shuffleInst != null && shuffleInst.length() > 0 || rrInst != null && rrInst.length() > 0 || mapInst != null && mapInst.length() > 0 || aggInst != null && aggInst.length() > 0 || otherInst != null && otherInst.length() > 0) {
            ret = false;
        }
        if (ret) {
            String[] instParts;
            for (String lrandStr : instParts = updatedRandInst.split("\u2021")) {
                long cols;
                long rows;
                DataGenMRInstruction lrandInst;
                if (InstructionUtils.getOpCode(lrandStr).equals("rand")) {
                    lrandInst = RandInstruction.parseInstruction(lrandStr);
                    rows = lrandInst.getRows();
                    cols = lrandInst.getCols();
                    double sparsity = ((RandInstruction)lrandInst).getSparsity();
                    double mem = MatrixBlock.estimateSizeInMemory(rows, cols, sparsity);
                    if (OptimizerUtils.isValidCPDimensions(rows, cols) && OptimizerUtils.isValidCPMatrixSize(rows, cols, sparsity) && !(mem >= OptimizerUtils.getLocalMemBudget())) continue;
                    ret = false;
                    break;
                }
                if (InstructionUtils.getOpCode(lrandStr).equals("seq")) {
                    lrandInst = SeqInstruction.parseInstruction(lrandStr);
                    rows = lrandInst.getRows();
                    cols = lrandInst.getCols();
                    double mem = MatrixBlock.estimateSizeInMemory(rows, cols, 1.0);
                    if (OptimizerUtils.isValidCPDimensions(rows, cols) && OptimizerUtils.isValidCPMatrixSize(rows, cols, 1.0) && !(mem >= OptimizerUtils.getLocalMemBudget())) continue;
                    ret = false;
                    break;
                }
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static void executeInMemoryMatrixReblock(ExecutionContext ec, String varin, String varout) throws DMLRuntimeException {
        MatrixObject in = ec.getMatrixObject(varin);
        MatrixObject out = ec.getMatrixObject(varout);
        MatrixBlock mb = (MatrixBlock)in.acquireRead();
        out.acquireModify(mb);
        out.release();
        in.release();
    }

    public static void executeInMemoryFrameReblock(ExecutionContext ec, String varin, String varout) throws DMLRuntimeException {
        FrameObject in = ec.getFrameObject(varin);
        FrameObject out = ec.getFrameObject(varout);
        FrameBlock fb = (FrameBlock)in.acquireRead();
        out.acquireModify(fb);
        out.release();
        in.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryReadMetaDataFileMatrixCharacteristics(DataOp dop) throws DMLRuntimeException {
        block5: {
            try {
                String mtdname = DataExpression.getMTDFileName(dop.getFileName());
                Path path = new Path(mtdname);
                FileSystem fs = IOUtilFunctions.getFileSystem(mtdname);
                if (!fs.exists(path)) break block5;
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
                    JSONObject mtd = JSONHelper.parse(br);
                    Expression.DataType dt = Expression.DataType.valueOf(String.valueOf(mtd.get("data_type")).toUpperCase());
                    dop.setDataType(dt);
                    if (dt != Expression.DataType.FRAME) {
                        dop.setValueType(Expression.ValueType.valueOf(String.valueOf(mtd.get("value_type")).toUpperCase()));
                    }
                    dop.setDim1(dt == Expression.DataType.MATRIX || dt == Expression.DataType.FRAME ? Long.parseLong(mtd.get("rows").toString()) : 0L);
                    dop.setDim2(dt == Expression.DataType.MATRIX || dt == Expression.DataType.FRAME ? Long.parseLong(mtd.get("cols").toString()) : 0L);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(br);
                    throw throwable;
                }
                IOUtilFunctions.closeSilently(br);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        }
    }

    public static enum ResetType {
        RESET,
        RESET_KNOWN_DIMS,
        NO_RESET;


        public boolean isReset() {
            return this != NO_RESET;
        }
    }
}

