/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.ipa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ipa.FunctionCallGraph;
import org.apache.sysml.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysml.hops.ipa.IPAPass;
import org.apache.sysml.hops.ipa.IPAPassApplyStaticHopRewrites;
import org.apache.sysml.hops.ipa.IPAPassFlagFunctionsRecompileOnce;
import org.apache.sysml.hops.ipa.IPAPassInlineFunctions;
import org.apache.sysml.hops.ipa.IPAPassPropagateReplaceLiterals;
import org.apache.sysml.hops.ipa.IPAPassRemoveConstantBinaryOps;
import org.apache.sysml.hops.ipa.IPAPassRemoveUnnecessaryCheckpoints;
import org.apache.sysml.hops.ipa.IPAPassRemoveUnusedFunctions;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DMLTranslator;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.udf.lib.DynamicReadMatrixCP;
import org.apache.sysml.udf.lib.DynamicReadMatrixRcCP;
import org.apache.sysml.udf.lib.OrderWrapper;

public class InterProceduralAnalysis {
    private static final boolean LDEBUG = false;
    private static final Log LOG = LogFactory.getLog((String)InterProceduralAnalysis.class.getName());
    protected static final boolean INTRA_PROCEDURAL_ANALYSIS = true;
    protected static final boolean PROPAGATE_KNOWN_UDF_STATISTICS = true;
    protected static final boolean ALLOW_MULTIPLE_FUNCTION_CALLS = true;
    protected static final boolean REMOVE_UNUSED_FUNCTIONS = true;
    protected static final boolean FLAG_FUNCTION_RECOMPILE_ONCE = true;
    protected static final boolean REMOVE_UNNECESSARY_CHECKPOINTS = true;
    protected static final boolean REMOVE_CONSTANT_BINARY_OPS = true;
    protected static final boolean PROPAGATE_SCALAR_VARS_INTO_FUN = true;
    protected static final boolean PROPAGATE_SCALAR_LITERALS = true;
    protected static final boolean APPLY_STATIC_REWRITES = true;
    protected static final int INLINING_MAX_NUM_OPS = 10;
    private final DMLProgram _prog;
    private final StatementBlock _sb;
    private final FunctionCallGraph _fgraph;
    private final ArrayList<IPAPass> _passes;

    public InterProceduralAnalysis(DMLProgram dmlp) {
        this._prog = dmlp;
        this._sb = null;
        this._fgraph = new FunctionCallGraph(dmlp);
        this._passes = new ArrayList();
        this._passes.add(new IPAPassRemoveUnusedFunctions());
        this._passes.add(new IPAPassFlagFunctionsRecompileOnce());
        this._passes.add(new IPAPassRemoveUnnecessaryCheckpoints());
        this._passes.add(new IPAPassRemoveConstantBinaryOps());
        this._passes.add(new IPAPassPropagateReplaceLiterals());
        this._passes.add(new IPAPassApplyStaticHopRewrites());
        this._passes.add(new IPAPassInlineFunctions());
    }

    public InterProceduralAnalysis(StatementBlock sb) {
        this._prog = sb.getDMLProg();
        this._sb = sb;
        this._fgraph = new FunctionCallGraph(sb);
        this._passes = new ArrayList();
    }

    public void analyzeProgram() throws HopsException {
        this.analyzeProgram(1);
    }

    public void analyzeProgram(int repetitions) throws HopsException {
        FunctionCallGraph graph2;
        IPAPassRemoveUnusedFunctions rmFuns;
        if (repetitions <= 0) {
            throw new HopsException("Invalid number of IPA repetitions: " + repetitions);
        }
        FunctionCallSizeInfo lastSizes = null;
        for (int i = 0; i < repetitions; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IPA: start IPA iteration " + (i + 1) + "/" + repetitions + "."));
            }
            FunctionCallSizeInfo fcallSizes = new FunctionCallSizeInfo(this._fgraph);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IPA: Initial FunctionCallSummary: \n" + fcallSizes));
            }
            for (String string : fcallSizes.getInvalidFunctions()) {
                if (!this.isUnarySizePreservingFunction(this._prog.getFunctionStatementBlock(string))) continue;
                fcallSizes.addDimsPreservingFunction(string);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("IPA: Extended FunctionCallSummary: \n" + fcallSizes));
            }
            LocalVariableMap callVars = new LocalVariableMap();
            for (StatementBlock sb : this._prog.getStatementBlocks()) {
                this.propagateStatisticsAcrossBlock(sb, callVars, fcallSizes, new HashSet<String>());
            }
            for (IPAPass iPAPass : this._passes) {
                if (!iPAPass.isApplicable(this._fgraph)) continue;
                iPAPass.rewriteProgram(this._prog, this._fgraph, fcallSizes);
            }
            if (!this._fgraph.getReachableFunctions().isEmpty() && (lastSizes == null || !lastSizes.equals(fcallSizes))) continue;
            if (!LOG.isDebugEnabled()) break;
            LOG.debug((Object)("IPA: Early abort after " + (i + 1) + "/" + repetitions + " repetitions due to reached fixpoint."));
            break;
        }
        if (((IPAPass)(rmFuns = new IPAPassRemoveUnusedFunctions())).isApplicable(graph2 = new FunctionCallGraph(this._prog))) {
            ((IPAPass)rmFuns).rewriteProgram(this._prog, graph2, null);
        }
    }

    public Set<String> analyzeSubProgram() throws HopsException, ParseException {
        DMLTranslator.resetHopsDAGVisitStatus(this._sb);
        FunctionCallSizeInfo fcallSizes = new FunctionCallSizeInfo(this._fgraph);
        if (!fcallSizes.getValidFunctions().isEmpty()) {
            LocalVariableMap callVars = new LocalVariableMap();
            this.propagateStatisticsAcrossBlock(this._sb, callVars, fcallSizes, new HashSet<String>());
        }
        return fcallSizes.getValidFunctions();
    }

    private boolean isUnarySizePreservingFunction(FunctionStatementBlock fsb) throws HopsException {
        boolean ret;
        FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
        boolean bl = ret = fstmt.getInputParams().size() == 1 && fstmt.getInputParams().get(0).getDataType() == Expression.DataType.MATRIX && fstmt.getOutputParams().size() == 1 && fstmt.getOutputParams().get(0).getDataType() == Expression.DataType.MATRIX;
        if (ret) {
            FunctionCallSizeInfo fcallSizes = new FunctionCallSizeInfo(this._fgraph, false);
            HashSet<String> fnStack = new HashSet<String>();
            LocalVariableMap callVars = new LocalVariableMap();
            MatrixObject mo = InterProceduralAnalysis.createOutputMatrix(7777L, 3333L, -1L);
            callVars.put(fstmt.getInputParams().get(0).getName(), mo);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack);
            }
            MatrixObject mo2 = (MatrixObject)callVars.get(fstmt.getOutputParams().get(0).getName());
            ret &= mo.getNumRows() == mo2.getNumRows() && mo.getNumColumns() == mo2.getNumColumns();
            mo.getMatrixCharacteristics().setDimension(-1L, -1L);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack);
            }
        }
        return ret;
    }

    private void propagateStatisticsAcrossBlock(StatementBlock sb, LocalVariableMap callVars, FunctionCallSizeInfo fcallSizes, Set<String> fnStack) throws HopsException {
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack);
            }
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(wsb.getPredicateHops(), callVars);
            Recompiler.removeUpdatedScalars(callVars, wsb);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : wstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldCallVars, callVars, (StatementBlock)wsb)) {
                InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(wsb.getPredicateHops(), callVars);
                for (StatementBlock sbi : wstmt.getBody()) {
                    this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack);
                }
            }
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(isb.getPredicateHops(), callVars);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            LocalVariableMap callVarsElse = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : istmt.getIfBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack);
            }
            for (StatementBlock sbi : istmt.getElseBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVarsElse, fcallSizes, fnStack);
            }
            callVars = Recompiler.reconcileUpdatedCallVarsIf(oldCallVars, callVars, callVarsElse, (StatementBlock)isb);
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(fsb.getFromHops(), callVars);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(fsb.getToHops(), callVars);
            InterProceduralAnalysis.propagateStatisticsAcrossPredicateDAG(fsb.getIncrementHops(), callVars);
            Recompiler.removeUpdatedScalars(callVars, fsb);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldCallVars, callVars, (StatementBlock)fsb)) {
                for (StatementBlock sbi : fstmt.getBody()) {
                    this.propagateStatisticsAcrossBlock(sbi, callVars, fcallSizes, fnStack);
                }
            }
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else {
            Recompiler.removeUpdatedScalars(callVars, sb);
            ArrayList<Hop> roots = sb.getHops();
            DMLProgram prog = sb.getDMLProg();
            Hop.resetVisitStatus(roots);
            InterProceduralAnalysis.propagateScalarsAcrossDAG(roots, callVars);
            Hop.resetVisitStatus(roots);
            InterProceduralAnalysis.propagateStatisticsAcrossDAG(roots, callVars);
            Hop.resetVisitStatus(roots);
            this.propagateStatisticsIntoFunctions(prog, roots, callVars, fcallSizes, fnStack);
        }
    }

    private static void propagateScalarsAcrossDAG(ArrayList<Hop> roots, LocalVariableMap vars) throws HopsException {
        for (Hop hop : roots) {
            try {
                Recompiler.rReplaceLiterals(hop, vars, true);
            }
            catch (Exception ex) {
                throw new HopsException("Failed to perform scalar literal replacement.", ex);
            }
        }
    }

    private static void propagateStatisticsAcrossPredicateDAG(Hop root, LocalVariableMap vars) throws HopsException {
        if (root == null) {
            return;
        }
        root.resetVisitStatus();
        try {
            Recompiler.rUpdateStatistics(root, vars);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to update Hop DAG statistics.", ex);
        }
    }

    private static void propagateStatisticsAcrossDAG(ArrayList<Hop> roots, LocalVariableMap vars) throws HopsException {
        if (roots == null) {
            return;
        }
        try {
            for (Hop hop : roots) {
                Recompiler.rUpdateStatistics(hop, vars);
            }
            Recompiler.extractDAGOutputStatistics(roots, vars, true);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to update Hop DAG statistics.", ex);
        }
    }

    private void propagateStatisticsIntoFunctions(DMLProgram prog, ArrayList<Hop> roots, LocalVariableMap callVars, FunctionCallSizeInfo fcallSizes, Set<String> fnStack) throws HopsException {
        for (Hop root : roots) {
            this.propagateStatisticsIntoFunctions(prog, root, callVars, fcallSizes, fnStack);
        }
    }

    private void propagateStatisticsIntoFunctions(DMLProgram prog, Hop hop, LocalVariableMap callVars, FunctionCallSizeInfo fcallSizes, Set<String> fnStack) throws HopsException {
        if (hop.isVisited()) {
            return;
        }
        for (Hop c : hop.getInput()) {
            this.propagateStatisticsIntoFunctions(prog, c, callVars, fcallSizes, fnStack);
        }
        if (hop instanceof FunctionOp) {
            FunctionOp fop = (FunctionOp)hop;
            String fkey = fop.getFunctionKey();
            if (fop.getFunctionType() == FunctionOp.FunctionType.DML) {
                FunctionStatementBlock fsb = prog.getFunctionStatementBlock(fop.getFunctionNamespace(), fop.getFunctionName());
                FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                if (fcallSizes.isValidFunction(fkey) && !fnStack.contains(fkey)) {
                    fnStack.add(fkey);
                    LocalVariableMap tmpVars = new LocalVariableMap();
                    InterProceduralAnalysis.populateLocalVariableMapForFunctionCall(fstmt, fop, callVars, tmpVars, fcallSizes);
                    this.propagateStatisticsAcrossBlock(fsb, tmpVars, fcallSizes, fnStack);
                    InterProceduralAnalysis.extractFunctionCallReturnStatistics(fstmt, fop, tmpVars, callVars, true);
                    fnStack.remove(fkey);
                } else if (fcallSizes.isDimsPreservingFunction(fkey)) {
                    InterProceduralAnalysis.extractFunctionCallEquivalentReturnStatistics(fstmt, fop, callVars);
                } else {
                    InterProceduralAnalysis.extractFunctionCallUnknownReturnStatistics(fstmt, fop, callVars);
                }
            } else if (fop.getFunctionType() == FunctionOp.FunctionType.EXTERNAL_FILE || fop.getFunctionType() == FunctionOp.FunctionType.EXTERNAL_MEM) {
                FunctionStatementBlock fsb = prog.getFunctionStatementBlock(fop.getFunctionNamespace(), fop.getFunctionName());
                ExternalFunctionStatement fstmt = (ExternalFunctionStatement)fsb.getStatement(0);
                InterProceduralAnalysis.extractExternalFunctionCallReturnStatistics(fstmt, fop, callVars);
            }
        }
        hop.setVisited();
    }

    private static void populateLocalVariableMapForFunctionCall(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callvars, LocalVariableMap vars, FunctionCallSizeInfo fcallSizes) throws HopsException {
        ArrayList<DataIdentifier> inputVars = fstmt.getInputParams();
        ArrayList<Hop> inputOps = fop.getInput();
        String fkey = fop.getFunctionKey();
        for (int i = 0; i < inputVars.size(); ++i) {
            Data scalar;
            DataIdentifier dat = inputVars.get(i);
            Hop input = inputOps.get(i);
            if (input.getDataType() == Expression.DataType.MATRIX) {
                MatrixObject mo = new MatrixObject(Expression.ValueType.DOUBLE, null);
                MatrixCharacteristics mc = new MatrixCharacteristics(input.getDim1(), input.getDim2(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), fcallSizes.isSafeNnz(fkey, i) ? input.getNnz() : -1L);
                MetaDataFormat meta = new MetaDataFormat(mc, null, null);
                mo.setMetaData(meta);
                vars.put(dat.getName(), mo);
                continue;
            }
            if (input.getDataType() != Expression.DataType.SCALAR) continue;
            if (input instanceof LiteralOp) {
                vars.put(dat.getName(), ScalarObjectFactory.createScalarObject(input.getValueType(), (LiteralOp)input));
                continue;
            }
            if (fcallSizes.getFunctionCallCount(fkey) != 1 || !(input instanceof DataOp) || (scalar = callvars.get(input.getName())) == null || !(scalar instanceof ScalarObject)) continue;
            vars.put(dat.getName(), scalar);
        }
    }

    private static void extractFunctionCallReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap tmpVars, LocalVariableMap callVars, boolean overwrite) throws HopsException {
        ArrayList<DataIdentifier> foutputOps = fstmt.getOutputParams();
        String[] outputVars = fop.getOutputVariableNames();
        String fkey = fop.getFunctionKey();
        try {
            for (int i = 0; i < foutputOps.size(); ++i) {
                MatrixObject moOut;
                MatrixCharacteristics mc;
                Expression.DataType pdataType;
                Expression.DataType fdataType;
                DataIdentifier di = foutputOps.get(i);
                String fvarname = di.getName();
                String pvarname = outputVars[i];
                if (callVars.keySet().contains(pvarname) && (fdataType = di.getDataType()) != (pdataType = callVars.get(pvarname).getDataType())) {
                    callVars.remove(pvarname);
                }
                if (di.getDataType() != Expression.DataType.MATRIX || !tmpVars.keySet().contains(fvarname)) continue;
                MatrixObject moIn = (MatrixObject)tmpVars.get(fvarname);
                if (!callVars.keySet().contains(pvarname) || overwrite) {
                    MatrixObject moOut2 = InterProceduralAnalysis.createOutputMatrix(moIn.getNumRows(), moIn.getNumColumns(), moIn.getNnz());
                    callVars.put(pvarname, moOut2);
                    continue;
                }
                Data dat = callVars.get(pvarname);
                if (!(dat instanceof MatrixObject) || OptimizerUtils.estimateSizeExactSparsity((mc = (moOut = (MatrixObject)dat).getMatrixCharacteristics()).getRows(), mc.getCols(), mc.getNonZeros() > 0L ? OptimizerUtils.getSparsity(mc) : 1.0) >= OptimizerUtils.estimateSize(moIn.getNumRows(), moIn.getNumColumns())) continue;
                mc.setDimension(moIn.getNumRows(), moIn.getNumColumns());
                mc.setNonZeros(moIn.getNnz());
            }
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics of function " + fkey + ".", ex);
        }
    }

    private static void extractFunctionCallUnknownReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callVars) throws HopsException {
        ArrayList<DataIdentifier> foutputOps = fstmt.getOutputParams();
        String[] outputVars = fop.getOutputVariableNames();
        String fkey = fop.getFunctionKey();
        try {
            for (int i = 0; i < foutputOps.size(); ++i) {
                DataIdentifier di = foutputOps.get(i);
                String pvarname = outputVars[i];
                if (di.getDataType() != Expression.DataType.MATRIX) continue;
                MatrixObject moOut = InterProceduralAnalysis.createOutputMatrix(-1L, -1L, -1L);
                callVars.put(pvarname, moOut);
            }
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics of function " + fkey + ".", ex);
        }
    }

    private static void extractFunctionCallEquivalentReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callVars) throws HopsException {
        try {
            Hop input = fop.getInput().get(0);
            MatrixObject moOut = InterProceduralAnalysis.createOutputMatrix(input.getDim1(), input.getDim2(), -1L);
            callVars.put(fop.getOutputVariableNames()[0], moOut);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics for unary function " + fop.getFunctionKey() + ".", ex);
        }
    }

    private static void extractExternalFunctionCallReturnStatistics(ExternalFunctionStatement fstmt, FunctionOp fop, LocalVariableMap callVars) throws HopsException {
        String className = fstmt.getOtherParams().get("classname");
        if (className.equals(OrderWrapper.class.getName())) {
            Hop input = fop.getInput().get(0);
            long lnnz = className.equals(OrderWrapper.class.getName()) ? input.getNnz() : -1L;
            MatrixObject moOut = InterProceduralAnalysis.createOutputMatrix(input.getDim1(), input.getDim2(), lnnz);
            callVars.put(fop.getOutputVariableNames()[0], moOut);
        } else if (className.equals(DynamicReadMatrixCP.class.getName()) || className.equals(DynamicReadMatrixRcCP.class.getName())) {
            Hop input1 = fop.getInput().get(1);
            Hop input2 = fop.getInput().get(2);
            if (input1 instanceof LiteralOp && input2 instanceof LiteralOp) {
                callVars.put(fop.getOutputVariableNames()[0], InterProceduralAnalysis.createOutputMatrix(((LiteralOp)input1).getLongValue(), ((LiteralOp)input2).getLongValue(), -1L));
            }
        } else {
            InterProceduralAnalysis.extractFunctionCallUnknownReturnStatistics(fstmt, fop, callVars);
        }
    }

    private static MatrixObject createOutputMatrix(long dim1, long dim2, long nnz) {
        MatrixObject moOut = new MatrixObject(Expression.ValueType.DOUBLE, null);
        MatrixCharacteristics mc = new MatrixCharacteristics(dim1, dim2, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), nnz);
        MetaDataFormat meta = new MetaDataFormat(mc, null, null);
        moOut.setMetaData(meta);
        return moOut;
    }
}

