/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Group;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.RightIndex;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class IndexingOp
extends Hop {
    public static String OPSTRING = "rix";
    private boolean _rowLowerEqualsUpper = false;
    private boolean _colLowerEqualsUpper = false;

    private IndexingOp() {
    }

    public IndexingOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop inpMatrix, Hop inpRowL, Hop inpRowU, Hop inpColL, Hop inpColU, boolean passedRowsLEU, boolean passedColsLEU) {
        super(l, dt, vt);
        this.getInput().add(0, inpMatrix);
        this.getInput().add(1, inpRowL);
        this.getInput().add(2, inpRowU);
        this.getInput().add(3, inpColL);
        this.getInput().add(4, inpColU);
        inpMatrix.getParent().add(this);
        inpRowL.getParent().add(this);
        inpRowU.getParent().add(this);
        inpColL.getParent().add(this);
        inpColU.getParent().add(this);
        this.setRowLowerEqualsUpper(passedRowsLEU);
        this.setColLowerEqualsUpper(passedColsLEU);
    }

    @Override
    public void checkArity() throws HopsException {
        HopsException.check(this._input.size() == 5, this, "should have 5 inputs but has %d inputs", this._input.size());
    }

    public boolean isRowLowerEqualsUpper() {
        return this._rowLowerEqualsUpper;
    }

    public boolean isColLowerEqualsUpper() {
        return this._colLowerEqualsUpper;
    }

    public void setRowLowerEqualsUpper(boolean passed) {
        this._rowLowerEqualsUpper = passed;
    }

    public void setColLowerEqualsUpper(boolean passed) {
        this._colLowerEqualsUpper = passed;
    }

    @Override
    public boolean isGPUEnabled() {
        if (!DMLScript.USE_ACCELERATOR) {
            return false;
        }
        return this.getDataType() == Expression.DataType.MATRIX && this.getInputMemEstimate() < 2.0E9;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        Hop input = this.getInput().get(0);
        if (HopRewriteUtils.isUnnecessaryRightIndexing(this)) {
            this.setLops(input.constructLops());
        } else {
            try {
                LopProperties.ExecType et = this.optFindExecType();
                if (et == LopProperties.ExecType.MR) {
                    IndexingMethod method = IndexingOp.optFindIndexingMethod(this._rowLowerEqualsUpper, this._colLowerEqualsUpper, input._dim1, input._dim2, this._dim1, this._dim2);
                    Data dummy = Data.createLiteralLop(Expression.ValueType.INT, Integer.toString(-1));
                    RightIndex reindex = new RightIndex(input.constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getInput().get(4).constructLops(), dummy, dummy, this.getDataType(), this.getValueType(), et);
                    this.setOutputDimensions(reindex);
                    this.setLineNumbers(reindex);
                    if (method == IndexingMethod.MR_RIX) {
                        Group group1 = new Group(reindex, Group.OperationTypes.Sort, Expression.DataType.MATRIX, this.getValueType());
                        this.setOutputDimensions(group1);
                        this.setLineNumbers(group1);
                        Aggregate agg1 = new Aggregate(group1, Aggregate.OperationTypes.Sum, Expression.DataType.MATRIX, this.getValueType(), et);
                        this.setOutputDimensions(agg1);
                        this.setLineNumbers(agg1);
                        this.setLops(agg1);
                    } else {
                        this.setLops(reindex);
                    }
                } else if (et == LopProperties.ExecType.SPARK) {
                    IndexingMethod method = IndexingOp.optFindIndexingMethod(this._rowLowerEqualsUpper, this._colLowerEqualsUpper, input._dim1, input._dim2, this._dim1, this._dim2);
                    AggBinaryOp.SparkAggType aggtype = method == IndexingMethod.MR_VRIX || this.isBlockAligned() ? AggBinaryOp.SparkAggType.NONE : AggBinaryOp.SparkAggType.MULTI_BLOCK;
                    Data dummy = Data.createLiteralLop(Expression.ValueType.INT, Integer.toString(-1));
                    RightIndex reindex = new RightIndex(input.constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getInput().get(4).constructLops(), (Lop)dummy, (Lop)dummy, this.getDataType(), this.getValueType(), aggtype, et);
                    this.setOutputDimensions(reindex);
                    this.setLineNumbers(reindex);
                    this.setLops(reindex);
                } else {
                    Data dummy = Data.createLiteralLop(Expression.ValueType.INT, Integer.toString(-1));
                    RightIndex reindex = new RightIndex(input.constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getInput().get(4).constructLops(), dummy, dummy, this.getDataType(), this.getValueType(), et);
                    this.setOutputDimensions(reindex);
                    this.setLineNumbers(reindex);
                    this.setLops(reindex);
                }
            }
            catch (Exception e) {
                throw new HopsException(this.printErrorLocation() + "In IndexingOp Hop, error constructing Lops ", e);
            }
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + OPSTRING;
        return s;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    @Override
    public void computeMemEstimate(MemoTable memo) {
        long lnnz;
        double lOutMemEst;
        super.computeMemEstimate(memo);
        MatrixCharacteristics mcM1 = memo.getAllInputStats(this.getInput().get(0));
        if (this.dimsKnown() && mcM1.getNonZeros() >= 0L && (lOutMemEst = this.computeOutputMemEstimate(this._dim1, this._dim2, lnnz = mcM1.getNonZeros())) < this._outputMemEstimate) {
            this._outputMemEstimate = lOutMemEst;
            this._memEstimate = this.getInputOutputSize();
        }
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double sparsity = this.isGPUEnabled() ? 1.0 : OptimizerUtils.getSparsity(dim1, dim2, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        Hop input = this.getInput().get(0);
        MatrixCharacteristics mc = memo.getAllInputStats(input);
        if (mc != null) {
            long lnnz = mc.dimsKnown() ? Math.min(mc.getRows() * mc.getCols(), mc.getNonZeros()) : -1L;
            ret = new long[]{mc.getRows(), mc.getCols(), lnnz};
            if (this._rowLowerEqualsUpper) {
                ret[0] = 1L;
            }
            if (this._colLowerEqualsUpper) {
                ret[1] = 1L;
            }
            Hop rl = this.getInput().get(1);
            Hop ru = this.getInput().get(2);
            Hop cl = this.getInput().get(3);
            Hop cu = this.getInput().get(4);
            if (IndexingOp.isBlockIndexingExpression(rl, ru)) {
                ret[0] = IndexingOp.getBlockIndexingExpressionSize(rl, ru);
            }
            if (IndexingOp.isBlockIndexingExpression(cl, cu)) {
                ret[1] = IndexingOp.getBlockIndexingExpressionSize(cl, cu);
            }
        }
        return ret;
    }

    private static boolean isBlockIndexingExpression(Hop lbound, Hop ubound) {
        BinaryOp lminus;
        BinaryOp lmult;
        boolean ret = false;
        LiteralOp constant = null;
        Hop var = null;
        if (lbound instanceof BinaryOp && ((BinaryOp)lbound).getOp() == Hop.OpOp2.PLUS && lbound.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)lbound.getInput().get(1)) == 1.0 && lbound.getInput().get(0) instanceof BinaryOp && (lmult = (BinaryOp)lbound.getInput().get(0)).getOp() == Hop.OpOp2.MULT && lmult.getInput().get(0) instanceof LiteralOp && lmult.getInput().get(1) instanceof BinaryOp && (lminus = (BinaryOp)lmult.getInput().get(1)).getOp() == Hop.OpOp2.MINUS && lminus.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)lminus.getInput().get(1)) == 1.0 && lminus.getInput().get(0) instanceof DataOp) {
            constant = (LiteralOp)lmult.getInput().get(0);
            var = (DataOp)lminus.getInput().get(0);
        }
        if (var != null && constant != null && ubound instanceof BinaryOp && ubound.getInput().get(0) instanceof LiteralOp && ubound.getInput().get(1) instanceof DataOp && ubound.getInput().get(1).getName().equals(var.getName())) {
            LiteralOp constant2 = (LiteralOp)ubound.getInput().get(0);
            ret = HopRewriteUtils.getDoubleValueSafe(constant) == HopRewriteUtils.getDoubleValueSafe(constant2);
        }
        return ret;
    }

    private boolean isBlockAligned() {
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        Hop input3 = this.getInput().get(2);
        Hop input4 = this.getInput().get(3);
        Hop input5 = this.getInput().get(4);
        long rl = input2 instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)input2) : -1L;
        long ru = input3 instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)input3) : -1L;
        long cl = input4 instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)input4) : -1L;
        long cu = input5 instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)input5) : -1L;
        int brlen = (int)input1.getRowsInBlock();
        int bclen = (int)input1.getColsInBlock();
        return OptimizerUtils.isIndexingRangeBlockAligned(rl, ru, cl, cu, brlen, bclen);
    }

    private static long getBlockIndexingExpressionSize(Hop lbound, Hop ubound) {
        LiteralOp c = (LiteralOp)ubound.getInput().get(0);
        return HopRewriteUtils.getIntValueSafe(c);
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.getInput().get(0).areDimsBelowThreshold() ? LopProperties.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        this.setRequiresRecompileIfNecessary();
        return this._etype;
    }

    private static IndexingMethod optFindIndexingMethod(boolean singleRow, boolean singleCol, long m1_dim1, long m1_dim2, long m2_dim1, long m2_dim2) {
        if (singleRow && m1_dim2 == m2_dim2 && m2_dim2 != -1L || singleCol && m1_dim1 == m2_dim1 && m2_dim1 != -1L) {
            return IndexingMethod.MR_VRIX;
        }
        return IndexingMethod.MR_RIX;
    }

    @Override
    public void refreshSizeInformation() {
        boolean constColRange;
        Hop input2 = this.getInput().get(1);
        Hop input3 = this.getInput().get(2);
        Hop input4 = this.getInput().get(3);
        Hop input5 = this.getInput().get(4);
        this._rowLowerEqualsUpper = input2 == input3;
        this._colLowerEqualsUpper = input4 == input5;
        boolean allRows = input2 instanceof LiteralOp && HopRewriteUtils.getIntValueSafe((LiteralOp)input2) == 1L && input3 instanceof UnaryOp && ((UnaryOp)input3).getOp() == Hop.OpOp1.NROW;
        boolean allCols = input4 instanceof LiteralOp && HopRewriteUtils.getIntValueSafe((LiteralOp)input4) == 1L && input5 instanceof UnaryOp && ((UnaryOp)input5).getOp() == Hop.OpOp1.NCOL;
        boolean constRowRange = input2 instanceof LiteralOp && input3 instanceof LiteralOp;
        boolean bl = constColRange = input4 instanceof LiteralOp && input5 instanceof LiteralOp;
        if (this._rowLowerEqualsUpper) {
            this.setDim1(1L);
        } else if (allRows) {
            this.setDim1(input3.getInput().get(0).getDim1());
        } else if (constRowRange) {
            this.setDim1(HopRewriteUtils.getIntValueSafe((LiteralOp)input3) - HopRewriteUtils.getIntValueSafe((LiteralOp)input2) + 1L);
        } else if (IndexingOp.isBlockIndexingExpression(input2, input3)) {
            this.setDim1(IndexingOp.getBlockIndexingExpressionSize(input2, input3));
        }
        if (this._colLowerEqualsUpper) {
            this.setDim2(1L);
        } else if (allCols) {
            this.setDim2(input5.getInput().get(0).getDim2());
        } else if (constColRange) {
            this.setDim2(HopRewriteUtils.getIntValueSafe((LiteralOp)input5) - HopRewriteUtils.getIntValueSafe((LiteralOp)input4) + 1L);
        } else if (IndexingOp.isBlockIndexingExpression(input4, input5)) {
            this.setDim2(IndexingOp.getBlockIndexingExpressionSize(input4, input5));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        IndexingOp ret = new IndexingOp();
        ret.clone(this, false);
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof IndexingOp) || this.getInput().size() != that.getInput().size()) {
            return false;
        }
        return this.getInput().get(0) == that.getInput().get(0) && this.getInput().get(1) == that.getInput().get(1) && this.getInput().get(2) == that.getInput().get(2) && this.getInput().get(3) == that.getInput().get(3) && this.getInput().get(4) == that.getInput().get(4);
    }

    private static enum IndexingMethod {
        CP_RIX,
        MR_RIX,
        MR_VRIX;

    }
}

