/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.algorithms.bivar_stats.Bivar_cc_output;
import org.apache.sysml.scripts.algorithms.bivar_stats.Bivar_sc_output;
import org.apache.sysml.scripts.algorithms.bivar_stats.Bivar_ss_output;

public class Bivar_stats
extends Script {
    public Bivar_stats() {
        String string = "scripts/algorithms/bivar-stats.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Bivar_cc_output bivar_cc(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/bivar-stats.dml') as mlcontextns;[chisq, df, pval, cramersv] = mlcontextns::bivar_cc(A, B, maxDomain);";
        Script script = new Script(string);
        script.in("A", object).in("B", object2).in("maxDomain", object3).out("chisq").out("df").out("pval").out("cramersv");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("chisq");
        double d2 = mLResults.getDouble("df");
        double d3 = mLResults.getDouble("pval");
        double d4 = mLResults.getDouble("cramersv");
        Bivar_cc_output bivar_cc_output = new Bivar_cc_output(d, d2, d3, d4);
        return bivar_cc_output;
    }

    public String bivar_cc__docs() {
        String string = "bivar_cc = function(Matrix[Double] A, Matrix[Double] B, Double maxDomain) return (Double chisq, Double df, Double pval, Double cramersv) {\n\n    # Contingency Table\n    F = table(A, B, maxDomain, maxDomain);\n    F = F[1:max(A), 1:max(B)];\n\n    # Chi-Squared\n    W = sum(F);\n    r = rowSums(F);\n    c = colSums(F);\n    E = (r %*% c)/W;\n    T = (F-E)^2/E;\n    chi_squared = sum(T);\n\n    # compute p-value\n    degFreedom = (nrow(F)-1)*(ncol(F)-1);\n    pValue = pchisq(target=chi_squared, df=degFreedom, lower.tail=FALSE);\n\n    # Cramer's V\n    R = nrow(F);\n    C = ncol(F);\n    q = min(R,C);\n    cramers_v = sqrt(chi_squared/(W*(q-1)));\n\n    # Assign return values\n    chisq = chi_squared;\n    df = as.double(degFreedom);\n    pval = pValue;\n    cramersv = cramers_v;\n}\n";
        return string;
    }

    public String bivar_cc__source() {
        String string = "bivar_cc = function(Matrix[Double] A, Matrix[Double] B, Double maxDomain) return (Double chisq, Double df, Double pval, Double cramersv) {\n\n    # Contingency Table\n    F = table(A, B, maxDomain, maxDomain);\n    F = F[1:max(A), 1:max(B)];\n\n    # Chi-Squared\n    W = sum(F);\n    r = rowSums(F);\n    c = colSums(F);\n    E = (r %*% c)/W;\n    T = (F-E)^2/E;\n    chi_squared = sum(T);\n\n    # compute p-value\n    degFreedom = (nrow(F)-1)*(ncol(F)-1);\n    pValue = pchisq(target=chi_squared, df=degFreedom, lower.tail=FALSE);\n\n    # Cramer's V\n    R = nrow(F);\n    C = ncol(F);\n    q = min(R,C);\n    cramers_v = sqrt(chi_squared/(W*(q-1)));\n\n    # Assign return values\n    chisq = chi_squared;\n    df = as.double(degFreedom);\n    pval = pValue;\n    cramersv = cramers_v;\n}\n";
        return string;
    }

    public Bivar_ss_output bivar_ss(Object object, Object object2) {
        String string = "source('scripts/algorithms/bivar-stats.dml') as mlcontextns;[R, covXY, sigmaX, sigmaY] = mlcontextns::bivar_ss(X, Y);";
        Script script = new Script(string);
        script.in("X", object).in("Y", object2).out("R").out("covXY").out("sigmaX").out("sigmaY");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("R");
        double d2 = mLResults.getDouble("covXY");
        double d3 = mLResults.getDouble("sigmaX");
        double d4 = mLResults.getDouble("sigmaY");
        Bivar_ss_output bivar_ss_output = new Bivar_ss_output(d, d2, d3, d4);
        return bivar_ss_output;
    }

    public String bivar_ss__docs() {
        String string = "bivar_ss = function(Matrix[Double] X, Matrix[Double] Y) return (Double R, Double covXY, Double sigmaX, Double sigmaY) {\n\n    # Unweighted co-variance\n    covXY = cov(X,Y);\n\n    # compute standard deviations for both X and Y by computing 2^nd central moment\n    W = nrow(X);\n    m2X = moment(X,2);\n    m2Y = moment(Y,2);\n    sigmaX = sqrt(m2X * (W/(W-1.0)) );\n    sigmaY = sqrt(m2Y * (W/(W-1.0)) );\n\n    # Pearson's R\n    R = covXY / (sigmaX*sigmaY);\n}\n";
        return string;
    }

    public String bivar_ss__source() {
        String string = "bivar_ss = function(Matrix[Double] X, Matrix[Double] Y) return (Double R, Double covXY, Double sigmaX, Double sigmaY) {\n\n    # Unweighted co-variance\n    covXY = cov(X,Y);\n\n    # compute standard deviations for both X and Y by computing 2^nd central moment\n    W = nrow(X);\n    m2X = moment(X,2);\n    m2Y = moment(Y,2);\n    sigmaX = sqrt(m2X * (W/(W-1.0)) );\n    sigmaY = sqrt(m2Y * (W/(W-1.0)) );\n\n    # Pearson's R\n    R = covXY / (sigmaX*sigmaY);\n}\n";
        return string;
    }

    public Bivar_sc_output bivar_sc(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/bivar-stats.dml') as mlcontextns;[Eta, AnovaF, pval, bw_ss, within_ss, bw_df, within_df, bw_mean_square, within_mean_square] = mlcontextns::bivar_sc(Y, A, maxDomain);";
        Script script = new Script(string);
        script.in("Y", object).in("A", object2).in("maxDomain", object3).out("Eta").out("AnovaF").out("pval").out("bw_ss").out("within_ss").out("bw_df").out("within_df").out("bw_mean_square").out("within_mean_square");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("Eta");
        double d2 = mLResults.getDouble("AnovaF");
        double d3 = mLResults.getDouble("pval");
        double d4 = mLResults.getDouble("bw_ss");
        double d5 = mLResults.getDouble("within_ss");
        double d6 = mLResults.getDouble("bw_df");
        double d7 = mLResults.getDouble("within_df");
        double d8 = mLResults.getDouble("bw_mean_square");
        double d9 = mLResults.getDouble("within_mean_square");
        Bivar_sc_output bivar_sc_output = new Bivar_sc_output(d, d2, d3, d4, d5, d6, d7, d8, d9);
        return bivar_sc_output;
    }

    public String bivar_sc__docs() {
        String string = "bivar_sc = function(Matrix[Double] Y, Matrix[Double] A, Double maxDomain) \n\t\t   return (Double Eta, Double AnovaF, Double pval, Double bw_ss, Double within_ss, Double bw_df, Double within_df, Double bw_mean_square, Double within_mean_square) {\n\n    # mean and variance in target variable\n    W = nrow(A);\n    my = mean(Y);\n    varY = moment(Y,2) * W/(W-1.0)\n\n    # category-wise (frequencies, means, variances)\n    CFreqs = aggregate(target=Y, groups=A, fn=\"count\", ngroups=maxDomain); \n    CMeans = aggregate(target=Y, groups=A, fn=\"mean\", ngroups=maxDomain);\n    CVars =  aggregate(target=Y, groups=A, fn=\"variance\", ngroups=maxDomain);\n    \n    # number of categories\n    R = nrow(CFreqs);\n\n    Eta = sqrt(1 - ( sum((CFreqs-1)*CVars) / ((W-1)*varY) ));\n\n    bw_ss = sum( (CFreqs*(CMeans-my)^2) );\n    bw_df = as.double(R-1);\n    bw_mean_square = bw_ss/bw_df;\n\t\n    within_ss = sum( (CFreqs-1)*CVars );\n    within_df = as.double(W-R);\n    within_mean_square = within_ss/within_df;\n\t\n    AnovaF = bw_mean_square/within_mean_square;\n    \n    pval = pf(target=AnovaF, df1=bw_df, df2=within_df, lower.tail=FALSE)\n}\n";
        return string;
    }

    public String bivar_sc__source() {
        String string = "bivar_sc = function(Matrix[Double] Y, Matrix[Double] A, Double maxDomain) \n\t\t   return (Double Eta, Double AnovaF, Double pval, Double bw_ss, Double within_ss, Double bw_df, Double within_df, Double bw_mean_square, Double within_mean_square) {\n\n    # mean and variance in target variable\n    W = nrow(A);\n    my = mean(Y);\n    varY = moment(Y,2) * W/(W-1.0)\n\n    # category-wise (frequencies, means, variances)\n    CFreqs = aggregate(target=Y, groups=A, fn=\"count\", ngroups=maxDomain); \n    CMeans = aggregate(target=Y, groups=A, fn=\"mean\", ngroups=maxDomain);\n    CVars =  aggregate(target=Y, groups=A, fn=\"variance\", ngroups=maxDomain);\n    \n    # number of categories\n    R = nrow(CFreqs);\n\n    Eta = sqrt(1 - ( sum((CFreqs-1)*CVars) / ((W-1)*varY) ));\n\n    bw_ss = sum( (CFreqs*(CMeans-my)^2) );\n    bw_df = as.double(R-1);\n    bw_mean_square = bw_ss/bw_df;\n\t\n    within_ss = sum( (CFreqs-1)*CVars );\n    within_df = as.double(W-R);\n    within_mean_square = within_ss/within_df;\n\t\n    AnovaF = bw_mean_square/within_mean_square;\n    \n    pval = pf(target=AnovaF, df1=bw_df, df2=within_df, lower.tail=FALSE)\n}\n";
        return string;
    }

    public double bivar_oo(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/bivar-stats.dml') as mlcontextns;sp = mlcontextns::bivar_oo(A, B, maxDomain);";
        Script script = new Script(string);
        script.in("A", object).in("B", object2).in("maxDomain", object3).out("sp");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("sp");
        return d;
    }

    public String bivar_oo__docs() {
        String string = "bivar_oo = function(Matrix[Double] A, Matrix[Double] B, Double maxDomain) return (Double sp) {\n\n    # compute contingency table\n    F = table(A, B, maxDomain, maxDomain);\n    F = F[1:max(A), 1:max(B)];\n    \n    catA = nrow(F);  # number of categories in A\n    catB = ncol(F);  # number of categories in B\n\n    # compute category-wise counts for both the attributes\n    R = rowSums(F);\n    S = colSums(F);\n\n    # compute scores, both are column vectors\n    [C] = computeRanks(R);\n    meanX = mean(C,R); \n\n    columnS = t(S);\n    [D] = computeRanks(columnS);\n\n    # scores (C,D) are individual values, and counts (R,S) act as weights\n    meanY = mean(D,columnS);\n\n    W = sum(F); # total weight, or total #cases\n    varX = moment(C,R,2)*(W/(W-1.0));\n    varY = moment(D,columnS,2)*(W/(W-1.0));\n    covXY = sum( t(F/(W-1) * (C-meanX)) * (D-meanY) );\n\n    sp = covXY/(sqrt(varX)*sqrt(varY));\n}\n";
        return string;
    }

    public String bivar_oo__source() {
        String string = "bivar_oo = function(Matrix[Double] A, Matrix[Double] B, Double maxDomain) return (Double sp) {\n\n    # compute contingency table\n    F = table(A, B, maxDomain, maxDomain);\n    F = F[1:max(A), 1:max(B)];\n    \n    catA = nrow(F);  # number of categories in A\n    catB = ncol(F);  # number of categories in B\n\n    # compute category-wise counts for both the attributes\n    R = rowSums(F);\n    S = colSums(F);\n\n    # compute scores, both are column vectors\n    [C] = computeRanks(R);\n    meanX = mean(C,R); \n\n    columnS = t(S);\n    [D] = computeRanks(columnS);\n\n    # scores (C,D) are individual values, and counts (R,S) act as weights\n    meanY = mean(D,columnS);\n\n    W = sum(F); # total weight, or total #cases\n    varX = moment(C,R,2)*(W/(W-1.0));\n    varY = moment(D,columnS,2)*(W/(W-1.0));\n    covXY = sum( t(F/(W-1) * (C-meanX)) * (D-meanY) );\n\n    sp = covXY/(sqrt(varX)*sqrt(varY));\n}\n";
        return string;
    }

    public Matrix computeRanks(Object object) {
        String string = "source('scripts/algorithms/bivar-stats.dml') as mlcontextns;Ranks = mlcontextns::computeRanks(X);";
        Script script = new Script(string);
        script.in("X", object).out("Ranks");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("Ranks");
        return matrix;
    }

    public String computeRanks__docs() {
        String string = "computeRanks = function(Matrix[Double] X) return (Matrix[Double] Ranks) {\n    Ranks = cumsum(X) - X/2 + 1/2;\n}\n";
        return string;
    }

    public String computeRanks__source() {
        String string = "computeRanks = function(Matrix[Double] X) return (Matrix[Double] Ranks) {\n    Ranks = cumsum(X) - X/2 + 1/2;\n}\n";
        return string;
    }
}

