/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixWriter;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.MapReduceTool;

public class WriterBinaryBlock
extends MatrixWriter {
    protected int _replication = -1;

    public WriterBinaryBlock(int replication) {
        this._replication = replication;
    }

    @Override
    public final void writeMatrixToHDFS(MatrixBlock src, String fname, long rlen, long clen, int brlen, int bclen, long nnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        MapReduceTool.deleteFileIfExistOnHDFS(fname);
        MRJobConfiguration.addBinaryBlockSerializationFramework((Configuration)job);
        if (src.isDiag()) {
            this.writeDiagBinaryBlockMatrixToHDFS(path, job, fs, src, rlen, clen, brlen, bclen);
        } else {
            this.writeBinaryBlockMatrixToHDFS(path, job, fs, src, rlen, clen, brlen, bclen);
        }
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeEmptyMatrixToHDFS(String fname, long rlen, long clen, int brlen, int bclen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        SequenceFile.Writer writer = null;
        try {
            writer = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
            MatrixIndexes index = new MatrixIndexes(1L, 1L);
            MatrixBlock block = new MatrixBlock((int)Math.max(Math.min(rlen, (long)brlen), 1L), (int)Math.max(Math.min(clen, (long)bclen), 1L), true);
            writer.append((Writable)index, (Writable)block);
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(writer);
            throw throwable;
        }
        IOUtilFunctions.closeSilently((Closeable)writer);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeBinaryBlockMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, long rlen, long clen, int brlen, int bclen) throws IOException, DMLRuntimeException {
        this.writeBinaryBlockMatrixToSequenceFile(path, job, fs, src, brlen, bclen, 0, (int)rlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeBinaryBlockMatrixToSequenceFile(Path path, JobConf job, FileSystem fs, MatrixBlock src, int brlen, int bclen, int rl, int ru) throws DMLRuntimeException, IOException {
        boolean sparse = src.isInSparseFormat();
        int rlen = src.getNumRows();
        int clen = src.getNumColumns();
        SequenceFile.Writer writer = null;
        writer = this._replication > 0 ? new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class, job.getInt("io.file.buffer.size", 4096), (short)this._replication, fs.getDefaultBlockSize(), null, new SequenceFile.Metadata()) : new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
        try {
            if (src.getNumRows() > rlen || src.getNumColumns() > clen) {
                throw new IOException("Matrix block [1:" + src.getNumRows() + ",1:" + src.getNumColumns() + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            MatrixIndexes indexes = new MatrixIndexes();
            if (rlen <= brlen && clen <= bclen && rl == 0) {
                indexes.setIndexes(1L, 1L);
                writer.append((Writable)indexes, (Writable)src);
            } else {
                MatrixBlock[] blocks = WriterBinaryBlock.createMatrixBlocksForReuse(rlen, clen, brlen, bclen, sparse, src.getNonZeros());
                for (int blockRow = rl / brlen; blockRow < (int)Math.ceil((double)ru / (double)brlen); ++blockRow) {
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)src.getNumColumns() / (double)bclen); ++blockCol) {
                        int maxRow = blockRow * brlen + brlen < src.getNumRows() ? brlen : src.getNumRows() - blockRow * brlen;
                        int maxCol = blockCol * bclen + bclen < src.getNumColumns() ? bclen : src.getNumColumns() - blockCol * bclen;
                        int row_offset = blockRow * brlen;
                        int col_offset = blockCol * bclen;
                        MatrixBlock block = WriterBinaryBlock.getMatrixBlockForReuse(blocks, maxRow, maxCol, brlen, bclen);
                        src.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                        indexes.setIndexes(blockRow + 1, blockCol + 1);
                        writer.append((Writable)indexes, (Writable)block);
                        block.reset();
                    }
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeDiagBinaryBlockMatrixToHDFS(Path path, JobConf job, FileSystem fs, MatrixBlock src, long rlen, long clen, int brlen, int bclen) throws IOException, DMLRuntimeException {
        boolean sparse = src.isInSparseFormat();
        SequenceFile.Writer writer = null;
        writer = this._replication > 0 ? new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class, job.getInt("io.file.buffer.size", 4096), (short)this._replication, fs.getDefaultBlockSize(), null, new SequenceFile.Metadata()) : new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
        try {
            if ((long)src.getNumRows() > rlen || (long)src.getNumColumns() > clen) {
                throw new IOException("Matrix block [1:" + src.getNumRows() + ",1:" + src.getNumColumns() + "] out of overall matrix range [1:" + rlen + ",1:" + clen + "].");
            }
            MatrixIndexes indexes = new MatrixIndexes();
            if (rlen <= (long)brlen && clen <= (long)bclen) {
                indexes.setIndexes(1L, 1L);
                writer.append((Writable)indexes, (Writable)src);
            } else {
                MatrixBlock[] blocks = WriterBinaryBlock.createMatrixBlocksForReuse(rlen, clen, brlen, bclen, sparse, src.getNonZeros());
                MatrixBlock emptyBlock = new MatrixBlock();
                for (int blockRow = 0; blockRow < (int)Math.ceil((double)src.getNumRows() / (double)brlen); ++blockRow) {
                    for (int blockCol = 0; blockCol < (int)Math.ceil((double)src.getNumColumns() / (double)bclen); ++blockCol) {
                        int maxRow = blockRow * brlen + brlen < src.getNumRows() ? brlen : src.getNumRows() - blockRow * brlen;
                        int maxCol = blockCol * bclen + bclen < src.getNumColumns() ? bclen : src.getNumColumns() - blockCol * bclen;
                        MatrixBlock block = null;
                        if (blockRow == blockCol) {
                            int row_offset = blockRow * brlen;
                            int col_offset = blockCol * bclen;
                            block = WriterBinaryBlock.getMatrixBlockForReuse(blocks, maxRow, maxCol, brlen, bclen);
                            src.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                        } else {
                            block = emptyBlock;
                            block.reset(maxRow, maxCol);
                        }
                        indexes.setIndexes(blockRow + 1, blockCol + 1);
                        writer.append((Writable)indexes, (Writable)block);
                        if (blockRow == blockCol) continue;
                        block.reset();
                    }
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writePartitionedBinaryBlockMatrixToHDFS(Path path, JobConf job, MatrixBlock src, long rlen, long clen, int brlen, int bclen, ParForProgramBlock.PDataPartitionFormat pformat) throws IOException, DMLRuntimeException {
        boolean sparse = src.isInSparseFormat();
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        MRJobConfiguration.addBinaryBlockSerializationFramework((Configuration)job);
        MatrixBlock[] blocks = WriterBinaryBlock.createMatrixBlocksForReuse(rlen, clen, brlen, bclen, sparse, src.getNonZeros());
        switch (pformat) {
            case ROW_BLOCK_WISE_N: {
                long numBlocks = Math.max((rlen - 1L) / (long)brlen + 1L, 1L);
                long numPartBlocks = (long)Math.ceil(4000000.0 / (double)clen / (double)brlen);
                int count = 0;
                int k = 0;
                while ((long)k < numBlocks) {
                    Path path2 = new Path(path.toString() + File.separator + ++count);
                    SequenceFile.Writer writer = new SequenceFile.Writer(fs, (Configuration)job, path2, MatrixIndexes.class, MatrixBlock.class);
                    try {
                        MatrixIndexes indexes = new MatrixIndexes();
                        int blockRow = k;
                        while ((long)blockRow < Math.min((long)((int)Math.ceil((double)src.getNumRows() / (double)brlen)), (long)k + numPartBlocks)) {
                            for (int blockCol = 0; blockCol < (int)Math.ceil((double)src.getNumColumns() / (double)bclen); ++blockCol) {
                                int maxRow = blockRow * brlen + brlen < src.getNumRows() ? brlen : src.getNumRows() - blockRow * brlen;
                                int maxCol = blockCol * bclen + bclen < src.getNumColumns() ? bclen : src.getNumColumns() - blockCol * bclen;
                                int row_offset = blockRow * brlen;
                                int col_offset = blockCol * bclen;
                                MatrixBlock block = WriterBinaryBlock.getMatrixBlockForReuse(blocks, maxRow, maxCol, brlen, bclen);
                                src.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                                indexes.setIndexes(blockRow + 1, blockCol + 1);
                                writer.append((Writable)indexes, (Writable)block);
                                block.reset();
                            }
                            ++blockRow;
                        }
                    }
                    finally {
                        IOUtilFunctions.closeSilently((Closeable)writer);
                    }
                    k = (int)((long)k + numPartBlocks);
                }
                break;
            }
            case COLUMN_BLOCK_WISE_N: {
                long numBlocks = Math.max((clen - 1L) / (long)bclen + 1L, 1L);
                long numPartBlocks = (long)Math.ceil(4000000.0 / (double)rlen / (double)bclen);
                int count = 0;
                int k = 0;
                while ((long)k < numBlocks) {
                    Path path2 = new Path(path.toString() + File.separator + ++count);
                    SequenceFile.Writer writer = new SequenceFile.Writer(fs, (Configuration)job, path2, MatrixIndexes.class, MatrixBlock.class);
                    try {
                        MatrixIndexes indexes = new MatrixIndexes();
                        for (int blockRow = 0; blockRow < (int)Math.ceil((double)src.getNumRows() / (double)brlen); ++blockRow) {
                            int blockCol = k;
                            while ((long)blockCol < Math.min((long)((int)Math.ceil((double)src.getNumColumns() / (double)bclen)), (long)k + numPartBlocks)) {
                                int maxRow = blockRow * brlen + brlen < src.getNumRows() ? brlen : src.getNumRows() - blockRow * brlen;
                                int maxCol = blockCol * bclen + bclen < src.getNumColumns() ? bclen : src.getNumColumns() - blockCol * bclen;
                                int row_offset = blockRow * brlen;
                                int col_offset = blockCol * bclen;
                                MatrixBlock block = WriterBinaryBlock.getMatrixBlockForReuse(blocks, maxRow, maxCol, brlen, bclen);
                                src.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
                                indexes.setIndexes(blockRow + 1, blockCol + 1);
                                writer.append((Writable)indexes, (Writable)block);
                                block.reset();
                                ++blockCol;
                            }
                        }
                    }
                    finally {
                        IOUtilFunctions.closeSilently((Closeable)writer);
                    }
                    k = (int)((long)k + numPartBlocks);
                }
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported partition format for distributed cache input: " + (Object)((Object)pformat));
            }
        }
    }
}

