/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.MatrixWriter;
import org.apache.sysml.runtime.io.WriterBinaryBlock;
import org.apache.sysml.runtime.io.WriterBinaryBlockParallel;
import org.apache.sysml.runtime.io.WriterBinaryCell;
import org.apache.sysml.runtime.io.WriterMatrixMarket;
import org.apache.sysml.runtime.io.WriterTextCSV;
import org.apache.sysml.runtime.io.WriterTextCSVParallel;
import org.apache.sysml.runtime.io.WriterTextCell;
import org.apache.sysml.runtime.io.WriterTextCellParallel;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.FileFormatProperties;
import org.apache.sysml.runtime.matrix.data.OutputInfo;

public class MatrixWriterFactory {
    public static MatrixWriter createMatrixWriter(OutputInfo oinfo) throws DMLRuntimeException {
        return MatrixWriterFactory.createMatrixWriter(oinfo, -1, null);
    }

    public static MatrixWriter createMatrixWriter(OutputInfo oinfo, int replication, FileFormatProperties props) throws DMLRuntimeException {
        MatrixWriter writer = null;
        if (oinfo == OutputInfo.TextCellOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new WriterTextCellParallel() : new WriterTextCell();
        } else if (oinfo == OutputInfo.MatrixMarketOutputInfo) {
            writer = new WriterMatrixMarket();
        } else if (oinfo == OutputInfo.CSVOutputInfo) {
            if (props != null && !(props instanceof CSVFileFormatProperties)) {
                throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
            }
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS) ? new WriterTextCSVParallel((CSVFileFormatProperties)props) : new WriterTextCSV((CSVFileFormatProperties)props);
        } else if (oinfo == OutputInfo.BinaryCellOutputInfo) {
            writer = new WriterBinaryCell();
        } else if (oinfo == OutputInfo.BinaryBlockOutputInfo) {
            writer = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS) ? new WriterBinaryBlockParallel(replication) : new WriterBinaryBlock(replication);
        } else {
            throw new DMLRuntimeException("Failed to create matrix writer for unknown output info: " + OutputInfo.outputInfoToString(oinfo));
        }
        return writer;
    }
}

