/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.FrameReader;
import org.apache.sysml.runtime.io.FrameReaderBinaryBlock;
import org.apache.sysml.runtime.io.FrameReaderBinaryBlockParallel;
import org.apache.sysml.runtime.io.FrameReaderTextCSV;
import org.apache.sysml.runtime.io.FrameReaderTextCSVParallel;
import org.apache.sysml.runtime.io.FrameReaderTextCell;
import org.apache.sysml.runtime.io.FrameReaderTextCellParallel;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.FileFormatProperties;
import org.apache.sysml.runtime.matrix.data.InputInfo;

public class FrameReaderFactory {
    public static FrameReader createFrameReader(InputInfo iinfo) throws DMLRuntimeException {
        CSVFileFormatProperties props = iinfo == InputInfo.CSVInputInfo ? new CSVFileFormatProperties() : null;
        return FrameReaderFactory.createFrameReader(iinfo, props);
    }

    public static FrameReader createFrameReader(InputInfo iinfo, FileFormatProperties props) throws DMLRuntimeException {
        FrameReader reader = null;
        if (iinfo == InputInfo.TextCellInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) ? new FrameReaderTextCellParallel() : new FrameReaderTextCell();
        } else if (iinfo == InputInfo.CSVInputInfo) {
            if (props != null && !(props instanceof CSVFileFormatProperties)) {
                throw new DMLRuntimeException("Wrong type of file format properties for CSV writer.");
            }
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) ? new FrameReaderTextCSVParallel((CSVFileFormatProperties)props) : new FrameReaderTextCSV((CSVFileFormatProperties)props);
        } else if (iinfo == InputInfo.BinaryBlockInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS) ? new FrameReaderBinaryBlockParallel() : new FrameReaderBinaryBlock();
        } else {
            throw new DMLRuntimeException("Failed to create frame reader for unknown input info: " + InputInfo.inputInfoToString(iinfo));
        }
        return reader;
    }
}

