/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.Arrays;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.instructions.cp.UnaryMatrixCPInstruction;
import org.apache.sysml.runtime.instructions.cp.UnaryScalarCPInstruction;
import org.apache.sysml.runtime.matrix.data.LibCommonsMath;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public abstract class UnaryCPInstruction
extends ComputationCPInstruction {
    protected UnaryCPInstruction(CPInstruction.CPType type, Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        this(type, op, in, null, null, out, opcode, instr);
    }

    protected UnaryCPInstruction(CPInstruction.CPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String instr) {
        this(type, op, in1, in2, null, out, opcode, instr);
    }

    protected UnaryCPInstruction(CPInstruction.CPType type, Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String instr) {
        super(type, op, in1, in2, in3, out, opcode, instr);
    }

    public static UnaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = null;
        Builtin func = null;
        if (parts.length == 4) {
            opcode = parts[0];
            in.split(parts[1]);
            out.split(parts[2]);
            func = Builtin.getBuiltinFnObject(opcode);
            if (Arrays.asList("ucumk+", "ucum*", "ucummin", "ucummax").contains(opcode)) {
                return new UnaryMatrixCPInstruction(new UnaryOperator(func, Integer.parseInt(parts[3])), in, out, opcode, str);
            }
            return new UnaryScalarCPInstruction(null, in, out, opcode, str);
        }
        opcode = UnaryCPInstruction.parseUnaryInstruction(str, in, out);
        if (in.getDataType() == Expression.DataType.SCALAR) {
            return new UnaryScalarCPInstruction(InstructionUtils.parseUnaryOperator(opcode), in, out, opcode, str);
        }
        if (in.getDataType() == Expression.DataType.MATRIX) {
            return new UnaryMatrixCPInstruction(LibCommonsMath.isSupportedUnaryOperation(opcode) ? null : InstructionUtils.parseUnaryOperator(opcode), in, out, opcode, str);
        }
        return null;
    }

    static String parseUnaryInstruction(String instr, CPOperand in, CPOperand out) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(instr, 2);
        return UnaryCPInstruction.parse(instr, in, null, null, out);
    }

    static String parseUnaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand out) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(instr, 3);
        return UnaryCPInstruction.parse(instr, in1, in2, null, out);
    }

    static String parseUnaryInstruction(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(instr, 4);
        return UnaryCPInstruction.parse(instr, in1, in2, in3, out);
    }

    private static String parse(String instr, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(instr);
        String opcode = parts[0];
        out.split(parts[parts.length - 1]);
        switch (parts.length) {
            case 3: {
                in1.split(parts[1]);
                in2 = null;
                in3 = null;
                break;
            }
            case 4: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                in3 = null;
                break;
            }
            case 5: {
                in1.split(parts[1]);
                in2.split(parts[2]);
                in3.split(parts[3]);
                break;
            }
            default: {
                throw new DMLRuntimeException("Unexpected number of operands in the instruction: " + instr);
            }
        }
        return opcode;
    }
}

