/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.FrameIndexingCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MatrixIndexingCPInstruction;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;
import org.apache.sysml.runtime.util.IndexRange;

public abstract class IndexingCPInstruction
extends UnaryCPInstruction {
    protected final CPOperand rowLower;
    protected final CPOperand rowUpper;
    protected final CPOperand colLower;
    protected final CPOperand colUpper;

    protected IndexingCPInstruction(Operator op, CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.MatrixIndexing, op, in, out, opcode, istr);
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
    }

    protected IndexingCPInstruction(Operator op, CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.MatrixIndexing, op, lhsInput, rhsInput, out, opcode, istr);
        this.rowLower = rl;
        this.rowUpper = ru;
        this.colLower = cl;
        this.colUpper = cu;
    }

    protected IndexRange getIndexRange(ExecutionContext ec) throws DMLRuntimeException {
        return new IndexRange((int)(ec.getScalarInput(this.rowLower.getName(), this.rowLower.getValueType(), this.rowLower.isLiteral()).getLongValue() - 1L), (int)(ec.getScalarInput(this.rowUpper.getName(), this.rowUpper.getValueType(), this.rowUpper.isLiteral()).getLongValue() - 1L), (int)(ec.getScalarInput(this.colLower.getName(), this.colLower.getValueType(), this.colLower.isLiteral()).getLongValue() - 1L), (int)(ec.getScalarInput(this.colUpper.getName(), this.colUpper.getValueType(), this.colUpper.isLiteral()).getLongValue() - 1L));
    }

    public static IndexingCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("rightIndex")) {
            if (parts.length == 7) {
                CPOperand in = new CPOperand(parts[1]);
                CPOperand rl = new CPOperand(parts[2]);
                CPOperand ru = new CPOperand(parts[3]);
                CPOperand cl = new CPOperand(parts[4]);
                CPOperand cu = new CPOperand(parts[5]);
                CPOperand out = new CPOperand(parts[6]);
                if (in.getDataType() == Expression.DataType.MATRIX) {
                    return new MatrixIndexingCPInstruction(new SimpleOperator(null), in, rl, ru, cl, cu, out, opcode, str);
                }
                if (in.getDataType() == Expression.DataType.FRAME) {
                    return new FrameIndexingCPInstruction(new SimpleOperator(null), in, rl, ru, cl, cu, out, opcode, str);
                }
                throw new DMLRuntimeException("Can index only on Frames or Matrices");
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        if (opcode.equalsIgnoreCase("leftIndex")) {
            if (parts.length == 8) {
                CPOperand lhsInput = new CPOperand(parts[1]);
                CPOperand rhsInput = new CPOperand(parts[2]);
                CPOperand rl = new CPOperand(parts[3]);
                CPOperand ru = new CPOperand(parts[4]);
                CPOperand cl = new CPOperand(parts[5]);
                CPOperand cu = new CPOperand(parts[6]);
                CPOperand out = new CPOperand(parts[7]);
                if (lhsInput.getDataType() == Expression.DataType.MATRIX) {
                    return new MatrixIndexingCPInstruction(new SimpleOperator(null), lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, str);
                }
                if (lhsInput.getDataType() == Expression.DataType.FRAME) {
                    return new FrameIndexingCPInstruction(new SimpleOperator(null), lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, str);
                }
                throw new DMLRuntimeException("Can index only on Frames or Matrices");
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a MatrixIndexingCPInstruction: " + str);
    }
}

