/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.caching;

import java.util.ArrayList;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class CacheBlockFactory {
    public static CacheBlock newInstance(int code) {
        switch (code) {
            case 0: {
                return new MatrixBlock();
            }
            case 1: {
                return new FrameBlock();
            }
        }
        throw new RuntimeException("Unsupported cache block type: " + code);
    }

    public static int getCode(CacheBlock block) {
        if (block instanceof MatrixBlock) {
            return 0;
        }
        if (block instanceof FrameBlock) {
            return 1;
        }
        throw new RuntimeException("Unsupported cache block type: " + block.getClass().getName());
    }

    public static ArrayList<?> getPairList(CacheBlock block) {
        int code = CacheBlockFactory.getCode(block);
        switch (code) {
            case 0: {
                return new ArrayList();
            }
            case 1: {
                return new ArrayList();
            }
        }
        throw new RuntimeException("Unsupported cache block type: " + code);
    }
}

