/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.apache.sysml.parser.DataIdentifier;

public class VariableSet {
    private HashMap<String, DataIdentifier> _variables = new HashMap();

    public VariableSet() {
    }

    public VariableSet(VariableSet vs) {
        if (vs != null) {
            this._variables.putAll(vs.getVariables());
        }
    }

    public void addVariable(String name, DataIdentifier id) {
        this._variables.put(name, id);
    }

    public void addVariables(VariableSet vs) {
        if (vs != null) {
            this._variables.putAll(vs.getVariables());
        }
    }

    public void removeVariables(VariableSet vs) {
        if (vs != null) {
            for (String var : vs.getVariables().keySet()) {
                this._variables.remove(var);
            }
        }
    }

    public boolean containsVariable(String name) {
        return this._variables.containsKey(name);
    }

    public boolean containsAnyName(Set<String> names) {
        return this._variables.keySet().stream().anyMatch(n -> names.contains(n));
    }

    public DataIdentifier getVariable(String name) {
        return this._variables.get(name);
    }

    public Set<String> getVariableNames() {
        return this._variables.keySet();
    }

    public HashMap<String, DataIdentifier> getVariables() {
        return this._variables;
    }

    public String toString() {
        return Arrays.toString(this._variables.keySet().toArray());
    }

    public static VariableSet union(VariableSet vs1, VariableSet vs2) {
        VariableSet ret = new VariableSet(vs1);
        ret.addVariables(vs2);
        return ret;
    }

    public static VariableSet minus(VariableSet vs1, VariableSet vs2) {
        VariableSet ret = new VariableSet(vs1);
        ret.removeVariables(vs2);
        return ret;
    }
}

