/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.ParseInfo;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatementBlock;

public class FunctionStatementBlock
extends StatementBlock {
    private boolean _recompileOnce = false;

    @Override
    public VariableSet validate(DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException, ParseException, IOException {
        if (this._statements.size() > 1) {
            LOG.error((Object)(this.printBlockErrorLocation() + "FunctionStatementBlock should have only 1 statement (FunctionStatement)"));
            throw new LanguageException(this.printBlockErrorLocation() + "FunctionStatementBlock should have only 1 statement (FunctionStatement)");
        }
        FunctionStatement fstmt = (FunctionStatement)this._statements.get(0);
        ArrayList<DataIdentifier> inputValues = fstmt.getInputParams();
        for (DataIdentifier inputValue : inputValues) {
            if (inputValue.getDataType() != Expression.DataType.MATRIX || inputValue.getValueType() == Expression.ValueType.DOUBLE) continue;
            this.raiseValidateError("for function " + fstmt.getName() + ", input variable " + inputValue.getName() + " has an unsupported value type of " + (Object)((Object)inputValue.getValueType()) + ".", false);
        }
        if (!(fstmt instanceof ExternalFunctionStatement)) {
            this._dmlProg = dmlProg;
            for (StatementBlock sb : fstmt.getBody()) {
                ids = sb.validate(dmlProg, ids, constVars, conditional);
                constVars = sb.getConstOut();
            }
            if (fstmt.getBody().size() > 0) {
                this._constVarsIn.putAll(fstmt.getBody().get(0).getConstIn());
            }
            if (fstmt.getBody().size() > 1) {
                this._constVarsOut.putAll(fstmt.getBody().get(fstmt.getBody().size() - 1).getConstOut());
            }
            ArrayList<DataIdentifier> returnValues = fstmt.getOutputParams();
            for (DataIdentifier returnValue : returnValues) {
                DataIdentifier curr = ids.getVariable(returnValue.getName());
                if (curr == null) {
                    this.raiseValidateError("for function " + fstmt.getName() + ", return variable " + returnValue.getName() + " must be defined in function ", conditional);
                }
                if (curr.getDataType() == Expression.DataType.UNKNOWN) {
                    this.raiseValidateError("for function " + fstmt.getName() + ", return variable " + curr.getName() + " data type of " + (Object)((Object)curr.getDataType()) + " may not match data type in function signature of " + (Object)((Object)returnValue.getDataType()), true);
                }
                if (curr.getValueType() == Expression.ValueType.UNKNOWN) {
                    this.raiseValidateError("for function " + fstmt.getName() + ", return variable " + curr.getName() + " data type of " + (Object)((Object)curr.getValueType()) + " may not match data type in function signature of " + (Object)((Object)returnValue.getValueType()), true);
                }
                if (curr.getDataType() != Expression.DataType.UNKNOWN && !curr.getDataType().equals((Object)returnValue.getDataType())) {
                    this.raiseValidateError("for function " + fstmt.getName() + ", return variable " + curr.getName() + " data type of " + (Object)((Object)curr.getDataType()) + " does not match data type in function signature of " + (Object)((Object)returnValue.getDataType()), conditional);
                }
                if (curr.getValueType() == Expression.ValueType.UNKNOWN || curr.getValueType().equals((Object)returnValue.getValueType())) continue;
                if (curr.getDataType() == Expression.DataType.SCALAR && returnValue.getDataType() == Expression.DataType.SCALAR) {
                    if (returnValue.getValueType() == Expression.ValueType.DOUBLE) {
                        if (curr.getValueType() == Expression.ValueType.INT) {
                            IntIdentifier currIntValue = (IntIdentifier)constVars.get(curr.getName());
                            if (currIntValue != null) {
                                DoubleIdentifier currDoubleValue = new DoubleIdentifier(currIntValue.getValue(), (ParseInfo)curr);
                                constVars.put(curr.getName(), currDoubleValue);
                            }
                            LOG.warn((Object)(curr.printWarningLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " but was safely cast"));
                            curr.setValueType(Expression.ValueType.DOUBLE);
                            ids.addVariable(curr.getName(), curr);
                        } else {
                            LOG.error((Object)(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast value"));
                            throw new LanguageException(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast value");
                        }
                    }
                    if (returnValue.getValueType() != Expression.ValueType.INT) continue;
                    LOG.error((Object)(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast " + (Object)((Object)curr.getValueType()) + " as " + (Object)((Object)returnValue.getValueType())));
                    throw new LanguageException(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast " + (Object)((Object)curr.getValueType()) + " as " + (Object)((Object)returnValue.getValueType()));
                }
                LOG.error((Object)(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast double as int"));
                throw new LanguageException(curr.printErrorLocation() + "for function " + fstmt.getName() + ", return variable " + curr.getName() + " value type of " + (Object)((Object)curr.getValueType()) + " does not match value type in function signature of " + (Object)((Object)returnValue.getValueType()) + " and cannot safely cast " + (Object)((Object)curr.getValueType()) + " as " + (Object)((Object)returnValue.getValueType()));
            }
        } else {
            ExternalFunctionStatement efstmt = (ExternalFunctionStatement)fstmt;
            efstmt.validateParameters(this);
            this._dmlProg = dmlProg;
            for (StatementBlock sb : efstmt.getBody()) {
                ids = sb.validate(dmlProg, ids, constVars, conditional);
                constVars = sb.getConstOut();
            }
        }
        return ids;
    }

    public FunctionOp.FunctionType getFunctionOpType() {
        FunctionOp.FunctionType ret = FunctionOp.FunctionType.UNKNOWN;
        FunctionStatement fstmt = (FunctionStatement)this._statements.get(0);
        if (fstmt instanceof ExternalFunctionStatement) {
            ExternalFunctionStatement efstmt = (ExternalFunctionStatement)fstmt;
            String execType = efstmt.getOtherParams().get("exectype");
            if (execType != null) {
                ret = execType.equals("mem") ? FunctionOp.FunctionType.EXTERNAL_MEM : FunctionOp.FunctionType.EXTERNAL_FILE;
            }
        } else {
            ret = FunctionOp.FunctionType.DML;
        }
        return ret;
    }

    @Override
    public VariableSet initializeforwardLV(VariableSet activeInPassed) throws LanguageException {
        FunctionStatement fstmt = (FunctionStatement)this._statements.get(0);
        if (this._statements.size() > 1) {
            LOG.error((Object)(this.printBlockErrorLocation() + "FunctionStatementBlock should have only 1 statement (while statement)"));
            throw new LanguageException(this.printBlockErrorLocation() + "FunctionStatementBlock should have only 1 statement (while statement)");
        }
        this._read = new VariableSet();
        this._gen = new VariableSet();
        VariableSet current = new VariableSet();
        current.addVariables(activeInPassed);
        for (StatementBlock sb : fstmt.getBody()) {
            current = sb.initializeforwardLV(current);
            for (String varName : sb._gen.getVariableNames()) {
                if (this._kill.getVariableNames().contains(varName)) continue;
                this._gen.addVariable(varName, sb._gen.getVariable(varName));
            }
            this._read.addVariables(sb._read);
            this._updated.addVariables(sb._updated);
            if (sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) continue;
            this._kill.addVariables(sb._kill);
        }
        this._liveOut = new VariableSet();
        this._liveOut.addVariables(current);
        this._liveOut.addVariables(this._updated);
        return this._liveOut;
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet loPassed) throws LanguageException {
        FunctionStatement wstmt = (FunctionStatement)this._statements.get(0);
        VariableSet lo = new VariableSet();
        lo.addVariables(loPassed);
        int numBlocks = wstmt.getBody().size();
        for (int i = numBlocks - 1; i >= 0; --i) {
            lo = wstmt.getBody().get(i).analyze(lo);
        }
        VariableSet loReturn = new VariableSet();
        loReturn.addVariables(lo);
        return loReturn;
    }

    @Override
    public VariableSet analyze(VariableSet loPassed) throws LanguageException {
        LOG.error((Object)(this.printBlockErrorLocation() + "Both liveIn and liveOut variables need to be specified for liveness analysis for FunctionStatementBlock"));
        throw new LanguageException(this.printBlockErrorLocation() + "Both liveIn and liveOut variables need to be specified for liveness analysis for FunctionStatementBlock");
    }

    public VariableSet analyze(VariableSet liPassed, VariableSet loPassed) throws LanguageException {
        VariableSet candidateLO = new VariableSet();
        candidateLO.addVariables(loPassed);
        candidateLO.addVariables(this._gen);
        VariableSet origLiveOut = new VariableSet();
        origLiveOut.addVariables(this._liveOut);
        this._liveOut = new VariableSet();
        for (String name : candidateLO.getVariableNames()) {
            if (!origLiveOut.containsVariable(name)) continue;
            this._liveOut.addVariable(name, candidateLO.getVariable(name));
        }
        this.initializebackwardLV(this._liveOut);
        this._liveIn = new VariableSet();
        this._liveIn.addVariables(liPassed);
        VariableSet liveInReturn = new VariableSet();
        liveInReturn.addVariables(this._liveIn);
        return liveInReturn;
    }

    public void setRecompileOnce(boolean flag) {
        this._recompileOnce = flag;
    }

    public boolean isRecompileOnce() {
        return this._recompileOnce;
    }
}

