/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.globalopt.gdfgraph;

import java.util.ArrayList;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;

public class GDFNode {
    private static IDSequence _seqID = new IDSequence();
    protected NodeType _type = null;
    protected long _ID = _seqID.getNextID();
    protected Hop _hop = null;
    protected ProgramBlock _pb = null;
    protected ArrayList<GDFNode> _inputs = null;

    public GDFNode() {
    }

    public GDFNode(Hop hop, ProgramBlock pb, ArrayList<GDFNode> inputs) {
        this();
        this._type = NodeType.HOP_NODE;
        this._hop = hop;
        this._pb = pb;
        this._inputs = inputs;
    }

    public NodeType getNodeType() {
        return this._type;
    }

    public long getID() {
        return this._ID;
    }

    public Hop getHop() {
        return this._hop;
    }

    public ProgramBlock getProgramBlock() {
        return this._pb;
    }

    public Program getProgram() {
        if (this._pb != null) {
            return this._pb.getProgram();
        }
        return null;
    }

    public ArrayList<GDFNode> getInputs() {
        return this._inputs;
    }

    public Expression.DataType getDataType() {
        return this._hop.getDataType();
    }

    public boolean requiresMREnumeration() {
        boolean ret = this._hop.getDataType() == Expression.DataType.MATRIX;
        for (Hop c : this._hop.getInput()) {
            ret |= c.getDataType() == Expression.DataType.MATRIX;
        }
        if (this._hop instanceof UnaryOp && ((UnaryOp)this._hop).getOp() == Hop.OpOp1.CAST_AS_SCALAR) {
            ret = false;
        }
        if (this._hop instanceof DataGenOp && ((DataGenOp)this._hop).getOp() == Hop.DataGenMethod.SINIT) {
            ret = false;
        }
        if (this._hop instanceof UnaryOp && ((UnaryOp)this._hop).getOp() == Hop.OpOp1.NROW) {
            ret = false;
        }
        if (this._hop instanceof UnaryOp && ((UnaryOp)this._hop).getOp() == Hop.OpOp1.NCOL) {
            ret = false;
        }
        return ret;
    }

    public boolean isValidInputFormatForOperation(Hop.FileFormatTypes format) {
        return this._hop instanceof UnaryOp && format != Hop.FileFormatTypes.CSV || this._hop instanceof AggUnaryOp && ((AggUnaryOp)this._hop).getDirection() == Hop.Direction.RowCol && format != Hop.FileFormatTypes.CSV || HopRewriteUtils.isTransposeOperation(this._hop) && format != Hop.FileFormatTypes.CSV || format == Hop.FileFormatTypes.BINARY;
    }

    public String explain(String deps) {
        String ldeps;
        String string = ldeps = deps != null ? deps : "";
        if (this._hop != null) {
            return "Node " + ldeps + " [" + this._hop.getHopID() + ", " + this._hop.getOpString() + "]";
        }
        return "Node " + ldeps + " [null]";
    }

    public static enum NodeType {
        HOP_NODE,
        LOOP_NODE,
        CROSS_BLOCK_NODE;

    }
}

