/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.CodegenUtils;
import org.apache.sysml.runtime.codegen.SpoofOperator;
import org.apache.sysml.runtime.compress.utils.IntArrayList;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;

public class RowClassMeet
extends PackageFunction {
    private static final long serialVersionUID = 1L;
    private Matrix CMat;
    private Matrix NMat;

    @Override
    public int getNumFunctionOutputs() {
        return 2;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        switch (pos) {
            case 0: {
                return this.CMat;
            }
            case 1: {
                return this.NMat;
            }
        }
        throw new RuntimeException("RowClassMeet produces only one output");
    }

    @Override
    public void execute() {
        try {
            MatrixBlock A = (MatrixBlock)((Matrix)this.getFunctionInput(0)).getMatrixObject().acquireRead();
            MatrixBlock B = (MatrixBlock)((Matrix)this.getFunctionInput(1)).getMatrixObject().acquireRead();
            int nr = Math.max(A.getNumRows(), B.getNumRows());
            int nc = Math.max(A.getNumColumns(), B.getNumColumns());
            MatrixBlock C = new MatrixBlock(nr, nc, false).allocateBlock();
            MatrixBlock N = new MatrixBlock(nr, nc, false).allocateBlock();
            double[] dC = C.getDenseBlock();
            double[] dN = N.getDenseBlock();
            SpoofOperator.SideInput sB = CodegenUtils.createSideInput(B);
            boolean mv = B.getNumRows() == 1;
            int numCols = Math.min(A.getNumColumns(), B.getNumColumns());
            HashMap<ClassLabel, IntArrayList> classLabelMapping = new HashMap<ClassLabel, IntArrayList>();
            int i = 0;
            int ai = 0;
            while (i < A.getNumRows()) {
                block10: {
                    block11: {
                        block9: {
                            classLabelMapping.clear();
                            sB.reset();
                            if (!A.isInSparseFormat()) break block9;
                            if (A.getSparseBlock() == null || A.getSparseBlock().isEmpty(i)) break block10;
                            int alen = A.getSparseBlock().size(i);
                            int apos = A.getSparseBlock().pos(i);
                            int[] aix = A.getSparseBlock().indexes(i);
                            double[] avals = A.getSparseBlock().values(i);
                            for (int k = apos; k < apos + alen && aix[k] < numCols; ++k) {
                                int bval = (int)sB.getValue(mv ? 0 : i, aix[k]);
                                if (bval == 0) continue;
                                ClassLabel key = new ClassLabel((int)avals[k], bval);
                                if (!classLabelMapping.containsKey(key)) {
                                    classLabelMapping.put(key, new IntArrayList());
                                }
                                ((IntArrayList)classLabelMapping.get(key)).appendValue(aix[k]);
                            }
                            break block11;
                        }
                        double[] denseBlk = A.getDenseBlock();
                        if (denseBlk == null) break;
                        for (int j = 0; j < numCols; ++j) {
                            int aVal = (int)denseBlk[ai + j];
                            int bVal = (int)sB.getValue(mv ? 0 : i, j);
                            if (aVal == 0 || bVal == 0) continue;
                            ClassLabel key = new ClassLabel(aVal, bVal);
                            if (!classLabelMapping.containsKey(key)) {
                                classLabelMapping.put(key, new IntArrayList());
                            }
                            ((IntArrayList)classLabelMapping.get(key)).appendValue(j);
                        }
                    }
                    int labelID = 1;
                    for (Map.Entry entry : classLabelMapping.entrySet()) {
                        int nVal = ((IntArrayList)entry.getValue()).size();
                        int[] list = ((IntArrayList)entry.getValue()).extractValues();
                        int off = i * nc;
                        for (int k = 0; k < nVal; ++k) {
                            dN[off + list[k]] = nVal;
                            dC[off + list[k]] = labelID;
                        }
                        ++labelID;
                    }
                }
                ++i;
                ai += A.getNumColumns();
            }
            ((Matrix)this.getFunctionInput(0)).getMatrixObject().release();
            ((Matrix)this.getFunctionInput(1)).getMatrixObject().release();
            C.recomputeNonZeros();
            C.examSparsity();
            this.CMat = new Matrix(this.createOutputFilePathAndName("TMP"), nr, nc, Matrix.ValueType.Double);
            this.CMat.setMatrixDoubleArray(C, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
            N.recomputeNonZeros();
            N.examSparsity();
            this.NMat = new Matrix(this.createOutputFilePathAndName("TMP"), nr, nc, Matrix.ValueType.Double);
            this.NMat.setMatrixDoubleArray(N, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
        }
        catch (IOException | DMLRuntimeException e) {
            throw new RuntimeException("Error while executing RowClassMeet", e);
        }
    }

    private static class ClassLabel {
        public int aVal;
        public int bVal;

        public ClassLabel(int aVal, int bVal) {
            this.aVal = aVal;
            this.bVal = bVal;
        }

        public int hashCode() {
            return UtilFunctions.intHashCode(this.aVal, this.bVal);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClassLabel)) {
                return false;
            }
            ClassLabel that = (ClassLabel)o;
            return this.aVal == that.aVal && this.bVal == that.bVal;
        }
    }
}

