/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.LongStream;
import org.apache.commons.math3.random.Well1024a;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.MMTSJ;
import org.apache.sysml.lops.MapMultChain;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.functionobjects.CTable;
import org.apache.sysml.runtime.functionobjects.DiagIndex;
import org.apache.sysml.runtime.functionobjects.Divide;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.functionobjects.KahanPlusSq;
import org.apache.sysml.runtime.functionobjects.Multiply;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.functionobjects.ReduceAll;
import org.apache.sysml.runtime.functionobjects.ReduceCol;
import org.apache.sysml.runtime.functionobjects.ReduceRow;
import org.apache.sysml.runtime.functionobjects.RevIndex;
import org.apache.sysml.runtime.functionobjects.SortIndex;
import org.apache.sysml.runtime.functionobjects.SwapIndex;
import org.apache.sysml.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.CTableMap;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysml.runtime.matrix.data.LibMatrixBincell;
import org.apache.sysml.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysml.runtime.matrix.data.LibMatrixMult;
import org.apache.sysml.runtime.matrix.data.LibMatrixNative;
import org.apache.sysml.runtime.matrix.data.LibMatrixOuterAgg;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixBlockDataInput;
import org.apache.sysml.runtime.matrix.data.MatrixBlockDataOutput;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlockCSR;
import org.apache.sysml.runtime.matrix.data.SparseBlockFactory;
import org.apache.sysml.runtime.matrix.data.SparseBlockMCSR;
import org.apache.sysml.runtime.matrix.data.SparseRow;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateTernaryOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.matrix.operators.COVOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.QuaternaryOperator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.FastBufferedDataInputStream;
import org.apache.sysml.runtime.util.FastBufferedDataOutputStream;
import org.apache.sysml.runtime.util.IndexRange;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.GPUStatistics;
import org.apache.sysml.utils.NativeHelper;

public class MatrixBlock
extends MatrixValue
implements CacheBlock,
Externalizable {
    private static final long serialVersionUID = 7319972089143154056L;
    public static final double SPARSITY_TURN_POINT = 0.4;
    public static final double ULTRA_SPARSITY_TURN_POINT = 4.0E-5;
    public static final SparseBlock.Type DEFAULT_SPARSEBLOCK = SparseBlock.Type.MCSR;
    public static final SparseBlock.Type DEFAULT_INPLACE_SPARSEBLOCK = SparseBlock.Type.CSR;
    public static final double MAX_SHALLOW_SERIALIZE_OVERHEAD = 1.3;
    public static final boolean CONVERT_MCSR_TO_CSR_ON_DEEP_SERIALIZE = true;
    public static final int HEADER_SIZE = 9;
    protected int rlen = -1;
    protected int clen = -1;
    protected boolean sparse = true;
    protected long nonZeros = 0L;
    protected double[] denseBlock = null;
    protected SparseBlock sparseBlock = null;
    protected int estimatedNNzsPerRow = -1;
    protected int numGroups = -1;
    protected boolean diag = false;

    public MatrixBlock() {
        this(0, 0, true, -1L);
    }

    public MatrixBlock(int rl, int cl, boolean sp) {
        this(rl, cl, sp, -1L);
    }

    public MatrixBlock(int rl, int cl, long estnnz) {
        this(rl, cl, MatrixBlock.evalSparseFormatInMemory(rl, cl, estnnz), estnnz);
    }

    public MatrixBlock(int rl, int cl, boolean sp, long estnnz) {
        this.reset(rl, cl, sp, estnnz, 0.0);
    }

    public MatrixBlock(MatrixBlock that) {
        this.copy(that);
    }

    public MatrixBlock(int rl, int cl, long nnz, SparseBlock sblock) {
        this(rl, cl, true, nnz);
        this.nonZeros = nnz;
        this.sparseBlock = sblock;
    }

    public MatrixBlock(MatrixBlock that, SparseBlock.Type stype, boolean deep) {
        this(that.rlen, that.clen, that.sparse);
        if (!that.isInSparseFormat()) {
            throw new RuntimeException("Sparse matrix block expected.");
        }
        this.nonZeros = that.nonZeros;
        this.estimatedNNzsPerRow = that.estimatedNNzsPerRow;
        this.sparseBlock = SparseBlockFactory.copySparseBlock(stype, that.sparseBlock, deep);
    }

    @Override
    public void reset() {
        this.reset(this.rlen, this.clen, this.sparse, -1L, 0.0);
    }

    @Override
    public void reset(int rl, int cl) {
        this.reset(rl, cl, this.sparse, -1L, 0.0);
    }

    public void reset(int rl, int cl, long estnnz) {
        this.reset(rl, cl, MatrixBlock.evalSparseFormatInMemory(rl, cl, estnnz), estnnz, 0.0);
    }

    @Override
    public void reset(int rl, int cl, boolean sp) {
        this.reset(rl, cl, sp, -1L, 0.0);
    }

    @Override
    public void reset(int rl, int cl, boolean sp, long estnnz) {
        this.reset(rl, cl, sp, estnnz, 0.0);
    }

    @Override
    public void reset(int rl, int cl, double val) {
        this.reset(rl, cl, false, -1L, val);
    }

    private void reset(int rl, int cl, boolean sp, long estnnz, double val) {
        this.rlen = rl;
        this.clen = cl;
        this.sparse = val == 0.0 ? sp : false;
        this.nonZeros = val == 0.0 ? 0L : (long)(rl * cl);
        int n = this.estimatedNNzsPerRow = estnnz < 0L || !this.sparse ? -1 : (int)Math.ceil((double)estnnz / (double)this.rlen);
        if (this.sparse) {
            this.resetSparse();
        } else {
            this.resetDense(val);
        }
        this.numGroups = -1;
        this.diag = false;
    }

    private void resetSparse() {
        if (this.sparseBlock == null) {
            return;
        }
        this.sparseBlock.reset(this.estimatedNNzsPerRow, this.clen);
    }

    private void resetDense(double val) {
        if (this.denseBlock != null && this.denseBlock.length < this.rlen * this.clen && val == 0.0) {
            this.denseBlock = null;
        } else if (val != 0.0) {
            this.allocateDenseBlock(false);
        }
        if (this.denseBlock != null) {
            Arrays.fill(this.denseBlock, 0, this.rlen * this.clen, val);
        }
    }

    public void init(double[][] arr, int r, int c) throws DMLRuntimeException {
        if (this.sparse) {
            throw new DMLRuntimeException("MatrixBlockDSM.init() can be invoked only on matrices with dense representation.");
        }
        if (r * c > this.rlen * this.clen) {
            throw new DMLRuntimeException("MatrixBlockDSM.init() invoked with too large dimensions (" + r + "," + c + ") vs (" + this.rlen + "," + this.clen + ")");
        }
        this.allocateDenseBlock();
        int i = 0;
        int ix = 0;
        while (i < r) {
            System.arraycopy(arr[i], 0, this.denseBlock, ix, arr[i].length);
            ++i;
            ix += this.clen;
        }
        this.recomputeNonZeros();
    }

    public void init(double[] arr, int r, int c) throws DMLRuntimeException {
        if (this.sparse) {
            throw new DMLRuntimeException("MatrixBlockDSM.init() can be invoked only on matrices with dense representation.");
        }
        if (r * c > this.rlen * this.clen) {
            throw new DMLRuntimeException("MatrixBlockDSM.init() invoked with too large dimensions (" + r + "," + c + ") vs (" + this.rlen + "," + this.clen + ")");
        }
        this.allocateDenseBlock();
        System.arraycopy(arr, 0, this.denseBlock, 0, arr.length);
        this.recomputeNonZeros();
    }

    public boolean isAllocated() {
        return this.sparse ? this.sparseBlock != null : this.denseBlock != null;
    }

    public MatrixBlock allocateDenseBlock() {
        this.allocateDenseBlock(true);
        return this;
    }

    public MatrixBlock allocateBlock() {
        if (this.sparse) {
            this.allocateSparseRowsBlock();
        } else {
            this.allocateDenseBlock();
        }
        return this;
    }

    public void allocateDenseBlock(boolean clearNNZ) {
        long limit = (long)this.rlen * (long)this.clen;
        if (limit > Integer.MAX_VALUE) {
            String execType = OptimizerUtils.isSparkExecutionMode() ? "SPARK" : "MR";
            throw new RuntimeException("Dense in-memory matrix block (" + this.rlen + "x" + this.clen + ") exceeds supported size of " + Integer.MAX_VALUE + " elements (16GB). Please, report this issue and reduce the JVM heapsize to execute this operation in " + execType + ".");
        }
        if (this.denseBlock == null || (long)this.denseBlock.length < limit) {
            this.denseBlock = new double[(int)limit];
        }
        if (clearNNZ) {
            this.nonZeros = 0L;
        }
        this.sparse = false;
    }

    public void allocateSparseRowsBlock() {
        this.allocateSparseRowsBlock(true);
    }

    public void allocateSparseRowsBlock(boolean clearNNZ) {
        if (this.sparseBlock == null || this.sparseBlock.numRows() < this.rlen) {
            this.sparseBlock = SparseBlockFactory.createSparseBlock(DEFAULT_SPARSEBLOCK, this.rlen);
        }
        if (clearNNZ) {
            this.nonZeros = 0L;
        }
    }

    public void allocateAndResetSparseRowsBlock(boolean clearNNZ, SparseBlock.Type stype) {
        if (this.sparseBlock == null || this.sparseBlock.numRows() < this.rlen || !SparseBlockFactory.isSparseBlockType(this.sparseBlock, stype)) {
            this.sparseBlock = SparseBlockFactory.createSparseBlock(stype, this.rlen);
        } else {
            this.sparseBlock.reset(this.estimatedNNzsPerRow, this.clen);
        }
        if (clearNNZ) {
            this.nonZeros = 0L;
        }
    }

    public void allocateDenseBlockUnsafe(int rl, int cl) throws DMLRuntimeException {
        this.sparse = false;
        this.rlen = rl;
        this.clen = cl;
        this.allocateDenseBlock();
    }

    public void cleanupBlock(boolean dense, boolean sparse) {
        if (dense) {
            this.denseBlock = null;
        }
        if (sparse) {
            this.sparseBlock = null;
        }
    }

    @Override
    public int getNumRows() {
        return this.rlen;
    }

    public void setNumRows(int r) {
        this.rlen = r;
    }

    @Override
    public int getNumColumns() {
        return this.clen;
    }

    public void setNumColumns(int c) {
        this.clen = c;
    }

    @Override
    public long getNonZeros() {
        return this.nonZeros;
    }

    public long setNonZeros(long nnz) {
        this.nonZeros = nnz;
        return this.nonZeros;
    }

    public double getSparsity() {
        return OptimizerUtils.getSparsity(this.rlen, this.clen, this.nonZeros);
    }

    public boolean isVector() {
        return this.rlen == 1 || this.clen == 1;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmptyBlock(false);
    }

    public boolean isEmptyBlock() {
        return this.isEmptyBlock(true);
    }

    public boolean isEmptyBlock(boolean safe) {
        boolean ret = false;
        if (this.sparse && this.sparseBlock == null) {
            ret = true;
        } else if (!this.sparse && this.denseBlock == null) {
            ret = true;
        }
        if (this.nonZeros == 0L) {
            if (safe) {
                this.recomputeNonZeros();
            }
            ret = this.nonZeros == 0L;
        }
        return ret;
    }

    public void setDiag() {
        this.diag = true;
    }

    public boolean isDiag() {
        return this.diag;
    }

    public double[] getDenseBlock() {
        if (this.sparse) {
            return null;
        }
        return this.denseBlock;
    }

    public SparseBlock getSparseBlock() {
        if (!this.sparse) {
            return null;
        }
        return this.sparseBlock;
    }

    public Iterator<IJV> getSparseBlockIterator() {
        if (!this.sparse) {
            throw new RuntimeException("getSparseBlockInterator should not be called for dense format");
        }
        if (this.sparseBlock == null) {
            return new ArrayList().iterator();
        }
        if (this.rlen == this.sparseBlock.numRows()) {
            return this.sparseBlock.getIterator();
        }
        return this.sparseBlock.getIterator(this.rlen);
    }

    public Iterator<IJV> getSparseBlockIterator(int rl, int ru) {
        if (!this.sparse) {
            throw new RuntimeException("getSparseBlockInterator should not be called for dense format");
        }
        if (this.sparseBlock == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.sparseBlock.getIterator(rl, ru);
    }

    @Override
    public double getValue(int r, int c) {
        if (r >= this.rlen || c >= this.clen) {
            throw new RuntimeException("indexes (" + r + "," + c + ") out of range (" + this.rlen + "," + this.clen + ")");
        }
        return this.quickGetValue(r, c);
    }

    @Override
    public void setValue(int r, int c, double v) {
        if (r >= this.rlen || c >= this.clen) {
            throw new RuntimeException("indexes (" + r + "," + c + ") out of range (" + this.rlen + "," + this.clen + ")");
        }
        this.quickSetValue(r, c, v);
    }

    public double quickGetValue(int r, int c) {
        if (this.sparse) {
            if (this.sparseBlock == null) {
                return 0.0;
            }
            return this.sparseBlock.get(r, c);
        }
        if (this.denseBlock == null) {
            return 0.0;
        }
        return this.denseBlock[r * this.clen + c];
    }

    public void quickSetValue(int r, int c, double v) {
        if (this.sparse) {
            if ((this.sparseBlock == null || this.sparseBlock.isEmpty(r)) && v == 0.0) {
                return;
            }
            this.allocateSparseRowsBlock(false);
            this.sparseBlock.allocate(r, this.estimatedNNzsPerRow, this.clen);
            if (this.sparseBlock.set(r, c, v)) {
                this.nonZeros += v != 0.0 ? 1L : -1L;
            }
        } else {
            if (this.denseBlock == null && v == 0.0) {
                return;
            }
            this.allocateDenseBlock(false);
            int index = r * this.clen + c;
            if (this.denseBlock[index] == 0.0) {
                ++this.nonZeros;
            }
            this.denseBlock[index] = v;
            if (v == 0.0) {
                --this.nonZeros;
            }
        }
    }

    public double getValueDenseUnsafe(int r, int c) {
        if (this.denseBlock == null) {
            return 0.0;
        }
        return this.denseBlock[r * this.clen + c];
    }

    public void setValueDenseUnsafe(int r, int c, double v) {
        this.denseBlock[r * this.clen + c] = v;
    }

    public double getValueSparseUnsafe(int r, int c) {
        if (this.sparseBlock == null || this.sparseBlock.isEmpty(r)) {
            return 0.0;
        }
        return this.sparseBlock.get(r, c);
    }

    public void appendValue(int r, int c, double v) {
        if (v == 0.0) {
            return;
        }
        if (!this.sparse) {
            this.allocateDenseBlock(false);
            this.denseBlock[r * this.clen + c] = v;
            ++this.nonZeros;
        } else {
            this.allocateSparseRowsBlock(false);
            this.sparseBlock.allocate(r, this.estimatedNNzsPerRow, this.clen);
            this.sparseBlock.append(r, c, v);
            ++this.nonZeros;
        }
    }

    public void appendRow(int r, SparseRow row) {
        this.appendRow(r, row, true);
    }

    public void appendRow(int r, SparseRow row, boolean deep) {
        if (row == null) {
            return;
        }
        if (this.sparse) {
            this.allocateSparseRowsBlock(false);
            this.sparseBlock.set(r, row, deep);
            this.nonZeros += (long)row.size();
        } else {
            int[] cols = row.indexes();
            double[] vals = row.values();
            for (int i = 0; i < row.size(); ++i) {
                this.quickSetValue(r, cols[i], vals[i]);
            }
        }
    }

    public void appendToSparse(MatrixBlock that, int rowoffset, int coloffset) {
        this.appendToSparse(that, rowoffset, coloffset, true);
    }

    public void appendToSparse(MatrixBlock that, int rowoffset, int coloffset, boolean deep) {
        if (that == null || that.isEmptyBlock(false)) {
            return;
        }
        this.allocateSparseRowsBlock(false);
        if (that.sparse) {
            SparseBlock b = that.sparseBlock;
            for (int i = 0; i < that.rlen; ++i) {
                if (b.isEmpty(i)) continue;
                int aix = rowoffset + i;
                if (!this.sparseBlock.isAllocated(aix) && coloffset == 0) {
                    boolean ldeep = deep && b instanceof SparseBlockMCSR;
                    this.sparseBlock.set(aix, b.get(i), ldeep);
                    continue;
                }
                int pos = b.pos(i);
                int len = b.size(i);
                int[] ix = b.indexes(i);
                double[] val = b.values(i);
                if (this.estimatedNNzsPerRow > 0) {
                    this.sparseBlock.allocate(aix, Math.max(this.estimatedNNzsPerRow, this.sparseBlock.size(aix) + len), this.clen);
                } else {
                    this.sparseBlock.allocate(aix, this.sparseBlock.size(aix) + len);
                }
                for (int j = pos; j < pos + len; ++j) {
                    this.sparseBlock.append(aix, coloffset + ix[j], val[j]);
                }
            }
        } else {
            double[] b = that.denseBlock;
            int bm = that.rlen;
            int bn = that.clen;
            int i = 0;
            int aix = rowoffset;
            int bix = 0;
            while (i < bm) {
                for (int j = 0; j < bn; ++j) {
                    double bval = b[bix + j];
                    if (bval == 0.0) continue;
                    this.sparseBlock.allocate(aix, this.estimatedNNzsPerRow, this.clen);
                    this.sparseBlock.append(aix, coloffset + j, bval);
                }
                ++i;
                ++aix;
                bix += bn;
            }
        }
    }

    public void sortSparseRows() {
        if (!this.sparse || this.sparseBlock == null) {
            return;
        }
        this.sparseBlock.sort();
    }

    public void sortSparseRows(int rl, int ru) {
        if (!this.sparse || this.sparseBlock == null) {
            return;
        }
        for (int i = rl; i < ru; ++i) {
            if (this.sparseBlock.isEmpty(i)) continue;
            this.sparseBlock.sort(i);
        }
    }

    public double minNonZero() throws DMLRuntimeException {
        if (this.isEmptyBlock()) {
            return -1.0;
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                double val = this.quickGetValue(i, j);
                if (val == 0.0) continue;
                min = Math.min(min, val);
            }
        }
        return min;
    }

    public double min() throws DMLRuntimeException {
        AggregateOperator aop = new AggregateOperator(Double.MAX_VALUE, Builtin.getBuiltinFnObject("min"));
        AggregateUnaryOperator auop = new AggregateUnaryOperator(aop, ReduceAll.getReduceAllFnObject());
        MatrixBlock out = new MatrixBlock(1, 1, false);
        LibMatrixAgg.aggregateUnaryMatrix(this, out, auop);
        return out.quickGetValue(0, 0);
    }

    public double max() throws DMLRuntimeException {
        AggregateOperator aop = new AggregateOperator(-1.7976931348623157E308, Builtin.getBuiltinFnObject("max"));
        AggregateUnaryOperator auop = new AggregateUnaryOperator(aop, ReduceAll.getReduceAllFnObject());
        MatrixBlock out = new MatrixBlock(1, 1, false);
        LibMatrixAgg.aggregateUnaryMatrix(this, out, auop);
        return out.quickGetValue(0, 0);
    }

    public double sum() throws DMLRuntimeException {
        KahanPlus kplus = KahanPlus.getKahanPlusFnObject();
        return this.sumWithFn(kplus);
    }

    public double sumSq() throws DMLRuntimeException {
        KahanPlusSq kplusSq = KahanPlusSq.getKahanPlusSqFnObject();
        return this.sumWithFn(kplusSq);
    }

    private double sumWithFn(KahanFunction kfunc) throws DMLRuntimeException {
        PartialAggregate.CorrectionLocationType corrLoc = PartialAggregate.CorrectionLocationType.LASTCOLUMN;
        ReduceAll reduceAllObj = ReduceAll.getReduceAllFnObject();
        AggregateOperator aop = new AggregateOperator(0.0, kfunc, true, corrLoc);
        AggregateUnaryOperator auop = new AggregateUnaryOperator(aop, reduceAllObj);
        MatrixBlock out = new MatrixBlock(1, 2, false);
        LibMatrixAgg.aggregateUnaryMatrix(this, out, auop);
        return out.quickGetValue(0, 0);
    }

    @Override
    public boolean isInSparseFormat() {
        return this.sparse;
    }

    public boolean isUltraSparse() {
        return this.isUltraSparse(true);
    }

    public boolean isUltraSparse(boolean checkNnz) {
        double sp = (double)this.nonZeros / (double)this.rlen / (double)this.clen;
        return this.sparse && sp < 4.0E-5 && (!checkNnz || this.nonZeros < 40L);
    }

    public boolean isUltraSparsePermutationMatrix() {
        if (!this.isUltraSparse(false)) {
            return false;
        }
        boolean isPM = true;
        SparseBlock sblock = this.getSparseBlock();
        int i = 0;
        while (i < this.rlen & isPM) {
            isPM &= sblock.isEmpty(i) || sblock.size(i) == 1;
            ++i;
        }
        return isPM;
    }

    private boolean isUltraSparseSerialize(boolean sparseDst) {
        return this.nonZeros < (long)this.rlen && sparseDst;
    }

    public boolean evalSparseFormatInMemory() {
        long lrlen = this.rlen;
        long lclen = this.clen;
        long lnonZeros = this.nonZeros;
        if (lnonZeros <= 0L) {
            this.recomputeNonZeros();
            lnonZeros = this.nonZeros;
        }
        return MatrixBlock.evalSparseFormatInMemory(lrlen, lclen, lnonZeros);
    }

    private boolean evalSparseFormatInMemory(boolean transpose) {
        int lrlen = transpose ? this.clen : this.rlen;
        int lclen = transpose ? this.rlen : this.clen;
        long lnonZeros = this.nonZeros;
        if (lnonZeros <= 0L) {
            this.recomputeNonZeros();
            lnonZeros = this.nonZeros;
        }
        return MatrixBlock.evalSparseFormatInMemory(lrlen, lclen, lnonZeros);
    }

    public boolean evalSparseFormatOnDisk() {
        long lrlen = this.rlen;
        long lclen = this.clen;
        if (this.nonZeros <= 0L) {
            this.recomputeNonZeros();
        }
        return MatrixBlock.evalSparseFormatOnDisk(lrlen, lclen, this.nonZeros);
    }

    public void examSparsity() throws DMLRuntimeException {
        this.examSparsity(null);
    }

    public void examSparsity(String opcode) throws DMLRuntimeException {
        boolean sparseDst = this.evalSparseFormatInMemory();
        if (this.isEmptyBlock(false)) {
            this.cleanupBlock(true, true);
        }
        if (this.sparse && !sparseDst) {
            this.sparseToDense();
        } else if (!this.sparse && sparseDst) {
            this.denseToSparse();
        }
    }

    public static boolean evalSparseFormatInMemory(long nrows, long ncols, long nnz) {
        double lsparsity = (double)nnz / (double)nrows / (double)ncols;
        boolean lsparse = lsparsity < 0.4;
        double sizeSparse = MatrixBlock.estimateSizeSparseInMemory(nrows, ncols, lsparsity);
        double sizeDense = MatrixBlock.estimateSizeDenseInMemory(nrows, ncols);
        return lsparse && sizeSparse < sizeDense;
    }

    public static boolean evalSparseFormatOnDisk(long nrows, long ncols, long nnz) {
        double lsparsity = (double)nnz / (double)nrows / (double)ncols;
        boolean lsparse = lsparsity < 0.4;
        double sizeUltraSparse = MatrixBlock.estimateSizeUltraSparseOnDisk(nrows, ncols, nnz);
        double sizeSparse = MatrixBlock.estimateSizeSparseOnDisk(nrows, ncols, nnz);
        double sizeDense = MatrixBlock.estimateSizeDenseOnDisk(nrows, ncols);
        return lsparse && (sizeSparse < sizeDense || sizeUltraSparse < sizeDense);
    }

    private void denseToSparse() {
        this.sparse = true;
        if (this.denseBlock == null) {
            return;
        }
        double[] a = this.denseBlock;
        int m = this.rlen;
        int n = this.clen;
        int nnz = (int)this.nonZeros;
        int[] rptr = new int[m + 1];
        int[] indexes = new int[nnz];
        double[] values = new double[nnz];
        int pos = 0;
        int aix = 0;
        for (int i = 0; i < m; ++i) {
            int j = 0;
            while (j < n) {
                double aval = a[aix];
                if (aval != 0.0) {
                    indexes[pos] = j;
                    values[pos] = aval;
                    ++pos;
                }
                ++j;
                ++aix;
            }
            rptr[i + 1] = pos;
        }
        this.sparseBlock = new SparseBlockCSR(rptr, indexes, values, nnz);
        this.nonZeros = nnz;
        this.denseBlock = null;
    }

    public void sparseToDense() throws DMLRuntimeException {
        this.sparse = false;
        if (this.sparseBlock == null) {
            return;
        }
        int limit = this.rlen * this.clen;
        if (limit < 0) {
            throw new DMLRuntimeException("Unexpected error in sparseToDense().. limit < 0: " + this.rlen + ", " + this.clen + ", " + limit);
        }
        this.allocateDenseBlock(false);
        Arrays.fill(this.denseBlock, 0, limit, 0.0);
        SparseBlock a = this.sparseBlock;
        double[] c = this.denseBlock;
        int i = 0;
        int cix = 0;
        while (i < this.rlen) {
            if (!a.isEmpty(i)) {
                int apos = a.pos(i);
                int alen = a.size(i);
                int[] aix = a.indexes(i);
                double[] avals = a.values(i);
                for (int j = apos; j < apos + alen; ++j) {
                    if (avals[j] == 0.0) continue;
                    c[cix + aix[j]] = avals[j];
                }
            }
            ++i;
            cix += this.clen;
        }
        this.sparseBlock = null;
    }

    public long recomputeNonZeros() {
        return this.recomputeNonZeros(null);
    }

    public long recomputeNonZeros(String opcode) {
        long t1;
        long l = t1 = opcode != null && DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS ? System.nanoTime() : 0L;
        if (this.sparse && this.sparseBlock != null) {
            this.nonZeros = this.sparseBlock.size(0, this.sparseBlock.numRows());
        } else if (!this.sparse && this.denseBlock != null) {
            double[] a = this.denseBlock;
            int limit = this.rlen * this.clen;
            int nnz = 0;
            for (int i = 0; i < limit; ++i) {
                nnz += a[i] != 0.0 ? 1 : 0;
            }
            this.nonZeros = nnz;
        }
        if (opcode != null && DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS) {
            long t2 = System.nanoTime();
            GPUStatistics.maintainCPMiscTimes(opcode, "rnnz", t2 - t1);
        }
        return this.nonZeros;
    }

    public long recomputeNonZeros(int rl, int ru) {
        return this.recomputeNonZeros(rl, ru, 0, this.clen - 1);
    }

    public long recomputeNonZeros(int rl, int ru, int cl, int cu) {
        if (this.sparse && this.sparseBlock != null) {
            long nnz = 0L;
            if (cl == 0 && cu == this.clen - 1) {
                nnz = this.sparseBlock.size(rl, ru + 1);
            } else if (cl == cu) {
                int rlimit = Math.min(ru + 1, this.rlen);
                for (int i = rl; i < rlimit; ++i) {
                    if (this.sparseBlock.isEmpty(i)) continue;
                    nnz += this.sparseBlock.get(i, cl) != 0.0 ? 1L : 0L;
                }
            } else {
                nnz = this.sparseBlock.size(rl, ru + 1, cl, cu + 1);
            }
            return nnz;
        }
        if (!this.sparse && this.denseBlock != null) {
            double[] a = this.denseBlock;
            int n = this.clen;
            int nnz = 0;
            if (cl == 0 && cu == n - 1) {
                for (int i = rl * n; i < (ru + 1) * n; ++i) {
                    nnz += a[i] != 0.0 ? 1 : 0;
                }
            } else {
                int i = rl;
                int ix = rl * n;
                while (i <= ru) {
                    for (int j = cl; j <= cu; ++j) {
                        nnz += a[ix + j] != 0.0 ? 1 : 0;
                    }
                    ++i;
                    ix += n;
                }
            }
            return nnz;
        }
        return 0L;
    }

    public void checkNonZeros() {
        long nnzBefore = this.getNonZeros();
        this.recomputeNonZeros();
        long nnzAfter = this.getNonZeros();
        if (nnzBefore != nnzAfter) {
            throw new RuntimeException("Number of non zeros incorrect: " + nnzBefore + " vs " + nnzAfter);
        }
    }

    public void checkSparseRows() {
        if (!this.sparse || this.sparseBlock == null) {
            return;
        }
        for (int i = 0; i < this.rlen; ++i) {
            int k;
            if (this.sparseBlock.isEmpty(i)) continue;
            int apos = this.sparseBlock.pos(i);
            int alen = this.sparseBlock.size(i);
            int[] aix = this.sparseBlock.indexes(i);
            double[] avals = this.sparseBlock.values(i);
            for (k = apos + 1; k < apos + alen; ++k) {
                if (aix[k - 1] < aix[k]) continue;
                throw new RuntimeException("Wrong sparse row ordering: " + k + " " + aix[k - 1] + " " + aix[k]);
            }
            for (k = apos; k < apos + alen; ++k) {
                if (avals[k] != 0.0) continue;
                throw new RuntimeException("Wrong sparse row: zero at " + k);
            }
        }
    }

    @Override
    public void copy(MatrixValue thatValue) {
        MatrixBlock that = MatrixBlock.checkType(thatValue);
        this.copy(that, that.evalSparseFormatInMemory());
    }

    @Override
    public void copy(MatrixValue thatValue, boolean sp) {
        MatrixBlock that = MatrixBlock.checkType(thatValue);
        if (this == that) {
            throw new RuntimeException("Copy must not overwrite itself!");
        }
        this.rlen = that.rlen;
        this.clen = that.clen;
        this.sparse = sp;
        this.estimatedNNzsPerRow = (int)Math.ceil((double)thatValue.getNonZeros() / (double)this.rlen);
        if (this.sparse && that.sparse) {
            this.copySparseToSparse(that);
        } else if (this.sparse && !that.sparse) {
            this.copyDenseToSparse(that);
        } else if (!this.sparse && that.sparse) {
            this.copySparseToDense(that);
        } else {
            this.copyDenseToDense(that);
        }
    }

    public MatrixBlock copyShallow(MatrixBlock that) {
        this.rlen = that.rlen;
        this.clen = that.clen;
        this.nonZeros = that.nonZeros;
        this.sparse = that.sparse;
        if (!this.sparse) {
            this.denseBlock = that.denseBlock;
        } else {
            this.sparseBlock = that.sparseBlock;
        }
        return this;
    }

    private void copySparseToSparse(MatrixBlock that) {
        this.nonZeros = that.nonZeros;
        if (that.isEmptyBlock(false)) {
            this.resetSparse();
            return;
        }
        this.allocateSparseRowsBlock(false);
        for (int i = 0; i < Math.min(that.sparseBlock.numRows(), this.rlen); ++i) {
            if (!that.sparseBlock.isEmpty(i)) {
                this.sparseBlock.set(i, that.sparseBlock.get(i), true);
                continue;
            }
            if (this.sparseBlock.isEmpty(i)) continue;
            this.sparseBlock.reset(i, this.estimatedNNzsPerRow, this.clen);
        }
    }

    private void copyDenseToDense(MatrixBlock that) {
        this.nonZeros = that.nonZeros;
        int limit = this.rlen * this.clen;
        if (that.isEmptyBlock(false)) {
            if (this.denseBlock != null) {
                Arrays.fill(this.denseBlock, 0, limit, 0.0);
            }
            return;
        }
        this.allocateDenseBlock(false);
        System.arraycopy(that.denseBlock, 0, this.denseBlock, 0, limit);
    }

    private void copySparseToDense(MatrixBlock that) {
        this.nonZeros = that.nonZeros;
        if (that.isEmptyBlock(false)) {
            if (this.denseBlock != null) {
                Arrays.fill(this.denseBlock, 0.0);
            }
            return;
        }
        this.allocateDenseBlock(false);
        int start = 0;
        int r = 0;
        while (r < Math.min(that.sparseBlock.numRows(), this.rlen)) {
            if (!that.sparseBlock.isEmpty(r)) {
                int pos = that.sparseBlock.pos(r);
                int len = that.sparseBlock.size(r);
                int[] aix = that.sparseBlock.indexes(r);
                double[] avals = that.sparseBlock.values(r);
                for (int i = pos; i < pos + len; ++i) {
                    this.denseBlock[start + aix[i]] = avals[i];
                }
            }
            ++r;
            start += this.clen;
        }
    }

    private void copyDenseToSparse(MatrixBlock that) {
        this.nonZeros = that.nonZeros;
        if (that.isEmptyBlock(false)) {
            this.resetSparse();
            return;
        }
        this.allocateSparseRowsBlock(false);
        int ix = 0;
        for (int i = 0; i < this.rlen; ++i) {
            this.sparseBlock.reset(i, this.estimatedNNzsPerRow, this.clen);
            for (int j = 0; j < this.clen; ++j) {
                double val;
                if ((val = that.denseBlock[ix++]) == 0.0) continue;
                this.sparseBlock.allocate(i, this.estimatedNNzsPerRow, this.clen);
                this.sparseBlock.append(i, j, val);
            }
        }
    }

    public void copy(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) throws DMLRuntimeException {
        if (this.sparse && src.sparse) {
            this.copySparseToSparse(rl, ru, cl, cu, src, awareDestNZ);
        } else if (this.sparse && !src.sparse) {
            this.copyDenseToSparse(rl, ru, cl, cu, src, awareDestNZ);
        } else if (!this.sparse && src.sparse) {
            this.copySparseToDense(rl, ru, cl, cu, src, awareDestNZ);
        } else {
            this.copyDenseToDense(rl, ru, cl, cu, src, awareDestNZ);
        }
    }

    private void copySparseToSparse(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) {
        if (src.isEmptyBlock(false)) {
            if (awareDestNZ && this.sparseBlock != null) {
                this.copyEmptyToSparse(rl, ru, cl, cu, true);
            }
            return;
        }
        if (this.sparseBlock == null) {
            this.allocateSparseRowsBlock(false);
        } else if (awareDestNZ) {
            this.copyEmptyToSparse(rl, ru, cl, cu, true);
        }
        SparseBlock a = src.sparseBlock;
        SparseBlock b = this.sparseBlock;
        for (int i = 0; i < src.rlen; ++i) {
            int j;
            if (a.isEmpty(i)) continue;
            int apos = a.pos(i);
            int alen = a.size(i);
            int[] aix = a.indexes(i);
            double[] avals = a.values(i);
            if (b.isEmpty(rl + i)) {
                b.allocate(rl + i, this.estimatedNNzsPerRow, this.clen);
                for (j = apos; j < apos + alen; ++j) {
                    b.append(rl + i, cl + aix[j], avals[j]);
                }
                if (!awareDestNZ) continue;
                this.nonZeros += (long)b.size(rl + i);
                continue;
            }
            if (awareDestNZ) {
                int lnnz = b.size(rl + i);
                if (cl == cu && cl == aix[apos]) {
                    b.set(rl + i, cl, avals[apos]);
                } else {
                    b.deleteIndexRange(rl + i, cl, cu + 1);
                    for (int j2 = apos; j2 < apos + alen; ++j2) {
                        b.set(rl + i, cl + aix[j2], avals[j2]);
                    }
                }
                this.nonZeros += (long)(b.size(rl + i) - lnnz);
                continue;
            }
            for (j = apos; j < apos + alen; ++j) {
                b.set(rl + i, cl + aix[j], avals[j]);
            }
        }
    }

    private void copySparseToDense(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) throws DMLRuntimeException {
        if (src.isEmptyBlock(false)) {
            if (awareDestNZ && this.denseBlock != null) {
                this.nonZeros -= this.recomputeNonZeros(rl, ru, cl, cu);
                this.copyEmptyToDense(rl, ru, cl, cu);
            }
            return;
        }
        if (this.denseBlock == null) {
            this.allocateDenseBlock();
        } else if (awareDestNZ) {
            this.nonZeros -= this.recomputeNonZeros(rl, ru, cl, cu);
            this.copyEmptyToDense(rl, ru, cl, cu);
        }
        SparseBlock a = src.sparseBlock;
        int i = 0;
        int ix = rl * this.clen;
        while (i < src.rlen) {
            if (!a.isEmpty(i)) {
                int apos = a.pos(i);
                int alen = a.size(i);
                int[] aix = a.indexes(i);
                double[] avals = a.values(i);
                for (int j = apos; j < apos + alen; ++j) {
                    this.denseBlock[ix + cl + aix[j]] = avals[j];
                }
                if (awareDestNZ) {
                    this.nonZeros += (long)alen;
                }
            }
            ++i;
            ix += this.clen;
        }
    }

    private void copyDenseToSparse(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) {
        if (src.isEmptyBlock(false)) {
            if (awareDestNZ && this.sparseBlock != null) {
                this.copyEmptyToSparse(rl, ru, cl, cu, true);
            }
            return;
        }
        this.allocateSparseRowsBlock(false);
        SparseBlock a = this.sparseBlock;
        int i = 0;
        int ix = 0;
        while (i < src.rlen) {
            block11: {
                int lnnz;
                int rix;
                block10: {
                    int j;
                    rix = rl + i;
                    if (!(a instanceof SparseBlockMCSR) || !a.isEmpty(rix)) break block10;
                    lnnz = 0;
                    for (j = 0; j < src.clen; ++j) {
                        lnnz += src.denseBlock[ix + j] != 0.0 ? 1 : 0;
                    }
                    if (lnnz <= 0) break block11;
                    a.allocate(rix, lnnz);
                    for (j = 0; j < src.clen; ++j) {
                        double val = src.denseBlock[ix + j];
                        if (val == 0.0) continue;
                        a.append(rix, cl + j, val);
                    }
                    if (!awareDestNZ) break block11;
                    this.nonZeros += (long)lnnz;
                    break block11;
                }
                if (awareDestNZ) {
                    lnnz = a.size(rix);
                    if (cl == cu) {
                        double val = src.denseBlock[ix];
                        a.set(rix, cl, val);
                    } else {
                        a.setIndexRange(rix, cl, cu + 1, src.denseBlock, ix, src.clen);
                    }
                    this.nonZeros += (long)(a.size(rix) - lnnz);
                } else {
                    for (int j = 0; j < src.clen; ++j) {
                        double val = src.denseBlock[ix + j];
                        if (val == 0.0) continue;
                        a.set(rix, cl + j, val);
                    }
                }
            }
            ++i;
            ix += src.clen;
        }
    }

    private void copyDenseToDense(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) throws DMLRuntimeException {
        if (src.isEmptyBlock(false)) {
            if (awareDestNZ && this.denseBlock != null) {
                this.nonZeros -= this.recomputeNonZeros(rl, ru, cl, cu);
                this.copyEmptyToDense(rl, ru, cl, cu);
            }
            return;
        }
        this.allocateDenseBlock(false);
        if (awareDestNZ) {
            this.nonZeros = this.nonZeros - this.recomputeNonZeros(rl, ru, cl, cu) + src.nonZeros;
        }
        int rowLen = cu - cl + 1;
        if (this.clen == src.clen) {
            System.arraycopy(src.denseBlock, 0, this.denseBlock, rl * this.clen + cl, src.rlen * src.clen);
        } else {
            int i = 0;
            int ix1 = 0;
            int ix2 = rl * this.clen + cl;
            while (i < src.rlen) {
                System.arraycopy(src.denseBlock, ix1, this.denseBlock, ix2, rowLen);
                ++i;
                ix1 += src.clen;
                ix2 += this.clen;
            }
        }
    }

    private void copyEmptyToSparse(int rl, int ru, int cl, int cu, boolean updateNNZ) {
        SparseBlock a = this.sparseBlock;
        if (cl == cu) {
            for (int i = rl; i <= ru; ++i) {
                if (a.isEmpty(i)) continue;
                boolean update = a.set(i, cl, 0.0);
                if (!updateNNZ) continue;
                this.nonZeros -= update ? 1L : 0L;
            }
        } else {
            for (int i = rl; i <= ru; ++i) {
                if (a.isEmpty(i)) continue;
                int lnnz = a.size(i);
                a.deleteIndexRange(i, cl, cu + 1);
                if (!updateNNZ) continue;
                this.nonZeros += (long)(a.size(i) - lnnz);
            }
        }
    }

    private void copyEmptyToDense(int rl, int ru, int cl, int cu) {
        int rowLen = cu - cl + 1;
        if (this.clen == rowLen) {
            Arrays.fill(this.denseBlock, rl * this.clen + cl, ru * this.clen + cu + 1, 0.0);
        } else {
            int i = rl;
            int ix2 = rl * this.clen + cl;
            while (i <= ru) {
                Arrays.fill(this.denseBlock, ix2, ix2 + rowLen, 0.0);
                ++i;
                ix2 += this.clen;
            }
        }
    }

    @Override
    public void merge(CacheBlock that, boolean appendOnly) throws DMLRuntimeException {
        this.merge((MatrixBlock)that, appendOnly);
    }

    public void merge(MatrixBlock that, boolean appendOnly) throws DMLRuntimeException {
        if (that == null || that.isEmptyBlock(false)) {
            return;
        }
        if (this.rlen != that.rlen || this.clen != that.clen) {
            throw new DMLRuntimeException("Dimension mismatch on merge disjoint (target=" + this.rlen + "x" + this.clen + ", source=" + that.rlen + "x" + that.clen + ")");
        }
        if (this.nonZeros + that.nonZeros > (long)this.rlen * (long)this.clen) {
            throw new DMLRuntimeException("Number of non-zeros mismatch on merge disjoint (target=" + this.rlen + "x" + this.clen + ", nnz target=" + this.nonZeros + ", nnz source=" + that.nonZeros + ")");
        }
        if (this.isEmptyBlock(false) && (this.sparse || !this.isAllocated())) {
            this.copy(that);
            return;
        }
        long nnz = this.nonZeros + that.nonZeros;
        if (this.sparse) {
            this.mergeIntoSparse(that, appendOnly);
        } else {
            this.mergeIntoDense(that);
        }
        this.nonZeros = nnz;
    }

    private void mergeIntoDense(MatrixBlock that) {
        if (that.sparse) {
            double[] a = this.denseBlock;
            SparseBlock b = that.sparseBlock;
            int m = this.rlen;
            int n = this.clen;
            int i = 0;
            int aix = 0;
            while (i < m) {
                if (!b.isEmpty(i)) {
                    int bpos = b.pos(i);
                    int blen = b.size(i);
                    int[] bix = b.indexes(i);
                    double[] bval = b.values(i);
                    for (int j = bpos; j < bpos + blen; ++j) {
                        if (bval[j] == 0.0) continue;
                        a[aix + bix[j]] = bval[j];
                    }
                }
                ++i;
                aix += n;
            }
        } else {
            double[] a = this.denseBlock;
            double[] b = that.denseBlock;
            int len = this.rlen * this.clen;
            for (int i = 0; i < len; ++i) {
                a[i] = b[i] != 0.0 ? b[i] : a[i];
            }
        }
    }

    private void mergeIntoSparse(MatrixBlock that, boolean appendOnly) {
        if (that.sparse) {
            SparseBlock a = this.sparseBlock;
            SparseBlock b = that.sparseBlock;
            int m = this.rlen;
            for (int i = 0; i < m; ++i) {
                if (b.isEmpty(i)) continue;
                if (a.isEmpty(i)) {
                    a.set(i, b.get(i), true);
                    continue;
                }
                boolean appended = false;
                int bpos = b.pos(i);
                int blen = b.size(i);
                int[] bix = b.indexes(i);
                double[] bval = b.values(i);
                for (int j = bpos; j < bpos + blen; ++j) {
                    if (bval[j] == 0.0) continue;
                    a.append(i, bix[j], bval[j]);
                    appended = true;
                }
                if (appendOnly || !appended) continue;
                a.sort(i);
            }
        } else {
            SparseBlock a = this.sparseBlock;
            double[] b = that.denseBlock;
            int m = this.rlen;
            int n = this.clen;
            int i = 0;
            int bix = 0;
            while (i < m) {
                boolean appended = false;
                for (int j = 0; j < n; ++j) {
                    if (b[bix + j] == 0.0) continue;
                    this.appendValue(i, j, b[bix + j]);
                    appended = true;
                }
                if (!appendOnly && appended) {
                    a.sort(i);
                }
                ++i;
                bix += n;
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.rlen = in.readInt();
        this.clen = in.readInt();
        byte bformat = in.readByte();
        if (bformat < 0 || bformat >= BlockType.values().length) {
            throw new IOException("invalid format: '" + bformat + "' (need to be 0-" + BlockType.values().length + ").");
        }
        BlockType format = BlockType.values()[bformat];
        try {
            switch (format) {
                case ULTRA_SPARSE_BLOCK: {
                    this.nonZeros = this.readNnzInfo(in, true);
                    this.sparse = MatrixBlock.evalSparseFormatInMemory(this.rlen, this.clen, this.nonZeros);
                    this.cleanupBlock(true, !this.sparse || !(this.sparseBlock instanceof SparseBlockCSR));
                    if (this.sparse) {
                        this.readUltraSparseBlock(in);
                        break;
                    }
                    this.readUltraSparseToDense(in);
                    break;
                }
                case SPARSE_BLOCK: {
                    this.nonZeros = this.readNnzInfo(in, false);
                    this.sparse = MatrixBlock.evalSparseFormatInMemory(this.rlen, this.clen, this.nonZeros);
                    this.cleanupBlock(this.sparse, !this.sparse);
                    if (this.sparse) {
                        this.readSparseBlock(in);
                        break;
                    }
                    this.readSparseToDense(in);
                    break;
                }
                case DENSE_BLOCK: {
                    this.sparse = false;
                    this.cleanupBlock(false, true);
                    this.readDenseBlock(in);
                    break;
                }
                case EMPTY_BLOCK: {
                    this.sparse = true;
                    this.cleanupBlock(true, !(this.sparseBlock instanceof SparseBlockCSR));
                    if (this.sparseBlock != null) {
                        this.sparseBlock.reset();
                    }
                    this.nonZeros = 0L;
                }
            }
        }
        catch (DMLRuntimeException ex) {
            throw new IOException("Error reading block of type '" + format.toString() + "'.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDenseBlock(DataInput in) throws IOException, DMLRuntimeException {
        block4: {
            int limit;
            block5: {
                block3: {
                    this.allocateDenseBlock(true);
                    limit = this.rlen * this.clen;
                    if (!(in instanceof MatrixBlockDataInput)) break block3;
                    MatrixBlockDataInput mbin = (MatrixBlockDataInput)((Object)in);
                    this.nonZeros = mbin.readDoubleArray(limit, this.denseBlock);
                    break block4;
                }
                if (!(in instanceof DataInputBuffer)) break block5;
                DataInputBuffer din = (DataInputBuffer)in;
                FastBufferedDataInputStream mbin = null;
                try {
                    mbin = new FastBufferedDataInputStream((InputStream)din);
                    this.nonZeros = mbin.readDoubleArray(limit, this.denseBlock);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(mbin);
                    throw throwable;
                }
                IOUtilFunctions.closeSilently(mbin);
                break block4;
            }
            for (int i = 0; i < limit; ++i) {
                this.denseBlock[i] = in.readDouble();
                if (this.denseBlock[i] == 0.0) continue;
                ++this.nonZeros;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSparseBlock(DataInput in) throws IOException {
        block5: {
            block6: {
                block4: {
                    this.allocateSparseRowsBlock(false);
                    this.resetSparse();
                    if (!(in instanceof MatrixBlockDataInput)) break block4;
                    MatrixBlockDataInput mbin = (MatrixBlockDataInput)((Object)in);
                    this.nonZeros = mbin.readSparseRows(this.rlen, this.nonZeros, this.sparseBlock);
                    break block5;
                }
                if (!(in instanceof DataInputBuffer)) break block6;
                DataInputBuffer din = (DataInputBuffer)in;
                FastBufferedDataInputStream mbin = null;
                try {
                    mbin = new FastBufferedDataInputStream((InputStream)din);
                    this.nonZeros = mbin.readSparseRows(this.rlen, this.nonZeros, this.sparseBlock);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(mbin);
                    throw throwable;
                }
                IOUtilFunctions.closeSilently(mbin);
                break block5;
            }
            for (int r = 0; r < this.rlen; ++r) {
                int rnnz = in.readInt();
                if (rnnz <= 0) continue;
                this.sparseBlock.reset(r, rnnz, this.clen);
                for (int j = 0; j < rnnz; ++j) {
                    this.sparseBlock.append(r, in.readInt(), in.readDouble());
                }
            }
        }
    }

    private void readSparseToDense(DataInput in) throws IOException, DMLRuntimeException {
        this.allocateDenseBlock(false);
        Arrays.fill(this.denseBlock, 0.0);
        for (int r = 0; r < this.rlen; ++r) {
            int nr = in.readInt();
            for (int j = 0; j < nr; ++j) {
                double val;
                int c = in.readInt();
                this.denseBlock[r * this.clen + c] = val = in.readDouble();
            }
        }
    }

    private void readUltraSparseBlock(DataInput in) throws IOException {
        this.allocateAndResetSparseRowsBlock(false, SparseBlock.Type.CSR);
        if (this.clen > 1) {
            SparseBlockCSR sblockCSR = (SparseBlockCSR)this.sparseBlock;
            sblockCSR.initUltraSparse((int)this.nonZeros, in);
        } else {
            for (long i = 0L; i < this.nonZeros; ++i) {
                int r = in.readInt();
                double val = in.readDouble();
                this.sparseBlock.allocate(r, 1, 1);
                this.sparseBlock.append(r, 0, val);
            }
        }
    }

    private void readUltraSparseToDense(DataInput in) throws IOException, DMLRuntimeException {
        this.allocateDenseBlock(false);
        Arrays.fill(this.denseBlock, 0.0);
        if (this.clen > 1) {
            for (long i = 0L; i < this.nonZeros; ++i) {
                double val;
                int r = in.readInt();
                int c = in.readInt();
                this.denseBlock[r * this.clen + c] = val = in.readDouble();
            }
        } else {
            for (long i = 0L; i < this.nonZeros; ++i) {
                double val;
                int r = in.readInt();
                this.denseBlock[r] = val = in.readDouble();
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        boolean sparseSrc = this.sparse;
        boolean sparseDst = this.evalSparseFormatOnDisk();
        out.writeInt(this.rlen);
        out.writeInt(this.clen);
        if (sparseSrc) {
            if (this.sparseBlock == null || this.nonZeros == 0L) {
                MatrixBlock.writeEmptyBlock(out);
            } else if (this.isUltraSparseSerialize(sparseDst)) {
                this.writeSparseToUltraSparse(out);
            } else if (sparseDst) {
                this.writeSparseBlock(out);
            } else {
                this.writeSparseToDense(out);
            }
        } else if (this.denseBlock == null || this.nonZeros == 0L) {
            MatrixBlock.writeEmptyBlock(out);
        } else if (this.isUltraSparseSerialize(sparseDst)) {
            this.writeDenseToUltraSparse(out);
        } else if (sparseDst) {
            this.writeDenseToSparse(out);
        } else {
            this.writeDenseBlock(out);
        }
    }

    private static void writeEmptyBlock(DataOutput out) throws IOException {
        out.writeByte(BlockType.EMPTY_BLOCK.ordinal());
    }

    private void writeDenseBlock(DataOutput out) throws IOException {
        out.writeByte(BlockType.DENSE_BLOCK.ordinal());
        int limit = this.rlen * this.clen;
        if (out instanceof MatrixBlockDataOutput) {
            ((MatrixBlockDataOutput)((Object)out)).writeDoubleArray(limit, this.denseBlock);
        } else {
            for (int i = 0; i < limit; ++i) {
                out.writeDouble(this.denseBlock[i]);
            }
        }
    }

    private void writeSparseBlock(DataOutput out) throws IOException {
        out.writeByte(BlockType.SPARSE_BLOCK.ordinal());
        this.writeNnzInfo(out, false);
        if (out instanceof MatrixBlockDataOutput) {
            ((MatrixBlockDataOutput)((Object)out)).writeSparseRows(this.rlen, this.sparseBlock);
        } else {
            int r;
            for (r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                if (this.sparseBlock.isEmpty(r)) {
                    out.writeInt(0);
                    continue;
                }
                int pos = this.sparseBlock.pos(r);
                int nr = this.sparseBlock.size(r);
                int[] cols = this.sparseBlock.indexes(r);
                double[] values = this.sparseBlock.values(r);
                out.writeInt(nr);
                for (int j = pos; j < pos + nr; ++j) {
                    out.writeInt(cols[j]);
                    out.writeDouble(values[j]);
                }
            }
            while (r < this.rlen) {
                out.writeInt(0);
                ++r;
            }
        }
    }

    private void writeSparseToUltraSparse(DataOutput out) throws IOException {
        out.writeByte(BlockType.ULTRA_SPARSE_BLOCK.ordinal());
        this.writeNnzInfo(out, true);
        long wnnz = 0L;
        if (this.clen > 1) {
            for (int r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                if (this.sparseBlock.isEmpty(r)) continue;
                int apos = this.sparseBlock.pos(r);
                int alen = this.sparseBlock.size(r);
                int[] aix = this.sparseBlock.indexes(r);
                double[] avals = this.sparseBlock.values(r);
                for (int j = apos; j < apos + alen; ++j) {
                    out.writeInt(r);
                    out.writeInt(aix[j]);
                    out.writeDouble(avals[j]);
                    ++wnnz;
                }
            }
        } else {
            for (int r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                if (this.sparseBlock.isEmpty(r)) continue;
                int pos = this.sparseBlock.pos(r);
                out.writeInt(r);
                out.writeDouble(this.sparseBlock.values(r)[pos]);
                ++wnnz;
            }
        }
        if (this.nonZeros != wnnz) {
            throw new IOException("Invalid number of serialized non-zeros: " + wnnz + " (expected: " + this.nonZeros + ")");
        }
    }

    private void writeSparseToDense(DataOutput out) throws IOException {
        out.writeByte(BlockType.DENSE_BLOCK.ordinal());
        if (this.sparseBlock == null) {
            for (int i = 0; i < this.rlen * this.clen; ++i) {
                out.writeDouble(0.0);
            }
        } else {
            SparseBlock a = this.sparseBlock;
            for (int i = 0; i < this.rlen; ++i) {
                if (i < a.numRows() && !a.isEmpty(i)) {
                    int apos = a.pos(i);
                    int alen = a.size(i);
                    int[] aix = a.indexes(i);
                    double[] avals = a.values(i);
                    int j = 0;
                    for (int j2 = 0; j2 < alen; ++j2) {
                        while (j < aix[apos + j2]) {
                            out.writeDouble(0.0);
                            ++j;
                        }
                        out.writeDouble(avals[apos + j2]);
                        ++j;
                    }
                    for (j = aix[apos + alen - 1] + 1; j < this.clen; ++j) {
                        out.writeDouble(0.0);
                    }
                    continue;
                }
                for (int j = 0; j < this.clen; ++j) {
                    out.writeDouble(0.0);
                }
            }
        }
    }

    private void writeDenseToUltraSparse(DataOutput out) throws IOException {
        out.writeByte(BlockType.ULTRA_SPARSE_BLOCK.ordinal());
        this.writeNnzInfo(out, true);
        long wnnz = 0L;
        if (this.clen > 1) {
            int ix = 0;
            for (int r = 0; r < this.rlen; ++r) {
                int c = 0;
                while (c < this.clen) {
                    if (this.denseBlock[ix] != 0.0) {
                        out.writeInt(r);
                        out.writeInt(c);
                        out.writeDouble(this.denseBlock[ix]);
                        ++wnnz;
                    }
                    ++c;
                    ++ix;
                }
            }
        } else {
            for (int r = 0; r < this.rlen; ++r) {
                if (this.denseBlock[r] == 0.0) continue;
                out.writeInt(r);
                out.writeDouble(this.denseBlock[r]);
                ++wnnz;
            }
        }
        if (this.nonZeros != wnnz) {
            throw new IOException("Invalid number of serialized non-zeros: " + wnnz + " (expected: " + this.nonZeros + ")");
        }
    }

    private void writeDenseToSparse(DataOutput out) throws IOException {
        out.writeByte(BlockType.SPARSE_BLOCK.ordinal());
        this.writeNnzInfo(out, false);
        int start = 0;
        for (int r = 0; r < this.rlen; ++r) {
            int nr = 0;
            for (int i = start; i < start + this.clen; ++i) {
                if (this.denseBlock[i] == 0.0) continue;
                ++nr;
            }
            out.writeInt(nr);
            for (int c = 0; c < this.clen; ++c) {
                if (this.denseBlock[start] != 0.0) {
                    out.writeInt(c);
                    out.writeDouble(this.denseBlock[start]);
                }
                ++start;
            }
        }
    }

    private long readNnzInfo(DataInput in, boolean ultrasparse) throws IOException {
        long lrlen = this.rlen;
        long lclen = this.clen;
        this.nonZeros = lrlen * lclen > Integer.MAX_VALUE && !ultrasparse ? in.readLong() : (long)in.readInt();
        return this.nonZeros;
    }

    private void writeNnzInfo(DataOutput out, boolean ultrasparse) throws IOException {
        long lrlen = this.rlen;
        long lclen = this.clen;
        if (lrlen * lclen > Integer.MAX_VALUE && !ultrasparse) {
            out.writeLong(this.nonZeros);
        } else {
            out.writeInt((int)this.nonZeros);
        }
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        if (is instanceof ObjectInputStream) {
            ObjectInputStream ois = (ObjectInputStream)is;
            FastBufferedDataInputStream fis = new FastBufferedDataInputStream(ois);
            this.readFields(fis);
        } else {
            this.readFields(is);
        }
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        if (os instanceof ObjectOutputStream) {
            ObjectOutputStream oos = (ObjectOutputStream)os;
            FastBufferedDataOutputStream fos = new FastBufferedDataOutputStream(oos);
            this.write(fos);
            fos.flush();
        } else {
            this.write(os);
        }
    }

    public long getExactSizeOnDisk() {
        boolean sparseSrc = this.sparse;
        boolean sparseDst = this.evalSparseFormatOnDisk();
        long lrlen = this.rlen;
        long lclen = this.clen;
        long lnonZeros = this.nonZeros;
        if (lnonZeros <= 0L) {
            this.recomputeNonZeros();
            lnonZeros = this.nonZeros;
        }
        if (sparseSrc) {
            if (this.sparseBlock == null || lnonZeros == 0L) {
                return 9L;
            }
            if (lnonZeros < lrlen && sparseDst) {
                return MatrixBlock.estimateSizeUltraSparseOnDisk(lrlen, lclen, lnonZeros);
            }
            if (sparseDst) {
                return MatrixBlock.estimateSizeSparseOnDisk(lrlen, lclen, lnonZeros);
            }
            return MatrixBlock.estimateSizeDenseOnDisk(lrlen, lclen);
        }
        if (this.denseBlock == null || lnonZeros == 0L) {
            return 9L;
        }
        if (lnonZeros < lrlen && sparseDst) {
            return MatrixBlock.estimateSizeUltraSparseOnDisk(lrlen, lclen, lnonZeros);
        }
        if (sparseDst) {
            return MatrixBlock.estimateSizeSparseOnDisk(lrlen, lclen, lnonZeros);
        }
        return MatrixBlock.estimateSizeDenseOnDisk(lrlen, lclen);
    }

    public long estimateSizeInMemory() {
        return MatrixBlock.estimateSizeInMemory(this.rlen, this.clen, this.getSparsity());
    }

    public static long estimateSizeInMemory(long nrows, long ncols, double sparsity) {
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(nrows, ncols, (long)(sparsity * (double)nrows * (double)ncols));
        if (sparse) {
            return MatrixBlock.estimateSizeSparseInMemory(nrows, ncols, sparsity);
        }
        return MatrixBlock.estimateSizeDenseInMemory(nrows, ncols);
    }

    public static long estimateSizeDenseInMemory(long nrows, long ncols) {
        double size = 44.0;
        return (long)Math.min(size += 8.0 * (double)nrows * (double)ncols, 9.223372036854776E18);
    }

    public static long estimateSizeSparseInMemory(long nrows, long ncols, double sparsity) {
        return MatrixBlock.estimateSizeSparseInMemory(nrows, ncols, sparsity, DEFAULT_SPARSEBLOCK);
    }

    public static long estimateSizeSparseInMemory(long nrows, long ncols, double sparsity, SparseBlock.Type stype) {
        double size = 44.0;
        return (long)Math.min(size += (double)SparseBlockFactory.estimateSizeSparseInMemory(stype, nrows, ncols, sparsity), 9.223372036854776E18);
    }

    public long estimateSizeOnDisk() {
        return MatrixBlock.estimateSizeOnDisk(this.rlen, this.clen, this.nonZeros);
    }

    public static long estimateSizeOnDisk(long nrows, long ncols, long nnz) {
        boolean sparse = MatrixBlock.evalSparseFormatOnDisk(nrows, ncols, nnz);
        if (sparse && nnz < nrows) {
            return MatrixBlock.estimateSizeUltraSparseOnDisk(nrows, ncols, nnz);
        }
        if (sparse) {
            return MatrixBlock.estimateSizeSparseOnDisk(nrows, ncols, nnz);
        }
        return MatrixBlock.estimateSizeDenseOnDisk(nrows, ncols);
    }

    private static long estimateSizeDenseOnDisk(long nrows, long ncols) {
        long size = 9L;
        return size += nrows * ncols * 8L;
    }

    private static long estimateSizeSparseOnDisk(long nrows, long ncols, long nnz) {
        long size = 9L;
        size += nrows * ncols > Integer.MAX_VALUE ? 8L : 4L;
        return size += nrows * 4L + nnz * 12L;
    }

    private static long estimateSizeUltraSparseOnDisk(long nrows, long ncols, long nnz) {
        long size = 9L;
        size += 4L;
        size = ncols > 1L ? (size += nnz * 16L) : (size += nnz * 12L);
        return size;
    }

    public static SparsityEstimate estimateSparsityOnAggBinary(MatrixBlock m1, MatrixBlock m2, AggregateBinaryOperator op) {
        boolean ultrasparse = m1.isUltraSparse() || m2.isUltraSparse();
        return new SparsityEstimate(ultrasparse, m1.getNumRows() * m2.getNumRows());
    }

    private static SparsityEstimate estimateSparsityOnBinary(MatrixBlock m1, MatrixBlock m2, BinaryOperator op) {
        SparsityEstimate est = new SparsityEstimate();
        if (!op.sparseSafe && !(op.fn instanceof Divide)) {
            est.sparse = false;
            return est;
        }
        LibMatrixBincell.BinaryAccessType atype = LibMatrixBincell.getBinaryAccessType(m1, m2);
        boolean outer = atype == LibMatrixBincell.BinaryAccessType.OUTER_VECTOR_VECTOR;
        long m = m1.getNumRows();
        long n = outer ? (long)m2.getNumColumns() : (long)m1.getNumColumns();
        long nz1 = m1.getNonZeros();
        long nz2 = m2.getNonZeros();
        long estnnz = 0L;
        if (atype == LibMatrixBincell.BinaryAccessType.OUTER_VECTOR_VECTOR) {
            estnnz = nz1 * nz2;
        } else {
            if (atype == LibMatrixBincell.BinaryAccessType.MATRIX_COL_VECTOR) {
                nz2 *= n;
            } else if (atype == LibMatrixBincell.BinaryAccessType.MATRIX_ROW_VECTOR) {
                nz2 *= m;
            }
            double sp1 = OptimizerUtils.getSparsity(m, n, nz1);
            double sp2 = OptimizerUtils.getSparsity(m, n, nz2);
            double spout = OptimizerUtils.getBinaryOpSparsity(sp1, sp2, op.getBinaryOperatorOpOp2(), true);
            estnnz = UtilFunctions.toLong(spout * (double)m * (double)n);
        }
        est.sparse = MatrixBlock.evalSparseFormatInMemory(m, n, estnnz);
        est.estimatedNonZeros = estnnz;
        return est;
    }

    private boolean estimateSparsityOnSlice(int selectRlen, int selectClen, int finalRlen, int finalClen) {
        long ennz = (long)((double)this.nonZeros / (double)this.rlen / (double)this.clen * (double)selectRlen * (double)selectClen);
        return MatrixBlock.evalSparseFormatInMemory(finalRlen, finalClen, ennz);
    }

    private static boolean estimateSparsityOnLeftIndexing(long rlenm1, long clenm1, long nnzm1, long rlenm2, long clenm2, long nnzm2) {
        long ennz = Math.min(rlenm1 * clenm1, nnzm1 + nnzm2);
        return MatrixBlock.evalSparseFormatInMemory(rlenm1, clenm1, ennz);
    }

    private static boolean estimateSparsityOnGroupedAgg(long rlen, long groups) {
        long ennz = Math.min(groups, rlen);
        return MatrixBlock.evalSparseFormatInMemory(groups, 1L, ennz);
    }

    @Override
    public long getInMemorySize() {
        if (!this.isAllocated()) {
            return 44L;
        }
        return !this.sparse ? MatrixBlock.estimateSizeDenseInMemory(this.rlen, this.clen) : MatrixBlock.estimateSizeSparseInMemory(this.rlen, this.clen, this.getSparsity(), SparseBlockFactory.getSparseBlockType(this.sparseBlock));
    }

    @Override
    public long getExactSerializedSize() {
        return this.getExactSizeOnDisk();
    }

    @Override
    public boolean isShallowSerialize() {
        return this.isShallowSerialize(false);
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        boolean sparseDst = this.evalSparseFormatOnDisk();
        return !this.sparse || !sparseDst || this.sparse && this.sparseBlock instanceof SparseBlockCSR || this.sparse && this.sparseBlock instanceof SparseBlockMCSR && (double)this.getInMemorySize() / 1.3 <= (double)this.getExactSerializedSize() || this.sparse && this.sparseBlock instanceof SparseBlockMCSR && this.nonZeros < Integer.MAX_VALUE && inclConvert && !this.isUltraSparseSerialize(sparseDst);
    }

    @Override
    public void toShallowSerializeBlock() {
        if (this.isShallowSerialize() || !this.isShallowSerialize(true)) {
            return;
        }
        this.sparseBlock = SparseBlockFactory.copySparseBlock(SparseBlock.Type.CSR, this.sparseBlock, false);
    }

    @Override
    public void compactEmptyBlock() {
        if (this.isEmptyBlock(false) && this.isAllocated()) {
            this.cleanupBlock(true, true);
        }
    }

    @Override
    public MatrixValue scalarOperations(ScalarOperator op, MatrixValue result) throws DMLRuntimeException {
        MatrixBlock ret = MatrixBlock.checkType(result);
        boolean sp = this.sparse;
        if (!op.sparseSafe) {
            sp = false;
        }
        if (ret == null) {
            ret = new MatrixBlock(this.rlen, this.clen, sp, this.nonZeros);
        } else {
            ret.reset(this.rlen, this.clen, sp, this.nonZeros);
        }
        LibMatrixBincell.bincellOp(this, ret, op);
        return ret;
    }

    @Override
    public MatrixValue unaryOperations(UnaryOperator op, MatrixValue result) throws DMLRuntimeException {
        MatrixBlock ret = MatrixBlock.checkType(result);
        boolean sp = this.sparse;
        if (!op.sparseSafe) {
            sp = false;
        }
        if (ret == null) {
            ret = new MatrixBlock(this.rlen, this.clen, sp, this.nonZeros);
        } else {
            ret.reset(this.rlen, this.clen, sp);
        }
        if (LibMatrixAgg.isSupportedUnaryOperator(op)) {
            if (op.getNumThreads() > 1) {
                LibMatrixAgg.cumaggregateUnaryMatrix(this, ret, op, op.getNumThreads());
            } else {
                LibMatrixAgg.cumaggregateUnaryMatrix(this, ret, op);
            }
        } else if (op.sparseSafe) {
            this.sparseUnaryOperations(op, ret);
        } else {
            this.denseUnaryOperations(op, ret);
        }
        if (ret.isEmptyBlock(false)) {
            ret.examSparsity();
        }
        return ret;
    }

    private void sparseUnaryOperations(UnaryOperator op, MatrixBlock ret) throws DMLRuntimeException {
        if (this.isEmptyBlock(false)) {
            return;
        }
        int m = this.rlen;
        int n = this.clen;
        if (this.sparse && ret.sparse) {
            ret.allocateSparseRowsBlock();
            SparseBlock a = this.sparseBlock;
            SparseBlock c = ret.sparseBlock;
            long nnz = 0L;
            for (int i = 0; i < m; ++i) {
                if (a.isEmpty(i)) continue;
                int apos = a.pos(i);
                int alen = a.size(i);
                int[] aix = a.indexes(i);
                double[] avals = a.values(i);
                c.allocate(i, alen);
                for (int j = apos; j < apos + alen; ++j) {
                    double val = op.fn.execute(avals[j]);
                    c.append(i, aix[j], val);
                    nnz += val != 0.0 ? 1L : 0L;
                }
            }
            ret.nonZeros = nnz;
        } else if (this.sparse) {
            SparseBlock a = this.sparseBlock;
            for (int i = 0; i < m; ++i) {
                if (a.isEmpty(i)) continue;
                int apos = a.pos(i);
                int alen = a.size(i);
                int[] aix = a.indexes(i);
                double[] avals = a.values(i);
                for (int j = apos; j < apos + alen; ++j) {
                    double val = op.fn.execute(avals[j]);
                    ret.appendValue(i, aix[j], val);
                }
            }
        } else {
            ret.allocateDenseBlock();
            double[] a = this.denseBlock;
            double[] c = ret.denseBlock;
            int len = m * n;
            int nnz = 0;
            for (int i = 0; i < len; ++i) {
                c[i] = op.fn.execute(a[i]);
                nnz += c[i] != 0.0 ? 1 : 0;
            }
            ret.nonZeros = nnz;
        }
    }

    private void denseUnaryOperations(UnaryOperator op, MatrixBlock ret) throws DMLRuntimeException {
        double val0 = op.fn.execute(0L);
        int m = this.rlen;
        int n = this.clen;
        if (this.isEmptyBlock(false)) {
            if (val0 != 0.0) {
                ret.reset(m, n, val0);
            }
            return;
        }
        if (this.sparse && val0 != 0.0) {
            ret.reset(m, n, val0);
        }
        this.sparseUnaryOperations(op, ret);
    }

    @Override
    public void unaryOperationsInPlace(UnaryOperator op) throws DMLRuntimeException {
        if (op.sparseSafe) {
            this.sparseUnaryOperationsInPlace(op);
        } else {
            this.denseUnaryOperationsInPlace(op);
        }
    }

    private void sparseUnaryOperationsInPlace(UnaryOperator op) throws DMLRuntimeException {
        if (this.isEmptyBlock(false)) {
            return;
        }
        if (this.sparse) {
            this.nonZeros = 0L;
            for (int r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                if (this.sparseBlock.isEmpty(r)) continue;
                int apos = this.sparseBlock.pos(r);
                int alen = this.sparseBlock.size(r);
                int[] aix = this.sparseBlock.indexes(r);
                double[] avals = this.sparseBlock.values(r);
                int pos = 0;
                for (int i = apos; i < apos + alen; ++i) {
                    double v = op.fn.execute(avals[i]);
                    if (v == 0.0) continue;
                    avals[pos] = v;
                    aix[pos] = aix[i];
                    ++pos;
                    ++this.nonZeros;
                }
                this.sparseBlock.deleteIndexRange(r, pos, this.clen);
            }
        } else {
            int limit = this.rlen * this.clen;
            this.nonZeros = 0L;
            for (int i = 0; i < limit; ++i) {
                this.denseBlock[i] = op.fn.execute(this.denseBlock[i]);
                if (this.denseBlock[i] == 0.0) continue;
                ++this.nonZeros;
            }
        }
    }

    private void denseUnaryOperationsInPlace(UnaryOperator op) throws DMLRuntimeException {
        if (this.sparse) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    double v = op.fn.execute(this.quickGetValue(r, c));
                    this.quickSetValue(r, c, v);
                }
            }
        } else {
            if (this.denseBlock == null) {
                this.allocateDenseBlock();
            }
            int limit = this.rlen * this.clen;
            int lnnz = 0;
            for (int i = 0; i < limit; ++i) {
                this.denseBlock[i] = op.fn.execute(this.denseBlock[i]);
                if (this.denseBlock[i] == 0.0) continue;
                ++lnnz;
            }
            this.nonZeros = lnnz;
        }
    }

    @Override
    public MatrixValue binaryOperations(BinaryOperator op, MatrixValue thatValue, MatrixValue result) throws DMLRuntimeException {
        MatrixBlock that = MatrixBlock.checkType(thatValue);
        MatrixBlock ret = MatrixBlock.checkType(result);
        if (!LibMatrixBincell.isValidDimensionsBinary(this, that)) {
            throw new RuntimeException("Block sizes are not matched for binary cell operations: " + this.rlen + "x" + this.clen + " vs " + that.rlen + "x" + that.clen);
        }
        boolean outer = LibMatrixBincell.getBinaryAccessType(this, that) == LibMatrixBincell.BinaryAccessType.OUTER_VECTOR_VECTOR;
        int rows = this.rlen;
        int cols = outer ? that.clen : this.clen;
        SparsityEstimate resultSparse = MatrixBlock.estimateSparsityOnBinary(this, that, op);
        if (ret == null) {
            ret = new MatrixBlock(rows, cols, resultSparse.sparse, resultSparse.estimatedNonZeros);
        } else {
            ret.reset(rows, cols, resultSparse.sparse, resultSparse.estimatedNonZeros);
        }
        LibMatrixBincell.bincellOp(this, that, ret, op);
        return ret;
    }

    @Override
    public void binaryOperationsInPlace(BinaryOperator op, MatrixValue thatValue) throws DMLRuntimeException {
        MatrixBlock that = MatrixBlock.checkType(thatValue);
        if (!LibMatrixBincell.isValidDimensionsBinary(this, that)) {
            throw new RuntimeException("block sizes are not matched for binary cell operations: " + this.rlen + "*" + this.clen + " vs " + that.rlen + "*" + that.clen);
        }
        SparsityEstimate resultSparse = MatrixBlock.estimateSparsityOnBinary(this, that, op);
        if (resultSparse.sparse && !this.sparse) {
            this.denseToSparse();
        } else if (!resultSparse.sparse && this.sparse) {
            this.sparseToDense();
        }
        LibMatrixBincell.bincellOpInPlace(this, that, op);
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue correction, MatrixValue newWithCorrection) throws DMLRuntimeException {
        MatrixBlock cor = MatrixBlock.checkType(correction);
        MatrixBlock newWithCor = MatrixBlock.checkType(newWithCorrection);
        KahanObject buffer = new KahanObject(0.0, 0.0);
        if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTROW) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    buffer._correction = cor.quickGetValue(0, c);
                    buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.quickGetValue(r, c), newWithCor.quickGetValue(r + 1, c));
                    this.quickSetValue(r, c, buffer._sum);
                    cor.quickSetValue(0, c, buffer._correction);
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTCOLUMN) {
            if (aggOp.increOp.fn instanceof Builtin && (((Builtin)aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MAXINDEX || ((Builtin)aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MININDEX)) {
                for (int r = 0; r < this.rlen; ++r) {
                    double currMaxValue = cor.quickGetValue(r, 0);
                    long newMaxIndex = (long)newWithCor.quickGetValue(r, 0);
                    double newMaxValue = newWithCor.quickGetValue(r, 1);
                    double update = aggOp.increOp.fn.execute(newMaxValue, currMaxValue);
                    if (2.0 == update) {
                        long curMaxIndex = (long)this.quickGetValue(r, 0);
                        this.quickSetValue(r, 0, Math.max(curMaxIndex, newMaxIndex));
                        continue;
                    }
                    if (1.0 != update) continue;
                    this.quickSetValue(r, 0, newMaxIndex);
                    cor.quickSetValue(r, 0, newMaxValue);
                }
            } else {
                for (int r = 0; r < this.rlen; ++r) {
                    for (int c = 0; c < this.clen; ++c) {
                        buffer._sum = this.quickGetValue(r, c);
                        buffer._correction = cor.quickGetValue(r, 0);
                        buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.quickGetValue(r, c), newWithCor.quickGetValue(r, c + 1));
                        this.quickSetValue(r, c, buffer._sum);
                        cor.quickSetValue(r, 0, buffer._correction);
                    }
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.NONE) {
            if (aggOp.increOp.fn instanceof KahanPlus) {
                LibMatrixAgg.aggregateBinaryMatrix(newWithCor, this, cor);
            } else {
                if (newWithCor.isInSparseFormat() && aggOp.sparseSafe) {
                    SparseBlock b = newWithCor.getSparseBlock();
                    if (b == null) {
                        return;
                    }
                    for (int r = 0; r < Math.min(this.rlen, b.numRows()); ++r) {
                        if (b.isEmpty(r)) continue;
                        int bpos = b.pos(r);
                        int blen = b.size(r);
                        int[] bix = b.indexes(r);
                        double[] bvals = b.values(r);
                        for (int j = bpos; j < bpos + blen; ++j) {
                            int c = bix[j];
                            buffer._sum = this.quickGetValue(r, c);
                            buffer._correction = cor.quickGetValue(r, c);
                            buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, bvals[j]);
                            this.quickSetValue(r, c, buffer._sum);
                            cor.quickSetValue(r, c, buffer._correction);
                        }
                    }
                } else {
                    for (int r = 0; r < this.rlen; ++r) {
                        for (int c = 0; c < this.clen; ++c) {
                            buffer._sum = this.quickGetValue(r, c);
                            buffer._correction = cor.quickGetValue(r, c);
                            buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, newWithCor.quickGetValue(r, c));
                            this.quickSetValue(r, c, buffer._sum);
                            cor.quickSetValue(r, c, buffer._correction);
                        }
                    }
                }
                this.examSparsity();
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOROWS) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    double n = cor.quickGetValue(0, c);
                    buffer._correction = cor.quickGetValue(1, c);
                    double mu2 = newWithCor.quickGetValue(r, c);
                    double n2 = newWithCor.quickGetValue(r + 1, c);
                    double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
                    buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
                    this.quickSetValue(r, c, buffer._sum);
                    cor.quickSetValue(0, c, n);
                    cor.quickSetValue(1, c, buffer._correction);
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    double n = cor.quickGetValue(r, 0);
                    buffer._correction = cor.quickGetValue(r, 1);
                    double mu2 = newWithCor.quickGetValue(r, c);
                    double n2 = newWithCor.quickGetValue(r, c + 1);
                    double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
                    buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
                    this.quickSetValue(r, c, buffer._sum);
                    cor.quickSetValue(r, 0, n);
                    cor.quickSetValue(r, 1, buffer._correction);
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTFOURROWS && aggOp.increOp.fn instanceof CM && ((CM)aggOp.increOp.fn).getAggOpType() == CMOperator.AggregateOperationTypes.VARIANCE) {
            CM_COV_Object cbuff_curr = new CM_COV_Object();
            CM_COV_Object cbuff_part = new CM_COV_Object();
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    cbuff_curr.w = cor.quickGetValue(1, c);
                    cbuff_curr.m2._sum = this.quickGetValue(r, c) * (cbuff_curr.w - 1.0);
                    cbuff_curr.mean._sum = cor.quickGetValue(0, c);
                    cbuff_curr.m2._correction = cor.quickGetValue(2, c);
                    cbuff_curr.mean._correction = cor.quickGetValue(3, c);
                    cbuff_part.w = newWithCor.quickGetValue(r + 2, c);
                    cbuff_part.m2._sum = newWithCor.quickGetValue(r, c) * (cbuff_part.w - 1.0);
                    cbuff_part.mean._sum = newWithCor.quickGetValue(r + 1, c);
                    cbuff_part.m2._correction = newWithCor.quickGetValue(r + 3, c);
                    cbuff_part.mean._correction = newWithCor.quickGetValue(r + 4, c);
                    cbuff_curr = (CM_COV_Object)aggOp.increOp.fn.execute((Data)cbuff_curr, cbuff_part);
                    double var = cbuff_curr.getRequiredResult(CMOperator.AggregateOperationTypes.VARIANCE);
                    this.quickSetValue(r, c, var);
                    cor.quickSetValue(0, c, cbuff_curr.mean._sum);
                    cor.quickSetValue(1, c, cbuff_curr.w);
                    cor.quickSetValue(2, c, cbuff_curr.m2._correction);
                    cor.quickSetValue(3, c, cbuff_curr.mean._correction);
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTFOURCOLUMNS && aggOp.increOp.fn instanceof CM && ((CM)aggOp.increOp.fn).getAggOpType() == CMOperator.AggregateOperationTypes.VARIANCE) {
            CM_COV_Object cbuff_curr = new CM_COV_Object();
            CM_COV_Object cbuff_part = new CM_COV_Object();
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    cbuff_curr.w = cor.quickGetValue(r, 1);
                    cbuff_curr.m2._sum = this.quickGetValue(r, c) * (cbuff_curr.w - 1.0);
                    cbuff_curr.mean._sum = cor.quickGetValue(r, 0);
                    cbuff_curr.m2._correction = cor.quickGetValue(r, 2);
                    cbuff_curr.mean._correction = cor.quickGetValue(r, 3);
                    cbuff_part.w = newWithCor.quickGetValue(r, c + 2);
                    cbuff_part.m2._sum = newWithCor.quickGetValue(r, c) * (cbuff_part.w - 1.0);
                    cbuff_part.mean._sum = newWithCor.quickGetValue(r, c + 1);
                    cbuff_part.m2._correction = newWithCor.quickGetValue(r, c + 3);
                    cbuff_part.mean._correction = newWithCor.quickGetValue(r, c + 4);
                    cbuff_curr = (CM_COV_Object)aggOp.increOp.fn.execute((Data)cbuff_curr, cbuff_part);
                    double var = cbuff_curr.getRequiredResult(CMOperator.AggregateOperationTypes.VARIANCE);
                    this.quickSetValue(r, c, var);
                    cor.quickSetValue(r, 0, cbuff_curr.mean._sum);
                    cor.quickSetValue(r, 1, cbuff_curr.w);
                    cor.quickSetValue(r, 2, cbuff_curr.m2._correction);
                    cor.quickSetValue(r, 3, cbuff_curr.mean._correction);
                }
            }
        } else {
            throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)((Object)aggOp.correctionLocation));
        }
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue newWithCorrection) throws DMLRuntimeException {
        MatrixBlock newWithCor = MatrixBlock.checkType(newWithCorrection);
        KahanObject buffer = new KahanObject(0.0, 0.0);
        if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTROW) {
            if (aggOp.increOp.fn instanceof KahanPlus) {
                LibMatrixAgg.aggregateBinaryMatrix(newWithCor, this, aggOp);
            } else {
                for (int r = 0; r < this.rlen - 1; ++r) {
                    for (int c = 0; c < this.clen; ++c) {
                        buffer._sum = this.quickGetValue(r, c);
                        buffer._correction = this.quickGetValue(r + 1, c);
                        buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.quickGetValue(r, c), newWithCor.quickGetValue(r + 1, c));
                        this.quickSetValue(r, c, buffer._sum);
                        this.quickSetValue(r + 1, c, buffer._correction);
                    }
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTCOLUMN) {
            if (aggOp.increOp.fn instanceof Builtin && (((Builtin)aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MAXINDEX || ((Builtin)aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MININDEX)) {
                for (int r = 0; r < this.rlen; ++r) {
                    double currMaxValue = this.quickGetValue(r, 1);
                    long newMaxIndex = (long)newWithCor.quickGetValue(r, 0);
                    double newMaxValue = newWithCor.quickGetValue(r, 1);
                    double update = aggOp.increOp.fn.execute(newMaxValue, currMaxValue);
                    if (2.0 == update) {
                        long curMaxIndex = (long)this.quickGetValue(r, 0);
                        this.quickSetValue(r, 0, Math.max(curMaxIndex, newMaxIndex));
                        continue;
                    }
                    if (1.0 != update) continue;
                    this.quickSetValue(r, 0, newMaxIndex);
                    this.quickSetValue(r, 1, newMaxValue);
                }
            } else if (aggOp.increOp.fn instanceof KahanPlus) {
                LibMatrixAgg.aggregateBinaryMatrix(newWithCor, this, aggOp);
            } else {
                for (int r = 0; r < this.rlen; ++r) {
                    for (int c = 0; c < this.clen - 1; ++c) {
                        buffer._sum = this.quickGetValue(r, c);
                        buffer._correction = this.quickGetValue(r, c + 1);
                        buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.quickGetValue(r, c), newWithCor.quickGetValue(r, c + 1));
                        this.quickSetValue(r, c, buffer._sum);
                        this.quickSetValue(r, c + 1, buffer._correction);
                    }
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOROWS) {
            for (int r = 0; r < this.rlen - 2; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    double n = this.quickGetValue(r + 1, c);
                    buffer._correction = this.quickGetValue(r + 2, c);
                    double mu2 = newWithCor.quickGetValue(r, c);
                    double n2 = newWithCor.quickGetValue(r + 1, c);
                    double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
                    buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
                    this.quickSetValue(r, c, buffer._sum);
                    this.quickSetValue(r + 1, c, n);
                    this.quickSetValue(r + 2, c, buffer._correction);
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS) {
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen - 2; ++c) {
                    buffer._sum = this.quickGetValue(r, c);
                    double n = this.quickGetValue(r, c + 1);
                    buffer._correction = this.quickGetValue(r, c + 2);
                    double mu2 = newWithCor.quickGetValue(r, c);
                    double n2 = newWithCor.quickGetValue(r, c + 1);
                    double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
                    buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
                    this.quickSetValue(r, c, buffer._sum);
                    this.quickSetValue(r, c + 1, n);
                    this.quickSetValue(r, c + 2, buffer._correction);
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTFOURROWS && aggOp.increOp.fn instanceof CM && ((CM)aggOp.increOp.fn).getAggOpType() == CMOperator.AggregateOperationTypes.VARIANCE) {
            CM_COV_Object cbuff_curr = new CM_COV_Object();
            CM_COV_Object cbuff_part = new CM_COV_Object();
            for (int r = 0; r < this.rlen - 4; ++r) {
                for (int c = 0; c < this.clen; ++c) {
                    cbuff_curr.w = this.quickGetValue(r + 2, c);
                    cbuff_curr.m2._sum = this.quickGetValue(r, c) * (cbuff_curr.w - 1.0);
                    cbuff_curr.mean._sum = this.quickGetValue(r + 1, c);
                    cbuff_curr.m2._correction = this.quickGetValue(r + 3, c);
                    cbuff_curr.mean._correction = this.quickGetValue(r + 4, c);
                    cbuff_part.w = newWithCor.quickGetValue(r + 2, c);
                    cbuff_part.m2._sum = newWithCor.quickGetValue(r, c) * (cbuff_part.w - 1.0);
                    cbuff_part.mean._sum = newWithCor.quickGetValue(r + 1, c);
                    cbuff_part.m2._correction = newWithCor.quickGetValue(r + 3, c);
                    cbuff_part.mean._correction = newWithCor.quickGetValue(r + 4, c);
                    cbuff_curr = (CM_COV_Object)aggOp.increOp.fn.execute((Data)cbuff_curr, cbuff_part);
                    double var = cbuff_curr.getRequiredResult(CMOperator.AggregateOperationTypes.VARIANCE);
                    this.quickSetValue(r, c, var);
                    this.quickSetValue(r + 1, c, cbuff_curr.mean._sum);
                    this.quickSetValue(r + 2, c, cbuff_curr.w);
                    this.quickSetValue(r + 3, c, cbuff_curr.m2._correction);
                    this.quickSetValue(r + 4, c, cbuff_curr.mean._correction);
                }
            }
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTFOURCOLUMNS && aggOp.increOp.fn instanceof CM && ((CM)aggOp.increOp.fn).getAggOpType() == CMOperator.AggregateOperationTypes.VARIANCE) {
            CM_COV_Object cbuff_curr = new CM_COV_Object();
            CM_COV_Object cbuff_part = new CM_COV_Object();
            for (int r = 0; r < this.rlen; ++r) {
                for (int c = 0; c < this.clen - 4; ++c) {
                    cbuff_curr.w = this.quickGetValue(r, c + 2);
                    cbuff_curr.m2._sum = this.quickGetValue(r, c) * (cbuff_curr.w - 1.0);
                    cbuff_curr.mean._sum = this.quickGetValue(r, c + 1);
                    cbuff_curr.m2._correction = this.quickGetValue(r, c + 3);
                    cbuff_curr.mean._correction = this.quickGetValue(r, c + 4);
                    cbuff_part.w = newWithCor.quickGetValue(r, c + 2);
                    cbuff_part.m2._sum = newWithCor.quickGetValue(r, c) * (cbuff_part.w - 1.0);
                    cbuff_part.mean._sum = newWithCor.quickGetValue(r, c + 1);
                    cbuff_part.m2._correction = newWithCor.quickGetValue(r, c + 3);
                    cbuff_part.mean._correction = newWithCor.quickGetValue(r, c + 4);
                    cbuff_curr = (CM_COV_Object)aggOp.increOp.fn.execute((Data)cbuff_curr, cbuff_part);
                    double var = cbuff_curr.getRequiredResult(CMOperator.AggregateOperationTypes.VARIANCE);
                    this.quickSetValue(r, c, var);
                    this.quickSetValue(r, c + 1, cbuff_curr.mean._sum);
                    this.quickSetValue(r, c + 2, cbuff_curr.w);
                    this.quickSetValue(r, c + 3, cbuff_curr.m2._correction);
                    this.quickSetValue(r, c + 4, cbuff_curr.mean._correction);
                }
            }
        } else {
            throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)((Object)aggOp.correctionLocation));
        }
    }

    @Override
    public MatrixValue reorgOperations(ReorgOperator op, MatrixValue ret, int startRow, int startColumn, int length) throws DMLRuntimeException {
        if (!(op.fn instanceof SwapIndex || op.fn instanceof DiagIndex || op.fn instanceof SortIndex || op.fn instanceof RevIndex)) {
            throw new DMLRuntimeException("the current reorgOperations cannot support: " + op.fn.getClass() + ".");
        }
        MatrixBlock result = MatrixBlock.checkType(ret);
        MatrixValue.CellIndex tempCellIndex = new MatrixValue.CellIndex(-1, -1);
        op.fn.computeDimension(this.rlen, this.clen, tempCellIndex);
        boolean sps = MatrixBlock.evalSparseFormatInMemory(tempCellIndex.row, tempCellIndex.column, this.nonZeros);
        if (result == null) {
            result = new MatrixBlock(tempCellIndex.row, tempCellIndex.column, sps, this.nonZeros);
        } else {
            result.reset(tempCellIndex.row, tempCellIndex.column, sps, this.nonZeros);
        }
        if (LibMatrixReorg.isSupportedReorgOperator(op)) {
            LibMatrixReorg.reorg(this, result, op);
        } else {
            MatrixValue.CellIndex temp = new MatrixValue.CellIndex(0, 0);
            if (this.sparse) {
                if (this.sparseBlock != null) {
                    for (int r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                        if (this.sparseBlock.isEmpty(r)) continue;
                        int apos = this.sparseBlock.pos(r);
                        int alen = this.sparseBlock.size(r);
                        int[] aix = this.sparseBlock.indexes(r);
                        double[] avals = this.sparseBlock.values(r);
                        for (int i = apos; i < apos + alen; ++i) {
                            tempCellIndex.set(r, aix[i]);
                            op.fn.execute(tempCellIndex, temp);
                            result.appendValue(temp.row, temp.column, avals[i]);
                        }
                    }
                }
            } else if (this.denseBlock != null) {
                if (result.isInSparseFormat()) {
                    double[] a = this.denseBlock;
                    int aix = 0;
                    for (int i = 0; i < this.rlen; ++i) {
                        int j = 0;
                        while (j < this.clen) {
                            temp.set(i, j);
                            op.fn.execute(temp, temp);
                            result.appendValue(temp.row, temp.column, a[aix]);
                            ++j;
                            ++aix;
                        }
                    }
                } else {
                    result.allocateDenseBlock();
                    Arrays.fill(result.denseBlock, 0.0);
                    double[] a = this.denseBlock;
                    double[] c = result.denseBlock;
                    int n = result.clen;
                    int aix = 0;
                    for (int i = 0; i < this.rlen; ++i) {
                        int j = 0;
                        while (j < this.clen) {
                            temp.set(i, j);
                            op.fn.execute(temp, temp);
                            c[temp.row * n + temp.column] = a[aix];
                            ++j;
                            ++aix;
                        }
                    }
                    result.nonZeros = this.nonZeros;
                }
            }
        }
        return result;
    }

    public MatrixBlock appendOperations(MatrixBlock that, MatrixBlock ret) throws DMLRuntimeException {
        return this.appendOperations(that, ret, true);
    }

    public MatrixBlock appendOperations(MatrixBlock that, MatrixBlock ret, boolean cbind) throws DMLRuntimeException {
        return this.appendOperations(new MatrixBlock[]{that}, ret, cbind);
    }

    public MatrixBlock appendOperations(MatrixBlock[] that, MatrixBlock ret, boolean cbind) throws DMLRuntimeException {
        MatrixBlock result = MatrixBlock.checkType(ret);
        int m = cbind ? this.rlen : this.rlen + Arrays.stream(that).mapToInt(mb -> mb.rlen).sum();
        int n = cbind ? this.clen + Arrays.stream(that).mapToInt(mb -> mb.clen).sum() : this.clen;
        long nnz = this.nonZeros + Arrays.stream(that).mapToLong(mb -> mb.nonZeros).sum();
        boolean shallowCopy = this.nonZeros == nnz;
        boolean sp = MatrixBlock.evalSparseFormatInMemory(m, n, nnz);
        if (result == null) {
            result = new MatrixBlock(m, n, sp, nnz);
        } else {
            result.reset(m, n, sp, nnz);
        }
        if (!result.sparse && nnz != 0L) {
            if (cbind) {
                result.copy(0, m - 1, 0, this.clen - 1, this, false);
                int off = this.clen;
                for (int i = 0; i < that.length; ++i) {
                    result.copy(0, m - 1, off, off + that[i].clen - 1, that[i], false);
                    off += that[i].clen;
                }
            } else {
                result.copy(0, this.rlen - 1, 0, n - 1, this, false);
                int off = this.rlen;
                for (int i = 0; i < that.length; ++i) {
                    result.copy(off, off + that[i].rlen - 1, 0, n - 1, that[i], false);
                    off += that[i].rlen;
                }
            }
        } else if (nnz != 0L) {
            int off;
            result.allocateSparseRowsBlock();
            if (cbind && nnz > (long)this.rlen && !shallowCopy && result.getSparseBlock() instanceof SparseBlockMCSR) {
                SparseBlock sblock = result.getSparseBlock();
                for (int i = 0; i < result.rlen; ++i) {
                    int row = i;
                    int lnnz = (int)(this.recomputeNonZeros(i, i, 0, this.clen - 1) + Arrays.stream(that).mapToLong(mb -> mb.recomputeNonZeros(row, row, 0, mb.clen - 1)).sum());
                    sblock.allocate(i, lnnz);
                }
            }
            result.appendToSparse(this, 0, 0, !shallowCopy);
            if (cbind) {
                off = this.clen;
                for (int i = 0; i < that.length; ++i) {
                    result.appendToSparse(that[i], 0, off);
                    off += that[i].clen;
                }
            } else {
                off = this.rlen;
                for (int i = 0; i < that.length; ++i) {
                    result.appendToSparse(that[i], off, 0);
                    off += that[i].rlen;
                }
            }
        }
        result.nonZeros = nnz;
        return result;
    }

    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype) throws DMLRuntimeException {
        return this.transposeSelfMatrixMultOperations(out, tstype, 1);
    }

    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype, int k) throws DMLRuntimeException {
        int dim;
        if (tstype != MMTSJ.MMTSJType.LEFT && tstype != MMTSJ.MMTSJType.RIGHT) {
            throw new DMLRuntimeException("Invalid MMTSJ type '" + tstype.toString() + "'.");
        }
        boolean leftTranspose = tstype == MMTSJ.MMTSJType.LEFT;
        int n = dim = leftTranspose ? this.clen : this.rlen;
        if (out == null) {
            out = new MatrixBlock(dim, dim, false);
        } else {
            out.reset(dim, dim, false);
        }
        if (k > 1) {
            LibMatrixMult.matrixMultTransposeSelf(this, out, leftTranspose, k);
        } else {
            LibMatrixMult.matrixMultTransposeSelf(this, out, leftTranspose);
        }
        return out;
    }

    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype) throws DMLRuntimeException {
        return this.chainMatrixMultOperations(v, w, out, ctype, 1);
    }

    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype, int k) throws DMLRuntimeException {
        if (ctype != MapMultChain.ChainType.XtXv && ctype != MapMultChain.ChainType.XtwXv && ctype != MapMultChain.ChainType.XtXvy) {
            throw new DMLRuntimeException("Invalid mmchain type '" + ctype.toString() + "'.");
        }
        if (this.getNumColumns() != v.getNumRows()) {
            throw new DMLRuntimeException("Dimensions mismatch on mmchain operation (" + this.getNumColumns() + " != " + v.getNumRows() + ")");
        }
        if (v != null && v.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid input vector (column vector expected, but ncol=" + v.getNumColumns() + ")");
        }
        if (w != null && w.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid weight vector (column vector expected, but ncol=" + w.getNumColumns() + ")");
        }
        if (out != null) {
            out.reset(this.clen, 1, false);
        } else {
            out = new MatrixBlock(this.clen, 1, false);
        }
        if (k > 1) {
            LibMatrixMult.matrixMultChain(this, v, w, out, ctype, k);
        } else {
            LibMatrixMult.matrixMultChain(this, v, w, out, ctype);
        }
        return out;
    }

    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val) throws DMLRuntimeException {
        this.permutationMatrixMultOperations(m2Val, out1Val, out2Val, 1);
    }

    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val, int k) throws DMLRuntimeException {
        MatrixBlock m2 = MatrixBlock.checkType(m2Val);
        MatrixBlock ret1 = MatrixBlock.checkType(out1Val);
        MatrixBlock ret2 = MatrixBlock.checkType(out2Val);
        if (this.rlen != m2.rlen) {
            throw new RuntimeException("Dimensions do not match for permutation matrix multiplication (" + this.rlen + "!=" + m2.rlen + ").");
        }
        if (k > 1) {
            LibMatrixMult.matrixMultPermute(this, m2, ret1, ret2, k);
        } else {
            LibMatrixMult.matrixMultPermute(this, m2, ret1, ret2);
        }
    }

    public final MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, IndexRange ixrange, MatrixBlock ret, MatrixObject.UpdateType update) throws DMLRuntimeException {
        return this.leftIndexingOperations(rhsMatrix, ixrange, ret, update, null);
    }

    public final MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, IndexRange ixrange, MatrixBlock ret, MatrixObject.UpdateType update, String opcode) throws DMLRuntimeException {
        return this.leftIndexingOperations(rhsMatrix, (int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, ret, update, opcode);
    }

    public MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, int rl, int ru, int cl, int cu, MatrixBlock ret, MatrixObject.UpdateType update) throws DMLRuntimeException {
        return this.leftIndexingOperations(rhsMatrix, rl, ru, cl, cu, ret, update, null);
    }

    public MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, int rl, int ru, int cl, int cu, MatrixBlock ret, MatrixObject.UpdateType update, String opcode) throws DMLRuntimeException {
        if (rl < 0 || rl >= this.getNumRows() || ru < rl || ru >= this.getNumRows() || cl < 0 || cu >= this.getNumColumns() || cu < cl || cu >= this.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for matrix indexing: [" + (rl + 1) + ":" + (ru + 1) + "," + (cl + 1) + ":" + (cu + 1) + "] must be within matrix dimensions [" + this.getNumRows() + "," + this.getNumColumns() + "].");
        }
        if (ru - rl + 1 < rhsMatrix.getNumRows() || cu - cl + 1 < rhsMatrix.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for matrix indexing: dimensions of the source matrix [" + rhsMatrix.getNumRows() + "x" + rhsMatrix.getNumColumns() + "] do not match the shape of the matrix specified by indices [" + (rl + 1) + ":" + (ru + 1) + ", " + (cl + 1) + ":" + (cu + 1) + "].");
        }
        MatrixBlock result = ret;
        boolean sp = MatrixBlock.estimateSparsityOnLeftIndexing(this.rlen, this.clen, this.nonZeros, rhsMatrix.getNumRows(), rhsMatrix.getNumColumns(), rhsMatrix.getNonZeros());
        if (!update.isInPlace()) {
            if (result == null) {
                result = new MatrixBlock(this.rlen, this.clen, sp);
            } else {
                result.reset(this.rlen, this.clen, sp);
            }
            result.copy(this, sp);
        } else {
            result = this;
            if (result.sparse && !sp) {
                result.sparseToDense();
            } else if (!result.sparse && sp) {
                result.denseToSparse();
            }
            if (result.sparse && update != MatrixObject.UpdateType.INPLACE_PINNED) {
                result.sparseBlock = SparseBlockFactory.copySparseBlock(DEFAULT_INPLACE_SPARSEBLOCK, result.sparseBlock, false);
            }
        }
        MatrixBlock src = rhsMatrix;
        if (rl == ru && cl == cu) {
            result.quickSetValue(rl, cl, src.quickGetValue(0, 0));
        } else {
            long t1 = opcode != null && DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS ? System.nanoTime() : 0L;
            boolean isCSRCopy = false;
            if (!result.isEmptyBlock(false) && result.sparse && result.sparseBlock instanceof SparseBlockCSR) {
                SparseBlockCSR sblock = (SparseBlockCSR)result.sparseBlock;
                if (src.sparse) {
                    sblock.setIndexRange(rl, ru + 1, cl, cu + 1, src.getSparseBlock());
                } else {
                    sblock.setIndexRange(rl, ru + 1, cl, cu + 1, src.getDenseBlock(), 0, src.getNumRows() * src.getNumColumns());
                }
                result.nonZeros = sblock.size();
                isCSRCopy = true;
            } else {
                result.copy(rl, ru, cl, cu, src, true);
            }
            if (opcode != null && DMLScript.STATISTICS && DMLScript.FINEGRAINED_STATISTICS) {
                long t2 = System.nanoTime();
                if (isCSRCopy) {
                    GPUStatistics.maintainCPMiscTimes(opcode, "csrlix", t2 - t1);
                } else {
                    GPUStatistics.maintainCPMiscTimes(opcode, "lixcp", t2 - t1);
                }
            }
        }
        return result;
    }

    public MatrixBlock leftIndexingOperations(ScalarObject scalar, int rl, int cl, MatrixBlock ret, MatrixObject.UpdateType update) throws DMLRuntimeException {
        double inVal = scalar.getDoubleValue();
        boolean sp = MatrixBlock.estimateSparsityOnLeftIndexing(this.rlen, this.clen, this.nonZeros, 1L, 1L, inVal != 0.0 ? 1L : 0L);
        if (!update.isInPlace()) {
            if (ret == null) {
                ret = new MatrixBlock(this.rlen, this.clen, sp);
            } else {
                ret.reset(this.rlen, this.clen, sp);
            }
            ret.copy(this, sp);
        } else {
            ret = this;
            if (ret.sparse && update != MatrixObject.UpdateType.INPLACE_PINNED) {
                ret.sparseBlock = SparseBlockFactory.copySparseBlock(DEFAULT_INPLACE_SPARSEBLOCK, ret.sparseBlock, false);
            }
        }
        ret.quickSetValue(rl, cl, inVal);
        return ret;
    }

    public MatrixBlock sliceOperations(IndexRange ixrange, MatrixBlock ret) throws DMLRuntimeException {
        return this.sliceOperations((int)ixrange.rowStart, (int)ixrange.rowEnd, (int)ixrange.colStart, (int)ixrange.colEnd, true, ret);
    }

    @Override
    public MatrixBlock sliceOperations(int rl, int ru, int cl, int cu, CacheBlock ret) throws DMLRuntimeException {
        return this.sliceOperations(rl, ru, cl, cu, true, ret);
    }

    public MatrixBlock sliceOperations(int rl, int ru, int cl, int cu, boolean deep, CacheBlock ret) throws DMLRuntimeException {
        boolean result_sparsity;
        if (rl < 0 || rl >= this.getNumRows() || ru < rl || ru >= this.getNumRows() || cl < 0 || cu >= this.getNumColumns() || cu < cl || cu >= this.getNumColumns()) {
            throw new DMLRuntimeException("Invalid values for matrix indexing: [" + (rl + 1) + ":" + (ru + 1) + "," + (cl + 1) + ":" + (cu + 1) + "] must be within matrix dimensions [" + this.getNumRows() + "," + this.getNumColumns() + "]");
        }
        MatrixBlock result = MatrixBlock.checkType((MatrixBlock)ret);
        long estnnz = (long)((double)this.nonZeros / (double)this.rlen / (double)this.clen * (double)(ru - rl + 1) * (double)(cu - cl + 1));
        boolean bl = result_sparsity = this.sparse && MatrixBlock.evalSparseFormatInMemory(ru - rl + 1, cu - cl + 1, estnnz);
        if (result == null) {
            result = new MatrixBlock(ru - rl + 1, cu - cl + 1, result_sparsity, estnnz);
        } else {
            result.reset(ru - rl + 1, cu - cl + 1, result_sparsity, estnnz);
        }
        if (rl == 0 && ru == this.rlen - 1 && cl == 0 && cu == this.clen - 1) {
            result.copy(this);
        } else if (this.sparse) {
            this.sliceSparse(rl, ru, cl, cu, deep, result);
        } else {
            this.sliceDense(rl, ru, cl, cu, result);
        }
        return result;
    }

    private void sliceSparse(int rl, int ru, int cl, int cu, boolean deep, MatrixBlock dest) throws DMLRuntimeException {
        if (this.isEmptyBlock(false)) {
            return;
        }
        if (cl == cu) {
            dest.allocateDenseBlock();
            for (int i = rl; i <= ru; ++i) {
                double val;
                if (this.sparseBlock.isEmpty(i) || (val = this.sparseBlock.get(i, cl)) == 0.0) continue;
                dest.denseBlock[i - rl] = val;
                ++dest.nonZeros;
            }
        } else if (cl == 0 && cu == this.clen - 1) {
            boolean ldeep = deep && this.sparseBlock instanceof SparseBlockMCSR;
            for (int i = rl; i <= ru; ++i) {
                dest.appendRow(i - rl, this.sparseBlock.get(i), ldeep);
            }
        } else {
            for (int i = rl; i <= ru; ++i) {
                int astart;
                if (this.sparseBlock.isEmpty(i)) continue;
                int apos = this.sparseBlock.pos(i);
                int alen = this.sparseBlock.size(i);
                int[] aix = this.sparseBlock.indexes(i);
                double[] avals = this.sparseBlock.values(i);
                int n = astart = cl > 0 ? this.sparseBlock.posFIndexGTE(i, cl) : 0;
                if (astart == -1) continue;
                for (int j = apos + astart; j < apos + alen && aix[j] <= cu; ++j) {
                    dest.appendValue(i - rl, aix[j] - cl, avals[j]);
                }
            }
        }
    }

    private void sliceDense(int rl, int ru, int cl, int cu, MatrixBlock dest) throws DMLRuntimeException {
        if (this.denseBlock == null) {
            return;
        }
        dest.allocateDenseBlock();
        if (cl == cu) {
            if (this.clen == 1) {
                System.arraycopy(this.denseBlock, rl, dest.denseBlock, 0, ru - rl + 1);
            } else {
                int len = this.clen;
                int i = rl * len + cl;
                int ix = 0;
                while (i <= ru * len + cu) {
                    dest.denseBlock[ix] = this.denseBlock[i];
                    i += len;
                    ++ix;
                }
            }
        } else {
            int len1 = this.clen;
            int len2 = dest.clen;
            int i = rl;
            int ix1 = rl * len1 + cl;
            int ix2 = 0;
            while (i <= ru) {
                System.arraycopy(this.denseBlock, ix1, dest.denseBlock, ix2, len2);
                ++i;
                ix1 += len1;
                ix2 += len2;
            }
        }
        dest.recomputeNonZeros();
    }

    @Override
    public void sliceOperations(ArrayList<IndexedMatrixValue> outlist, IndexRange range, int rowCut, int colCut, int normalBlockRowFactor, int normalBlockColFactor, int boundaryRlen, int boundaryClen) {
        block16: {
            MatrixBlock bottomright;
            MatrixBlock bottomleft;
            MatrixBlock topright;
            MatrixBlock topleft;
            block15: {
                topleft = null;
                topright = null;
                bottomleft = null;
                bottomright = null;
                Iterator<IndexedMatrixValue> p = outlist.iterator();
                int blockRowFactor = normalBlockRowFactor;
                int blockColFactor = normalBlockColFactor;
                if ((long)rowCut > range.rowEnd) {
                    blockRowFactor = boundaryRlen;
                }
                if ((long)colCut > range.colEnd) {
                    blockColFactor = boundaryClen;
                }
                int minrowcut = (int)Math.min((long)rowCut, range.rowEnd);
                int mincolcut = (int)Math.min((long)colCut, range.colEnd);
                int maxrowcut = (int)Math.max((long)rowCut, range.rowStart);
                int maxcolcut = (int)Math.max((long)colCut, range.colStart);
                if (range.rowStart < (long)rowCut && range.colStart < (long)colCut) {
                    topleft = (MatrixBlock)p.next().getValue();
                    topleft.reset(blockRowFactor, blockColFactor, this.estimateSparsityOnSlice(minrowcut - (int)range.rowStart, mincolcut - (int)range.colStart, blockRowFactor, blockColFactor));
                }
                if (range.rowStart < (long)rowCut && range.colEnd >= (long)colCut) {
                    topright = (MatrixBlock)p.next().getValue();
                    topright.reset(blockRowFactor, boundaryClen, this.estimateSparsityOnSlice(minrowcut - (int)range.rowStart, (int)range.colEnd - maxcolcut + 1, blockRowFactor, boundaryClen));
                }
                if (range.rowEnd >= (long)rowCut && range.colStart < (long)colCut) {
                    bottomleft = (MatrixBlock)p.next().getValue();
                    bottomleft.reset(boundaryRlen, blockColFactor, this.estimateSparsityOnSlice((int)range.rowEnd - maxrowcut + 1, mincolcut - (int)range.colStart, boundaryRlen, blockColFactor));
                }
                if (range.rowEnd >= (long)rowCut && range.colEnd >= (long)colCut) {
                    bottomright = (MatrixBlock)p.next().getValue();
                    bottomright.reset(boundaryRlen, boundaryClen, this.estimateSparsityOnSlice((int)range.rowEnd - maxrowcut + 1, (int)range.colEnd - maxcolcut + 1, boundaryRlen, boundaryClen));
                }
                if (!this.sparse) break block15;
                if (this.sparseBlock == null) break block16;
                int r = (int)range.rowStart;
                while ((long)r < Math.min((long)Math.min(rowCut, this.sparseBlock.numRows()), range.rowEnd + 1L)) {
                    this.sliceHelp(r, range, colCut, topleft, topright, normalBlockRowFactor - rowCut, normalBlockRowFactor, normalBlockColFactor);
                    ++r;
                }
                while ((long)r <= Math.min(range.rowEnd, (long)(this.sparseBlock.numRows() - 1))) {
                    this.sliceHelp(r, range, colCut, bottomleft, bottomright, -rowCut, normalBlockRowFactor, normalBlockColFactor);
                    ++r;
                }
                break block16;
            }
            if (this.denseBlock != null) {
                int c;
                int i = (int)range.rowStart * this.clen;
                int r = (int)range.rowStart;
                while ((long)r < Math.min((long)rowCut, range.rowEnd + 1L)) {
                    c = (int)range.colStart;
                    while ((long)c < Math.min((long)colCut, range.colEnd + 1L)) {
                        topleft.appendValue(r + normalBlockRowFactor - rowCut, c + normalBlockColFactor - colCut, this.denseBlock[i + c]);
                        ++c;
                    }
                    while ((long)c <= range.colEnd) {
                        topright.appendValue(r + normalBlockRowFactor - rowCut, c - colCut, this.denseBlock[i + c]);
                        ++c;
                    }
                    i += this.clen;
                    ++r;
                }
                while ((long)r <= range.rowEnd) {
                    c = (int)range.colStart;
                    while ((long)c < Math.min((long)colCut, range.colEnd + 1L)) {
                        bottomleft.appendValue(r - rowCut, c + normalBlockColFactor - colCut, this.denseBlock[i + c]);
                        ++c;
                    }
                    while ((long)c <= range.colEnd) {
                        bottomright.appendValue(r - rowCut, c - colCut, this.denseBlock[i + c]);
                        ++c;
                    }
                    i += this.clen;
                    ++r;
                }
            }
        }
    }

    private void sliceHelp(int r, IndexRange range, int colCut, MatrixBlock left, MatrixBlock right, int rowOffset, int normalBlockRowFactor, int normalBlockColFactor) {
        if (this.sparseBlock.isEmpty(r)) {
            return;
        }
        int[] cols = this.sparseBlock.indexes(r);
        double[] values = this.sparseBlock.values(r);
        int start = this.sparseBlock.posFIndexGTE(r, (int)range.colStart);
        if (start < 0) {
            return;
        }
        int end = this.sparseBlock.posFIndexLTE(r, (int)range.colEnd);
        if (end < 0 || start > end) {
            return;
        }
        int pos = this.sparseBlock.pos(r);
        for (int i = start; i <= end; ++i) {
            if (cols[pos + i] < colCut) {
                left.appendValue(r + rowOffset, cols[pos + i] + normalBlockColFactor - colCut, values[pos + i]);
                continue;
            }
            right.appendValue(r + rowOffset, cols[pos + i] - colCut, values[pos + i]);
        }
    }

    @Override
    public void appendOperations(MatrixValue v2, ArrayList<IndexedMatrixValue> outlist, int blockRowFactor, int blockColFactor, boolean cbind, boolean m2IsLast, int nextNCol) throws DMLRuntimeException {
        MatrixBlock m2 = (MatrixBlock)v2;
        if (cbind && this.clen == blockColFactor || !cbind && this.rlen == blockRowFactor) {
            ((MatrixBlock)outlist.get(0).getValue()).copy(this);
            ((MatrixBlock)outlist.get(1).getValue()).copy(m2);
        } else if (cbind && this.clen + m2.clen < blockColFactor || !cbind && this.rlen + m2.rlen < blockRowFactor) {
            this.appendOperations(m2, (MatrixBlock)outlist.get(0).getValue(), cbind);
        } else {
            MatrixBlock ret1 = (MatrixBlock)outlist.get(0).getValue();
            int lrlen1 = cbind ? this.rlen - 1 : blockRowFactor - this.rlen - 1;
            int lclen1 = cbind ? blockColFactor - this.clen - 1 : this.clen - 1;
            MatrixBlock tmp1 = m2.sliceOperations(0, lrlen1, 0, lclen1, new MatrixBlock());
            this.appendOperations(tmp1, ret1, cbind);
            MatrixBlock ret2 = (MatrixBlock)outlist.get(1).getValue();
            if (cbind) {
                m2.sliceOperations(0, this.rlen - 1, lclen1 + 1, m2.clen - 1, ret2);
            } else {
                m2.sliceOperations(lrlen1 + 1, m2.rlen - 1, 0, this.clen - 1, ret2);
            }
        }
    }

    @Override
    public MatrixValue zeroOutOperations(MatrixValue result, IndexRange range, boolean complementary) throws DMLRuntimeException {
        block29: {
            block28: {
                MatrixBlock.checkType(result);
                double currentSparsity = (double)this.nonZeros / (double)this.rlen / (double)this.clen;
                double estimatedSps = currentSparsity * (double)(range.rowEnd - range.rowStart + 1L) * (double)(range.colEnd - range.colStart + 1L) / (double)this.rlen / (double)this.clen;
                if (!complementary) {
                    estimatedSps = currentSparsity - estimatedSps;
                }
                boolean lsparse = MatrixBlock.evalSparseFormatInMemory(this.rlen, this.clen, (long)(estimatedSps * (double)this.rlen * (double)this.clen));
                if (result == null) {
                    result = new MatrixBlock(this.rlen, this.clen, lsparse, (int)(estimatedSps * (double)this.rlen * (double)this.clen));
                } else {
                    result.reset(this.rlen, this.clen, lsparse, (int)(estimatedSps * (double)this.rlen * (double)this.clen));
                }
                if (!this.sparse) break block28;
                if (this.sparseBlock != null) {
                    int r;
                    if (!complementary) {
                        for (r = 0; r < Math.min((int)range.rowStart, this.sparseBlock.numRows()); ++r) {
                            ((MatrixBlock)result).appendRow(r, this.sparseBlock.get(r));
                        }
                        for (r = Math.min((int)range.rowEnd + 1, this.sparseBlock.numRows()); r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                            ((MatrixBlock)result).appendRow(r, this.sparseBlock.get(r));
                        }
                    }
                    r = (int)range.rowStart;
                    while ((long)r <= Math.min(range.rowEnd, (long)(this.sparseBlock.numRows() - 1))) {
                        if (!this.sparseBlock.isEmpty(r)) {
                            int[] cols = this.sparseBlock.indexes(r);
                            double[] values = this.sparseBlock.values(r);
                            if (complementary) {
                                int end;
                                int start = this.sparseBlock.posFIndexGTE(r, (int)range.colStart);
                                if (start >= 0 && (end = this.sparseBlock.posFIndexGT(r, (int)range.colEnd)) >= 0 && start <= end) {
                                    for (int i = start; i < end; ++i) {
                                        ((MatrixBlock)result).appendValue(r, cols[i], values[i]);
                                    }
                                }
                            } else {
                                int i;
                                int end;
                                int pos = this.sparseBlock.pos(r);
                                int len = this.sparseBlock.size(r);
                                int start = this.sparseBlock.posFIndexGTE(r, (int)range.colStart);
                                if (start < 0) {
                                    start = pos + len;
                                }
                                if ((end = this.sparseBlock.posFIndexGT(r, (int)range.colEnd)) < 0) {
                                    end = pos + len;
                                }
                                for (i = pos; i < start; ++i) {
                                    ((MatrixBlock)result).appendValue(r, cols[i], values[i]);
                                }
                                for (i = end; i < pos + len; ++i) {
                                    ((MatrixBlock)result).appendValue(r, cols[i], values[i]);
                                }
                            }
                        }
                        ++r;
                    }
                }
                break block29;
            }
            if (this.denseBlock == null) break block29;
            if (complementary) {
                int offset = (int)range.rowStart * this.clen;
                int r = (int)range.rowStart;
                while ((long)r <= range.rowEnd) {
                    int c = (int)range.colStart;
                    while ((long)c <= range.colEnd) {
                        ((MatrixBlock)result).appendValue(r, c, this.denseBlock[offset + c]);
                        ++c;
                    }
                    offset += this.clen;
                    ++r;
                }
            } else {
                int c;
                int r;
                int offset = 0;
                for (r = 0; r < (int)range.rowStart; ++r) {
                    c = 0;
                    while (c < this.clen) {
                        ((MatrixBlock)result).appendValue(r, c, this.denseBlock[offset]);
                        ++c;
                        ++offset;
                    }
                }
                while (r <= (int)range.rowEnd) {
                    for (c = 0; c < (int)range.colStart; ++c) {
                        ((MatrixBlock)result).appendValue(r, c, this.denseBlock[offset + c]);
                    }
                    for (c = (int)range.colEnd + 1; c < this.clen; ++c) {
                        ((MatrixBlock)result).appendValue(r, c, this.denseBlock[offset + c]);
                    }
                    offset += this.clen;
                    ++r;
                }
                while (r < this.rlen) {
                    c = 0;
                    while (c < this.clen) {
                        ((MatrixBlock)result).appendValue(r, c, this.denseBlock[offset]);
                        ++c;
                        ++offset;
                    }
                    ++r;
                }
            }
        }
        return result;
    }

    @Override
    public MatrixValue aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blockingFactorRow, int blockingFactorCol, MatrixIndexes indexesIn) throws DMLRuntimeException {
        return this.aggregateUnaryOperations(op, result, blockingFactorRow, blockingFactorCol, indexesIn, false);
    }

    @Override
    public MatrixValue aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blockingFactorRow, int blockingFactorCol, MatrixIndexes indexesIn, boolean inCP) throws DMLRuntimeException {
        MatrixValue.CellIndex tempCellIndex = new MatrixValue.CellIndex(-1, -1);
        op.indexFn.computeDimension(this.rlen, this.clen, tempCellIndex);
        if (op.aggOp.correctionExists) {
            switch (op.aggOp.correctionLocation) {
                case LASTROW: {
                    ++tempCellIndex.row;
                    break;
                }
                case LASTCOLUMN: {
                    ++tempCellIndex.column;
                    break;
                }
                case LASTTWOROWS: {
                    tempCellIndex.row += 2;
                    break;
                }
                case LASTTWOCOLUMNS: {
                    tempCellIndex.column += 2;
                    break;
                }
                case LASTFOURROWS: {
                    tempCellIndex.row += 4;
                    break;
                }
                case LASTFOURCOLUMNS: {
                    tempCellIndex.column += 4;
                    break;
                }
                default: {
                    throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)((Object)op.aggOp.correctionLocation));
                }
            }
        }
        if (result == null) {
            result = new MatrixBlock(tempCellIndex.row, tempCellIndex.column, false);
        } else {
            result.reset(tempCellIndex.row, tempCellIndex.column, false);
        }
        MatrixBlock ret = (MatrixBlock)result;
        if (LibMatrixAgg.isSupportedUnaryAggregateOperator(op)) {
            if (op.getNumThreads() > 1) {
                LibMatrixAgg.aggregateUnaryMatrix(this, ret, op, op.getNumThreads());
            } else {
                LibMatrixAgg.aggregateUnaryMatrix(this, ret, op);
            }
            LibMatrixAgg.recomputeIndexes(ret, op, blockingFactorRow, blockingFactorCol, indexesIn);
        } else if (op.sparseSafe) {
            this.sparseAggregateUnaryHelp(op, ret, blockingFactorRow, blockingFactorCol, indexesIn);
        } else {
            this.denseAggregateUnaryHelp(op, ret, blockingFactorRow, blockingFactorCol, indexesIn);
        }
        if (op.aggOp.correctionExists && inCP) {
            ((MatrixBlock)result).dropLastRowsOrColumns(op.aggOp.correctionLocation);
        }
        return ret;
    }

    private void sparseAggregateUnaryHelp(AggregateUnaryOperator op, MatrixBlock result, int blockingFactorRow, int blockingFactorCol, MatrixIndexes indexesIn) throws DMLRuntimeException {
        block6: {
            int c;
            int r;
            KahanObject buffer;
            MatrixValue.CellIndex tempCellIndex;
            block5: {
                if (op.aggOp.initialValue != 0.0) {
                    result.reset(result.rlen, result.clen, op.aggOp.initialValue);
                }
                tempCellIndex = new MatrixValue.CellIndex(-1, -1);
                buffer = new KahanObject(0.0, 0.0);
                r = 0;
                c = 0;
                if (!this.sparse) break block5;
                if (this.sparseBlock == null) break block6;
                SparseBlock a = this.sparseBlock;
                for (r = 0; r < Math.min(this.rlen, a.numRows()); ++r) {
                    if (a.isEmpty(r)) continue;
                    int apos = a.pos(r);
                    int alen = a.size(r);
                    int[] aix = a.indexes(r);
                    double[] aval = a.values(r);
                    for (int i = apos; i < apos + alen; ++i) {
                        tempCellIndex.set(r, aix[i]);
                        op.indexFn.execute(tempCellIndex, tempCellIndex);
                        MatrixBlock.incrementalAggregateUnaryHelp(op.aggOp, result, tempCellIndex.row, tempCellIndex.column, aval[i], buffer);
                    }
                }
                break block6;
            }
            if (this.denseBlock != null) {
                int limit = this.rlen * this.clen;
                for (int i = 0; i < limit; ++i) {
                    r = i / this.clen;
                    c = i % this.clen;
                    tempCellIndex.set(r, c);
                    op.indexFn.execute(tempCellIndex, tempCellIndex);
                    MatrixBlock.incrementalAggregateUnaryHelp(op.aggOp, result, tempCellIndex.row, tempCellIndex.column, this.denseBlock[i], buffer);
                }
            }
        }
    }

    private void denseAggregateUnaryHelp(AggregateUnaryOperator op, MatrixBlock result, int blockingFactorRow, int blockingFactorCol, MatrixIndexes indexesIn) throws DMLRuntimeException {
        if (op.aggOp.initialValue != 0.0) {
            result.reset(result.rlen, result.clen, op.aggOp.initialValue);
        }
        MatrixValue.CellIndex tempCellIndex = new MatrixValue.CellIndex(-1, -1);
        KahanObject buffer = new KahanObject(0.0, 0.0);
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                tempCellIndex.set(i, j);
                op.indexFn.execute(tempCellIndex, tempCellIndex);
                if (op.aggOp.correctionExists && op.aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTCOLUMN && op.aggOp.increOp.fn instanceof Builtin && (((Builtin)op.aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MAXINDEX || ((Builtin)op.aggOp.increOp.fn).bFunc == Builtin.BuiltinCode.MININDEX)) {
                    double currMaxValue = result.quickGetValue(i, 1);
                    long newMaxIndex = UtilFunctions.computeCellIndex(indexesIn.getColumnIndex(), blockingFactorCol, j);
                    double newMaxValue = this.quickGetValue(i, j);
                    double update = op.aggOp.increOp.fn.execute(newMaxValue, currMaxValue);
                    if (update != 1.0) continue;
                    result.quickSetValue(i, 0, newMaxIndex);
                    result.quickSetValue(i, 1, newMaxValue);
                    continue;
                }
                MatrixBlock.incrementalAggregateUnaryHelp(op.aggOp, result, tempCellIndex.row, tempCellIndex.column, this.quickGetValue(i, j), buffer);
            }
        }
    }

    private static void incrementalAggregateUnaryHelp(AggregateOperator aggOp, MatrixBlock result, int row, int column, double newvalue, KahanObject buffer) throws DMLRuntimeException {
        if (aggOp.correctionExists) {
            if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTROW || aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTCOLUMN) {
                int corRow = row;
                int corCol = column;
                if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTROW) {
                    ++corRow;
                } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTCOLUMN) {
                    ++corCol;
                } else {
                    throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)((Object)aggOp.correctionLocation));
                }
                buffer._sum = result.quickGetValue(row, column);
                buffer._correction = result.quickGetValue(corRow, corCol);
                buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, newvalue);
                result.quickSetValue(row, column, buffer._sum);
                result.quickSetValue(corRow, corCol, buffer._correction);
            } else {
                if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.NONE) {
                    throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)((Object)aggOp.correctionLocation));
                }
                int corRow = row;
                int corCol = column;
                int countRow = row;
                int countCol = column;
                if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOROWS) {
                    ++countRow;
                    corRow += 2;
                } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS) {
                    ++countCol;
                    corCol += 2;
                } else {
                    throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)((Object)aggOp.correctionLocation));
                }
                buffer._sum = result.quickGetValue(row, column);
                buffer._correction = result.quickGetValue(corRow, corCol);
                double count = result.quickGetValue(countRow, countCol) + 1.0;
                buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newvalue, count);
                result.quickSetValue(row, column, buffer._sum);
                result.quickSetValue(corRow, corCol, buffer._correction);
                result.quickSetValue(countRow, countCol, count);
            }
        } else {
            newvalue = aggOp.increOp.fn.execute(result.quickGetValue(row, column), newvalue);
            result.quickSetValue(row, column, newvalue);
        }
    }

    public void dropLastRowsOrColumns(PartialAggregate.CorrectionLocationType correctionLocation) {
        int step = correctionLocation.getNumRemovedRowsColumns();
        if (step <= 0) {
            return;
        }
        if (correctionLocation == PartialAggregate.CorrectionLocationType.LASTROW || correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOROWS || correctionLocation == PartialAggregate.CorrectionLocationType.LASTFOURROWS) {
            if (this.sparse && this.sparseBlock != null) {
                this.nonZeros -= this.recomputeNonZeros(1, this.rlen - 1, 0, this.clen - 1);
                this.sparseBlock = SparseBlockFactory.createSparseBlock(DEFAULT_SPARSEBLOCK, this.sparseBlock.get(0));
            } else if (!this.sparse && this.denseBlock != null) {
                this.nonZeros -= this.recomputeNonZeros(1, this.rlen - 1, 0, this.clen - 1);
                this.denseBlock = Arrays.copyOfRange(this.denseBlock, 0, this.clen);
            }
            this.rlen -= step;
        } else if (correctionLocation == PartialAggregate.CorrectionLocationType.LASTCOLUMN || correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS || correctionLocation == PartialAggregate.CorrectionLocationType.LASTFOURCOLUMNS) {
            if (this.sparse && this.sparseBlock != null) {
                double[] tmp = new double[this.rlen];
                int lnnz = 0;
                for (int i = 0; i < this.rlen; ++i) {
                    tmp[i] = this.sparseBlock.get(i, 0);
                    lnnz += tmp[i] != 0.0 ? 1 : 0;
                }
                this.cleanupBlock(true, true);
                this.sparse = false;
                this.denseBlock = tmp;
                this.nonZeros = lnnz;
            } else if (!this.sparse && this.denseBlock != null) {
                double[] tmp = new double[this.rlen];
                int lnnz = 0;
                int i = 0;
                int aix = 0;
                while (i < this.rlen) {
                    tmp[i] = this.denseBlock[aix];
                    lnnz += tmp[i] != 0.0 ? 1 : 0;
                    ++i;
                    aix += this.clen;
                }
                this.denseBlock = tmp;
                this.nonZeros = lnnz;
            }
            this.clen -= step;
        }
    }

    public CM_COV_Object cmOperations(CMOperator op) throws DMLRuntimeException {
        if (this.getNumColumns() != 1) {
            throw new DMLRuntimeException("Central Moment can not be computed on [" + this.getNumRows() + "," + this.getNumColumns() + "] matrix.");
        }
        CM_COV_Object cmobj = new CM_COV_Object();
        if (this.isEmptyBlock(false)) {
            op.fn.execute(cmobj, 0.0, this.getNumRows());
            return cmobj;
        }
        int nzcount = 0;
        if (this.sparse && this.sparseBlock != null) {
            for (int r = 0; r < Math.min(this.rlen, this.sparseBlock.numRows()); ++r) {
                if (this.sparseBlock.isEmpty(r)) continue;
                int apos = this.sparseBlock.pos(r);
                int alen = this.sparseBlock.size(r);
                double[] avals = this.sparseBlock.values(r);
                for (int i = apos; i < apos + alen; ++i) {
                    op.fn.execute((Data)cmobj, avals[i]);
                    ++nzcount;
                }
            }
            op.fn.execute(cmobj, 0.0, this.getNumRows() - nzcount);
        } else if (this.denseBlock != null) {
            for (int i = 0; i < this.rlen; ++i) {
                op.fn.execute((Data)cmobj, this.denseBlock[i]);
            }
        }
        return cmobj;
    }

    public CM_COV_Object cmOperations(CMOperator op, MatrixBlock weights) throws DMLRuntimeException {
        CM_COV_Object cmobj;
        block6: {
            block7: {
                block5: {
                    if (this.getNumColumns() != 1 || weights.getNumColumns() != 1) {
                        throw new DMLRuntimeException("Central Moment can be computed only on 1-dimensional column matrices.");
                    }
                    if (this.getNumRows() != weights.getNumRows() || this.getNumColumns() != weights.getNumColumns()) {
                        throw new DMLRuntimeException("Covariance: Mismatching dimensions between input and weight matrices - [" + this.getNumRows() + "," + this.getNumColumns() + "] != [" + weights.getNumRows() + "," + weights.getNumColumns() + "]");
                    }
                    cmobj = new CM_COV_Object();
                    if (!this.sparse || this.sparseBlock == null) break block5;
                    for (int i = 0; i < this.rlen; ++i) {
                        op.fn.execute(cmobj, this.quickGetValue(i, 0), weights.quickGetValue(i, 0));
                    }
                    break block6;
                }
                if (this.denseBlock == null) break block6;
                if (weights.sparse) break block7;
                if (weights.denseBlock == null) break block6;
                for (int i = 0; i < this.rlen; ++i) {
                    op.fn.execute(cmobj, this.denseBlock[i], weights.denseBlock[i]);
                }
                break block6;
            }
            for (int i = 0; i < this.rlen; ++i) {
                op.fn.execute(cmobj, this.denseBlock[i], weights.quickGetValue(i, 0));
            }
        }
        return cmobj;
    }

    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that) throws DMLRuntimeException {
        CM_COV_Object covobj;
        block6: {
            block7: {
                block5: {
                    if (this.getNumColumns() != 1 || that.getNumColumns() != 1) {
                        throw new DMLRuntimeException("Covariance can be computed only on 1-dimensional column matrices.");
                    }
                    if (this.getNumRows() != that.getNumRows() || this.getNumColumns() != that.getNumColumns()) {
                        throw new DMLRuntimeException("Covariance: Mismatching input matrix dimensions - [" + this.getNumRows() + "," + this.getNumColumns() + "] != [" + that.getNumRows() + "," + that.getNumColumns() + "]");
                    }
                    covobj = new CM_COV_Object();
                    if (!this.sparse || this.sparseBlock == null) break block5;
                    for (int i = 0; i < this.rlen; ++i) {
                        op.fn.execute(covobj, this.quickGetValue(i, 0), that.quickGetValue(i, 0));
                    }
                    break block6;
                }
                if (this.denseBlock == null) break block6;
                if (that.sparse) break block7;
                if (that.denseBlock == null) break block6;
                for (int i = 0; i < this.rlen; ++i) {
                    op.fn.execute(covobj, this.denseBlock[i], that.denseBlock[i]);
                }
                break block6;
            }
            for (int i = 0; i < this.rlen; ++i) {
                op.fn.execute(covobj, this.denseBlock[i], that.quickGetValue(i, 0));
            }
        }
        return covobj;
    }

    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that, MatrixBlock weights) throws DMLRuntimeException {
        CM_COV_Object covobj;
        block7: {
            block8: {
                block6: {
                    if (this.getNumColumns() != 1 || that.getNumColumns() != 1 || weights.getNumColumns() != 1) {
                        throw new DMLRuntimeException("Covariance can be computed only on 1-dimensional column matrices.");
                    }
                    if (this.getNumRows() != that.getNumRows() || this.getNumColumns() != that.getNumColumns()) {
                        throw new DMLRuntimeException("Covariance: Mismatching input matrix dimensions - [" + this.getNumRows() + "," + this.getNumColumns() + "] != [" + that.getNumRows() + "," + that.getNumColumns() + "]");
                    }
                    if (this.getNumRows() != weights.getNumRows() || this.getNumColumns() != weights.getNumColumns()) {
                        throw new DMLRuntimeException("Covariance: Mismatching dimensions between input and weight matrices - [" + this.getNumRows() + "," + this.getNumColumns() + "] != [" + weights.getNumRows() + "," + weights.getNumColumns() + "]");
                    }
                    covobj = new CM_COV_Object();
                    if (!this.sparse || this.sparseBlock == null) break block6;
                    for (int i = 0; i < this.rlen; ++i) {
                        op.fn.execute(covobj, this.quickGetValue(i, 0), that.quickGetValue(i, 0), weights.quickGetValue(i, 0));
                    }
                    break block7;
                }
                if (this.denseBlock == null) break block7;
                if (that.sparse || weights.sparse) break block8;
                if (that.denseBlock == null) break block7;
                for (int i = 0; i < this.rlen; ++i) {
                    op.fn.execute(covobj, this.denseBlock[i], that.denseBlock[i], weights.denseBlock[i]);
                }
                break block7;
            }
            for (int i = 0; i < this.rlen; ++i) {
                op.fn.execute(covobj, this.denseBlock[i], that.quickGetValue(i, 0), weights.quickGetValue(i, 0));
            }
        }
        return covobj;
    }

    public MatrixValue sortOperations(MatrixValue weights, MatrixValue result) throws DMLRuntimeException {
        int i;
        boolean wtflag = weights != null;
        MatrixBlock wts = weights == null ? null : MatrixBlock.checkType(weights);
        MatrixBlock.checkType(result);
        if (this.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid input dimensions (" + this.getNumRows() + "x" + this.getNumColumns() + ") to sort operation.");
        }
        if (wts != null && wts.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid weight dimensions (" + wts.getNumRows() + "x" + wts.getNumColumns() + ") to sort operation.");
        }
        int dim1 = (int)(1L + this.getNonZeros());
        if (result == null) {
            result = new MatrixBlock(dim1, 2, false);
        } else {
            result.reset(dim1, 2, false);
        }
        MatrixBlock tdw = new MatrixBlock(dim1, 2, false);
        double zero_wt = 0.0;
        int ind = 1;
        if (wtflag) {
            for (i = 0; i < this.rlen; ++i) {
                double d = this.quickGetValue(i, 0);
                double w = wts.quickGetValue(i, 0);
                if (d != 0.0) {
                    tdw.quickSetValue(ind, 0, d);
                    tdw.quickSetValue(ind, 1, w);
                    ++ind;
                    continue;
                }
                zero_wt += w;
            }
        } else {
            zero_wt = (long)this.getNumRows() - this.getNonZeros();
            for (i = 0; i < this.rlen; ++i) {
                double d = this.quickGetValue(i, 0);
                if (d == 0.0) continue;
                tdw.quickSetValue(ind, 0, d);
                tdw.quickSetValue(ind, 1, 1.0);
                ++ind;
            }
        }
        tdw.quickSetValue(0, 0, 0.0);
        tdw.quickSetValue(0, 1, zero_wt);
        SortIndex sfn = new SortIndex(1, false, false);
        ReorgOperator rop = new ReorgOperator(sfn);
        LibMatrixReorg.reorg(tdw, (MatrixBlock)result, rop);
        return result;
    }

    public double interQuartileMean() throws DMLRuntimeException {
        double psum;
        double sum_wt = this.sumWeightForQuantile();
        double q25d = 0.25 * sum_wt;
        double q75d = 0.75 * sum_wt;
        int q25i = (int)Math.ceil(q25d);
        int q75i = (int)Math.ceil(q75d);
        int i = -1;
        for (psum = 0.0; psum < (double)q25i && i < this.getNumRows(); psum += this.quickGetValue(++i, 1)) {
        }
        double q25Part = psum - q25d;
        double q25Val = this.quickGetValue(i, 0);
        double sum = 0.0;
        while (psum < (double)q75i && i < this.getNumRows()) {
            double v1 = this.quickGetValue(++i, 0);
            double v2 = this.quickGetValue(i, 1);
            psum += v2;
            sum += v1 * v2;
        }
        double q75Part = psum - q75d;
        double q75Val = this.quickGetValue(i, 0);
        return MatrixBlock.computeIQMCorrection(sum, sum_wt, q25Part, q25Val, q75Part, q75Val);
    }

    public static double computeIQMCorrection(double sum, double sum_wt, double q25Part, double q25Val, double q75Part, double q75Val) {
        return (sum + q25Part * q25Val - q75Part * q75Val) / (sum_wt * 0.5);
    }

    public MatrixValue pickValues(MatrixValue quantiles, MatrixValue ret) throws DMLRuntimeException {
        MatrixBlock qs = MatrixBlock.checkType(quantiles);
        if (qs.clen != 1) {
            throw new DMLRuntimeException("Multiple quantiles can only be computed on a 1D matrix");
        }
        MatrixBlock output = MatrixBlock.checkType(ret);
        if (output == null) {
            output = new MatrixBlock(qs.rlen, qs.clen, false);
        } else {
            output.reset(qs.rlen, qs.clen, false);
        }
        for (int i = 0; i < qs.rlen; ++i) {
            output.quickSetValue(i, 0, this.pickValue(qs.quickGetValue(i, 0)));
        }
        return output;
    }

    public double median() throws DMLRuntimeException {
        double sum_wt = this.sumWeightForQuantile();
        return this.pickValue(0.5, sum_wt % 2.0 == 0.0);
    }

    public double pickValue(double quantile) throws DMLRuntimeException {
        return this.pickValue(quantile, false);
    }

    public double pickValue(double quantile, boolean average) throws DMLRuntimeException {
        double sum_wt = this.sumWeightForQuantile();
        average = average && sum_wt % 2.0 == 0.0;
        int pos = (int)Math.ceil(quantile * sum_wt);
        int t = 0;
        int i = -1;
        while ((t = (int)((double)t + this.quickGetValue(++i, 1))) < pos && i < this.getNumRows()) {
        }
        if (this.quickGetValue(i, 1) != 0.0) {
            if (average) {
                if (pos < t) {
                    return this.quickGetValue(i, 0);
                }
                if (this.quickGetValue(i + 1, 1) != 0.0) {
                    return (this.quickGetValue(i, 0) + this.quickGetValue(i + 1, 0)) / 2.0;
                }
                return (this.quickGetValue(i, 0) + this.quickGetValue(i + 2, 0)) / 2.0;
            }
            return this.quickGetValue(i, 0);
        }
        if (i + 1 < this.getNumRows()) {
            return this.quickGetValue(i + 1, 0);
        }
        return this.quickGetValue(i - 1, 0);
    }

    public double sumWeightForQuantile() throws DMLRuntimeException {
        double sum_wt = 0.0;
        for (int i = 0; i < this.getNumRows(); ++i) {
            double tmp = this.quickGetValue(i, 1);
            sum_wt += tmp;
            if (!(Math.floor(tmp) < tmp)) continue;
            throw new DMLRuntimeException("Wrong input data, quantile weights are expected to be integers but found '" + tmp + "'.");
        }
        return sum_wt;
    }

    @Override
    public MatrixValue aggregateBinaryOperations(MatrixIndexes m1Index, MatrixValue m1Value, MatrixIndexes m2Index, MatrixValue m2Value, MatrixValue result, AggregateBinaryOperator op) throws DMLRuntimeException {
        return this.aggregateBinaryOperations(m1Value, m2Value, result, op);
    }

    @Override
    public MatrixValue aggregateBinaryOperations(MatrixValue m1Value, MatrixValue m2Value, MatrixValue result, AggregateBinaryOperator op) throws DMLRuntimeException {
        MatrixBlock m1 = MatrixBlock.checkType(m1Value);
        MatrixBlock m2 = MatrixBlock.checkType(m2Value);
        MatrixBlock ret = MatrixBlock.checkType(result);
        if (m1.clen != m2.rlen) {
            throw new RuntimeException("Dimensions do not match for matrix multiplication (" + m1.clen + "!=" + m2.rlen + ").");
        }
        if (!(op.binaryFn instanceof Multiply) || !(op.aggOp.increOp.fn instanceof Plus)) {
            throw new DMLRuntimeException("Unsupported binary aggregate operation: (" + op.binaryFn + ", " + op.aggOp + ").");
        }
        int rl = m1.rlen;
        int cl = m2.clen;
        SparsityEstimate sp = MatrixBlock.estimateSparsityOnAggBinary(m1, m2, op);
        if (ret == null) {
            ret = new MatrixBlock(rl, cl, sp.sparse, sp.estimatedNonZeros);
        } else {
            ret.reset(rl, cl, sp.sparse, sp.estimatedNonZeros);
        }
        if (NativeHelper.isNativeLibraryLoaded()) {
            LibMatrixNative.matrixMult(m1, m2, ret, op.getNumThreads());
        } else if (op.getNumThreads() > 1) {
            LibMatrixMult.matrixMult(m1, m2, ret, op.getNumThreads());
        } else {
            LibMatrixMult.matrixMult(m1, m2, ret);
        }
        return ret;
    }

    public MatrixBlock aggregateTernaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, AggregateTernaryOperator op, boolean inCP) throws DMLRuntimeException {
        int cl;
        if (m1.rlen != m2.rlen || m1.clen != m2.clen || m3 != null && (m2.rlen != m3.rlen || m2.clen != m3.clen)) {
            throw new DMLRuntimeException("Invalid dimensions for aggregate ternary (" + m1.rlen + "x" + m1.clen + ", " + m2.rlen + "x" + m2.clen + ", " + m3.rlen + "x" + m3.clen + ").");
        }
        if (!(op.aggOp.increOp.fn instanceof KahanPlus) || !(op.binaryFn instanceof Multiply)) {
            throw new DMLRuntimeException("Unsupported operator for aggregate ternary operations.");
        }
        int rl = op.indexFn instanceof ReduceRow ? 2 : 1;
        int n = cl = op.indexFn instanceof ReduceRow ? m1.clen : 2;
        if (ret == null) {
            ret = new MatrixBlock(rl, cl, false);
        } else {
            ret.reset(rl, cl, false);
        }
        ret = op.getNumThreads() > 1 ? LibMatrixAgg.aggregateTernary(m1, m2, m3, ret, op, op.getNumThreads()) : LibMatrixAgg.aggregateTernary(m1, m2, m3, ret, op);
        if (op.aggOp.correctionExists && inCP) {
            ret.dropLastRowsOrColumns(op.aggOp.correctionLocation);
        }
        return ret;
    }

    public MatrixBlock uaggouterchainOperations(MatrixBlock mbLeft, MatrixBlock mbRight, MatrixBlock mbOut, BinaryOperator bOp, AggregateUnaryOperator uaggOp) throws DMLRuntimeException {
        double[] bv = DataConverter.convertToDoubleVector(mbRight);
        int[] bvi = null;
        if (LibMatrixOuterAgg.isSupportedUaggOp(uaggOp, bOp)) {
            int iCols;
            if (LibMatrixOuterAgg.isRowIndexMax(uaggOp) || LibMatrixOuterAgg.isRowIndexMin(uaggOp)) {
                bvi = LibMatrixOuterAgg.prepareRowIndices(bv.length, bv, bOp, uaggOp);
            } else {
                Arrays.sort(bv);
            }
            int iRows = uaggOp.indexFn instanceof ReduceCol ? mbLeft.getNumRows() : 2;
            int n = iCols = uaggOp.indexFn instanceof ReduceRow ? mbLeft.getNumColumns() : 2;
            if (mbOut == null) {
                mbOut = new MatrixBlock(iRows, iCols, false);
            } else {
                mbOut.reset(iRows, iCols, false);
            }
        } else {
            throw new DMLRuntimeException("Unsupported operator for unary aggregate operations.");
        }
        LibMatrixOuterAgg.aggregateMatrix(mbLeft, mbOut, bv, bvi, bOp, uaggOp);
        return mbOut;
    }

    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op) throws DMLRuntimeException {
        return this.groupedAggOperations(tgt, wghts, ret, ngroups, op, 1);
    }

    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op, int k) throws DMLRuntimeException {
        boolean validMatrixOp;
        MatrixBlock target = MatrixBlock.checkType(tgt);
        MatrixBlock weights = MatrixBlock.checkType(wghts);
        boolean bl = validMatrixOp = weights == null && ngroups >= 1;
        if (this.getNumColumns() != 1 || weights != null && weights.getNumColumns() != 1) {
            throw new DMLRuntimeException("groupedAggregate can only operate on 1-dimensional column matrices for groups and weights.");
        }
        if (target.getNumColumns() != 1 && op instanceof CMOperator && !validMatrixOp) {
            throw new DMLRuntimeException("groupedAggregate can only operate on 1-dimensional column matrices for target (for this aggregation function).");
        }
        if (target.getNumColumns() != 1 && target.getNumRows() != 1 && !validMatrixOp) {
            throw new DMLRuntimeException("groupedAggregate can only operate on 1-dimensional column or row matrix for target.");
        }
        if (this.getNumRows() != target.getNumRows() && this.getNumRows() != Math.max(target.getNumRows(), target.getNumColumns()) || weights != null && this.getNumRows() != weights.getNumRows()) {
            throw new DMLRuntimeException("groupedAggregate can only operate on matrices with equal dimensions.");
        }
        if (ngroups > 0) {
            this.numGroups = ngroups;
        }
        if (this.numGroups <= 0) {
            double min = this.min();
            double max = this.max();
            if (min <= 0.0) {
                throw new DMLRuntimeException("Invalid value (" + min + ") encountered in 'groups' while computing groupedAggregate");
            }
            if (max <= 0.0) {
                throw new DMLRuntimeException("Invalid value (" + max + ") encountered in 'groups' while computing groupedAggregate.");
            }
            this.numGroups = (int)max;
        }
        boolean rowVector = target.getNumRows() == 1 && target.getNumColumns() > 1;
        MatrixBlock result = MatrixBlock.checkType(ret);
        boolean result_sparsity = MatrixBlock.estimateSparsityOnGroupedAgg(this.rlen, this.numGroups);
        if (result == null) {
            result = new MatrixBlock(this.numGroups, rowVector ? 1 : target.getNumColumns(), result_sparsity);
        } else {
            result.reset(this.numGroups, rowVector ? 1 : target.getNumColumns(), result_sparsity);
        }
        if (k > 1) {
            LibMatrixAgg.groupedAggregate(this, target, weights, result, this.numGroups, op, k);
        } else {
            LibMatrixAgg.groupedAggregate(this, target, weights, result, this.numGroups, op);
        }
        return result;
    }

    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, MatrixBlock select) throws DMLRuntimeException {
        MatrixBlock result = MatrixBlock.checkType(ret);
        return LibMatrixReorg.rmempty(this, result, rows, select);
    }

    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows) throws DMLRuntimeException {
        return this.removeEmptyOperations(ret, rows, null);
    }

    public MatrixBlock rexpandOperations(MatrixBlock ret, double max, boolean rows, boolean cast, boolean ignore, int k) throws DMLRuntimeException {
        MatrixBlock result = MatrixBlock.checkType(ret);
        return LibMatrixReorg.rexpand(this, result, max, rows, cast, ignore, k);
    }

    @Override
    public MatrixValue replaceOperations(MatrixValue result, double pattern, double replacement) throws DMLRuntimeException {
        MatrixBlock ret = MatrixBlock.checkType(result);
        this.examSparsity();
        ret.reset(this.rlen, this.clen, this.sparse);
        if (this.nonZeros == 0L && pattern != 0.0) {
            return ret;
        }
        boolean NaNpattern = Double.isNaN(pattern);
        if (this.sparse) {
            if (pattern != 0.0) {
                ret.allocateSparseRowsBlock();
                SparseBlock a = this.sparseBlock;
                SparseBlock c = ret.sparseBlock;
                for (int i = 0; i < this.rlen; ++i) {
                    if (a.isEmpty(i)) continue;
                    c.allocate(i);
                    int apos = a.pos(i);
                    int alen = a.size(i);
                    int[] aix = a.indexes(i);
                    double[] avals = a.values(i);
                    for (int j = apos; j < apos + alen; ++j) {
                        double val = avals[j];
                        if (val == pattern || NaNpattern && Double.isNaN(val)) {
                            c.append(i, aix[j], replacement);
                            continue;
                        }
                        c.append(i, aix[j], val);
                    }
                }
            } else {
                ret.sparse = false;
                ret.allocateDenseBlock();
                SparseBlock a = this.sparseBlock;
                double[] c = ret.denseBlock;
                Arrays.fill(c, replacement);
                if (a != null) {
                    int i = 0;
                    int cix = 0;
                    while (i < this.rlen) {
                        if (!a.isEmpty(i)) {
                            int apos = a.pos(i);
                            int alen = a.size(i);
                            int[] aix = a.indexes(i);
                            double[] avals = a.values(i);
                            for (int j = apos; j < apos + alen; ++j) {
                                if (avals[j] == 0.0) continue;
                                c[cix + aix[j]] = avals[j];
                            }
                        }
                        ++i;
                        cix += this.clen;
                    }
                }
            }
        } else {
            int mn = ret.rlen * ret.clen;
            ret.allocateDenseBlock();
            double[] a = this.denseBlock;
            double[] c = ret.denseBlock;
            for (int i = 0; i < mn; ++i) {
                double val = a[i];
                c[i] = val == pattern || NaNpattern && Double.isNaN(val) ? replacement : a[i];
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return ret;
    }

    @Override
    public void ternaryOperations(Operator op, double scalarThat, MatrixValue that2Val, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        MatrixBlock that2 = MatrixBlock.checkType(that2Val);
        CTable ctable = CTable.getCTableFnObject();
        double v2 = scalarThat;
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                double v1 = this.quickGetValue(i, j);
                double w = that2.quickGetValue(i, j);
                ctable.execute(v1, v2, w, false, resultMap, resultBlock);
            }
        }
        if (resultBlock != null) {
            resultBlock.recomputeNonZeros();
        }
    }

    @Override
    public void ternaryOperations(Operator op, double scalarThat, double scalarThat2, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        CTable ctable = CTable.getCTableFnObject();
        double v2 = scalarThat;
        double w = scalarThat2;
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                double v1 = this.quickGetValue(i, j);
                ctable.execute(v1, v2, w, false, resultMap, resultBlock);
            }
        }
        if (resultBlock != null) {
            resultBlock.recomputeNonZeros();
        }
    }

    @Override
    public void ternaryOperations(Operator op, MatrixIndexes ix1, double scalarThat, boolean left, int brlen, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        CTable ctable = CTable.getCTableFnObject();
        double w = scalarThat;
        int offset = (int)((ix1.getRowIndex() - 1L) * (long)brlen);
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                double v1 = this.quickGetValue(i, j);
                if (left) {
                    ctable.execute(offset + i + 1, v1, w, false, resultMap, resultBlock);
                    continue;
                }
                ctable.execute(v1, offset + i + 1, w, false, resultMap, resultBlock);
            }
        }
        if (resultBlock != null) {
            resultBlock.recomputeNonZeros();
        }
    }

    @Override
    public void ternaryOperations(Operator op, MatrixValue thatVal, double scalarThat2, boolean ignoreZeros, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        MatrixBlock that = MatrixBlock.checkType(thatVal);
        CTable ctable = CTable.getCTableFnObject();
        double w = scalarThat2;
        if (ignoreZeros && this.sparse && that.sparse) {
            if (this.isEmptyBlock(false) && that.isEmptyBlock(false)) {
                return;
            }
            SparseBlock a = this.sparseBlock;
            SparseBlock b = that.sparseBlock;
            for (int i = 0; i < this.rlen; ++i) {
                if (a.isEmpty(i)) continue;
                int alen = a.size(i);
                int apos = a.pos(i);
                double[] avals = a.values(i);
                int bpos = b.pos(i);
                double[] bvals = b.values(i);
                for (int j = 0; j < alen; ++j) {
                    ctable.execute(avals[apos + j], bvals[bpos + j], w, ignoreZeros, resultMap, resultBlock);
                }
            }
        } else {
            for (int i = 0; i < this.rlen; ++i) {
                for (int j = 0; j < this.clen; ++j) {
                    double v1 = this.quickGetValue(i, j);
                    double v2 = that.quickGetValue(i, j);
                    ctable.execute(v1, v2, w, ignoreZeros, resultMap, resultBlock);
                }
            }
        }
        if (resultBlock != null) {
            resultBlock.recomputeNonZeros();
        }
    }

    public void ternaryOperations(Operator op, MatrixValue thatMatrix, double thatScalar, MatrixBlock resultBlock) throws DMLRuntimeException {
        MatrixBlock that = MatrixBlock.checkType(thatMatrix);
        CTable ctable = CTable.getCTableFnObject();
        double w = thatScalar;
        int maxCol = 0;
        for (int i = 0; i < this.rlen; ++i) {
            double v2 = that.quickGetValue(i, 0);
            maxCol = ctable.execute(i + 1, v2, w, maxCol, resultBlock);
        }
        resultBlock.clen = maxCol;
    }

    public void ternaryOperations(Operator op, MatrixValue thatVal, MatrixValue that2Val, CTableMap resultMap) throws DMLRuntimeException {
        this.ternaryOperations(op, thatVal, that2Val, resultMap, null);
    }

    @Override
    public void ternaryOperations(Operator op, MatrixValue thatVal, MatrixValue that2Val, CTableMap resultMap, MatrixBlock resultBlock) throws DMLRuntimeException {
        MatrixBlock that = MatrixBlock.checkType(thatVal);
        MatrixBlock that2 = MatrixBlock.checkType(that2Val);
        CTable ctable = CTable.getCTableFnObject();
        if (resultBlock == null) {
            for (int i = 0; i < this.rlen; ++i) {
                for (int j = 0; j < this.clen; ++j) {
                    double v1 = this.quickGetValue(i, j);
                    double v2 = that.quickGetValue(i, j);
                    double w = that2.quickGetValue(i, j);
                    ctable.execute(v1, v2, w, false, resultMap);
                }
            }
        } else {
            for (int i = 0; i < this.rlen; ++i) {
                for (int j = 0; j < this.clen; ++j) {
                    double v1 = this.quickGetValue(i, j);
                    double v2 = that.quickGetValue(i, j);
                    double w = that2.quickGetValue(i, j);
                    ctable.execute(v1, v2, w, false, resultBlock);
                }
            }
            resultBlock.recomputeNonZeros();
        }
    }

    @Override
    public MatrixValue quaternaryOperations(QuaternaryOperator qop, MatrixValue um, MatrixValue vm, MatrixValue wm, MatrixValue out) throws DMLRuntimeException {
        return this.quaternaryOperations(qop, um, vm, wm, out, 1);
    }

    public MatrixValue quaternaryOperations(QuaternaryOperator qop, MatrixValue um, MatrixValue vm, MatrixValue wm, MatrixValue out, int k) throws DMLRuntimeException {
        MatrixBlock W;
        if (this.getNumRows() != um.getNumRows()) {
            throw new DMLRuntimeException("Dimension mismatch rows on quaternary operation: " + this.getNumRows() + "!=" + um.getNumRows());
        }
        if (this.getNumColumns() != vm.getNumRows()) {
            throw new DMLRuntimeException("Dimension mismatch columns quaternary operation: " + this.getNumColumns() + "!=" + vm.getNumRows());
        }
        MatrixBlock X = this;
        MatrixBlock U = MatrixBlock.checkType(um);
        MatrixBlock V = MatrixBlock.checkType(vm);
        MatrixBlock R = MatrixBlock.checkType(out);
        if (qop.wtype1 != null || qop.wtype4 != null) {
            R.reset(1, 1, false);
        } else if (qop.wtype2 != null || qop.wtype5 != null) {
            R.reset(this.rlen, this.clen, this.sparse);
        } else if (qop.wtype3 != null) {
            MatrixCharacteristics mc = qop.wtype3.computeOutputCharacteristics(X.rlen, X.clen, U.clen);
            R.reset((int)mc.getRows(), (int)mc.getCols(), qop.wtype3.isBasic() ? X.isInSparseFormat() : false);
        }
        if (qop.wtype1 != null) {
            MatrixBlock matrixBlock = W = qop.wtype1.hasFourInputs() ? MatrixBlock.checkType(wm) : null;
            if (k > 1) {
                LibMatrixMult.matrixMultWSLoss(X, U, V, W, R, qop.wtype1, k);
            } else {
                LibMatrixMult.matrixMultWSLoss(X, U, V, W, R, qop.wtype1);
            }
        } else if (qop.wtype2 != null) {
            if (k > 1) {
                LibMatrixMult.matrixMultWSigmoid(X, U, V, R, qop.wtype2, k);
            } else {
                LibMatrixMult.matrixMultWSigmoid(X, U, V, R, qop.wtype2);
            }
        } else if (qop.wtype3 != null) {
            MatrixBlock matrixBlock = W = qop.wtype3.hasFourInputs() ? MatrixBlock.checkType(wm) : null;
            if (qop.getScalar() != 0.0) {
                W = new MatrixBlock(1, 1, false);
                W.quickSetValue(0, 0, qop.getScalar());
            }
            if (k > 1) {
                LibMatrixMult.matrixMultWDivMM(X, U, V, W, R, qop.wtype3, k);
            } else {
                LibMatrixMult.matrixMultWDivMM(X, U, V, W, R, qop.wtype3);
            }
        } else if (qop.wtype4 != null) {
            double eps;
            W = qop.wtype4.hasFourInputs() ? MatrixBlock.checkType(wm) : null;
            double d = eps = W != null && W.getNumRows() == 1 && W.getNumColumns() == 1 ? W.quickGetValue(0, 0) : qop.getScalar();
            if (k > 1) {
                LibMatrixMult.matrixMultWCeMM(X, U, V, eps, R, qop.wtype4, k);
            } else {
                LibMatrixMult.matrixMultWCeMM(X, U, V, eps, R, qop.wtype4);
            }
        } else if (qop.wtype5 != null) {
            if (k > 1) {
                LibMatrixMult.matrixMultWuMM(X, U, V, R, qop.wtype5, qop.fn, k);
            } else {
                LibMatrixMult.matrixMultWuMM(X, U, V, R, qop.wtype5, qop.fn);
            }
        }
        return R;
    }

    public static MatrixBlock randOperations(int rows, int cols, double sparsity, double min, double max, String pdf, long seed) throws DMLRuntimeException {
        return MatrixBlock.randOperations(rows, cols, sparsity, min, max, pdf, seed, 1);
    }

    public static MatrixBlock randOperations(int rows, int cols, double sparsity, double min, double max, String pdf, long seed, int k) throws DMLRuntimeException {
        RandomMatrixGenerator rgen = new RandomMatrixGenerator(pdf, rows, cols, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), sparsity, min, max);
        if (k > 1) {
            return MatrixBlock.randOperations(rgen, seed, k);
        }
        return MatrixBlock.randOperations(rgen, seed);
    }

    public static MatrixBlock randOperations(RandomMatrixGenerator rgen, long seed) throws DMLRuntimeException {
        return MatrixBlock.randOperations(rgen, seed, 1);
    }

    public static MatrixBlock randOperations(RandomMatrixGenerator rgen, long seed, int k) throws DMLRuntimeException {
        MatrixBlock out = new MatrixBlock();
        Well1024a bigrand = null;
        LongStream nnzInBlock = null;
        if (!LibMatrixDatagen.isShortcutRandOperation(rgen._min, rgen._max, rgen._sparsity, rgen._pdf)) {
            bigrand = LibMatrixDatagen.setupSeedsForRand(seed);
            nnzInBlock = LibMatrixDatagen.computeNNZperBlock(rgen._rows, rgen._cols, rgen._rowsPerBlock, rgen._colsPerBlock, rgen._sparsity);
        }
        if (k > 1) {
            out.randOperationsInPlace(rgen, nnzInBlock, bigrand, -1L, k);
        } else {
            out.randOperationsInPlace(rgen, nnzInBlock, bigrand, -1L);
        }
        return out;
    }

    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, LongStream nnzInBlock, Well1024a bigrand, long bSeed) throws DMLRuntimeException {
        LibMatrixDatagen.generateRandomMatrix(this, rgen, nnzInBlock, bigrand, bSeed);
        return this;
    }

    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, LongStream nnzInBlock, Well1024a bigrand, long bSeed, int k) throws DMLRuntimeException {
        LibMatrixDatagen.generateRandomMatrix(this, rgen, nnzInBlock, bigrand, bSeed, k);
        return this;
    }

    public static MatrixBlock seqOperations(double from, double to, double incr) throws DMLRuntimeException {
        MatrixBlock out = new MatrixBlock();
        LibMatrixDatagen.generateSequence(out, from, to, incr);
        return out;
    }

    public MatrixBlock seqOperationsInPlace(double from, double to, double incr) throws DMLRuntimeException {
        LibMatrixDatagen.generateSequence(this, from, to, incr);
        return this;
    }

    public static MatrixBlock sampleOperations(long range, int size, boolean replace, long seed) throws DMLRuntimeException {
        MatrixBlock out = new MatrixBlock();
        LibMatrixDatagen.generateSample(out, range, size, replace, seed);
        return out;
    }

    private static MatrixBlock checkType(MatrixValue block) {
        if (block != null && !(block instanceof MatrixBlock)) {
            throw new RuntimeException("Unsupported matrix value: " + block.getClass().getSimpleName());
        }
        return (MatrixBlock)block;
    }

    public boolean isThreadSafe() {
        return !this.sparse || (this.sparseBlock != null ? this.sparseBlock.isThreadSafe() : DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR);
    }

    public static boolean isThreadSafe(boolean sparse) {
        return !sparse || DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR;
    }

    public void print() {
        System.out.println("sparse = " + this.sparse);
        if (!this.sparse) {
            System.out.println("nonzeros = " + this.nonZeros);
        }
        for (int i = 0; i < this.rlen; ++i) {
            for (int j = 0; j < this.clen; ++j) {
                System.out.print(this.quickGetValue(i, j) + "\t");
            }
            System.out.println();
        }
    }

    public int compareTo(Object arg0) {
        throw new RuntimeException("CompareTo should never be called for matrix blocks.");
    }

    public boolean equals(Object arg0) {
        throw new RuntimeException("equals should never be called for matrix blocks.");
    }

    public int hashCode() {
        throw new RuntimeException("HashCode should never be called for matrix blocks.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sparse? = ");
        sb.append(this.sparse);
        sb.append("\n");
        sb.append("nonzeros = ");
        sb.append(this.nonZeros);
        sb.append("\n");
        sb.append("size: ");
        sb.append(this.rlen);
        sb.append(" X ");
        sb.append(this.clen);
        sb.append("\n");
        if (this.sparse) {
            if (this.sparseBlock != null) {
                sb.append(this.sparseBlock.toString());
            }
        } else if (this.denseBlock != null) {
            int i = 0;
            int ix = 0;
            while (i < this.rlen) {
                for (int j = 0; j < this.clen; ++j) {
                    sb.append(this.denseBlock[ix + j]);
                    sb.append("\t");
                }
                sb.append("\n");
                ++i;
                ix += this.clen;
            }
        }
        return sb.toString();
    }

    public static class SparsityEstimate {
        public long estimatedNonZeros = 0L;
        public boolean sparse = false;

        public SparsityEstimate(boolean sps, long nnzs) {
            this.sparse = sps;
            this.estimatedNonZeros = nnzs;
        }

        public SparsityEstimate() {
        }
    }

    public static enum BlockType {
        EMPTY_BLOCK,
        ULTRA_SPARSE_BLOCK,
        SPARSE_BLOCK,
        DENSE_BLOCK;

    }
}

