/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlockFactory;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.FastBufferedDataInputStream;
import org.apache.sysml.runtime.util.FastBufferedDataOutputStream;
import org.apache.sysml.runtime.util.IndexRange;

public class PartitionedBlock<T extends CacheBlock>
implements Externalizable {
    protected CacheBlock[] _partBlocks = null;
    protected long _rlen = -1L;
    protected long _clen = -1L;
    protected int _brlen = -1;
    protected int _bclen = -1;
    protected int _offset = 0;

    public PartitionedBlock() {
    }

    public PartitionedBlock(T block, int brlen, int bclen) {
        int rlen = block.getNumRows();
        int clen = block.getNumColumns();
        this._rlen = rlen;
        this._clen = clen;
        this._brlen = brlen;
        this._bclen = bclen;
        int nrblks = this.getNumRowBlocks();
        int ncblks = this.getNumColumnBlocks();
        int code = CacheBlockFactory.getCode(block);
        try {
            this._partBlocks = new CacheBlock[nrblks * ncblks];
            int ix = 0;
            for (int i = 0; i < nrblks; ++i) {
                int j = 0;
                while (j < ncblks) {
                    CacheBlock tmp = CacheBlockFactory.newInstance(code);
                    block.sliceOperations(i * this._brlen, Math.min((i + 1) * this._brlen, rlen) - 1, j * this._bclen, Math.min((j + 1) * this._bclen, clen) - 1, tmp);
                    this._partBlocks[ix] = tmp;
                    ++j;
                    ++ix;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed partitioning of broadcast variable input.", ex);
        }
        this._offset = 0;
    }

    public PartitionedBlock(int rlen, int clen, int brlen, int bclen) {
        this._rlen = rlen;
        this._clen = clen;
        this._brlen = brlen;
        this._bclen = bclen;
        int nrblks = this.getNumRowBlocks();
        int ncblks = this.getNumColumnBlocks();
        this._partBlocks = new CacheBlock[nrblks * ncblks];
    }

    public PartitionedBlock<T> createPartition(int offset, int numBlks, T block) {
        PartitionedBlock<T> ret = new PartitionedBlock<T>();
        ret._rlen = this._rlen;
        ret._clen = this._clen;
        ret._brlen = this._brlen;
        ret._bclen = this._bclen;
        ret._partBlocks = new CacheBlock[numBlks];
        ret._offset = offset;
        System.arraycopy(this._partBlocks, offset, ret._partBlocks, 0, numBlks);
        return ret;
    }

    public long getNumRows() {
        return this._rlen;
    }

    public long getNumCols() {
        return this._clen;
    }

    public long getNumRowsPerBlock() {
        return this._brlen;
    }

    public long getNumColumnsPerBlock() {
        return this._bclen;
    }

    public int getNumRowBlocks() {
        return (int)Math.ceil((double)this._rlen / (double)this._brlen);
    }

    public int getNumColumnBlocks() {
        return (int)Math.ceil((double)this._clen / (double)this._bclen);
    }

    public T getBlock(int rowIndex, int colIndex) throws DMLRuntimeException {
        int nrblks = this.getNumRowBlocks();
        int ncblks = this.getNumColumnBlocks();
        if (rowIndex <= 0 || rowIndex > nrblks || colIndex <= 0 || colIndex > ncblks) {
            throw new DMLRuntimeException("Block indexes [" + rowIndex + "," + colIndex + "] out of range [" + nrblks + "," + ncblks + "]");
        }
        int rix = rowIndex - 1;
        int cix = colIndex - 1;
        int ix = rix * ncblks + cix - this._offset;
        return (T)this._partBlocks[ix];
    }

    public void setBlock(int rowIndex, int colIndex, T block) throws DMLRuntimeException {
        int nrblks = this.getNumRowBlocks();
        int ncblks = this.getNumColumnBlocks();
        if (rowIndex <= 0 || rowIndex > nrblks || colIndex <= 0 || colIndex > ncblks) {
            throw new DMLRuntimeException("Block indexes [" + rowIndex + "," + colIndex + "] out of range [" + nrblks + "," + ncblks + "]");
        }
        int rix = rowIndex - 1;
        int cix = colIndex - 1;
        int ix = rix * ncblks + cix - this._offset;
        this._partBlocks[ix] = block;
    }

    public long getInMemorySize() {
        long ret = 24L;
        ret += 32L;
        if (this._partBlocks != null) {
            for (CacheBlock block : this._partBlocks) {
                ret += block.getInMemorySize();
            }
        }
        return ret;
    }

    public long getExactSerializedSize() {
        long ret = 24L;
        if (this._partBlocks != null) {
            for (CacheBlock block : this._partBlocks) {
                ret += block.getExactSerializedSize();
            }
        }
        return ret;
    }

    public T sliceOperations(long rl, long ru, long cl, long cu, T block) throws DMLRuntimeException {
        int lrl = (int)rl;
        int lru = (int)ru;
        int lcl = (int)cl;
        int lcu = (int)cu;
        ArrayList<Pair> allBlks = CacheBlockFactory.getPairList(block);
        int start_iix = (lrl - 1) / this._brlen + 1;
        int end_iix = (lru - 1) / this._brlen + 1;
        int start_jix = (lcl - 1) / this._bclen + 1;
        int end_jix = (lcu - 1) / this._bclen + 1;
        for (int iix = start_iix; iix <= end_iix; ++iix) {
            for (int jix = start_jix; jix <= end_jix; ++jix) {
                IndexRange ixrange = new IndexRange(rl, ru, cl, cu);
                allBlks.addAll(OperationsOnMatrixValues.performSlice(ixrange, this._brlen, this._bclen, iix, jix, this.getBlock(iix, jix)));
            }
        }
        if (allBlks.size() == 1) {
            return (T)((CacheBlock)allBlks.get(0).getValue());
        }
        try {
            Constructor<?> constr = block.getClass().getConstructor(Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            CacheBlock ret = (CacheBlock)constr.newInstance(lru - lrl + 1, lcu - lcl + 1, false);
            for (Pair kv : allBlks) {
                ret.merge((CacheBlock)kv.getValue(), false);
            }
            return (T)ret;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    public void clearBlocks() {
        this._partBlocks = null;
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        AutoCloseable dis = is;
        int code = this.readHeader((DataInput)((Object)dis));
        if (is instanceof ObjectInputStream && code == 0) {
            ObjectInputStream ois = (ObjectInputStream)is;
            dis = new FastBufferedDataInputStream(ois);
        }
        this.readPayload((DataInput)((Object)dis), code);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        if (os instanceof ObjectOutputStream) {
            ObjectOutputStream oos = (ObjectOutputStream)os;
            FastBufferedDataOutputStream fos = new FastBufferedDataOutputStream(oos);
            this.writeHeaderAndPayload(fos);
            fos.flush();
        } else {
            this.writeHeaderAndPayload(os);
        }
    }

    private void writeHeaderAndPayload(DataOutput dos) throws IOException {
        dos.writeLong(this._rlen);
        dos.writeLong(this._clen);
        dos.writeInt(this._brlen);
        dos.writeInt(this._bclen);
        dos.writeInt(this._offset);
        dos.writeInt(this._partBlocks.length);
        dos.writeByte(CacheBlockFactory.getCode(this._partBlocks[0]));
        for (CacheBlock block : this._partBlocks) {
            block.write(dos);
        }
    }

    private int readHeader(DataInput dis) throws IOException {
        this._rlen = dis.readLong();
        this._clen = dis.readLong();
        this._brlen = dis.readInt();
        this._bclen = dis.readInt();
        this._offset = dis.readInt();
        int len = dis.readInt();
        byte code = dis.readByte();
        this._partBlocks = new CacheBlock[len];
        return code;
    }

    private void readPayload(DataInput dis, int code) throws IOException {
        int len = this._partBlocks.length;
        for (int i = 0; i < len; ++i) {
            this._partBlocks[i] = CacheBlockFactory.newInstance(code);
            this._partBlocks[i].readFields(dis);
        }
    }
}

