/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.gpu.ArithmeticBinaryGPUInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.utils.GPUStatistics;

public class MatrixMatrixAxpyGPUInstruction
extends ArithmeticBinaryGPUInstruction {
    CPOperand constant = null;
    int multiplier = 1;

    private MatrixMatrixAxpyGPUInstruction(Operator op, CPOperand in1, CPOperand constant, int multiplier, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this.constant = constant;
        this.multiplier = multiplier;
    }

    public static MatrixMatrixAxpyGPUInstruction parseInstruction(String str) throws DMLRuntimeException {
        BinaryOperator operator;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 4);
        String opcode = parts[0];
        int multiplier = 1;
        if (opcode.equals("-*")) {
            multiplier = -1;
        }
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand constant = new CPOperand(parts[2]);
        if (constant.getDataType() != Expression.DataType.SCALAR) {
            throw new DMLRuntimeException("Expected second operand to be a scalar");
        }
        CPOperand in2 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        Expression.DataType dt1 = in1.getDataType();
        Expression.DataType dt2 = in2.getDataType();
        Expression.DataType dt3 = out.getDataType();
        Operator operator2 = dt1 != dt2 ? InstructionUtils.parseScalarBinaryOperator(opcode, dt1 == Expression.DataType.SCALAR) : (operator = InstructionUtils.parseBinaryOperator(opcode));
        if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.MATRIX && dt3 == Expression.DataType.MATRIX) {
            return new MatrixMatrixAxpyGPUInstruction(operator, in1, constant, multiplier, in2, out, opcode, str);
        }
        if (dt3 == Expression.DataType.MATRIX && (dt1 == Expression.DataType.SCALAR && dt2 == Expression.DataType.MATRIX || dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.SCALAR)) {
            throw new DMLRuntimeException("Unsupported GPU PlusMult/MinusMult ArithmeticInstruction.");
        }
        throw new DMLRuntimeException("Unsupported GPU ArithmeticInstruction.");
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        GPUStatistics.incrementNoOfExecutedGPUInst();
        MatrixObject in1 = this.getMatrixInputForGPUInstruction(ec, this._input1.getName());
        MatrixObject in2 = this.getMatrixInputForGPUInstruction(ec, this._input2.getName());
        ScalarObject scalar = ec.getScalarInput(this.constant.getName(), this.constant.getValueType(), this.constant.isLiteral());
        long rlen1 = in1.getNumRows();
        long clen1 = in1.getNumColumns();
        long rlen2 = in2.getNumRows();
        long clen2 = in2.getNumColumns();
        if (!MatrixMatrixAxpyGPUInstruction.isValidMMOperation(rlen1, rlen2, clen1, clen2) && !MatrixMatrixAxpyGPUInstruction.isValidMVOperation(rlen1, rlen2, clen1, clen2)) {
            throw new DMLRuntimeException("Incorrect dimensions of inputs in GPU axpy operation. input1:" + rlen1 + " X " + clen1 + " and input2:" + rlen2 + " X " + clen2);
        }
        ec.setMetaData(this._output.getName(), (int)rlen1, (int)clen1);
        LibMatrixCUDA.axpy(ec, ec.getGPUContext(0), this.getExtendedOpcode(), in1, in2, this._output.getName(), (double)this.multiplier * scalar.getDoubleValue());
        ec.releaseMatrixInputForGPUInstruction(this._input1.getName());
        ec.releaseMatrixInputForGPUInstruction(this._input2.getName());
        ec.releaseMatrixOutputForGPUInstruction(this._output.getName());
    }

    private static boolean isValidMMOperation(long rlen1, long rlen2, long clen1, long clen2) {
        return rlen1 == rlen2 && clen1 == clen2;
    }

    private static boolean isValidMVOperation(long rlen1, long rlen2, long clen1, long clen2) {
        return rlen1 == rlen2 && clen2 == 1L || rlen2 == 1L && clen1 == clen2;
    }
}

