/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import java.util.HashMap;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.spark.AggregateTernarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.AggregateUnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.AppendGAlignedSPInstruction;
import org.apache.sysml.runtime.instructions.spark.AppendGSPInstruction;
import org.apache.sysml.runtime.instructions.spark.AppendMSPInstruction;
import org.apache.sysml.runtime.instructions.spark.AppendRSPInstruction;
import org.apache.sysml.runtime.instructions.spark.ArithmeticBinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.BinUaggChainSPInstruction;
import org.apache.sysml.runtime.instructions.spark.BuiltinBinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.BuiltinNarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.BuiltinUnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.CSVReblockSPInstruction;
import org.apache.sysml.runtime.instructions.spark.CastSPInstruction;
import org.apache.sysml.runtime.instructions.spark.CentralMomentSPInstruction;
import org.apache.sysml.runtime.instructions.spark.CheckpointSPInstruction;
import org.apache.sysml.runtime.instructions.spark.CompressionSPInstruction;
import org.apache.sysml.runtime.instructions.spark.ConvolutionSPInstruction;
import org.apache.sysml.runtime.instructions.spark.CovarianceSPInstruction;
import org.apache.sysml.runtime.instructions.spark.CpmmSPInstruction;
import org.apache.sysml.runtime.instructions.spark.CumulativeAggregateSPInstruction;
import org.apache.sysml.runtime.instructions.spark.CumulativeOffsetSPInstruction;
import org.apache.sysml.runtime.instructions.spark.IndexingSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MapmmChainSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MapmmSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MatrixReshapeSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MultiReturnParameterizedBuiltinSPInstruction;
import org.apache.sysml.runtime.instructions.spark.PMapmmSPInstruction;
import org.apache.sysml.runtime.instructions.spark.ParameterizedBuiltinSPInstruction;
import org.apache.sysml.runtime.instructions.spark.PlusMultSPInstruction;
import org.apache.sysml.runtime.instructions.spark.PmmSPInstruction;
import org.apache.sysml.runtime.instructions.spark.QuantilePickSPInstruction;
import org.apache.sysml.runtime.instructions.spark.QuantileSortSPInstruction;
import org.apache.sysml.runtime.instructions.spark.QuaternarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.RandSPInstruction;
import org.apache.sysml.runtime.instructions.spark.ReblockSPInstruction;
import org.apache.sysml.runtime.instructions.spark.RelationalBinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.ReorgSPInstruction;
import org.apache.sysml.runtime.instructions.spark.RmmSPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.SpoofSPInstruction;
import org.apache.sysml.runtime.instructions.spark.TernarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.Tsmm2SPInstruction;
import org.apache.sysml.runtime.instructions.spark.TsmmSPInstruction;
import org.apache.sysml.runtime.instructions.spark.UaggOuterChainSPInstruction;
import org.apache.sysml.runtime.instructions.spark.WriteSPInstruction;
import org.apache.sysml.runtime.instructions.spark.ZipmmSPInstruction;

public class SPInstructionParser
extends InstructionParser {
    public static final HashMap<String, SPInstruction.SPINSTRUCTION_TYPE> String2SPInstructionType = new HashMap();

    public static SPInstruction parseSingleInstruction(String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        SPInstruction.SPINSTRUCTION_TYPE cptype = InstructionUtils.getSPType(str);
        if (cptype == null) {
            throw new DMLRuntimeException("Invalid SP Instruction Type: " + str);
        }
        SPInstruction spinst = SPInstructionParser.parseSingleInstruction(cptype, str);
        if (spinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return spinst;
    }

    public static SPInstruction parseSingleInstruction(SPInstruction.SPINSTRUCTION_TYPE sptype, String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        String[] parts = null;
        switch (sptype) {
            case CPMM: {
                return CpmmSPInstruction.parseInstruction(str);
            }
            case RMM: {
                return RmmSPInstruction.parseInstruction(str);
            }
            case MAPMM: {
                return MapmmSPInstruction.parseInstruction(str);
            }
            case MAPMMCHAIN: {
                return MapmmChainSPInstruction.parseInstruction(str);
            }
            case TSMM: {
                return TsmmSPInstruction.parseInstruction(str);
            }
            case TSMM2: {
                return Tsmm2SPInstruction.parseInstruction(str);
            }
            case PMM: {
                return PmmSPInstruction.parseInstruction(str);
            }
            case ZIPMM: {
                return ZipmmSPInstruction.parseInstruction(str);
            }
            case PMAPMM: {
                return PMapmmSPInstruction.parseInstruction(str);
            }
            case UaggOuterChain: {
                return UaggOuterChainSPInstruction.parseInstruction(str);
            }
            case AggregateUnary: {
                return AggregateUnarySPInstruction.parseInstruction(str);
            }
            case AggregateTernary: {
                return AggregateTernarySPInstruction.parseInstruction(str);
            }
            case Convolution: {
                return ConvolutionSPInstruction.parseInstruction(str);
            }
            case MatrixIndexing: {
                return IndexingSPInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgSPInstruction.parseInstruction(str);
            }
            case ArithmeticBinary: {
                String opcode = InstructionUtils.getOpCode(str);
                if (opcode.equals("+*") || opcode.equals("-*")) {
                    return PlusMultSPInstruction.parseInstruction(str);
                }
                return ArithmeticBinarySPInstruction.parseInstruction(str);
            }
            case RelationalBinary: {
                return RelationalBinarySPInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernarySPInstruction.parseInstruction(str);
            }
            case Quaternary: {
                return QuaternarySPInstruction.parseInstruction(str);
            }
            case Reblock: {
                return ReblockSPInstruction.parseInstruction(str);
            }
            case CSVReblock: {
                return CSVReblockSPInstruction.parseInstruction(str);
            }
            case Builtin: {
                parts = InstructionUtils.getInstructionPartsWithValueType(str);
                if (parts[0].equals("log") || parts[0].equals("log_nz")) {
                    if (parts.length == 3) {
                        return BuiltinUnarySPInstruction.parseInstruction(str);
                    }
                    if (parts.length == 4) {
                        return BuiltinBinarySPInstruction.parseInstruction(str);
                    }
                } else {
                    throw new DMLRuntimeException("Invalid Builtin Instruction: " + str);
                }
            }
            case BuiltinBinary: {
                return BuiltinBinarySPInstruction.parseInstruction(str);
            }
            case BuiltinUnary: {
                return BuiltinUnarySPInstruction.parseInstruction(str);
            }
            case BuiltinNary: {
                return BuiltinNarySPInstruction.parseInstruction(str);
            }
            case ParameterizedBuiltin: {
                return ParameterizedBuiltinSPInstruction.parseInstruction(str);
            }
            case MultiReturnBuiltin: {
                return MultiReturnParameterizedBuiltinSPInstruction.parseInstruction(str);
            }
            case MatrixReshape: {
                return MatrixReshapeSPInstruction.parseInstruction(str);
            }
            case MAppend: {
                return AppendMSPInstruction.parseInstruction(str);
            }
            case RAppend: {
                return AppendRSPInstruction.parseInstruction(str);
            }
            case GAppend: {
                return AppendGSPInstruction.parseInstruction(str);
            }
            case GAlignedAppend: {
                return AppendGAlignedSPInstruction.parseInstruction(str);
            }
            case Rand: {
                return RandSPInstruction.parseInstruction(str);
            }
            case QSort: {
                return QuantileSortSPInstruction.parseInstruction(str);
            }
            case QPick: {
                return QuantilePickSPInstruction.parseInstruction(str);
            }
            case Write: {
                return WriteSPInstruction.parseInstruction(str);
            }
            case CumsumAggregate: {
                return CumulativeAggregateSPInstruction.parseInstruction(str);
            }
            case CumsumOffset: {
                return CumulativeOffsetSPInstruction.parseInstruction(str);
            }
            case CentralMoment: {
                return CentralMomentSPInstruction.parseInstruction(str);
            }
            case Covariance: {
                return CovarianceSPInstruction.parseInstruction(str);
            }
            case BinUaggChain: {
                return BinUaggChainSPInstruction.parseInstruction(str);
            }
            case Checkpoint: {
                return CheckpointSPInstruction.parseInstruction(str);
            }
            case Compression: {
                return CompressionSPInstruction.parseInstruction(str);
            }
            case SpoofFused: {
                return SpoofSPInstruction.parseInstruction(str);
            }
            case Cast: {
                return CastSPInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid SP Instruction Type: " + (Object)((Object)sptype));
    }

    static {
        String2SPInstructionType.put("uak+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uark+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uack+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uasqk+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uarsqk+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uacsqk+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uamean", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uarmean", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uacmean", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uavar", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uarvar", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uacvar", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uamax", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uarmax", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uarimax", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uacmax", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uamin", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uarmin", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uarimin", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uacmin", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("ua+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uar+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uac+", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("ua*", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uatrace", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("uaktrace", SPInstruction.SPINSTRUCTION_TYPE.AggregateUnary);
        String2SPInstructionType.put("mapmm", SPInstruction.SPINSTRUCTION_TYPE.MAPMM);
        String2SPInstructionType.put("mapmmchain", SPInstruction.SPINSTRUCTION_TYPE.MAPMMCHAIN);
        String2SPInstructionType.put("tsmm", SPInstruction.SPINSTRUCTION_TYPE.TSMM);
        String2SPInstructionType.put("tsmm2", SPInstruction.SPINSTRUCTION_TYPE.TSMM2);
        String2SPInstructionType.put("cpmm", SPInstruction.SPINSTRUCTION_TYPE.CPMM);
        String2SPInstructionType.put("rmm", SPInstruction.SPINSTRUCTION_TYPE.RMM);
        String2SPInstructionType.put("pmm", SPInstruction.SPINSTRUCTION_TYPE.PMM);
        String2SPInstructionType.put("zipmm", SPInstruction.SPINSTRUCTION_TYPE.ZIPMM);
        String2SPInstructionType.put("pmapmm", SPInstruction.SPINSTRUCTION_TYPE.PMAPMM);
        String2SPInstructionType.put("uaggouterchain", SPInstruction.SPINSTRUCTION_TYPE.UaggOuterChain);
        String2SPInstructionType.put("tak+*", SPInstruction.SPINSTRUCTION_TYPE.AggregateTernary);
        String2SPInstructionType.put("tack+*", SPInstruction.SPINSTRUCTION_TYPE.AggregateTernary);
        String2SPInstructionType.put("conv2d", SPInstruction.SPINSTRUCTION_TYPE.Convolution);
        String2SPInstructionType.put("conv2d_bias_add", SPInstruction.SPINSTRUCTION_TYPE.Convolution);
        String2SPInstructionType.put("maxpooling", SPInstruction.SPINSTRUCTION_TYPE.Convolution);
        String2SPInstructionType.put("relu_maxpooling", SPInstruction.SPINSTRUCTION_TYPE.Convolution);
        String2SPInstructionType.put("rightIndex", SPInstruction.SPINSTRUCTION_TYPE.MatrixIndexing);
        String2SPInstructionType.put("leftIndex", SPInstruction.SPINSTRUCTION_TYPE.MatrixIndexing);
        String2SPInstructionType.put("mapLeftIndex", SPInstruction.SPINSTRUCTION_TYPE.MatrixIndexing);
        String2SPInstructionType.put("r'", SPInstruction.SPINSTRUCTION_TYPE.Reorg);
        String2SPInstructionType.put("rev", SPInstruction.SPINSTRUCTION_TYPE.Reorg);
        String2SPInstructionType.put("rdiag", SPInstruction.SPINSTRUCTION_TYPE.Reorg);
        String2SPInstructionType.put("rshape", SPInstruction.SPINSTRUCTION_TYPE.MatrixReshape);
        String2SPInstructionType.put("rsort", SPInstruction.SPINSTRUCTION_TYPE.Reorg);
        String2SPInstructionType.put("+", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("-", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("*", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("/", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("%%", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("%/%", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("1-*", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("^", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("^2", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("*2", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("+*", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("-*", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map+", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map-", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map*", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map/", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map%%", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map%/%", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map1-*", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map^", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map+*", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map-*", SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary);
        String2SPInstructionType.put("map>", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("map>=", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("map<", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("map<=", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("map==", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("map!=", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("==", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("!=", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("<", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put(">", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("<=", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put(">=", SPInstruction.SPINSTRUCTION_TYPE.RelationalBinary);
        String2SPInstructionType.put("rblk", SPInstruction.SPINSTRUCTION_TYPE.Reblock);
        String2SPInstructionType.put("csvrblk", SPInstruction.SPINSTRUCTION_TYPE.CSVReblock);
        String2SPInstructionType.put("chkpoint", SPInstruction.SPINSTRUCTION_TYPE.Checkpoint);
        String2SPInstructionType.put("compress", SPInstruction.SPINSTRUCTION_TYPE.Compression);
        String2SPInstructionType.put("log", SPInstruction.SPINSTRUCTION_TYPE.Builtin);
        String2SPInstructionType.put("log_nz", SPInstruction.SPINSTRUCTION_TYPE.Builtin);
        String2SPInstructionType.put("max", SPInstruction.SPINSTRUCTION_TYPE.BuiltinBinary);
        String2SPInstructionType.put("min", SPInstruction.SPINSTRUCTION_TYPE.BuiltinBinary);
        String2SPInstructionType.put("mapmax", SPInstruction.SPINSTRUCTION_TYPE.BuiltinBinary);
        String2SPInstructionType.put("mapmin", SPInstruction.SPINSTRUCTION_TYPE.BuiltinBinary);
        String2SPInstructionType.put("exp", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("abs", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("sin", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("cos", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("tan", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("asin", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("acos", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("atan", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("sinh", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("cosh", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("tanh", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("sign", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("sqrt", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("plogp", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("round", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("ceil", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("floor", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("sprop", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("sigmoid", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("sel+", SPInstruction.SPINSTRUCTION_TYPE.BuiltinUnary);
        String2SPInstructionType.put("groupedagg", SPInstruction.SPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2SPInstructionType.put("mapgroupedagg", SPInstruction.SPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2SPInstructionType.put("rmempty", SPInstruction.SPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2SPInstructionType.put("replace", SPInstruction.SPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2SPInstructionType.put("rexpand", SPInstruction.SPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2SPInstructionType.put("transformapply", SPInstruction.SPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2SPInstructionType.put("transformdecode", SPInstruction.SPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2SPInstructionType.put("transformencode", SPInstruction.SPINSTRUCTION_TYPE.MultiReturnBuiltin);
        String2SPInstructionType.put("mappend", SPInstruction.SPINSTRUCTION_TYPE.MAppend);
        String2SPInstructionType.put("rappend", SPInstruction.SPINSTRUCTION_TYPE.RAppend);
        String2SPInstructionType.put("gappend", SPInstruction.SPINSTRUCTION_TYPE.GAppend);
        String2SPInstructionType.put("galignedappend", SPInstruction.SPINSTRUCTION_TYPE.GAlignedAppend);
        String2SPInstructionType.put("cbind", SPInstruction.SPINSTRUCTION_TYPE.BuiltinNary);
        String2SPInstructionType.put("rbind", SPInstruction.SPINSTRUCTION_TYPE.BuiltinNary);
        String2SPInstructionType.put("rand", SPInstruction.SPINSTRUCTION_TYPE.Rand);
        String2SPInstructionType.put("seq", SPInstruction.SPINSTRUCTION_TYPE.Rand);
        String2SPInstructionType.put("sample", SPInstruction.SPINSTRUCTION_TYPE.Rand);
        String2SPInstructionType.put("ctable", SPInstruction.SPINSTRUCTION_TYPE.Ternary);
        String2SPInstructionType.put("ctableexpand", SPInstruction.SPINSTRUCTION_TYPE.Ternary);
        String2SPInstructionType.put("mapwsloss", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("redwsloss", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("mapwsigmoid", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("redwsigmoid", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("mapwdivmm", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("redwdivmm", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("mapwcemm", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("redwcemm", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("mapwumm", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("redwumm", SPInstruction.SPINSTRUCTION_TYPE.Quaternary);
        String2SPInstructionType.put("ucumack+", SPInstruction.SPINSTRUCTION_TYPE.CumsumAggregate);
        String2SPInstructionType.put("ucumac*", SPInstruction.SPINSTRUCTION_TYPE.CumsumAggregate);
        String2SPInstructionType.put("ucumacmin", SPInstruction.SPINSTRUCTION_TYPE.CumsumAggregate);
        String2SPInstructionType.put("ucumacmax", SPInstruction.SPINSTRUCTION_TYPE.CumsumAggregate);
        String2SPInstructionType.put("bcumoffk+", SPInstruction.SPINSTRUCTION_TYPE.CumsumOffset);
        String2SPInstructionType.put("bcumoff*", SPInstruction.SPINSTRUCTION_TYPE.CumsumOffset);
        String2SPInstructionType.put("bcumoffmin", SPInstruction.SPINSTRUCTION_TYPE.CumsumOffset);
        String2SPInstructionType.put("bcumoffmax", SPInstruction.SPINSTRUCTION_TYPE.CumsumOffset);
        String2SPInstructionType.put("cm", SPInstruction.SPINSTRUCTION_TYPE.CentralMoment);
        String2SPInstructionType.put("cov", SPInstruction.SPINSTRUCTION_TYPE.Covariance);
        String2SPInstructionType.put("qsort", SPInstruction.SPINSTRUCTION_TYPE.QSort);
        String2SPInstructionType.put("qpick", SPInstruction.SPINSTRUCTION_TYPE.QPick);
        String2SPInstructionType.put("binuaggchain", SPInstruction.SPINSTRUCTION_TYPE.BinUaggChain);
        String2SPInstructionType.put("write", SPInstruction.SPINSTRUCTION_TYPE.Write);
        String2SPInstructionType.put("castdtm", SPInstruction.SPINSTRUCTION_TYPE.Cast);
        String2SPInstructionType.put("castdtf", SPInstruction.SPINSTRUCTION_TYPE.Cast);
        String2SPInstructionType.put("spoof", SPInstruction.SPINSTRUCTION_TYPE.SpoofFused);
    }
}

