/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.GPUInstructionParser;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.MRInstructionParser;
import org.apache.sysml.runtime.instructions.SPInstructionParser;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;

public class InstructionParser {
    public static Instruction parseSingleInstruction(String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        String execType = str.split("\u00b0")[0];
        if (execType.equalsIgnoreCase(LopProperties.ExecType.CP.toString()) || execType.equalsIgnoreCase(LopProperties.ExecType.CP_FILE.toString())) {
            CPInstruction.CPType cptype = InstructionUtils.getCPType(str);
            if (cptype == null) {
                throw new DMLRuntimeException("Unknown CP instruction: " + str);
            }
            return CPInstructionParser.parseSingleInstruction(cptype, str);
        }
        if (execType.equalsIgnoreCase(LopProperties.ExecType.SPARK.toString())) {
            SPInstruction.SPINSTRUCTION_TYPE sptype = InstructionUtils.getSPType(str);
            if (sptype == null) {
                throw new DMLRuntimeException("Unknown SPARK instruction: " + str);
            }
            return SPInstructionParser.parseSingleInstruction(sptype, str);
        }
        if (execType.equalsIgnoreCase(LopProperties.ExecType.GPU.toString())) {
            GPUInstruction.GPUINSTRUCTION_TYPE gputype = InstructionUtils.getGPUType(str);
            if (gputype == null) {
                throw new DMLRuntimeException("Unknown GPU instruction: " + str);
            }
            return GPUInstructionParser.parseSingleInstruction(gputype, str);
        }
        if (execType.equalsIgnoreCase("MR")) {
            MRInstruction.MRINSTRUCTION_TYPE mrtype = InstructionUtils.getMRType(str);
            if (mrtype == null) {
                throw new DMLRuntimeException("Unknown MR instruction: " + str);
            }
            return MRInstructionParser.parseSingleInstruction(mrtype, str);
        }
        throw new DMLRuntimeException("Unknown execution type in instruction: " + str);
    }

    public static Instruction[] parseMixedInstructions(String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        String[] strlist = str.split("\u2021");
        Instruction[] inst = new Instruction[strlist.length];
        for (int i = 0; i < inst.length; ++i) {
            inst[i] = InstructionParser.parseSingleInstruction(strlist[i]);
        }
        return inst;
    }
}

