/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.CodegenUtils;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.parfor.CachedReuseVariables;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.ParWorker;
import org.apache.sysml.runtime.controlprogram.parfor.ProgramConverter;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForUtils;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDHandler;
import org.apache.sysml.runtime.util.LocalFileUtils;
import scala.Tuple2;

public class RemoteParForSparkWorker
extends ParWorker
implements PairFlatMapFunction<Task, Long, String> {
    private static final long serialVersionUID = -3254950138084272296L;
    private static final CachedReuseVariables reuseVars = new CachedReuseVariables();
    private final long _jobid;
    private final String _prog;
    private final HashMap<String, byte[]> _clsMap;
    private boolean _initialized = false;
    private boolean _caching = true;
    private final LongAccumulator _aTasks;
    private final LongAccumulator _aIters;

    public RemoteParForSparkWorker(long jobid, String program, HashMap<String, byte[]> clsMap, boolean cpCaching, LongAccumulator atasks, LongAccumulator aiters) throws DMLRuntimeException {
        this._jobid = jobid;
        this._prog = program;
        this._clsMap = clsMap;
        this._initialized = false;
        this._caching = cpCaching;
        this._aTasks = atasks;
        this._aIters = aiters;
    }

    public Iterator<Tuple2<Long, String>> call(Task arg0) throws Exception {
        if (!this._initialized) {
            this.configureWorker(TaskContext.get().taskAttemptId());
        }
        long numIter = this.getExecutedIterations();
        super.executeTask(arg0);
        this._aTasks.add(1L);
        this._aIters.add((long)((int)(this.getExecutedIterations() - numIter)));
        ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
        ArrayList<String> tmp = RemoteParForUtils.exportResultVariables(this._workerID, this._ec.getVariables(), this._resultVars);
        for (String val : tmp) {
            ret.add(new Tuple2((Object)this._workerID, (Object)val));
        }
        return ret.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureWorker(long taskID) throws DMLRuntimeException, IOException {
        this._workerID = taskID;
        for (Map.Entry<String, byte[]> e : this._clsMap.entrySet()) {
            CodegenUtils.getClassSync(e.getKey(), e.getValue());
        }
        ParForBody body = ProgramConverter.parseParForBody(this._prog, (int)this._workerID);
        this._childBlocks = body.getChildBlocks();
        this._ec = body.getEc();
        this._resultVars = body.getResultVarNames();
        this._numTasks = 0L;
        this._numIters = 0L;
        this._ec.pinVariables(this._ec.getVarList());
        Collection blacklist = CollectionUtils.union((Collection)this._resultVars, this._ec.getVarListPartitioned());
        reuseVars.reuseVariables(this._jobid, this._ec.getVariables(), blacklist);
        Class<CacheableData> clazz = CacheableData.class;
        synchronized (CacheableData.class) {
            if (!CacheableData.isCachingActive() && !InfrastructureAnalyzer.isLocalMode()) {
                String uuid = IDHandler.createDistributedUniqueID();
                LocalFileUtils.createWorkingDirectoryWithUUID(uuid);
                CacheableData.initCaching(uuid);
                CacheableData.cacheEvictionLocalFilePrefix = CacheableData.cacheEvictionLocalFilePrefix + "_" + this._workerID;
                RemoteParForUtils.cleanupWorkingDirectoriesOnShutdown();
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            super.pinResultVariables();
            if (!this._caching && !InfrastructureAnalyzer.isLocalMode()) {
                CacheableData.disableCaching();
            }
            this._initialized = true;
            return;
        }
    }

    public static void cleanupCachedVariables(long pfid) {
        reuseVars.clearVariables(pfid);
    }
}

