/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.codegen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.SpoofOperator;
import org.apache.sysml.runtime.compress.BitmapEncoder;
import org.apache.sysml.runtime.compress.ColGroup;
import org.apache.sysml.runtime.compress.ColGroupValue;
import org.apache.sysml.runtime.compress.CompressedMatrixBlock;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.functionobjects.KahanPlusSq;
import org.apache.sysml.runtime.functionobjects.ValueFunction;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.LibMatrixMult;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class SpoofCellwise
extends SpoofOperator
implements Serializable {
    private static final long serialVersionUID = 3442528770573293590L;
    private final CellType _type;
    private final AggOp _aggOp;
    private final boolean _sparseSafe;

    public SpoofCellwise(CellType type, boolean sparseSafe, AggOp aggOp) {
        this._type = type;
        this._aggOp = aggOp;
        this._sparseSafe = sparseSafe;
    }

    public CellType getCellType() {
        return this._type;
    }

    public AggOp getAggOp() {
        return this._aggOp;
    }

    public boolean isSparseSafe() {
        return this._sparseSafe;
    }

    @Override
    public String getSpoofType() {
        return "Cell" + this.getClass().getName().split("\\.")[1];
    }

    private ValueFunction getAggFunction() {
        switch (this._aggOp) {
            case SUM: {
                return KahanPlus.getKahanPlusFnObject();
            }
            case SUM_SQ: {
                return KahanPlusSq.getKahanPlusSqFnObject();
            }
            case MIN: {
                return Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MIN);
            }
            case MAX: {
                return Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MAX);
            }
        }
        throw new RuntimeException("Unsupported aggregation type: " + this._aggOp.name());
    }

    @Override
    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, int k) throws DMLRuntimeException {
        long inputSize;
        if (inputs == null || inputs.size() < 1) {
            throw new RuntimeException("Invalid input arguments.");
        }
        MatrixBlock a = inputs.get(0);
        SpoofOperator.SideInput[] b = this.prepInputMatrices(inputs);
        double[] scalars = SpoofCellwise.prepInputScalars(scalarObjects);
        int m = a.getNumRows();
        int n = a.getNumColumns();
        boolean sparseSafe = this.isSparseSafe() || b.length == 0 && this.genexec(0.0, b, scalars, m, n, 0, 0) == 0.0;
        long l = inputSize = sparseSafe ? SpoofCellwise.getTotalInputNnz(inputs) : SpoofCellwise.getTotalInputSize(inputs);
        if (inputSize < 0x100000L) {
            k = 1;
        }
        double ret = 0.0;
        if (k <= 1) {
            ret = inputs.get(0) instanceof CompressedMatrixBlock ? this.executeCompressedAndAgg((CompressedMatrixBlock)a, b, scalars, m, n, sparseSafe, 0, m) : (!inputs.get(0).isInSparseFormat() ? this.executeDenseAndAgg(a.getDenseBlock(), b, scalars, m, n, sparseSafe, 0, m) : this.executeSparseAndAgg(a.getSparseBlock(), b, scalars, m, n, sparseSafe, 0, m));
        } else {
            try {
                ExecutorService pool = Executors.newFixedThreadPool(k);
                ArrayList<ParAggTask> tasks = new ArrayList<ParAggTask>();
                int nk = a instanceof CompressedMatrixBlock ? k : UtilFunctions.roundToNext(Math.min(8 * k, m / 32), k);
                int blklen = (int)Math.ceil((double)m / (double)nk);
                if (a instanceof CompressedMatrixBlock) {
                    blklen = BitmapEncoder.getAlignedBlocksize(blklen);
                }
                int i = 0;
                while (i < nk & i * blklen < m) {
                    tasks.add(new ParAggTask(a, b, scalars, m, n, sparseSafe, i * blklen, Math.min((i + 1) * blklen, m)));
                    ++i;
                }
                List taskret = pool.invokeAll(tasks);
                pool.shutdown();
                ValueFunction vfun = this.getAggFunction();
                if (vfun instanceof KahanFunction) {
                    KahanObject kbuff = new KahanObject(0.0, 0.0);
                    KahanPlus kplus = KahanPlus.getKahanPlusFnObject();
                    for (Future task : taskret) {
                        kplus.execute2(kbuff, (Double)task.get());
                    }
                    ret = kbuff._sum;
                } else {
                    for (Future task : taskret) {
                        ret = vfun.execute(ret, (double)((Double)task.get()));
                    }
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        }
        if ((this._aggOp == AggOp.MIN || this._aggOp == AggOp.MAX) && sparseSafe && a.getNonZeros() < (long)(a.getNumRows() * a.getNumColumns())) {
            ret = this.getAggFunction().execute(ret, 0.0);
        }
        return new DoubleObject(ret);
    }

    @Override
    public MatrixBlock execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out) throws DMLRuntimeException {
        return this.execute(inputs, scalarObjects, out, 1);
    }

    @Override
    public MatrixBlock execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out, int k) throws DMLRuntimeException {
        long lnnz;
        block19: {
            long inputSize;
            if (inputs == null || inputs.size() < 1 || out == null) {
                throw new RuntimeException("Invalid input arguments.");
            }
            MatrixBlock a = inputs.get(0);
            SpoofOperator.SideInput[] b = this.prepInputMatrices(inputs);
            double[] scalars = SpoofCellwise.prepInputScalars(scalarObjects);
            int m = a.getNumRows();
            int n = a.getNumColumns();
            boolean sparseSafe = this.isSparseSafe() || b.length == 0 && this.genexec(0.0, b, scalars, m, n, 0, 0) == 0.0;
            long l = inputSize = sparseSafe ? SpoofCellwise.getTotalInputNnz(inputs) : SpoofCellwise.getTotalInputSize(inputs);
            if (inputSize < 0x100000L) {
                k = 1;
            }
            boolean sparseOut = this._type == CellType.NO_AGG && sparseSafe && a.isInSparseFormat();
            switch (this._type) {
                case NO_AGG: {
                    out.reset(m, n, sparseOut);
                    break;
                }
                case ROW_AGG: {
                    out.reset(m, 1, false);
                    break;
                }
                case COL_AGG: {
                    out.reset(1, n, false);
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Invalid cell type: " + (Object)((Object)this._type));
                }
            }
            out.allocateBlock();
            lnnz = 0L;
            if (k <= 1) {
                lnnz = inputs.get(0) instanceof CompressedMatrixBlock ? this.executeCompressed((CompressedMatrixBlock)a, b, scalars, out, m, n, sparseSafe, 0, m) : (!inputs.get(0).isInSparseFormat() ? this.executeDense(a.getDenseBlock(), b, scalars, out, m, n, sparseSafe, 0, m) : this.executeSparse(a.getSparseBlock(), b, scalars, out, m, n, sparseSafe, 0, m));
            } else {
                try {
                    ExecutorService pool = Executors.newFixedThreadPool(k);
                    ArrayList<ParExecTask> tasks = new ArrayList<ParExecTask>();
                    int nk = UtilFunctions.roundToNext(Math.min(8 * k, m / 32), k);
                    int blklen = (int)Math.ceil((double)m / (double)nk);
                    if (a instanceof CompressedMatrixBlock) {
                        blklen = BitmapEncoder.getAlignedBlocksize(blklen);
                    }
                    int i = 0;
                    while (i < nk & i * blklen < m) {
                        tasks.add(new ParExecTask(a, b, scalars, out, m, n, sparseSafe, i * blklen, Math.min((i + 1) * blklen, m)));
                        ++i;
                    }
                    List taskret = pool.invokeAll(tasks);
                    pool.shutdown();
                    for (Future task : taskret) {
                        lnnz += ((Long)task.get()).longValue();
                    }
                    if (this._type != CellType.COL_AGG) break block19;
                    double[] c = out.getDenseBlock();
                    ValueFunction vfun = this.getAggFunction();
                    if (vfun instanceof KahanFunction) {
                        for (ParExecTask task : tasks) {
                            LibMatrixMult.vectAdd(task.getResult().getDenseBlock(), c, 0, 0, n);
                        }
                    } else {
                        for (ParExecTask task : tasks) {
                            double[] tmp = task.getResult().getDenseBlock();
                            for (int j = 0; j < n; ++j) {
                                c[j] = vfun.execute(c[j], tmp[j]);
                            }
                        }
                    }
                    lnnz = out.recomputeNonZeros();
                }
                catch (Exception ex) {
                    throw new DMLRuntimeException(ex);
                }
            }
        }
        out.setNonZeros(lnnz);
        out.examSparsity();
        return out;
    }

    private long executeDense(double[] a, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double[] c = out.getDenseBlock();
        SpoofOperator.SideInput[] lb = SpoofCellwise.createSparseSideInputs(b);
        if (this._type == CellType.NO_AGG) {
            return this.executeDenseNoAgg(a, lb, scalars, c, m, n, sparseSafe, rl, ru);
        }
        if (this._type == CellType.ROW_AGG) {
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeDenseRowAggSum(a, lb, scalars, c, m, n, sparseSafe, rl, ru);
            }
            return this.executeDenseRowAggMxx(a, lb, scalars, c, m, n, sparseSafe, rl, ru);
        }
        if (this._type == CellType.COL_AGG) {
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeDenseColAggSum(a, lb, scalars, c, m, n, sparseSafe, rl, ru);
            }
            return this.executeDenseColAggMxx(a, lb, scalars, c, m, n, sparseSafe, rl, ru);
        }
        return -1L;
    }

    private double executeDenseAndAgg(double[] a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        SpoofOperator.SideInput[] lb = SpoofCellwise.createSparseSideInputs(b);
        if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
            return this.executeDenseAggSum(a, lb, scalars, m, n, sparseSafe, rl, ru);
        }
        return this.executeDenseAggMxx(a, lb, scalars, m, n, sparseSafe, rl, ru);
    }

    private long executeSparse(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        if (sparseSafe && sblock == null) {
            return 0L;
        }
        SpoofOperator.SideInput[] lb = SpoofCellwise.createSparseSideInputs(b);
        if (this._type == CellType.NO_AGG) {
            if (out.isInSparseFormat()) {
                return this.executeSparseNoAggSparse(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru);
            }
            return this.executeSparseNoAggDense(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru);
        }
        if (this._type == CellType.ROW_AGG) {
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeSparseRowAggSum(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru);
            }
            return this.executeSparseRowAggMxx(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru);
        }
        if (this._type == CellType.COL_AGG) {
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeSparseColAggSum(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru);
            }
            return this.executeSparseColAggMxx(sblock, lb, scalars, out, m, n, sparseSafe, rl, ru);
        }
        return -1L;
    }

    private double executeSparseAndAgg(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        if (sparseSafe && sblock == null) {
            return 0.0;
        }
        SpoofOperator.SideInput[] lb = SpoofCellwise.createSparseSideInputs(b);
        if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
            return this.executeSparseAggSum(sblock, lb, scalars, m, n, sparseSafe, rl, ru);
        }
        return this.executeSparseAggMxx(sblock, lb, scalars, m, n, sparseSafe, rl, ru);
    }

    private long executeCompressed(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        if (this._type == CellType.NO_AGG) {
            long lnnz = this.executeCompressedNoAgg(a, b, scalars, out, m, n, sparseSafe, rl, ru);
            if (out.isInSparseFormat()) {
                out.sortSparseRows(rl, ru);
            }
            return lnnz;
        }
        if (this._type == CellType.ROW_AGG) {
            double[] c = out.getDenseBlock();
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeCompressedRowAggSum(a, b, scalars, c, m, n, sparseSafe, rl, ru);
            }
            return this.executeCompressedRowAggMxx(a, b, scalars, c, m, n, sparseSafe, rl, ru);
        }
        if (this._type == CellType.COL_AGG) {
            double[] c = out.getDenseBlock();
            if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
                return this.executeCompressedColAggSum(a, b, scalars, c, m, n, sparseSafe, rl, ru);
            }
            return this.executeCompressedColAggMxx(a, b, scalars, c, m, n, sparseSafe, rl, ru);
        }
        return -1L;
    }

    private double executeCompressedAndAgg(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        if (this._aggOp == AggOp.SUM || this._aggOp == AggOp.SUM_SQ) {
            return this.executeCompressedAggSum(a, b, scalars, m, n, sparseSafe, rl, ru);
        }
        return this.executeCompressedAggMxx(a, b, scalars, m, n, sparseSafe, rl, ru);
    }

    private long executeDenseNoAgg(double[] a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        long lnnz = 0L;
        int ix = rl * n;
        for (int i = rl; i < ru; ++i) {
            int j = 0;
            while (j < n) {
                double aval;
                double d = aval = a != null ? a[ix] : 0.0;
                if (aval != 0.0 || !sparseSafe) {
                    c[ix] = this.genexec(aval, b, scalars, m, n, i, j);
                    lnnz += c[ix] != 0.0 ? 1L : 0L;
                }
                ++j;
                ++ix;
            }
        }
        return lnnz;
    }

    private long executeDenseRowAggSum(double[] a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        long lnnz = 0L;
        int ix = rl * n;
        for (int i = rl; i < ru; ++i) {
            kbuff.set(0.0, 0.0);
            int j = 0;
            while (j < n) {
                double aval;
                double d = aval = a != null ? a[ix] : 0.0;
                if (aval != 0.0 || !sparseSafe) {
                    kplus.execute2(kbuff, this.genexec(aval, b, scalars, m, n, i, j));
                }
                ++j;
                ++ix;
            }
            c[i] = kbuff._sum;
            lnnz += c[i] != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeDenseRowAggMxx(double[] a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        long lnnz;
        block7: {
            ValueFunction vfun;
            double initialVal;
            block6: {
                initialVal = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
                vfun = this.getAggFunction();
                lnnz = 0L;
                if (a != null || sparseSafe) break block6;
                for (int i = rl; i < ru; ++i) {
                    double tmp = initialVal;
                    for (int j = 0; j < n; ++j) {
                        tmp = vfun.execute(tmp, this.genexec(0.0, b, scalars, m, n, i, j));
                    }
                    c[i] = tmp;
                    lnnz += c[i] != 0.0 ? 1L : 0L;
                }
                break block7;
            }
            if (a == null) break block7;
            int ix = rl * n;
            for (int i = rl; i < ru; ++i) {
                double tmp = initialVal;
                int j = 0;
                while (j < n) {
                    if (a[ix] != 0.0 || !sparseSafe) {
                        tmp = vfun.execute(tmp, this.genexec(a[ix], b, scalars, m, n, i, j));
                    }
                    ++j;
                    ++ix;
                }
                if (sparseSafe && UtilFunctions.containsZero(a, ix - n, n)) {
                    tmp = vfun.execute(tmp, 0.0);
                }
                lnnz += (c[i] = tmp) != 0.0 ? 1L : 0L;
            }
        }
        return lnnz;
    }

    private long executeDenseColAggSum(double[] a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        double[] corr = new double[n];
        int ix = rl * n;
        for (int i = rl; i < ru; ++i) {
            int j = 0;
            while (j < n) {
                double aval;
                double d = aval = a != null ? a[ix] : 0.0;
                if (aval != 0.0 || !sparseSafe) {
                    kbuff.set(c[j], corr[j]);
                    kplus.execute2(kbuff, this.genexec(aval, b, scalars, m, n, i, j));
                    c[j] = kbuff._sum;
                    corr[j] = kbuff._correction;
                }
                ++j;
                ++ix;
            }
        }
        return -1L;
    }

    private long executeDenseColAggMxx(double[] a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        block8: {
            ValueFunction vfun;
            block7: {
                double initialVal = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
                vfun = this.getAggFunction();
                Arrays.fill(c, initialVal);
                if (a != null || sparseSafe) break block7;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        c[j] = vfun.execute(c[j], this.genexec(0.0, b, scalars, m, n, i, j));
                    }
                }
                break block8;
            }
            if (a == null) break block8;
            int[] counts = new int[n];
            int ix = rl * n;
            for (int i = rl; i < ru; ++i) {
                int j = 0;
                while (j < n) {
                    if (a[ix] != 0.0 || !sparseSafe) {
                        c[j] = vfun.execute(c[j], this.genexec(a[ix], b, scalars, m, n, i, j));
                        int n2 = j;
                        counts[n2] = counts[n2] + 1;
                    }
                    ++j;
                    ++ix;
                }
            }
            if (sparseSafe) {
                for (int j = 0; j < n; ++j) {
                    if (counts[j] == ru - rl) continue;
                    c[j] = vfun.execute(c[j], 0.0);
                }
            }
        }
        return -1L;
    }

    private double executeDenseAggSum(double[] a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        int ix = rl * n;
        for (int i = rl; i < ru; ++i) {
            int j = 0;
            while (j < n) {
                double aval;
                double d = aval = a != null ? a[ix] : 0.0;
                if (aval != 0.0 || !sparseSafe) {
                    kplus.execute2(kbuff, this.genexec(aval, b, scalars, m, n, i, j));
                }
                ++j;
                ++ix;
            }
        }
        return kbuff._sum;
    }

    private double executeDenseAggMxx(double[] a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double ret = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
        ValueFunction vfun = this.getAggFunction();
        int ix = rl * n;
        for (int i = rl; i < ru; ++i) {
            int j = 0;
            while (j < n) {
                double aval;
                double d = aval = a != null ? a[ix] : 0.0;
                if (aval != 0.0 || !sparseSafe) {
                    ret = vfun.execute(ret, this.genexec(aval, b, scalars, m, n, i, j));
                }
                ++j;
                ++ix;
            }
        }
        return ret;
    }

    private long executeSparseNoAggSparse(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        SparseBlock c = out.getSparseBlock();
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                c.allocate(i, sparseSafe ? alen : n);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            c.append(i, j, this.genexec(0.0, b, scalars, m, n, i, j));
                        }
                    }
                    lastj = aix[k];
                    c.append(i, lastj, this.genexec(avals[k], b, scalars, m, n, i, lastj));
                }
            }
            if (!sparseSafe) {
                for (int j = lastj + 1; j < n; ++j) {
                    c.append(i, j, this.genexec(0.0, b, scalars, m, n, i, j));
                }
            }
            lnnz += (long)c.size(i);
        }
        return lnnz;
    }

    private long executeSparseNoAggDense(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double[] c = out.getDenseBlock();
        long lnnz = 0L;
        int i = rl;
        int cix = rl * n;
        while (i < ru) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            double d = this.genexec(0.0, b, scalars, m, n, i, j);
                            c[cix + j] = d;
                            lnnz += d != 0.0 ? 1L : 0L;
                        }
                    }
                    lastj = aix[k];
                    double d = this.genexec(avals[k], b, scalars, m, n, i, lastj);
                    c[cix + lastj] = d;
                    lnnz += d != 0.0 ? 1L : 0L;
                }
            }
            if (!sparseSafe) {
                for (int j = lastj + 1; j < n; ++j) {
                    double d = this.genexec(0.0, b, scalars, m, n, i, j);
                    c[cix + j] = d;
                    lnnz += d != 0.0 ? 1L : 0L;
                }
            }
            ++i;
            cix += n;
        }
        return lnnz;
    }

    private long executeSparseRowAggSum(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        double[] c = out.getDenseBlock();
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            kbuff.set(0.0, 0.0);
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, i, j));
                        }
                    }
                    lastj = aix[k];
                    kplus.execute2(kbuff, this.genexec(avals[k], b, scalars, m, n, i, lastj));
                }
            }
            if (!sparseSafe) {
                for (int j = lastj + 1; j < n; ++j) {
                    kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, i, j));
                }
            }
            lnnz += (c[i] = kbuff._sum) != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeSparseRowAggMxx(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double initialVal = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
        ValueFunction vfun = this.getAggFunction();
        double[] c = out.getDenseBlock();
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            double tmp = sparseSafe && sblock.size(i) < n ? 0.0 : initialVal;
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            tmp = vfun.execute(tmp, this.genexec(0.0, b, scalars, m, n, i, j));
                        }
                    }
                    lastj = aix[k];
                    tmp = vfun.execute(tmp, this.genexec(avals[k], b, scalars, m, n, i, lastj));
                }
            }
            if (!sparseSafe) {
                for (int j = lastj + 1; j < n; ++j) {
                    tmp = vfun.execute(tmp, this.genexec(0.0, b, scalars, m, n, i, j));
                }
            }
            lnnz += (c[i] = tmp) != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeSparseColAggSum(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        double[] corr = new double[n];
        double[] c = out.getDenseBlock();
        for (int i = rl; i < ru; ++i) {
            kbuff.set(0.0, 0.0);
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            kbuff.set(c[j], corr[j]);
                            kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, i, j));
                            c[j] = kbuff._sum;
                            corr[j] = kbuff._correction;
                        }
                    }
                    lastj = aix[k];
                    kbuff.set(c[aix[k]], corr[aix[k]]);
                    kplus.execute2(kbuff, this.genexec(avals[k], b, scalars, m, n, i, lastj));
                    c[aix[k]] = kbuff._sum;
                    corr[aix[k]] = kbuff._correction;
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                kbuff.set(c[j], corr[j]);
                kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, i, j));
                c[j] = kbuff._sum;
                corr[j] = kbuff._correction;
            }
        }
        return -1L;
    }

    private long executeSparseColAggMxx(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double initialVal = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
        ValueFunction vfun = this.getAggFunction();
        double[] c = out.getDenseBlock();
        Arrays.fill(c, initialVal);
        int[] count = new int[n];
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        int j = lastj + 1;
                        while (j < aix[k]) {
                            c[j] = vfun.execute(c[j], this.genexec(0.0, b, scalars, m, n, i, j));
                            int n2 = j++;
                            count[n2] = count[n2] + 1;
                        }
                    }
                    lastj = aix[k];
                    c[aix[k]] = vfun.execute(c[aix[k]], this.genexec(avals[k], b, scalars, m, n, i, lastj));
                    int n3 = aix[k];
                    count[n3] = count[n3] + 1;
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                c[j] = vfun.execute(c[j], this.genexec(0.0, b, scalars, m, n, i, j));
            }
        }
        return -1L;
    }

    private double executeSparseAggSum(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, i, j));
                        }
                    }
                    lastj = aix[k];
                    kplus.execute2(kbuff, this.genexec(avals[k], b, scalars, m, n, i, lastj));
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, i, j));
            }
        }
        return kbuff._sum;
    }

    private double executeSparseAggMxx(SparseBlock sblock, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double ret = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
        ret = sparseSafe && sblock.size() < (long)m * (long)n ? 0.0 : ret;
        ValueFunction vfun = this.getAggFunction();
        for (int i = rl; i < ru; ++i) {
            int lastj = -1;
            if (sblock != null && !sblock.isEmpty(i)) {
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                int[] aix = sblock.indexes(i);
                double[] avals = sblock.values(i);
                for (int k = apos; k < apos + alen; ++k) {
                    if (!sparseSafe) {
                        for (int j = lastj + 1; j < aix[k]; ++j) {
                            ret = vfun.execute(ret, this.genexec(0.0, b, scalars, m, n, i, j));
                        }
                    }
                    lastj = aix[k];
                    ret = vfun.execute(ret, this.genexec(avals[k], b, scalars, m, n, i, lastj));
                }
            }
            if (sparseSafe) continue;
            for (int j = lastj + 1; j < n; ++j) {
                ret = vfun.execute(ret, this.genexec(0.0, b, scalars, m, n, i, j));
            }
        }
        return ret;
    }

    private long executeCompressedNoAgg(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock out, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double[] c = out.getDenseBlock();
        SparseBlock csblock = out.getSparseBlock();
        if (out.isInSparseFormat() && rl % 65536 == 0 && ru % 65536 == 0) {
            int[] rnnz = a.countNonZerosPerRow(rl, ru);
            for (int i = rl; i < ru; ++i) {
                csblock.allocate(i, rnnz[i - rl]);
            }
        }
        long lnnz = 0L;
        Iterator<IJV> iter = a.getIterator(rl, ru, !sparseSafe);
        while (iter.hasNext()) {
            IJV cell = iter.next();
            double val = this.genexec(cell.getV(), b, scalars, m, n, cell.getI(), cell.getJ());
            if (out.isInSparseFormat()) {
                csblock.allocate(cell.getI());
                csblock.append(cell.getI(), cell.getJ(), val);
            } else {
                c[cell.getI() * n + cell.getJ()] = val;
            }
            lnnz += val != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeCompressedRowAggSum(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        long lnnz = 0L;
        Iterator<IJV> iter = a.getIterator(rl, ru, !sparseSafe);
        while (iter.hasNext()) {
            IJV cell = iter.next();
            double val = this.genexec(cell.getV(), b, scalars, m, n, cell.getI(), cell.getJ());
            kbuff.set(c[cell.getI()], 0.0);
            kplus.execute2(kbuff, val);
            c[cell.getI()] = kbuff._sum;
        }
        for (int i = rl; i < ru; ++i) {
            lnnz += c[i] != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeCompressedRowAggMxx(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        Arrays.fill(c, rl, ru, this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308);
        ValueFunction vfun = this.getAggFunction();
        long lnnz = 0L;
        Iterator<IJV> iter = a.getIterator(rl, ru, !sparseSafe);
        while (iter.hasNext()) {
            IJV cell = iter.next();
            double val = this.genexec(cell.getV(), b, scalars, m, n, cell.getI(), cell.getJ());
            c[cell.getI()] = vfun.execute(c[cell.getI()], val);
        }
        for (int i = rl; i < ru; ++i) {
            lnnz += c[i] != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private long executeCompressedColAggSum(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        double[] corr = new double[n];
        Iterator<IJV> iter = a.getIterator(rl, ru, !sparseSafe);
        while (iter.hasNext()) {
            IJV cell = iter.next();
            double val = this.genexec(cell.getV(), b, scalars, m, n, cell.getI(), cell.getJ());
            kbuff.set(c[cell.getJ()], corr[cell.getJ()]);
            kplus.execute2(kbuff, val);
            c[cell.getJ()] = kbuff._sum;
            corr[cell.getJ()] = kbuff._correction;
        }
        return -1L;
    }

    private long executeCompressedColAggMxx(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        Arrays.fill(c, rl, ru, this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308);
        ValueFunction vfun = this.getAggFunction();
        long lnnz = 0L;
        Iterator<IJV> iter = a.getIterator(rl, ru, !sparseSafe);
        while (iter.hasNext()) {
            IJV cell = iter.next();
            double val = this.genexec(cell.getV(), b, scalars, m, n, cell.getI(), cell.getJ());
            c[cell.getI()] = vfun.execute(c[cell.getI()], val);
        }
        for (int i = rl; i < ru; ++i) {
            lnnz += c[i] != 0.0 ? 1L : 0L;
        }
        return lnnz;
    }

    private double executeCompressedAggSum(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        KahanFunction kplus = (KahanFunction)this.getAggFunction();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        KahanObject kbuff2 = new KahanObject(0.0, 0.0);
        if (sparseSafe && b.length == 0 && !a.hasUncompressedColGroup()) {
            boolean entireGrp = rl == 0 && ru == a.getNumRows();
            for (ColGroup grp : a.getColGroups()) {
                ColGroupValue grpv = (ColGroupValue)grp;
                int[] counts = entireGrp ? grpv.getCounts() : grpv.getCounts(rl, ru);
                for (int k = 0; k < grpv.getNumValues(); ++k) {
                    kbuff2.set(0.0, 0.0);
                    double in = grpv.sumValues(k, kplus, kbuff2);
                    double out = this.genexec(in, b, scalars, m, n, -1, -1);
                    kplus.execute3(kbuff, out, counts[k]);
                }
            }
        } else {
            Iterator<IJV> iter = a.getIterator(rl, ru, !sparseSafe);
            while (iter.hasNext()) {
                IJV cell = iter.next();
                double val = this.genexec(cell.getV(), b, scalars, m, n, cell.getI(), cell.getJ());
                kplus.execute2(kbuff, val);
            }
        }
        return kbuff._sum;
    }

    private double executeCompressedAggMxx(CompressedMatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double ret = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
        ValueFunction vfun = this.getAggFunction();
        Iterator<IJV> iter = a.getIterator(rl, ru, !sparseSafe);
        while (iter.hasNext()) {
            IJV cell = iter.next();
            double val = this.genexec(cell.getV(), b, scalars, m, n, cell.getI(), cell.getJ());
            ret = vfun.execute(ret, val);
        }
        return ret;
    }

    protected abstract double genexec(double var1, SpoofOperator.SideInput[] var3, double[] var4, int var5, int var6, int var7, int var8);

    private class ParExecTask
    implements Callable<Long> {
        private final MatrixBlock _a;
        private final SpoofOperator.SideInput[] _b;
        private final double[] _scalars;
        private MatrixBlock _c;
        private final int _rlen;
        private final int _clen;
        private final boolean _safe;
        private final int _rl;
        private final int _ru;

        protected ParExecTask(MatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, MatrixBlock c, int rlen, int clen, boolean sparseSafe, int rl, int ru) {
            this._a = a;
            this._b = b;
            this._scalars = scalars;
            this._c = c;
            this._rlen = rlen;
            this._clen = clen;
            this._safe = sparseSafe;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Long call() throws DMLRuntimeException {
            if (SpoofCellwise.this._type == CellType.COL_AGG) {
                this._c = new MatrixBlock(1, this._clen, false);
                this._c.allocateDenseBlock();
            }
            if (this._a instanceof CompressedMatrixBlock) {
                return SpoofCellwise.this.executeCompressed((CompressedMatrixBlock)this._a, this._b, this._scalars, this._c, this._rlen, this._clen, this._safe, this._rl, this._ru);
            }
            if (!this._a.isInSparseFormat()) {
                return SpoofCellwise.this.executeDense(this._a.getDenseBlock(), this._b, this._scalars, this._c, this._rlen, this._clen, this._safe, this._rl, this._ru);
            }
            return SpoofCellwise.this.executeSparse(this._a.getSparseBlock(), this._b, this._scalars, this._c, this._rlen, this._clen, this._safe, this._rl, this._ru);
        }

        public MatrixBlock getResult() {
            return this._c;
        }
    }

    private class ParAggTask
    implements Callable<Double> {
        private final MatrixBlock _a;
        private final SpoofOperator.SideInput[] _b;
        private final double[] _scalars;
        private final int _rlen;
        private final int _clen;
        private final boolean _safe;
        private final int _rl;
        private final int _ru;

        protected ParAggTask(MatrixBlock a, SpoofOperator.SideInput[] b, double[] scalars, int rlen, int clen, boolean sparseSafe, int rl, int ru) {
            this._a = a;
            this._b = b;
            this._scalars = scalars;
            this._rlen = rlen;
            this._clen = clen;
            this._safe = sparseSafe;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Double call() throws DMLRuntimeException {
            if (this._a instanceof CompressedMatrixBlock) {
                return SpoofCellwise.this.executeCompressedAndAgg((CompressedMatrixBlock)this._a, this._b, this._scalars, this._rlen, this._clen, this._safe, this._rl, this._ru);
            }
            if (!this._a.isInSparseFormat()) {
                return SpoofCellwise.this.executeDenseAndAgg(this._a.getDenseBlock(), this._b, this._scalars, this._rlen, this._clen, this._safe, this._rl, this._ru);
            }
            return SpoofCellwise.this.executeSparseAndAgg(this._a.getSparseBlock(), this._b, this._scalars, this._rlen, this._clen, this._safe, this._rl, this._ru);
        }
    }

    public static enum AggOp {
        SUM,
        SUM_SQ,
        MIN,
        MAX;

    }

    public static enum CellType {
        NO_AGG,
        FULL_AGG,
        ROW_AGG,
        COL_AGG;

    }
}

