/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api;

import java.util.List;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.api.mlcontext.ScriptExecutor;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.codegen.SpoofCompiler;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.utils.NativeHelper;
import org.apache.sysml.utils.Statistics;

public class ScriptExecutorUtils {
    public static void executeRuntimeProgram(ScriptExecutor se, int statisticsMaxHeavyHitters) throws DMLRuntimeException {
        Program prog = se.getRuntimeProgram();
        ExecutionContext ec = se.getExecutionContext();
        DMLConfig config = se.getConfig();
        ScriptExecutorUtils.executeRuntimeProgram(prog, ec, config, statisticsMaxHeavyHitters);
    }

    public static void executeRuntimeProgram(Program rtprog, ExecutionContext ec, DMLConfig dmlconf, int statisticsMaxHeavyHitters) throws DMLRuntimeException {
        DMLScript.FINEGRAINED_STATISTICS = DMLScript.STATISTICS && dmlconf.getBooleanValue("sysml.stats.finegrained");
        DMLScript.SYNCHRONIZE_GPU = dmlconf.getBooleanValue("sysml.gpu.sync.postProcess");
        DMLScript.EAGER_CUDA_FREE = dmlconf.getBooleanValue("sysml.gpu.eager.cudaFree");
        DMLScript.STATISTICS_MAX_WRAP_LEN = dmlconf.getIntValue("sysml.stats.maxWrapLength");
        NativeHelper.initialize(dmlconf.getTextValue("sysml.native.blas.directory"), dmlconf.getTextValue("sysml.native.blas").trim());
        if (DMLScript.USE_ACCELERATOR) {
            DMLScript.FLOATING_POINT_PRECISION = dmlconf.getTextValue("sysml.floating.point.precision");
            LibMatrixCUDA.resetFloatingPointPrecision();
        }
        boolean exceptionThrown = false;
        Statistics.startRunTimer();
        try {
            if (DMLScript.USE_ACCELERATOR && ec != null) {
                List<GPUContext> gCtxs = GPUContextPool.reserveAllGPUContexts();
                if (gCtxs == null) {
                    throw new DMLRuntimeException("GPU : Could not create GPUContext, either no GPU or all GPUs currently in use");
                }
                gCtxs.get(0).initializeThread();
                ec.setGPUContexts(gCtxs);
            }
            rtprog.execute(ec);
        }
        catch (Throwable e) {
            exceptionThrown = true;
            throw e;
        }
        finally {
            if (DMLScript.USE_ACCELERATOR && !ec.getGPUContexts().isEmpty()) {
                ec.getGPUContexts().forEach(gCtx -> gCtx.clearTemporaryMemory());
                GPUContextPool.freeAllGPUContexts();
            }
            if (ConfigurationManager.isCodegenEnabled()) {
                SpoofCompiler.cleanupCodeGenerator();
            }
            Statistics.stopRunTimer();
            if (!exceptionThrown) {
                if (statisticsMaxHeavyHitters > 0) {
                    System.out.println(Statistics.display(statisticsMaxHeavyHitters));
                } else {
                    System.out.println(Statistics.display());
                }
            } else if (statisticsMaxHeavyHitters > 0) {
                System.err.println(Statistics.display(statisticsMaxHeavyHitters));
            } else {
                System.err.println(Statistics.display());
            }
        }
    }
}

