/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import java.io.IOException;
import java.util.Iterator;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;
import org.apache.sysml.udf.Scalar;

public class CumSumProd
extends PackageFunction {
    private static final long serialVersionUID = -7883258699548686065L;
    private Matrix ret;
    private MatrixBlock retMB;
    private MatrixBlock X;
    private MatrixBlock C;
    private double start;
    private boolean isReverse;
    int numRetRows;
    int numRetCols;
    double[] denseBlock;

    @Override
    public int getNumFunctionOutputs() {
        return 1;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        if (pos == 0) {
            return this.ret;
        }
        throw new RuntimeException("CumSumProd produces only one output");
    }

    @Override
    public void execute() {
        try {
            int i;
            this.X = (MatrixBlock)((Matrix)this.getFunctionInput(0)).getMatrixObject().acquireRead();
            this.C = (MatrixBlock)((Matrix)this.getFunctionInput(1)).getMatrixObject().acquireRead();
            if (this.X.getNumRows() != this.C.getNumRows()) {
                throw new RuntimeException("Number of rows of X and C should match");
            }
            if (this.X.getNumColumns() != this.C.getNumColumns() && this.C.getNumColumns() != 1) {
                throw new RuntimeException("Incorrect Number of columns of X and C (Expected C to be of same dimension or a vector)");
            }
            this.start = Double.parseDouble(((Scalar)this.getFunctionInput(2)).getValue());
            this.isReverse = Boolean.parseBoolean(((Scalar)this.getFunctionInput(3)).getValue());
            this.numRetRows = this.X.getNumRows();
            this.numRetCols = this.X.getNumColumns();
            this.allocateOutput();
            this.denseBlock = this.retMB.getDenseBlock();
            if (this.X.isInSparseFormat()) {
                Iterator<IJV> iter = this.X.getSparseBlockIterator();
                while (iter.hasNext()) {
                    IJV ijv = iter.next();
                    this.denseBlock[ijv.getI() * this.numRetCols + ijv.getJ()] = ijv.getV();
                }
            } else if (this.X.getDenseBlock() != null) {
                System.arraycopy(this.X.getDenseBlock(), 0, this.denseBlock, 0, this.denseBlock.length);
            }
            if (!this.isReverse) {
                this.addCNConstant(0, this.start);
                for (i = 1; i < this.numRetRows; ++i) {
                    this.addC(i, true);
                }
            } else {
                this.addCNConstant(this.numRetRows - 1, this.start);
                for (i = this.numRetRows - 2; i >= 0; --i) {
                    this.addC(i, false);
                }
            }
            ((Matrix)this.getFunctionInput(1)).getMatrixObject().release();
            ((Matrix)this.getFunctionInput(0)).getMatrixObject().release();
        }
        catch (CacheException e) {
            throw new RuntimeException("Error while executing CumSumProd", e);
        }
        this.retMB.recomputeNonZeros();
        try {
            this.retMB.examSparsity();
            this.ret.setMatrixDoubleArray(this.retMB, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException("Error while executing CumSumProd", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing CumSumProd", e);
        }
    }

    private void addCNConstant(int i, double constant) {
        block8: {
            boolean isCVector;
            block7: {
                boolean bl = isCVector = (long)this.C.getNumColumns() != this.ret.getNumCols();
                if (!this.C.isInSparseFormat()) break block7;
                Iterator<IJV> iter = this.C.getSparseBlockIterator(i, i + 1);
                while (iter.hasNext()) {
                    IJV ijv = iter.next();
                    if (!isCVector) {
                        int n = ijv.getI() * this.numRetCols + ijv.getJ();
                        this.denseBlock[n] = this.denseBlock[n] + ijv.getV() * constant;
                        continue;
                    }
                    double val = ijv.getV();
                    int j = ijv.getI() * this.numRetCols;
                    while (j < (ijv.getI() + 1) * this.numRetCols) {
                        int n = j++;
                        this.denseBlock[n] = this.denseBlock[n] + val * constant;
                    }
                }
                break block8;
            }
            double[] CBlk = this.C.getDenseBlock();
            if (CBlk == null) break block8;
            if (!isCVector) {
                for (int j = i * this.numRetCols; j < (i + 1) * this.numRetCols; ++j) {
                    int n = j;
                    this.denseBlock[n] = this.denseBlock[n] + CBlk[j] * constant;
                }
            } else {
                int j = i * this.numRetCols;
                while (j < (i + 1) * this.numRetCols) {
                    int n = j++;
                    this.denseBlock[n] = this.denseBlock[n] + CBlk[i] * constant;
                }
            }
        }
    }

    private void addC(int i, boolean addPrevRow) {
        block9: {
            boolean isCVector;
            block8: {
                boolean bl = isCVector = (long)this.C.getNumColumns() != this.ret.getNumCols();
                if (!this.C.isInSparseFormat()) break block8;
                Iterator<IJV> iter = this.C.getSparseBlockIterator(i, i + 1);
                while (iter.hasNext()) {
                    IJV ijv = iter.next();
                    if (!isCVector) {
                        if (addPrevRow) {
                            int n = ijv.getI() * this.numRetCols + ijv.getJ();
                            this.denseBlock[n] = this.denseBlock[n] + ijv.getV() * this.denseBlock[(ijv.getI() - 1) * this.numRetCols + ijv.getJ()];
                            continue;
                        }
                        int n = ijv.getI() * this.numRetCols + ijv.getJ();
                        this.denseBlock[n] = this.denseBlock[n] + ijv.getV() * this.denseBlock[(ijv.getI() + 1) * this.numRetCols + ijv.getJ()];
                        continue;
                    }
                    double val = ijv.getV();
                    int j = ijv.getI() * this.numRetCols;
                    while (j < (ijv.getI() + 1) * this.numRetCols) {
                        double val1 = addPrevRow ? this.denseBlock[(ijv.getI() - 1) * this.numRetCols + ijv.getJ()] : this.denseBlock[(ijv.getI() + 1) * this.numRetCols + ijv.getJ()];
                        int n = j++;
                        this.denseBlock[n] = this.denseBlock[n] + val * val1;
                    }
                }
                break block9;
            }
            double[] CBlk = this.C.getDenseBlock();
            if (CBlk == null) break block9;
            if (!isCVector) {
                for (int j = i * this.numRetCols; j < (i + 1) * this.numRetCols; ++j) {
                    double val1 = addPrevRow ? this.denseBlock[j - this.numRetCols] : this.denseBlock[j + this.numRetCols];
                    int n = j;
                    this.denseBlock[n] = this.denseBlock[n] + CBlk[j] * val1;
                }
            } else {
                int j = i * this.numRetCols;
                while (j < (i + 1) * this.numRetCols) {
                    double val1 = addPrevRow ? this.denseBlock[j - this.numRetCols] : this.denseBlock[j + this.numRetCols];
                    int n = j++;
                    this.denseBlock[n] = this.denseBlock[n] + CBlk[i] * val1;
                }
            }
        }
    }

    private void allocateOutput() {
        String dir = this.createOutputFilePathAndName("TMP");
        this.ret = new Matrix(dir, this.numRetRows, this.numRetCols, Matrix.ValueType.Double);
        this.retMB = new MatrixBlock(this.numRetRows, this.numRetCols, false);
        this.retMB.allocateDenseBlock();
    }
}

