/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.algorithms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.algorithms.glm.Binomial_probability_two_column_output;
import org.apache.sysml.scripts.algorithms.glm.Get_CG_Steihaug_point_output;
import org.apache.sysml.scripts.algorithms.glm.Get_trust_boundary_point_output;
import org.apache.sysml.scripts.algorithms.glm.Glm_dist_output;
import org.apache.sysml.scripts.algorithms.glm.Glm_initialize_output;
import org.apache.sysml.scripts.algorithms.glm.Glm_log_likelihood_part_output;
import org.apache.sysml.scripts.algorithms.glm.Round_to_print_output;

public class GLM
extends Script {
    public GLM() {
        String string = "scripts/algorithms/GLM.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Get_trust_boundary_point_output get_trust_boundary_point(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;[new_z, f_change] = mlcontextns::get_trust_boundary_point(g, z, p, q, r, pp, pq, trust_delta_sq);";
        Script script = new Script(string);
        script.in("g", object).in("z", object2).in("p", object3).in("q", object4).in("r", object5).in("pp", object6).in("pq", object7).in("trust_delta_sq", object8).out("new_z").out("f_change");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("new_z");
        double d = mLResults.getDouble("f_change");
        Get_trust_boundary_point_output get_trust_boundary_point_output = new Get_trust_boundary_point_output(matrix, d);
        return get_trust_boundary_point_output;
    }

    public String get_trust_boundary_point__docs() {
        String string = "get_trust_boundary_point = \n    function (Matrix[double] g, Matrix[double] z, Matrix[double] p, \n              Matrix[double] q, Matrix[double] r, double pp, double pq, \n              double trust_delta_sq)\n    return (Matrix[double] new_z, double f_change)\n{\n    zz = sum (z * z);  pz = sum (p * z);\n    sq_root_d = sqrt (pz * pz - pp * (zz - trust_delta_sq));\n    tau_1 = (- pz + sq_root_d) / pp;\n    tau_2 = (- pz - sq_root_d) / pp;\n    zq = sum (z * q);  gp = sum (g * p);\n    f_extra = 0.5 * sum (z * (r + g));\n    f_change_1 = f_extra + (0.5 * tau_1 * pq + zq + gp) * tau_1;\n    f_change_2 = f_extra + (0.5 * tau_2 * pq + zq + gp) * tau_2;\n    if (f_change_1 < f_change_2) {\n        new_z = z + (tau_1 * p);\n        f_change = f_change_1;\n    }\n    else {\n        new_z = z + (tau_2 * p);\n        f_change = f_change_2;\n    }\n}\n";
        return string;
    }

    public String get_trust_boundary_point__source() {
        String string = "get_trust_boundary_point = \n    function (Matrix[double] g, Matrix[double] z, Matrix[double] p, \n              Matrix[double] q, Matrix[double] r, double pp, double pq, \n              double trust_delta_sq)\n    return (Matrix[double] new_z, double f_change)\n{\n    zz = sum (z * z);  pz = sum (p * z);\n    sq_root_d = sqrt (pz * pz - pp * (zz - trust_delta_sq));\n    tau_1 = (- pz + sq_root_d) / pp;\n    tau_2 = (- pz - sq_root_d) / pp;\n    zq = sum (z * q);  gp = sum (g * p);\n    f_extra = 0.5 * sum (z * (r + g));\n    f_change_1 = f_extra + (0.5 * tau_1 * pq + zq + gp) * tau_1;\n    f_change_2 = f_extra + (0.5 * tau_2 * pq + zq + gp) * tau_2;\n    if (f_change_1 < f_change_2) {\n        new_z = z + (tau_1 * p);\n        f_change = f_change_1;\n    }\n    else {\n        new_z = z + (tau_2 * p);\n        f_change = f_change_2;\n    }\n}\n";
        return string;
    }

    public Get_CG_Steihaug_point_output get_CG_Steihaug_point(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;[z, neg_log_l_change, i_CG, reached_trust_boundary] = mlcontextns::get_CG_Steihaug_point(X, scale_X, shift_X, w, g, beta, lambda, trust_delta, max_iter_CG);";
        Script script = new Script(string);
        script.in("X", object).in("scale_X", object2).in("shift_X", object3).in("w", object4).in("g", object5).in("beta", object6).in("lambda", object7).in("trust_delta", object8).in("max_iter_CG", object9).out("z").out("neg_log_l_change").out("i_CG").out("reached_trust_boundary");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("z");
        double d = mLResults.getDouble("neg_log_l_change");
        long l = mLResults.getLong("i_CG");
        long l2 = mLResults.getLong("reached_trust_boundary");
        Get_CG_Steihaug_point_output get_CG_Steihaug_point_output = new Get_CG_Steihaug_point_output(matrix, d, l, l2);
        return get_CG_Steihaug_point_output;
    }

    public String get_CG_Steihaug_point__docs() {
        String string = "get_CG_Steihaug_point =\n    function (Matrix[double] X, Matrix[double] scale_X, Matrix[double] shift_X, Matrix[double] w,\n    Matrix[double] g, Matrix[double] beta, Matrix[double] lambda, double trust_delta, int max_iter_CG)\n    return (Matrix[double] z, double neg_log_l_change, int i_CG, int reached_trust_boundary)\n{\n    trust_delta_sq = trust_delta ^ 2;\n    size_CG = nrow (g);\n    z = matrix (0.0, rows = size_CG, cols = 1);\n    neg_log_l_change = 0.0;\n    reached_trust_boundary = 0;\n    g_reg = g + lambda * beta;\n    r_CG = g_reg;\n    p_CG = -r_CG;\n    rr_CG = sum(r_CG * r_CG);\n    eps_CG = rr_CG * min (0.25, sqrt (rr_CG));\n    converged_CG = 0;\n    if (rr_CG < eps_CG) {\n        converged_CG = 1;\n    }\n    \n    max_iteration_CG = max_iter_CG;\n    if (max_iteration_CG <= 0) {\n        max_iteration_CG = size_CG;\n    }\n    i_CG = 0;\n    while (converged_CG == 0)\n    {\n        i_CG = i_CG + 1;\n        ssX_p_CG = diag (scale_X) %*% p_CG;\n        ssX_p_CG [size_CG, ] = ssX_p_CG [size_CG, ] + t(shift_X) %*% p_CG;\n        temp_CG = t(X) %*% (w * (X %*% ssX_p_CG));\n        q_CG = (lambda * p_CG) + diag (scale_X) %*% temp_CG + shift_X %*% temp_CG [size_CG, ];\n        pq_CG = sum (p_CG * q_CG);\n        if (pq_CG <= 0) {\n            pp_CG = sum (p_CG * p_CG);  \n            if (pp_CG > 0) {\n                [z, neg_log_l_change] = \n                    get_trust_boundary_point (g_reg, z, p_CG, q_CG, r_CG, pp_CG, pq_CG, trust_delta_sq);\n                reached_trust_boundary = 1;\n            } else {\n                neg_log_l_change = 0.5 * sum (z * (r_CG + g_reg));\n            }\n            converged_CG = 1;\n        }\n        if (converged_CG == 0) {\n            alpha_CG = rr_CG / pq_CG;\n            new_z = z + alpha_CG * p_CG;\n            if (sum(new_z * new_z) >= trust_delta_sq) {\n                pp_CG = sum (p_CG * p_CG);  \n                [z, neg_log_l_change] = \n                    get_trust_boundary_point (g_reg, z, p_CG, q_CG, r_CG, pp_CG, pq_CG, trust_delta_sq);\n                reached_trust_boundary = 1;\n                converged_CG = 1;\n            }\n            if (converged_CG == 0) {\n                z = new_z;\n                old_rr_CG = rr_CG;\n                r_CG = r_CG + alpha_CG * q_CG;\n                rr_CG = sum(r_CG * r_CG);\n                if (i_CG == max_iteration_CG | rr_CG < eps_CG) {\n                    neg_log_l_change = 0.5 * sum (z * (r_CG + g_reg));\n                    reached_trust_boundary = 0;\n                    converged_CG = 1;\n                }\n                if (converged_CG == 0) {\n                    p_CG = -r_CG + (rr_CG / old_rr_CG) * p_CG;\n}   }   }   }   }\n";
        return string;
    }

    public String get_CG_Steihaug_point__source() {
        String string = "get_CG_Steihaug_point =\n    function (Matrix[double] X, Matrix[double] scale_X, Matrix[double] shift_X, Matrix[double] w,\n    Matrix[double] g, Matrix[double] beta, Matrix[double] lambda, double trust_delta, int max_iter_CG)\n    return (Matrix[double] z, double neg_log_l_change, int i_CG, int reached_trust_boundary)\n{\n    trust_delta_sq = trust_delta ^ 2;\n    size_CG = nrow (g);\n    z = matrix (0.0, rows = size_CG, cols = 1);\n    neg_log_l_change = 0.0;\n    reached_trust_boundary = 0;\n    g_reg = g + lambda * beta;\n    r_CG = g_reg;\n    p_CG = -r_CG;\n    rr_CG = sum(r_CG * r_CG);\n    eps_CG = rr_CG * min (0.25, sqrt (rr_CG));\n    converged_CG = 0;\n    if (rr_CG < eps_CG) {\n        converged_CG = 1;\n    }\n    \n    max_iteration_CG = max_iter_CG;\n    if (max_iteration_CG <= 0) {\n        max_iteration_CG = size_CG;\n    }\n    i_CG = 0;\n    while (converged_CG == 0)\n    {\n        i_CG = i_CG + 1;\n        ssX_p_CG = diag (scale_X) %*% p_CG;\n        ssX_p_CG [size_CG, ] = ssX_p_CG [size_CG, ] + t(shift_X) %*% p_CG;\n        temp_CG = t(X) %*% (w * (X %*% ssX_p_CG));\n        q_CG = (lambda * p_CG) + diag (scale_X) %*% temp_CG + shift_X %*% temp_CG [size_CG, ];\n        pq_CG = sum (p_CG * q_CG);\n        if (pq_CG <= 0) {\n            pp_CG = sum (p_CG * p_CG);  \n            if (pp_CG > 0) {\n                [z, neg_log_l_change] = \n                    get_trust_boundary_point (g_reg, z, p_CG, q_CG, r_CG, pp_CG, pq_CG, trust_delta_sq);\n                reached_trust_boundary = 1;\n            } else {\n                neg_log_l_change = 0.5 * sum (z * (r_CG + g_reg));\n            }\n            converged_CG = 1;\n        }\n        if (converged_CG == 0) {\n            alpha_CG = rr_CG / pq_CG;\n            new_z = z + alpha_CG * p_CG;\n            if (sum(new_z * new_z) >= trust_delta_sq) {\n                pp_CG = sum (p_CG * p_CG);  \n                [z, neg_log_l_change] = \n                    get_trust_boundary_point (g_reg, z, p_CG, q_CG, r_CG, pp_CG, pq_CG, trust_delta_sq);\n                reached_trust_boundary = 1;\n                converged_CG = 1;\n            }\n            if (converged_CG == 0) {\n                z = new_z;\n                old_rr_CG = rr_CG;\n                r_CG = r_CG + alpha_CG * q_CG;\n                rr_CG = sum(r_CG * r_CG);\n                if (i_CG == max_iteration_CG | rr_CG < eps_CG) {\n                    neg_log_l_change = 0.5 * sum (z * (r_CG + g_reg));\n                    reached_trust_boundary = 0;\n                    converged_CG = 1;\n                }\n                if (converged_CG == 0) {\n                    p_CG = -r_CG + (rr_CG / old_rr_CG) * p_CG;\n}   }   }   }   }\n";
        return string;
    }

    public Matrix straightenX(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;w = mlcontextns::straightenX(X, eps, max_iter_CG);";
        Script script = new Script(string);
        script.in("X", object).in("eps", object2).in("max_iter_CG", object3).out("w");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("w");
        return matrix;
    }

    public String straightenX__docs() {
        String string = "straightenX =\n    function (Matrix[double] X, double eps, int max_iter_CG)\n    return   (Matrix[double] w)\n{\n    w_X = t(colSums(X));\n    lambda_LS = 0.000001 * sum(X ^ 2) / ncol(X);\n    eps_LS = eps * nrow(X);\n\n    # BEGIN LEAST SQUARES\n    \n    r_LS = - w_X;\n    z_LS = matrix (0.0, rows = ncol(X), cols = 1);\n    p_LS = - r_LS;\n    norm_r2_LS = sum (r_LS ^ 2);\n    i_LS = 0;\n    while (i_LS < max_iter_CG & i_LS < ncol(X) & norm_r2_LS >= eps_LS)\n    {\n        q_LS = t(X) %*% X %*% p_LS;\n        q_LS = q_LS + lambda_LS * p_LS;\n        alpha_LS = norm_r2_LS / sum (p_LS * q_LS);\n        z_LS = z_LS + alpha_LS * p_LS;\n        old_norm_r2_LS = norm_r2_LS;\n        r_LS = r_LS + alpha_LS * q_LS;\n        norm_r2_LS = sum (r_LS ^ 2);\n        p_LS = -r_LS + (norm_r2_LS / old_norm_r2_LS) * p_LS;\n        i_LS = i_LS + 1;\n    }\n    \n    # END LEAST SQUARES\n    \n    w = (nrow(X) / sum (w_X * z_LS)) * z_LS;\n}\n";
        return string;
    }

    public String straightenX__source() {
        String string = "straightenX =\n    function (Matrix[double] X, double eps, int max_iter_CG)\n    return   (Matrix[double] w)\n{\n    w_X = t(colSums(X));\n    lambda_LS = 0.000001 * sum(X ^ 2) / ncol(X);\n    eps_LS = eps * nrow(X);\n\n    # BEGIN LEAST SQUARES\n    \n    r_LS = - w_X;\n    z_LS = matrix (0.0, rows = ncol(X), cols = 1);\n    p_LS = - r_LS;\n    norm_r2_LS = sum (r_LS ^ 2);\n    i_LS = 0;\n    while (i_LS < max_iter_CG & i_LS < ncol(X) & norm_r2_LS >= eps_LS)\n    {\n        q_LS = t(X) %*% X %*% p_LS;\n        q_LS = q_LS + lambda_LS * p_LS;\n        alpha_LS = norm_r2_LS / sum (p_LS * q_LS);\n        z_LS = z_LS + alpha_LS * p_LS;\n        old_norm_r2_LS = norm_r2_LS;\n        r_LS = r_LS + alpha_LS * q_LS;\n        norm_r2_LS = sum (r_LS ^ 2);\n        p_LS = -r_LS + (norm_r2_LS / old_norm_r2_LS) * p_LS;\n        i_LS = i_LS + 1;\n    }\n    \n    # END LEAST SQUARES\n    \n    w = (nrow(X) / sum (w_X * z_LS)) * z_LS;\n}\n";
        return string;
    }

    public Binomial_probability_two_column_output binomial_probability_two_column(Object object, Object object2, Object object3) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;[Y_prob, isNaN] = mlcontextns::binomial_probability_two_column(linear_terms, link_type, link_power);";
        Script script = new Script(string);
        script.in("linear_terms", object).in("link_type", object2).in("link_power", object3).out("Y_prob").out("isNaN");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("Y_prob");
        long l = mLResults.getLong("isNaN");
        Binomial_probability_two_column_output binomial_probability_two_column_output = new Binomial_probability_two_column_output(matrix, l);
        return binomial_probability_two_column_output;
    }

    public String binomial_probability_two_column__docs() {
        String string = "binomial_probability_two_column =\n    function (Matrix[double] linear_terms, int link_type, double link_power)\n    return   (Matrix[double] Y_prob, int isNaN)\n{\n    isNaN = 0;\n\n    # Define some auxiliary matrices\n\n    ones_2 = matrix (1.0, rows = 1, cols = 2);\n    zeros_r = matrix(0, nrow(linear_terms), 1);\n    ones_r = matrix(1, nrow(linear_terms), 1);\n\n    # Begin the function body\n\n    Y_prob = zeros_r %*% ones_2;\n    if (link_type == 1) { # Binomial.power\n        if          (link_power == 0) { # Binomial.log\n            Y_prob = cbind(exp(linear_terms), 1-exp(linear_terms));\n        } else if (link_power == 0.5) { # Binomial.sqrt\n            Y_prob = cbind(linear_terms^2, 1-linear_terms^2);\n        } else if (sum (linear_terms < 0) == 0) { # Binomial.power_nonlog\n            Y_prob = cbind(linear_terms^(1.0/link_power), 1-linear_terms^(1.0/link_power));\n        } else {\n            isNaN = 1;\n        }\n    } else {              # Binomial.non_power\n        is_LT_infinite = cbind(linear_terms==1.0/0.0, linear_terms==-1.0/0.0);\n        finite_linear_terms = replace (target =        linear_terms, pattern =  1.0/0.0, replacement = 0);\n        finite_linear_terms = replace (target = finite_linear_terms, pattern = -1.0/0.0, replacement = 0);\n        if (link_type == 2)             { # Binomial.logit\n            Y_prob = cbind(exp(finite_linear_terms), ones_r);\n            Y_prob = Y_prob / rowSums (Y_prob);\n        } else if (link_type == 3)    { # Binomial.probit\n            lt_pos_neg = cbind(finite_linear_terms>=0, finite_linear_terms<0);\n            t_gp = 1.0 / (1.0 + abs (finite_linear_terms) * 0.231641888);  # 0.231641888 = 0.3275911 / sqrt (2.0)\n            pt_gp = t_gp * ( 0.254829592 \n                  + t_gp * (-0.284496736 # \"Handbook of Mathematical Functions\", ed. by M. Abramowitz and I.A. Stegun,\n                  + t_gp * ( 1.421413741 # U.S. Nat-l Bureau of Standards, 10th print (Dec 1972), Sec. 7.1.26, p. 299\n                  + t_gp * (-1.453152027 \n                  + t_gp *   1.061405429))));\n            the_gauss_exp = exp (- (finite_linear_terms ^ 2) / 2.0);\n            Y_prob = lt_pos_neg + (0.5 - lt_pos_neg) * the_gauss_exp * pt_gp;\n        } else if (link_type == 4)    { # Binomial.cloglog\n            the_exp = exp (finite_linear_terms);\n            the_exp_exp = exp (- the_exp);\n            is_too_small = ((10000000 + the_exp) == 10000000);\n            Y_prob [, 1] = (1 - is_too_small) * (1 - the_exp_exp) + is_too_small * the_exp * (1 - the_exp / 2);\n            Y_prob [, 2] = the_exp_exp;\n        } else if (link_type == 5)    { # Binomial.cauchit\n            Y_prob = 0.5 + cbind(atan(finite_linear_terms), -atan(finite_linear_terms)) / 3.1415926535897932384626433832795;\n        } else {\n            isNaN = 1;\n        }\n        Y_prob = Y_prob * (1.0 - rowSums (is_LT_infinite)) + is_LT_infinite;\n}   }\n";
        return string;
    }

    public String binomial_probability_two_column__source() {
        String string = "binomial_probability_two_column =\n    function (Matrix[double] linear_terms, int link_type, double link_power)\n    return   (Matrix[double] Y_prob, int isNaN)\n{\n    isNaN = 0;\n\n    # Define some auxiliary matrices\n\n    ones_2 = matrix (1.0, rows = 1, cols = 2);\n    zeros_r = matrix(0, nrow(linear_terms), 1);\n    ones_r = matrix(1, nrow(linear_terms), 1);\n\n    # Begin the function body\n\n    Y_prob = zeros_r %*% ones_2;\n    if (link_type == 1) { # Binomial.power\n        if          (link_power == 0) { # Binomial.log\n            Y_prob = cbind(exp(linear_terms), 1-exp(linear_terms));\n        } else if (link_power == 0.5) { # Binomial.sqrt\n            Y_prob = cbind(linear_terms^2, 1-linear_terms^2);\n        } else if (sum (linear_terms < 0) == 0) { # Binomial.power_nonlog\n            Y_prob = cbind(linear_terms^(1.0/link_power), 1-linear_terms^(1.0/link_power));\n        } else {\n            isNaN = 1;\n        }\n    } else {              # Binomial.non_power\n        is_LT_infinite = cbind(linear_terms==1.0/0.0, linear_terms==-1.0/0.0);\n        finite_linear_terms = replace (target =        linear_terms, pattern =  1.0/0.0, replacement = 0);\n        finite_linear_terms = replace (target = finite_linear_terms, pattern = -1.0/0.0, replacement = 0);\n        if (link_type == 2)             { # Binomial.logit\n            Y_prob = cbind(exp(finite_linear_terms), ones_r);\n            Y_prob = Y_prob / rowSums (Y_prob);\n        } else if (link_type == 3)    { # Binomial.probit\n            lt_pos_neg = cbind(finite_linear_terms>=0, finite_linear_terms<0);\n            t_gp = 1.0 / (1.0 + abs (finite_linear_terms) * 0.231641888);  # 0.231641888 = 0.3275911 / sqrt (2.0)\n            pt_gp = t_gp * ( 0.254829592 \n                  + t_gp * (-0.284496736 # \"Handbook of Mathematical Functions\", ed. by M. Abramowitz and I.A. Stegun,\n                  + t_gp * ( 1.421413741 # U.S. Nat-l Bureau of Standards, 10th print (Dec 1972), Sec. 7.1.26, p. 299\n                  + t_gp * (-1.453152027 \n                  + t_gp *   1.061405429))));\n            the_gauss_exp = exp (- (finite_linear_terms ^ 2) / 2.0);\n            Y_prob = lt_pos_neg + (0.5 - lt_pos_neg) * the_gauss_exp * pt_gp;\n        } else if (link_type == 4)    { # Binomial.cloglog\n            the_exp = exp (finite_linear_terms);\n            the_exp_exp = exp (- the_exp);\n            is_too_small = ((10000000 + the_exp) == 10000000);\n            Y_prob [, 1] = (1 - is_too_small) * (1 - the_exp_exp) + is_too_small * the_exp * (1 - the_exp / 2);\n            Y_prob [, 2] = the_exp_exp;\n        } else if (link_type == 5)    { # Binomial.cauchit\n            Y_prob = 0.5 + cbind(atan(finite_linear_terms), -atan(finite_linear_terms)) / 3.1415926535897932384626433832795;\n        } else {\n            isNaN = 1;\n        }\n        Y_prob = Y_prob * (1.0 - rowSums (is_LT_infinite)) + is_LT_infinite;\n}   }\n";
        return string;
    }

    public long check_if_supported(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;is_supported = mlcontextns::check_if_supported(ncol_y, dist_type, var_power, link_type, link_power);";
        Script script = new Script(string);
        script.in("ncol_y", object).in("dist_type", object2).in("var_power", object3).in("link_type", object4).in("link_power", object5).out("is_supported");
        MLResults mLResults = script.execute();
        long l = mLResults.getLong("is_supported");
        return l;
    }

    public String check_if_supported__docs() {
        String string = "check_if_supported = \n    function (int ncol_y, int dist_type, double var_power, int link_type, double link_power)\n    return   (int is_supported)\n{\n    is_supported = 0;\n    if (ncol_y == 1 & dist_type == 1 & link_type == 1)\n    { # POWER DISTRIBUTION\n        is_supported = 1;\n        if (var_power == 0 & link_power == -1.0)        print (\"Gaussian.inverse\");     \n        else if (var_power == 0 & link_power ==    0)   print (\"Gaussian.log\");           \n        else if (var_power == 0 & link_power ==  0.5)   print (\"Gaussian.sqrt\");           \n        else if (var_power == 0 & link_power ==  1.0)   print (\"Gaussian.id\");             \n        else if (var_power == 0                     )   print (\"Gaussian.power_nonlog\");   \n        else if (var_power == 1.0 & link_power == -1.0) print (\"Poisson.inverse\");          \n        else if (var_power == 1.0 & link_power ==    0) print (\"Poisson.log\");              \n        else if (var_power == 1.0 & link_power ==  0.5) print (\"Poisson.sqrt\");             \n        else if (var_power == 1.0 & link_power ==  1.0) print (\"Poisson.id\");               \n        else if (var_power == 1.0                     ) print (\"Poisson.power_nonlog\");     \n        else if (var_power == 2.0 & link_power == -1.0) print (\"Gamma.inverse\");            \n        else if (var_power == 2.0 & link_power ==    0) print (\"Gamma.log\");                \n        else if (var_power == 2.0 & link_power ==  0.5) print (\"Gamma.sqrt\");               \n        else if (var_power == 2.0 & link_power ==  1.0) print (\"Gamma.id\");                 \n        else if (var_power == 2.0                     ) print (\"Gamma.power_nonlog\");      \n        else if (var_power == 3.0 & link_power == -2.0) print (\"InvGaussian.1/mu^2\");       \n        else if (var_power == 3.0 & link_power == -1.0) print (\"InvGaussian.inverse\");     \n        else if (var_power == 3.0 & link_power ==    0) print (\"InvGaussian.log\");          \n        else if (var_power == 3.0 & link_power ==  0.5) print (\"InvGaussian.sqrt\");         \n        else if (var_power == 3.0 & link_power ==  1.0) print (\"InvGaussian.id\");           \n        else if (var_power == 3.0                     ) print (\"InvGaussian.power_nonlog\");\n        else if (                   link_power ==    0) print (\"PowerDist.log\");           \n        else                                            print (\"PowerDist.power_nonlog\");\n    }\n    if (ncol_y == 1 & dist_type == 2)\n    {\n        print (\"Error: Bernoulli response matrix has not been converted into two-column format.\");\n    }\n    if (ncol_y == 2 & dist_type == 2 & link_type >= 1 & link_type <= 5)\n    { # BINOMIAL/BERNOULLI DISTRIBUTION\n        is_supported = 1;\n        if (link_type == 1 & link_power == -1.0)      print (\"Binomial.inverse\");     \n        else if (link_type == 1 & link_power ==    0) print (\"Binomial.log\");          \n        else if (link_type == 1 & link_power ==  0.5) print (\"Binomial.sqrt\");         \n        else if (link_type == 1 & link_power ==  1.0) print (\"Binomial.id\");           \n        else if (link_type == 1)                      print (\"Binomial.power_nonlog\"); \n        else if (link_type == 2)                      print (\"Binomial.logit\");        \n        else if (link_type == 3)                      print (\"Binomial.probit\");       \n        else if (link_type == 4)                      print (\"Binomial.cloglog\");      \n        else if (link_type == 5)                         print (\"Binomial.cauchit\");     \n    }   \n    if (is_supported == 0) {\n        print (\"Response matrix with \" + ncol_y + \" columns, distribution family (\" + dist_type + \", \" + var_power\n             + \") and link family (\" + link_type + \", \" + link_power + \") are NOT supported together.\");\n    }\n}\n";
        return string;
    }

    public String check_if_supported__source() {
        String string = "check_if_supported = \n    function (int ncol_y, int dist_type, double var_power, int link_type, double link_power)\n    return   (int is_supported)\n{\n    is_supported = 0;\n    if (ncol_y == 1 & dist_type == 1 & link_type == 1)\n    { # POWER DISTRIBUTION\n        is_supported = 1;\n        if (var_power == 0 & link_power == -1.0)        print (\"Gaussian.inverse\");     \n        else if (var_power == 0 & link_power ==    0)   print (\"Gaussian.log\");           \n        else if (var_power == 0 & link_power ==  0.5)   print (\"Gaussian.sqrt\");           \n        else if (var_power == 0 & link_power ==  1.0)   print (\"Gaussian.id\");             \n        else if (var_power == 0                     )   print (\"Gaussian.power_nonlog\");   \n        else if (var_power == 1.0 & link_power == -1.0) print (\"Poisson.inverse\");          \n        else if (var_power == 1.0 & link_power ==    0) print (\"Poisson.log\");              \n        else if (var_power == 1.0 & link_power ==  0.5) print (\"Poisson.sqrt\");             \n        else if (var_power == 1.0 & link_power ==  1.0) print (\"Poisson.id\");               \n        else if (var_power == 1.0                     ) print (\"Poisson.power_nonlog\");     \n        else if (var_power == 2.0 & link_power == -1.0) print (\"Gamma.inverse\");            \n        else if (var_power == 2.0 & link_power ==    0) print (\"Gamma.log\");                \n        else if (var_power == 2.0 & link_power ==  0.5) print (\"Gamma.sqrt\");               \n        else if (var_power == 2.0 & link_power ==  1.0) print (\"Gamma.id\");                 \n        else if (var_power == 2.0                     ) print (\"Gamma.power_nonlog\");      \n        else if (var_power == 3.0 & link_power == -2.0) print (\"InvGaussian.1/mu^2\");       \n        else if (var_power == 3.0 & link_power == -1.0) print (\"InvGaussian.inverse\");     \n        else if (var_power == 3.0 & link_power ==    0) print (\"InvGaussian.log\");          \n        else if (var_power == 3.0 & link_power ==  0.5) print (\"InvGaussian.sqrt\");         \n        else if (var_power == 3.0 & link_power ==  1.0) print (\"InvGaussian.id\");           \n        else if (var_power == 3.0                     ) print (\"InvGaussian.power_nonlog\");\n        else if (                   link_power ==    0) print (\"PowerDist.log\");           \n        else                                            print (\"PowerDist.power_nonlog\");\n    }\n    if (ncol_y == 1 & dist_type == 2)\n    {\n        print (\"Error: Bernoulli response matrix has not been converted into two-column format.\");\n    }\n    if (ncol_y == 2 & dist_type == 2 & link_type >= 1 & link_type <= 5)\n    { # BINOMIAL/BERNOULLI DISTRIBUTION\n        is_supported = 1;\n        if (link_type == 1 & link_power == -1.0)      print (\"Binomial.inverse\");     \n        else if (link_type == 1 & link_power ==    0) print (\"Binomial.log\");          \n        else if (link_type == 1 & link_power ==  0.5) print (\"Binomial.sqrt\");         \n        else if (link_type == 1 & link_power ==  1.0) print (\"Binomial.id\");           \n        else if (link_type == 1)                      print (\"Binomial.power_nonlog\"); \n        else if (link_type == 2)                      print (\"Binomial.logit\");        \n        else if (link_type == 3)                      print (\"Binomial.probit\");       \n        else if (link_type == 4)                      print (\"Binomial.cloglog\");      \n        else if (link_type == 5)                         print (\"Binomial.cauchit\");     \n    }   \n    if (is_supported == 0) {\n        print (\"Response matrix with \" + ncol_y + \" columns, distribution family (\" + dist_type + \", \" + var_power\n             + \") and link family (\" + link_type + \", \" + link_power + \") are NOT supported together.\");\n    }\n}\n";
        return string;
    }

    public Glm_initialize_output glm_initialize(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;[beta, saturated_log_l, isNaN] = mlcontextns::glm_initialize(X, Y, dist_type, var_power, link_type, link_power, icept_status, max_iter_CG);";
        Script script = new Script(string);
        script.in("X", object).in("Y", object2).in("dist_type", object3).in("var_power", object4).in("link_type", object5).in("link_power", object6).in("icept_status", object7).in("max_iter_CG", object8).out("beta").out("saturated_log_l").out("isNaN");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("beta");
        double d = mLResults.getDouble("saturated_log_l");
        long l = mLResults.getLong("isNaN");
        Glm_initialize_output glm_initialize_output = new Glm_initialize_output(matrix, d, l);
        return glm_initialize_output;
    }

    public String glm_initialize__docs() {
        String string = "glm_initialize = function (Matrix[double] X, Matrix[double] Y, int dist_type, double var_power, int link_type, double link_power, int icept_status, int max_iter_CG)\nreturn (Matrix[double] beta, double saturated_log_l, int isNaN)\n{\n    saturated_log_l = 0.0;\n    isNaN = 0;\n    y_corr = Y [, 1];\n    if (dist_type == 2) {\n        n_corr = rowSums (Y);\n        is_n_zero = (n_corr == 0);\n        y_corr = Y [, 1] / (n_corr + is_n_zero) + (0.5 - Y [, 1]) * is_n_zero;    \n    }\n    linear_terms = y_corr;\n    if (dist_type == 1 & link_type == 1) \n    { # POWER DISTRIBUTION\n        if (link_power ==  0) {\n            if (sum (y_corr < 0) == 0) {\n                is_zero_y_corr = (y_corr == 0);\n                linear_terms = log (y_corr + is_zero_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else { isNaN = 1; }\n        } else if (link_power ==  1.0) {\n            linear_terms = y_corr;\n        } else if (link_power == -1.0) {\n            linear_terms = 1.0 / y_corr;\n        } else if (link_power ==  0.5) {\n            if (sum (y_corr < 0) == 0) {\n                linear_terms = sqrt (y_corr);\n            } else { isNaN = 1; }\n        } else if (link_power >   0) {\n            if (sum (y_corr < 0) == 0) {\n                is_zero_y_corr = (y_corr == 0);\n                linear_terms = (y_corr + is_zero_y_corr) ^ link_power - is_zero_y_corr;\n            } else { isNaN = 1; }\n        } else {\n            if (sum (y_corr <= 0) == 0) {\n                linear_terms = y_corr ^ link_power;\n            } else { isNaN = 1; }\n        }\n    }\n    if (dist_type == 2 & link_type >= 1 & link_type <= 5)\n    { # BINOMIAL/BERNOULLI DISTRIBUTION\n        if (link_type == 1 & link_power == 0)  { # Binomial.log\n            if (sum (y_corr < 0) == 0) {\n                is_zero_y_corr = (y_corr == 0);\n                linear_terms = log (y_corr + is_zero_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else { isNaN = 1; }\n        } else if (link_type == 1 & link_power >  0)  { # Binomial.power_nonlog pos\n            if (sum (y_corr < 0) == 0) {\n                is_zero_y_corr = (y_corr == 0);\n                linear_terms = (y_corr + is_zero_y_corr) ^ link_power - is_zero_y_corr;\n            } else { isNaN = 1; }\n        } else if (link_type == 1)                      { # Binomial.power_nonlog neg\n            if (sum (y_corr <= 0) == 0) {\n                linear_terms = y_corr ^ link_power;\n            } else { isNaN = 1; }\n        } else { \n            is_zero_y_corr = (y_corr <= 0);\n            is_one_y_corr  = (y_corr >= 1.0);\n            y_corr = y_corr * (1.0 - is_zero_y_corr) * (1.0 - is_one_y_corr) + 0.5 * (is_zero_y_corr + is_one_y_corr);\n            if (link_type == 2)                           { # Binomial.logit\n                linear_terms = log (y_corr / (1.0 - y_corr)) \n                    + is_one_y_corr / (1.0 - is_one_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else if (link_type == 3)                  { # Binomial.probit\n                y_below_half = y_corr + (1.0 - 2.0 * y_corr) * (y_corr > 0.5);\n                t = sqrt (- 2.0 * log (y_below_half));\n                approx_inv_Gauss_CDF = - t + (2.515517 + t * (0.802853 + t * 0.010328)) / (1.0 + t * (1.432788 + t * (0.189269 + t * 0.001308)));\n                linear_terms = approx_inv_Gauss_CDF * (1.0 - 2.0 * (y_corr > 0.5))\n                    + is_one_y_corr / (1.0 - is_one_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else if (link_type == 4)                  { # Binomial.cloglog\n                linear_terms = log (- log (1.0 - y_corr))\n                    - log (- log (0.5)) * (is_zero_y_corr + is_one_y_corr)\n                    + is_one_y_corr / (1.0 - is_one_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else if (link_type == 5)                  { # Binomial.cauchit\n                linear_terms = tan ((y_corr - 0.5) * 3.1415926535897932384626433832795)\n                    + is_one_y_corr / (1.0 - is_one_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n        }   }      \n    }\n    \n    if (isNaN == 0) {\n        [saturated_log_l, isNaN] = \n            glm_log_likelihood_part (linear_terms, Y, dist_type, var_power, link_type, link_power);\n    }\n    \n    if ((dist_type == 1 & link_type == 1 & link_power == 0) |\n        (dist_type == 2 & link_type >= 2))\n    {    \n        desired_eta = 0.0;\n    } else if (link_type == 1 & link_power == 0) {\n        desired_eta = log (0.5);\n    } else if (link_type == 1) {\n        desired_eta = 0.5 ^ link_power;\n    } else {\n        desired_eta = 0.5;\n    }\n    \n    beta = matrix (0.0, rows = ncol(X), cols = 1);\n    \n    if (desired_eta != 0) {\n        if (icept_status == 1 | icept_status == 2) {\n            beta [nrow(beta), 1] = desired_eta;\n        } else {\n            # We want: avg (X %*% ssX_transform %*% beta) = desired_eta\n            # Note that \"ssX_transform\" is trivial here, hence ignored\n            \n            beta = straightenX (X, 0.000001, max_iter_CG);  \n            beta = beta * desired_eta;\n}   }   }\n";
        return string;
    }

    public String glm_initialize__source() {
        String string = "glm_initialize = function (Matrix[double] X, Matrix[double] Y, int dist_type, double var_power, int link_type, double link_power, int icept_status, int max_iter_CG)\nreturn (Matrix[double] beta, double saturated_log_l, int isNaN)\n{\n    saturated_log_l = 0.0;\n    isNaN = 0;\n    y_corr = Y [, 1];\n    if (dist_type == 2) {\n        n_corr = rowSums (Y);\n        is_n_zero = (n_corr == 0);\n        y_corr = Y [, 1] / (n_corr + is_n_zero) + (0.5 - Y [, 1]) * is_n_zero;    \n    }\n    linear_terms = y_corr;\n    if (dist_type == 1 & link_type == 1) \n    { # POWER DISTRIBUTION\n        if (link_power ==  0) {\n            if (sum (y_corr < 0) == 0) {\n                is_zero_y_corr = (y_corr == 0);\n                linear_terms = log (y_corr + is_zero_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else { isNaN = 1; }\n        } else if (link_power ==  1.0) {\n            linear_terms = y_corr;\n        } else if (link_power == -1.0) {\n            linear_terms = 1.0 / y_corr;\n        } else if (link_power ==  0.5) {\n            if (sum (y_corr < 0) == 0) {\n                linear_terms = sqrt (y_corr);\n            } else { isNaN = 1; }\n        } else if (link_power >   0) {\n            if (sum (y_corr < 0) == 0) {\n                is_zero_y_corr = (y_corr == 0);\n                linear_terms = (y_corr + is_zero_y_corr) ^ link_power - is_zero_y_corr;\n            } else { isNaN = 1; }\n        } else {\n            if (sum (y_corr <= 0) == 0) {\n                linear_terms = y_corr ^ link_power;\n            } else { isNaN = 1; }\n        }\n    }\n    if (dist_type == 2 & link_type >= 1 & link_type <= 5)\n    { # BINOMIAL/BERNOULLI DISTRIBUTION\n        if (link_type == 1 & link_power == 0)  { # Binomial.log\n            if (sum (y_corr < 0) == 0) {\n                is_zero_y_corr = (y_corr == 0);\n                linear_terms = log (y_corr + is_zero_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else { isNaN = 1; }\n        } else if (link_type == 1 & link_power >  0)  { # Binomial.power_nonlog pos\n            if (sum (y_corr < 0) == 0) {\n                is_zero_y_corr = (y_corr == 0);\n                linear_terms = (y_corr + is_zero_y_corr) ^ link_power - is_zero_y_corr;\n            } else { isNaN = 1; }\n        } else if (link_type == 1)                      { # Binomial.power_nonlog neg\n            if (sum (y_corr <= 0) == 0) {\n                linear_terms = y_corr ^ link_power;\n            } else { isNaN = 1; }\n        } else { \n            is_zero_y_corr = (y_corr <= 0);\n            is_one_y_corr  = (y_corr >= 1.0);\n            y_corr = y_corr * (1.0 - is_zero_y_corr) * (1.0 - is_one_y_corr) + 0.5 * (is_zero_y_corr + is_one_y_corr);\n            if (link_type == 2)                           { # Binomial.logit\n                linear_terms = log (y_corr / (1.0 - y_corr)) \n                    + is_one_y_corr / (1.0 - is_one_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else if (link_type == 3)                  { # Binomial.probit\n                y_below_half = y_corr + (1.0 - 2.0 * y_corr) * (y_corr > 0.5);\n                t = sqrt (- 2.0 * log (y_below_half));\n                approx_inv_Gauss_CDF = - t + (2.515517 + t * (0.802853 + t * 0.010328)) / (1.0 + t * (1.432788 + t * (0.189269 + t * 0.001308)));\n                linear_terms = approx_inv_Gauss_CDF * (1.0 - 2.0 * (y_corr > 0.5))\n                    + is_one_y_corr / (1.0 - is_one_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else if (link_type == 4)                  { # Binomial.cloglog\n                linear_terms = log (- log (1.0 - y_corr))\n                    - log (- log (0.5)) * (is_zero_y_corr + is_one_y_corr)\n                    + is_one_y_corr / (1.0 - is_one_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n            } else if (link_type == 5)                  { # Binomial.cauchit\n                linear_terms = tan ((y_corr - 0.5) * 3.1415926535897932384626433832795)\n                    + is_one_y_corr / (1.0 - is_one_y_corr) - is_zero_y_corr / (1.0 - is_zero_y_corr);\n        }   }      \n    }\n    \n    if (isNaN == 0) {\n        [saturated_log_l, isNaN] = \n            glm_log_likelihood_part (linear_terms, Y, dist_type, var_power, link_type, link_power);\n    }\n    \n    if ((dist_type == 1 & link_type == 1 & link_power == 0) |\n        (dist_type == 2 & link_type >= 2))\n    {    \n        desired_eta = 0.0;\n    } else if (link_type == 1 & link_power == 0) {\n        desired_eta = log (0.5);\n    } else if (link_type == 1) {\n        desired_eta = 0.5 ^ link_power;\n    } else {\n        desired_eta = 0.5;\n    }\n    \n    beta = matrix (0.0, rows = ncol(X), cols = 1);\n    \n    if (desired_eta != 0) {\n        if (icept_status == 1 | icept_status == 2) {\n            beta [nrow(beta), 1] = desired_eta;\n        } else {\n            # We want: avg (X %*% ssX_transform %*% beta) = desired_eta\n            # Note that \"ssX_transform\" is trivial here, hence ignored\n            \n            beta = straightenX (X, 0.000001, max_iter_CG);  \n            beta = beta * desired_eta;\n}   }   }\n";
        return string;
    }

    public Glm_dist_output glm_dist(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;[g_Y, w] = mlcontextns::glm_dist(linear_terms, Y, dist_type, var_power, link_type, link_power);";
        Script script = new Script(string);
        script.in("linear_terms", object).in("Y", object2).in("dist_type", object3).in("var_power", object4).in("link_type", object5).in("link_power", object6).out("g_Y").out("w");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("g_Y");
        Matrix matrix2 = mLResults.getMatrix("w");
        Glm_dist_output glm_dist_output = new Glm_dist_output(matrix, matrix2);
        return glm_dist_output;
    }

    public String glm_dist__docs() {
        String string = "glm_dist = function (Matrix[double] linear_terms, Matrix[double] Y,\n                     int dist_type, double var_power, int link_type, double link_power)\n    return (Matrix[double] g_Y, Matrix[double] w)\n    # ORIGINALLY we returned more meaningful vectors, namely:\n    # Matrix[double] y_residual    : y - y_mean, i.e. y observed - y predicted\n    # Matrix[double] link_gradient : derivative of the link function\n    # Matrix[double] var_function  : variance without dispersion, i.e. the V(mu) function\n    # BUT, this caused roundoff errors, so we had to compute \"directly useful\" vectors\n    # and skip over the \"meaningful intermediaries\".  Now we output these two variables:\n    #     g_Y = y_residual / (var_function * link_gradient);\n    #     w   = 1.0 / (var_function * link_gradient ^ 2);\n{\n    zeros_r = matrix(0, nrow(linear_terms), 1);\n    ones_r = matrix(1, nrow(linear_terms), 1);\n    g_Y  = zeros_r;\n    w  = zeros_r;\n\n    # Some constants\n\n    one_over_sqrt_two_pi = 0.39894228040143267793994605993438;\n    p_one_m_one = matrix(\"1 -1\", 1, 2);\n    m_one_p_one = matrix(\"-1 1\", 1, 2);\n    flip_pos = matrix(\"0 1 1 0\", 2, 2);\n    flip_neg = matrix(\"0 -1 1 0\", 2, 2);\n    \n    if (dist_type == 1 & link_type == 1) \n    { # POWER DISTRIBUTION\n        y_mean = zeros_r;\n        if (link_power ==  0) {\n            y_mean = exp (linear_terms);\n            y_mean_pow = y_mean ^ (1 - var_power);\n            w   = y_mean_pow * y_mean;\n            g_Y = y_mean_pow * (Y - y_mean);\n        } else if (link_power ==  1.0) {\n            y_mean = linear_terms;\n            w   = y_mean ^ (- var_power);\n            g_Y = w * (Y - y_mean);\n        } else {\n            y_mean = linear_terms ^ (1.0 / link_power);\n            c1  = (1 - var_power) / link_power - 1;\n            c2  = (2 - var_power) / link_power - 2;\n            g_Y = (linear_terms ^ c1) * (Y - y_mean) / link_power;\n            w   = (linear_terms ^ c2) / (link_power ^ 2);\n        }\n    }   \n    if (dist_type == 2 & link_type >= 1 & link_type <= 5)\n    { # BINOMIAL/BERNOULLI DISTRIBUTION\n        if (link_type == 1) { # BINOMIAL.POWER LINKS\n            if (link_power == 0)  { # Binomial.log\n                vec1 = 1 / (exp (- linear_terms) - 1);\n                g_Y = Y [, 1] - Y [, 2] * vec1;\n                w   = rowSums (Y) * vec1;\n            } else {                  # Binomial.nonlog\n                vec1 = zeros_r;\n                if (link_power == 0.5)  {\n                    vec1 = 1 / (1 - linear_terms ^ 2);\n                } else if (sum (linear_terms < 0) == 0) {\n                    vec1 = linear_terms ^ (- 2 + 1 / link_power) / (1 - linear_terms ^ (1 / link_power));\n                } else {isNaN = 1;}\n                # We want a \"zero-protected\" version of\n                #     vec2 = Y [, 1] / linear_terms;\n                is_y_0 = (Y [, 1] == 0);\n                vec2 = (Y [, 1] + is_y_0) / (linear_terms * (1 - is_y_0) + is_y_0) - is_y_0;\n                g_Y =  (vec2 - Y [, 2] * vec1 * linear_terms) / link_power;\n                w   =  rowSums (Y) * vec1 / link_power ^ 2;\n            }\n        } else {\n            is_LT_infinite = cbind(linear_terms==1.0/0.0, linear_terms==-1.0/0.0);\n            finite_linear_terms = replace (target =        linear_terms, pattern =  1.0/0.0, replacement = 0);\n            finite_linear_terms = replace (target = finite_linear_terms, pattern = -1.0/0.0, replacement = 0);\n            if (link_type == 2)                           { # Binomial.logit\n                Y_prob = cbind(exp(finite_linear_terms), ones_r);\n                Y_prob = Y_prob / rowSums (Y_prob);\n                Y_prob = Y_prob * (1.0 - rowSums (is_LT_infinite)) + is_LT_infinite;\n                g_Y = rowSums (Y * (Y_prob %*% flip_neg));           ### = y_residual;\n                w   = rowSums (Y * (Y_prob %*% flip_pos) * Y_prob);  ### = y_variance;\n            } else if (link_type == 3)                  { # Binomial.probit\n                is_lt_pos = (linear_terms >= 0);\n                t_gp = 1.0 / (1.0 + abs (finite_linear_terms) * 0.231641888);  # 0.231641888 = 0.3275911 / sqrt (2.0)\n                pt_gp = t_gp * ( 0.254829592 \n                      + t_gp * (-0.284496736 # \"Handbook of Mathematical Functions\", ed. by M. Abramowitz and I.A. Stegun,\n                      + t_gp * ( 1.421413741 # U.S. Nat-l Bureau of Standards, 10th print (Dec 1972), Sec. 7.1.26, p. 299\n                      + t_gp * (-1.453152027 \n                      + t_gp *   1.061405429))));\n                the_gauss_exp = exp (- (linear_terms ^ 2) / 2.0);\n                vec1 = 0.25 * pt_gp * (2 - the_gauss_exp * pt_gp);\n                vec2 = Y [, 1] - rowSums (Y) * is_lt_pos + the_gauss_exp * pt_gp * rowSums (Y) * (is_lt_pos - 0.5);\n                w   = the_gauss_exp * (one_over_sqrt_two_pi ^ 2) * rowSums (Y) / vec1;\n                g_Y = one_over_sqrt_two_pi * vec2 / vec1;\n            } else if (link_type == 4)                  { # Binomial.cloglog\n                the_exp = exp (linear_terms)\n                the_exp_exp = exp (- the_exp);\n                is_too_small = ((10000000 + the_exp) == 10000000);\n                the_exp_ratio = (1 - is_too_small) * (1 - the_exp_exp) / (the_exp + is_too_small) + is_too_small * (1 - the_exp / 2);\n                g_Y =  (rowSums (Y) * the_exp_exp - Y [, 2]) / the_exp_ratio;\n                w   =  the_exp_exp * the_exp * rowSums (Y) / the_exp_ratio;\n            } else if (link_type == 5)                  { # Binomial.cauchit\n                Y_prob = 0.5 + (atan (finite_linear_terms) %*% p_one_m_one) / 3.1415926535897932384626433832795;\n                Y_prob = Y_prob * (1.0 - rowSums (is_LT_infinite)) + is_LT_infinite;\n                y_residual = Y [, 1] * Y_prob [, 2] - Y [, 2] * Y_prob [, 1];\n                var_function = rowSums (Y) * Y_prob [, 1] * Y_prob [, 2];\n                link_gradient_normalized = (1 + linear_terms ^ 2) * 3.1415926535897932384626433832795;\n                g_Y =  rowSums (Y) * y_residual / (var_function * link_gradient_normalized);\n                w   = (rowSums (Y) ^ 2) / (var_function * link_gradient_normalized ^ 2);\n            }   \n        }\n    }\n}\n";
        return string;
    }

    public String glm_dist__source() {
        String string = "glm_dist = function (Matrix[double] linear_terms, Matrix[double] Y,\n                     int dist_type, double var_power, int link_type, double link_power)\n    return (Matrix[double] g_Y, Matrix[double] w)\n    # ORIGINALLY we returned more meaningful vectors, namely:\n    # Matrix[double] y_residual    : y - y_mean, i.e. y observed - y predicted\n    # Matrix[double] link_gradient : derivative of the link function\n    # Matrix[double] var_function  : variance without dispersion, i.e. the V(mu) function\n    # BUT, this caused roundoff errors, so we had to compute \"directly useful\" vectors\n    # and skip over the \"meaningful intermediaries\".  Now we output these two variables:\n    #     g_Y = y_residual / (var_function * link_gradient);\n    #     w   = 1.0 / (var_function * link_gradient ^ 2);\n{\n    zeros_r = matrix(0, nrow(linear_terms), 1);\n    ones_r = matrix(1, nrow(linear_terms), 1);\n    g_Y  = zeros_r;\n    w  = zeros_r;\n\n    # Some constants\n\n    one_over_sqrt_two_pi = 0.39894228040143267793994605993438;\n    p_one_m_one = matrix(\"1 -1\", 1, 2);\n    m_one_p_one = matrix(\"-1 1\", 1, 2);\n    flip_pos = matrix(\"0 1 1 0\", 2, 2);\n    flip_neg = matrix(\"0 -1 1 0\", 2, 2);\n    \n    if (dist_type == 1 & link_type == 1) \n    { # POWER DISTRIBUTION\n        y_mean = zeros_r;\n        if (link_power ==  0) {\n            y_mean = exp (linear_terms);\n            y_mean_pow = y_mean ^ (1 - var_power);\n            w   = y_mean_pow * y_mean;\n            g_Y = y_mean_pow * (Y - y_mean);\n        } else if (link_power ==  1.0) {\n            y_mean = linear_terms;\n            w   = y_mean ^ (- var_power);\n            g_Y = w * (Y - y_mean);\n        } else {\n            y_mean = linear_terms ^ (1.0 / link_power);\n            c1  = (1 - var_power) / link_power - 1;\n            c2  = (2 - var_power) / link_power - 2;\n            g_Y = (linear_terms ^ c1) * (Y - y_mean) / link_power;\n            w   = (linear_terms ^ c2) / (link_power ^ 2);\n        }\n    }   \n    if (dist_type == 2 & link_type >= 1 & link_type <= 5)\n    { # BINOMIAL/BERNOULLI DISTRIBUTION\n        if (link_type == 1) { # BINOMIAL.POWER LINKS\n            if (link_power == 0)  { # Binomial.log\n                vec1 = 1 / (exp (- linear_terms) - 1);\n                g_Y = Y [, 1] - Y [, 2] * vec1;\n                w   = rowSums (Y) * vec1;\n            } else {                  # Binomial.nonlog\n                vec1 = zeros_r;\n                if (link_power == 0.5)  {\n                    vec1 = 1 / (1 - linear_terms ^ 2);\n                } else if (sum (linear_terms < 0) == 0) {\n                    vec1 = linear_terms ^ (- 2 + 1 / link_power) / (1 - linear_terms ^ (1 / link_power));\n                } else {isNaN = 1;}\n                # We want a \"zero-protected\" version of\n                #     vec2 = Y [, 1] / linear_terms;\n                is_y_0 = (Y [, 1] == 0);\n                vec2 = (Y [, 1] + is_y_0) / (linear_terms * (1 - is_y_0) + is_y_0) - is_y_0;\n                g_Y =  (vec2 - Y [, 2] * vec1 * linear_terms) / link_power;\n                w   =  rowSums (Y) * vec1 / link_power ^ 2;\n            }\n        } else {\n            is_LT_infinite = cbind(linear_terms==1.0/0.0, linear_terms==-1.0/0.0);\n            finite_linear_terms = replace (target =        linear_terms, pattern =  1.0/0.0, replacement = 0);\n            finite_linear_terms = replace (target = finite_linear_terms, pattern = -1.0/0.0, replacement = 0);\n            if (link_type == 2)                           { # Binomial.logit\n                Y_prob = cbind(exp(finite_linear_terms), ones_r);\n                Y_prob = Y_prob / rowSums (Y_prob);\n                Y_prob = Y_prob * (1.0 - rowSums (is_LT_infinite)) + is_LT_infinite;\n                g_Y = rowSums (Y * (Y_prob %*% flip_neg));           ### = y_residual;\n                w   = rowSums (Y * (Y_prob %*% flip_pos) * Y_prob);  ### = y_variance;\n            } else if (link_type == 3)                  { # Binomial.probit\n                is_lt_pos = (linear_terms >= 0);\n                t_gp = 1.0 / (1.0 + abs (finite_linear_terms) * 0.231641888);  # 0.231641888 = 0.3275911 / sqrt (2.0)\n                pt_gp = t_gp * ( 0.254829592 \n                      + t_gp * (-0.284496736 # \"Handbook of Mathematical Functions\", ed. by M. Abramowitz and I.A. Stegun,\n                      + t_gp * ( 1.421413741 # U.S. Nat-l Bureau of Standards, 10th print (Dec 1972), Sec. 7.1.26, p. 299\n                      + t_gp * (-1.453152027 \n                      + t_gp *   1.061405429))));\n                the_gauss_exp = exp (- (linear_terms ^ 2) / 2.0);\n                vec1 = 0.25 * pt_gp * (2 - the_gauss_exp * pt_gp);\n                vec2 = Y [, 1] - rowSums (Y) * is_lt_pos + the_gauss_exp * pt_gp * rowSums (Y) * (is_lt_pos - 0.5);\n                w   = the_gauss_exp * (one_over_sqrt_two_pi ^ 2) * rowSums (Y) / vec1;\n                g_Y = one_over_sqrt_two_pi * vec2 / vec1;\n            } else if (link_type == 4)                  { # Binomial.cloglog\n                the_exp = exp (linear_terms)\n                the_exp_exp = exp (- the_exp);\n                is_too_small = ((10000000 + the_exp) == 10000000);\n                the_exp_ratio = (1 - is_too_small) * (1 - the_exp_exp) / (the_exp + is_too_small) + is_too_small * (1 - the_exp / 2);\n                g_Y =  (rowSums (Y) * the_exp_exp - Y [, 2]) / the_exp_ratio;\n                w   =  the_exp_exp * the_exp * rowSums (Y) / the_exp_ratio;\n            } else if (link_type == 5)                  { # Binomial.cauchit\n                Y_prob = 0.5 + (atan (finite_linear_terms) %*% p_one_m_one) / 3.1415926535897932384626433832795;\n                Y_prob = Y_prob * (1.0 - rowSums (is_LT_infinite)) + is_LT_infinite;\n                y_residual = Y [, 1] * Y_prob [, 2] - Y [, 2] * Y_prob [, 1];\n                var_function = rowSums (Y) * Y_prob [, 1] * Y_prob [, 2];\n                link_gradient_normalized = (1 + linear_terms ^ 2) * 3.1415926535897932384626433832795;\n                g_Y =  rowSums (Y) * y_residual / (var_function * link_gradient_normalized);\n                w   = (rowSums (Y) ^ 2) / (var_function * link_gradient_normalized ^ 2);\n            }   \n        }\n    }\n}\n";
        return string;
    }

    public Round_to_print_output round_to_print(Object object) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;[mantissa, eee] = mlcontextns::round_to_print(x_to_truncate);";
        Script script = new Script(string);
        script.in("x_to_truncate", object).out("mantissa").out("eee");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("mantissa");
        long l = mLResults.getLong("eee");
        Round_to_print_output round_to_print_output = new Round_to_print_output(d, l);
        return round_to_print_output;
    }

    public String round_to_print__docs() {
        String string = "round_to_print = function (double x_to_truncate)\nreturn (double mantissa, int eee)\n{\n    mantissa = 1.0;\n    eee = 0;\n    positive_infinity = 1.0 / 0.0;\n    x = abs (x_to_truncate);\n    if (x != x / 2.0) {\n        log_ten = log (10.0);\n        d_eee = round (log (x) / log_ten - 0.5);\n        mantissa = round (x * exp (log_ten * (4.0 - d_eee))) / 10000;\n        if (mantissa == 10.0) {\n            mantissa = 1.0;\n            d_eee = d_eee + 1;\n        }\n        if (x_to_truncate < 0) {\n            mantissa = - mantissa;\n        }\n        eee = 0;\n        pow_two = 1;\n        res_eee = abs (d_eee);\n        while (res_eee != 0) {\n            new_res_eee = round (res_eee / 2.0 - 0.3);\n            if (new_res_eee * 2.0 < res_eee) {\n                eee = eee + pow_two;\n            }\n            res_eee = new_res_eee;\n            pow_two = 2 * pow_two;\n        }\n        if (d_eee < 0) {\n            eee = - eee;\n        }\n    } else { mantissa = x_to_truncate; }\n}\n";
        return string;
    }

    public String round_to_print__source() {
        String string = "round_to_print = function (double x_to_truncate)\nreturn (double mantissa, int eee)\n{\n    mantissa = 1.0;\n    eee = 0;\n    positive_infinity = 1.0 / 0.0;\n    x = abs (x_to_truncate);\n    if (x != x / 2.0) {\n        log_ten = log (10.0);\n        d_eee = round (log (x) / log_ten - 0.5);\n        mantissa = round (x * exp (log_ten * (4.0 - d_eee))) / 10000;\n        if (mantissa == 10.0) {\n            mantissa = 1.0;\n            d_eee = d_eee + 1;\n        }\n        if (x_to_truncate < 0) {\n            mantissa = - mantissa;\n        }\n        eee = 0;\n        pow_two = 1;\n        res_eee = abs (d_eee);\n        while (res_eee != 0) {\n            new_res_eee = round (res_eee / 2.0 - 0.3);\n            if (new_res_eee * 2.0 < res_eee) {\n                eee = eee + pow_two;\n            }\n            res_eee = new_res_eee;\n            pow_two = 2 * pow_two;\n        }\n        if (d_eee < 0) {\n            eee = - eee;\n        }\n    } else { mantissa = x_to_truncate; }\n}\n";
        return string;
    }

    public Glm_log_likelihood_part_output glm_log_likelihood_part(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/algorithms/GLM.dml') as mlcontextns;[log_l, isNaN] = mlcontextns::glm_log_likelihood_part(linear_terms, Y, dist_type, var_power, link_type, link_power);";
        Script script = new Script(string);
        script.in("linear_terms", object).in("Y", object2).in("dist_type", object3).in("var_power", object4).in("link_type", object5).in("link_power", object6).out("log_l").out("isNaN");
        MLResults mLResults = script.execute();
        double d = mLResults.getDouble("log_l");
        long l = mLResults.getLong("isNaN");
        Glm_log_likelihood_part_output glm_log_likelihood_part_output = new Glm_log_likelihood_part_output(d, l);
        return glm_log_likelihood_part_output;
    }

    public String glm_log_likelihood_part__docs() {
        String string = "glm_log_likelihood_part = function (Matrix[double] linear_terms, Matrix[double] Y,\n        int dist_type, double var_power, int link_type, double link_power)\n    return (double log_l, int isNaN)\n{\n    isNaN = 0;\n    log_l = 0.0;\n    num_records = nrow (Y);\n    zeros_r = matrix (0.0, rows = num_records, cols = 1);\n    \n    if (dist_type == 1 & link_type == 1)\n    { # POWER DISTRIBUTION\n        b_cumulant = zeros_r;\n        natural_parameters = zeros_r;\n        is_natural_parameter_log_zero = zeros_r;\n        if          (var_power == 1.0 & link_power == 0)  { # Poisson.log\n            b_cumulant = exp (linear_terms);\n            is_natural_parameter_log_zero = (linear_terms == -1.0/0.0);\n            natural_parameters = replace (target = linear_terms, pattern = -1.0/0.0, replacement = 0);\n        } else if (var_power == 1.0 & link_power == 1.0)  { # Poisson.id\n            if (sum (linear_terms < 0) == 0)  {\n                b_cumulant = linear_terms;\n                is_natural_parameter_log_zero = (linear_terms == 0);\n                natural_parameters = log (linear_terms + is_natural_parameter_log_zero);\n            } else {isNaN = 1;}\n        } else if (var_power == 1.0 & link_power == 0.5)  { # Poisson.sqrt\n            if (sum (linear_terms < 0) == 0)  {\n                b_cumulant = linear_terms ^ 2;\n                is_natural_parameter_log_zero = (linear_terms == 0);\n                natural_parameters = 2.0 * log (linear_terms + is_natural_parameter_log_zero);\n            } else {isNaN = 1;}\n        } else if (var_power == 1.0 & link_power  > 0)  { # Poisson.power_nonlog, pos\n            if (sum (linear_terms < 0) == 0)  {\n                is_natural_parameter_log_zero = (linear_terms == 0);\n                b_cumulant = (linear_terms + is_natural_parameter_log_zero) ^ (1.0 / link_power) - is_natural_parameter_log_zero;\n                natural_parameters = log (linear_terms + is_natural_parameter_log_zero) / link_power;\n            } else {isNaN = 1;}\n        } else if (var_power == 1.0)                      { # Poisson.power_nonlog, neg\n            if (sum (linear_terms <= 0) == 0) {\n                b_cumulant = linear_terms ^ (1.0 / link_power);\n                natural_parameters = log (linear_terms) / link_power;\n            } else {isNaN = 1;}\n        } else if (var_power == 2.0 & link_power == -1.0) { # Gamma.inverse\n            if (sum (linear_terms <= 0) == 0) {\n                b_cumulant = - log (linear_terms);\n                natural_parameters = - linear_terms;\n            } else {isNaN = 1;}\n        } else if (var_power == 2.0 & link_power ==  1.0) { # Gamma.id\n            if (sum (linear_terms <= 0) == 0) {\n                b_cumulant = log (linear_terms);\n                natural_parameters = - 1.0 / linear_terms;\n            } else {isNaN = 1;}\n        } else if (var_power == 2.0 & link_power ==  0) { # Gamma.log\n            b_cumulant = linear_terms;\n            natural_parameters = - exp (- linear_terms);\n        } else if (var_power == 2.0)                      { # Gamma.power_nonlog\n            if (sum (linear_terms <= 0) == 0) {\n                b_cumulant = log (linear_terms) / link_power;\n                natural_parameters = - linear_terms ^ (- 1.0 / link_power);\n            } else {isNaN = 1;}\n        } else if                    (link_power ==  0) { # PowerDist.log\n            natural_parameters = exp (linear_terms * (1.0 - var_power)) / (1.0 - var_power);\n            b_cumulant = exp (linear_terms * (2.0 - var_power)) / (2.0 - var_power);\n        } else {                                              # PowerDist.power_nonlog\n            if          (-2 * link_power == 1.0 - var_power) {\n                natural_parameters = 1.0 / (linear_terms ^ 2) / (1.0 - var_power);\n            } else if (-1 * link_power == 1.0 - var_power) {\n                natural_parameters = 1.0 / linear_terms / (1.0 - var_power);\n            } else if (     link_power == 1.0 - var_power) {\n                natural_parameters = linear_terms / (1.0 - var_power);\n            } else if ( 2 * link_power == 1.0 - var_power) {\n                natural_parameters = linear_terms ^ 2 / (1.0 - var_power);\n            } else if (sum (linear_terms <= 0) == 0) {\n                power = (1.0 - var_power) / link_power;\n                natural_parameters = (linear_terms ^ power) / (1.0 - var_power);\n            } else {\n                isNaN = 1;\n            } \n            \n            if          (-2 * link_power == 2.0 - var_power) {\n                b_cumulant = 1.0 / (linear_terms ^ 2) / (2.0 - var_power);\n            } else if (-1 * link_power == 2.0 - var_power) {\n                b_cumulant = 1.0 / linear_terms / (2.0 - var_power);\n            } else if (     link_power == 2.0 - var_power) {\n                b_cumulant = linear_terms / (2.0 - var_power);\n            } else if ( 2 * link_power == 2.0 - var_power) {\n                b_cumulant = linear_terms ^ 2 / (2.0 - var_power);\n            } else if (sum (linear_terms <= 0) == 0) {\n                power = (2.0 - var_power) / link_power;\n                b_cumulant = (linear_terms ^ power) / (2.0 - var_power);\n            } else {\n                isNaN = 1;\n            }\n        }\n        if (sum (is_natural_parameter_log_zero * abs (Y)) > 0) {\n            log_l = -1.0 / 0.0;\n            isNaN = 1;\n        }\n        if (isNaN == 0)\n        {\n            log_l = sum (Y * natural_parameters - b_cumulant);\n            if (log_l != log_l | (log_l == log_l + 1.0 & log_l == log_l * 2.0)) {\n                log_l = -1.0 / 0.0;\n                isNaN = 1;\n    }   }   }\n    \n    if (dist_type == 2 & link_type >= 1 & link_type <= 5)\n    { # BINOMIAL/BERNOULLI DISTRIBUTION\n    \n        [Y_prob, isNaN] = binomial_probability_two_column (linear_terms, link_type, link_power);\n        \n        if (isNaN == 0) {\n            if( sum((Y_prob<=0) * abs(Y)) == 0 ) {\n                log_l = sum (Y * log (Y_prob * (1 - (Y_prob<=0)) + (Y_prob<=0)));\n                if (log_l != log_l | (log_l == log_l + 1.0 & log_l == log_l * 2.0)) {\n                    isNaN = 1;\n                }\n            } else {\n                log_l = -1.0 / 0.0;\n                isNaN = 1;\n    }   }   }\n    \n    if (isNaN == 1) {\n        log_l = - 1.0 / 0.0; \n    }\n}\n";
        return string;
    }

    public String glm_log_likelihood_part__source() {
        String string = "glm_log_likelihood_part = function (Matrix[double] linear_terms, Matrix[double] Y,\n        int dist_type, double var_power, int link_type, double link_power)\n    return (double log_l, int isNaN)\n{\n    isNaN = 0;\n    log_l = 0.0;\n    num_records = nrow (Y);\n    zeros_r = matrix (0.0, rows = num_records, cols = 1);\n    \n    if (dist_type == 1 & link_type == 1)\n    { # POWER DISTRIBUTION\n        b_cumulant = zeros_r;\n        natural_parameters = zeros_r;\n        is_natural_parameter_log_zero = zeros_r;\n        if          (var_power == 1.0 & link_power == 0)  { # Poisson.log\n            b_cumulant = exp (linear_terms);\n            is_natural_parameter_log_zero = (linear_terms == -1.0/0.0);\n            natural_parameters = replace (target = linear_terms, pattern = -1.0/0.0, replacement = 0);\n        } else if (var_power == 1.0 & link_power == 1.0)  { # Poisson.id\n            if (sum (linear_terms < 0) == 0)  {\n                b_cumulant = linear_terms;\n                is_natural_parameter_log_zero = (linear_terms == 0);\n                natural_parameters = log (linear_terms + is_natural_parameter_log_zero);\n            } else {isNaN = 1;}\n        } else if (var_power == 1.0 & link_power == 0.5)  { # Poisson.sqrt\n            if (sum (linear_terms < 0) == 0)  {\n                b_cumulant = linear_terms ^ 2;\n                is_natural_parameter_log_zero = (linear_terms == 0);\n                natural_parameters = 2.0 * log (linear_terms + is_natural_parameter_log_zero);\n            } else {isNaN = 1;}\n        } else if (var_power == 1.0 & link_power  > 0)  { # Poisson.power_nonlog, pos\n            if (sum (linear_terms < 0) == 0)  {\n                is_natural_parameter_log_zero = (linear_terms == 0);\n                b_cumulant = (linear_terms + is_natural_parameter_log_zero) ^ (1.0 / link_power) - is_natural_parameter_log_zero;\n                natural_parameters = log (linear_terms + is_natural_parameter_log_zero) / link_power;\n            } else {isNaN = 1;}\n        } else if (var_power == 1.0)                      { # Poisson.power_nonlog, neg\n            if (sum (linear_terms <= 0) == 0) {\n                b_cumulant = linear_terms ^ (1.0 / link_power);\n                natural_parameters = log (linear_terms) / link_power;\n            } else {isNaN = 1;}\n        } else if (var_power == 2.0 & link_power == -1.0) { # Gamma.inverse\n            if (sum (linear_terms <= 0) == 0) {\n                b_cumulant = - log (linear_terms);\n                natural_parameters = - linear_terms;\n            } else {isNaN = 1;}\n        } else if (var_power == 2.0 & link_power ==  1.0) { # Gamma.id\n            if (sum (linear_terms <= 0) == 0) {\n                b_cumulant = log (linear_terms);\n                natural_parameters = - 1.0 / linear_terms;\n            } else {isNaN = 1;}\n        } else if (var_power == 2.0 & link_power ==  0) { # Gamma.log\n            b_cumulant = linear_terms;\n            natural_parameters = - exp (- linear_terms);\n        } else if (var_power == 2.0)                      { # Gamma.power_nonlog\n            if (sum (linear_terms <= 0) == 0) {\n                b_cumulant = log (linear_terms) / link_power;\n                natural_parameters = - linear_terms ^ (- 1.0 / link_power);\n            } else {isNaN = 1;}\n        } else if                    (link_power ==  0) { # PowerDist.log\n            natural_parameters = exp (linear_terms * (1.0 - var_power)) / (1.0 - var_power);\n            b_cumulant = exp (linear_terms * (2.0 - var_power)) / (2.0 - var_power);\n        } else {                                              # PowerDist.power_nonlog\n            if          (-2 * link_power == 1.0 - var_power) {\n                natural_parameters = 1.0 / (linear_terms ^ 2) / (1.0 - var_power);\n            } else if (-1 * link_power == 1.0 - var_power) {\n                natural_parameters = 1.0 / linear_terms / (1.0 - var_power);\n            } else if (     link_power == 1.0 - var_power) {\n                natural_parameters = linear_terms / (1.0 - var_power);\n            } else if ( 2 * link_power == 1.0 - var_power) {\n                natural_parameters = linear_terms ^ 2 / (1.0 - var_power);\n            } else if (sum (linear_terms <= 0) == 0) {\n                power = (1.0 - var_power) / link_power;\n                natural_parameters = (linear_terms ^ power) / (1.0 - var_power);\n            } else {\n                isNaN = 1;\n            } \n            \n            if          (-2 * link_power == 2.0 - var_power) {\n                b_cumulant = 1.0 / (linear_terms ^ 2) / (2.0 - var_power);\n            } else if (-1 * link_power == 2.0 - var_power) {\n                b_cumulant = 1.0 / linear_terms / (2.0 - var_power);\n            } else if (     link_power == 2.0 - var_power) {\n                b_cumulant = linear_terms / (2.0 - var_power);\n            } else if ( 2 * link_power == 2.0 - var_power) {\n                b_cumulant = linear_terms ^ 2 / (2.0 - var_power);\n            } else if (sum (linear_terms <= 0) == 0) {\n                power = (2.0 - var_power) / link_power;\n                b_cumulant = (linear_terms ^ power) / (2.0 - var_power);\n            } else {\n                isNaN = 1;\n            }\n        }\n        if (sum (is_natural_parameter_log_zero * abs (Y)) > 0) {\n            log_l = -1.0 / 0.0;\n            isNaN = 1;\n        }\n        if (isNaN == 0)\n        {\n            log_l = sum (Y * natural_parameters - b_cumulant);\n            if (log_l != log_l | (log_l == log_l + 1.0 & log_l == log_l * 2.0)) {\n                log_l = -1.0 / 0.0;\n                isNaN = 1;\n    }   }   }\n    \n    if (dist_type == 2 & link_type >= 1 & link_type <= 5)\n    { # BINOMIAL/BERNOULLI DISTRIBUTION\n    \n        [Y_prob, isNaN] = binomial_probability_two_column (linear_terms, link_type, link_power);\n        \n        if (isNaN == 0) {\n            if( sum((Y_prob<=0) * abs(Y)) == 0 ) {\n                log_l = sum (Y * log (Y_prob * (1 - (Y_prob<=0)) + (Y_prob<=0)));\n                if (log_l != log_l | (log_l == log_l + 1.0 & log_l == log_l * 2.0)) {\n                    isNaN = 1;\n                }\n            } else {\n                log_l = -1.0 / 0.0;\n                isNaN = 1;\n    }   }   }\n    \n    if (isNaN == 1) {\n        log_l = - 1.0 / 0.0; \n    }\n}\n";
        return string;
    }
}

