/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.runtime.matrix.data.ConvolutionParameters;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;

public class LibMatrixDNNIm2ColHelper {
    private static final Log LOG = LogFactory.getLog((String)LibMatrixDNNIm2ColHelper.class.getName());

    private static void appendInputValueToIm2colOutput(MatrixBlock output, int cInput, int hInput, int wInput, double value, int R, int S, int P, int Q, int stride_h, int stride_w, int pad_h, int pad_w, boolean trans) {
        int RS = R * S;
        int rMax = Math.min(R - 1, hInput + pad_h);
        int sMin = Math.max(0, wInput + pad_w - Q * stride_w + 1);
        int sMax = Math.min(S - 1, wInput + pad_w);
        for (int rMin = Math.max(0, hInput + pad_h - P * stride_h + 1); (hInput - rMin + pad_h) % stride_h != 0 && rMin <= rMax; ++rMin) {
        }
        while ((wInput - sMin + pad_w) % stride_w != 0 && sMin <= sMax) {
            ++sMin;
        }
        for (int r = rMin; r <= rMax; r += stride_h) {
            int p = (hInput - r + pad_h) / stride_h;
            int pQ = p * Q;
            int outRowIndex = cInput * RS + r * S;
            for (int s = sMin; s <= sMax; s += stride_w) {
                int q = (wInput - s + pad_w) / stride_w;
                if (trans) {
                    output.appendValue(pQ + q, outRowIndex + s, value);
                    continue;
                }
                output.appendValue(outRowIndex + s, pQ + q, value);
            }
        }
    }

    private static void appendInputValueToIm2colOutputSimple(MatrixBlock output, int c, int h, int w, double value, int R, int S, int RS, int P, boolean trans) {
        int rMin = Math.max(0, h - P + 1);
        int rMax = Math.min(R - 1, h);
        int cix = c * RS + w + rMin * S;
        int p = h - rMin;
        while (p >= h - rMax) {
            output.appendValue(trans ? p : cix, trans ? cix : p, value);
            --p;
            cix += S;
        }
    }

    private static class SparseSparseIm2colWorker
    implements Im2colWorker {
        private final MatrixBlock input;
        private final MatrixBlock output;
        private final int S;
        private final int R;
        private final int P;
        private final int Q;
        private final int W;
        private final int HW;
        private final int stride_h;
        private final int stride_w;
        private final int pad_h;
        private final int pad_w;
        private final boolean trans;

        public SparseSparseIm2colWorker(MatrixBlock input, MatrixBlock im2ColOutBlock, ConvolutionParameters params, boolean trans) {
            this.input = input;
            this.output = im2ColOutBlock;
            this.HW = params.H * params.W;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.stride_h = params.stride_h;
            this.stride_w = params.stride_w;
            this.pad_h = params.pad_h;
            this.pad_w = params.pad_w;
            this.trans = trans;
        }

        @Override
        public void execute(int n) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n, int cInput) {
            this.output.reset();
            SparseBlock sblock = this.input.sparseBlock;
            if (sblock.isEmpty(n)) {
                return;
            }
            int apos = sblock.pos(n);
            int alen = sblock.size(n);
            int[] aix = sblock.indexes(n);
            double[] avals = sblock.values(n);
            for (int j = apos; j < apos + alen; ++j) {
                int chw = aix[j];
                if (cInput != chw / this.HW) continue;
                int hInput = (chw - cInput * this.HW) / this.W;
                int wInput = chw % this.W;
                LibMatrixDNNIm2ColHelper.appendInputValueToIm2colOutput(this.output, cInput, hInput, wInput, avals[j], this.R, this.S, this.P, this.Q, this.stride_h, this.stride_w, this.pad_h, this.pad_w, this.trans);
            }
            this.output.sortSparseRows();
        }
    }

    private static class SparseSparseIm2colWorkerAllChan
    implements Im2colWorker {
        private final MatrixBlock input;
        private final MatrixBlock output;
        private final int S;
        private final int R;
        private final int P;
        private final int Q;
        private final int W;
        private final int HW;
        private final int RS;
        private final int stride_h;
        private final int stride_w;
        private final int pad_h;
        private final int pad_w;
        private final boolean trans;
        private final boolean simple;

        public SparseSparseIm2colWorkerAllChan(MatrixBlock input, MatrixBlock im2ColOutBlock, ConvolutionParameters params, boolean trans) {
            this.input = input;
            this.output = im2ColOutBlock;
            this.HW = params.H * params.W;
            this.RS = params.R * params.S;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.stride_h = params.stride_h;
            this.stride_w = params.stride_w;
            this.pad_h = params.pad_h;
            this.pad_w = params.pad_w;
            this.trans = trans;
            boolean bl = this.simple = params.isStride1Pad0() && this.W == this.S && this.Q == 1;
            if (!input.isInSparseFormat()) {
                throw new RuntimeException("Incorrect operator selection. Expected dense input for SparseIm2colWorkerAllChannels");
            }
        }

        @Override
        public void execute(int n, int c) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n) {
            this.output.reset();
            SparseBlock sblock = this.input.sparseBlock;
            if (sblock.isEmpty(n)) {
                return;
            }
            int apos = sblock.pos(n);
            int alen = sblock.size(n);
            int[] aix = sblock.indexes(n);
            double[] avals = sblock.values(n);
            for (int j = apos; j < apos + alen; ++j) {
                int chw = aix[j];
                int cInput = chw / this.HW;
                int hInput = (chw - cInput * this.HW) / this.W;
                int wInput = chw % this.W;
                if (this.simple) {
                    LibMatrixDNNIm2ColHelper.appendInputValueToIm2colOutputSimple(this.output, cInput, hInput, wInput, avals[j], this.R, this.S, this.RS, this.P, this.trans);
                    continue;
                }
                LibMatrixDNNIm2ColHelper.appendInputValueToIm2colOutput(this.output, cInput, hInput, wInput, avals[j], this.R, this.S, this.P, this.Q, this.stride_h, this.stride_w, this.pad_h, this.pad_w, this.trans);
            }
            this.output.sortSparseRows();
        }
    }

    private static class DenseIm2colWorkerAllChannels
    implements Im2colWorker {
        private final double[] inputArray;
        private final double[] outputArray;
        private final int CRS;
        private final int S;
        private final int R;
        private final int P;
        private final int Q;
        private final int CHW;
        private final int H;
        private final int W;
        private final int stride_h;
        private final int stride_w;
        private final int pad_h;
        private final int pad_w;
        private final boolean trans;

        public DenseIm2colWorkerAllChannels(double[] inputArray, double[] outputArray, ConvolutionParameters params, boolean trans) {
            this.inputArray = inputArray;
            this.outputArray = outputArray;
            this.CRS = params.C * params.R * params.S;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.CHW = params.C * params.H * params.W;
            this.stride_h = params.stride_h;
            this.stride_w = params.stride_w;
            this.pad_h = params.pad_h;
            this.pad_w = params.pad_w;
            this.trans = trans;
        }

        @Override
        public void execute(int n, int c) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n) {
            Arrays.fill(this.outputArray, 0.0);
            int nOffset = n * this.CHW;
            for (int c = 0; c < this.CRS; ++c) {
                int wOffset = c % this.S;
                int hOffset = c / this.S % this.R;
                int cInput = c / this.R / this.S;
                for (int h = 0; h < this.P; ++h) {
                    int outOffset = this.trans ? c + h * this.Q * this.CRS : (c * this.P + h) * this.Q;
                    int hPadded = h * this.stride_h - this.pad_h + hOffset;
                    int inputOffset = nOffset + (cInput * this.H + hPadded) * this.W;
                    if (hPadded < 0 || hPadded >= this.H) continue;
                    for (int w = 0; w < this.Q; ++w) {
                        int wPadded = w * this.stride_w - this.pad_w + wOffset;
                        if (wPadded < 0 || wPadded >= this.W) continue;
                        this.outputArray[outOffset + (this.trans ? w * this.CRS : w)] = this.inputArray[inputOffset + wPadded];
                    }
                }
            }
        }
    }

    static class DenseIm2colWorker
    implements Im2colWorker {
        private final double[] inputArray;
        private final double[] outputArray;
        private final int S;
        private final int R;
        private final int P;
        private final int Q;
        private final int CHW;
        private final int H;
        private final int W;
        private final int stride_h;
        private final int stride_w;
        private final int pad_h;
        private final int pad_w;

        public DenseIm2colWorker(double[] inputArray, double[] outputArray, ConvolutionParameters params) {
            this.inputArray = inputArray;
            this.outputArray = outputArray;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.CHW = params.C * params.H * params.W;
            this.stride_h = params.stride_h;
            this.stride_w = params.stride_w;
            this.pad_h = params.pad_h;
            this.pad_w = params.pad_w;
        }

        @Override
        public void execute(int n) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n, int cInput) {
            int nOffset = n * this.CHW;
            int RS = this.R * this.S;
            for (int rs = 0; rs < RS; ++rs) {
                int wOffset = rs % this.S;
                int hOffset = rs / this.S;
                for (int h = 0; h < this.P; ++h) {
                    int outOffset = (rs * this.P + h) * this.Q;
                    int hPadded = h * this.stride_h - this.pad_h + hOffset;
                    int inputOffset = nOffset + (cInput * this.H + hPadded) * this.W;
                    if (hPadded < 0 || hPadded >= this.H) {
                        Arrays.fill(this.outputArray, outOffset, outOffset + this.Q, 0.0);
                        continue;
                    }
                    for (int w = 0; w < this.Q; ++w) {
                        int wPadded = w * this.stride_w - this.pad_w + wOffset;
                        boolean assign = wPadded >= 0 && wPadded < this.W;
                        this.outputArray[outOffset + w] = assign ? this.inputArray[inputOffset + wPadded] : 0.0;
                    }
                }
            }
        }
    }

    static class DenseIm2colWorkerStride1Pad0AllChannels
    implements Im2colWorker {
        private final double[] inputArray;
        private final double[] outputArray;
        private final int CRS;
        private final int S;
        private final int R;
        private final int P;
        private final int Q;
        private final int CHW;
        private final int H;
        private final int W;

        public DenseIm2colWorkerStride1Pad0AllChannels(double[] inputArray, double[] outputArray, ConvolutionParameters params) {
            this.inputArray = inputArray;
            this.outputArray = outputArray;
            this.CRS = params.C * params.R * params.S;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.CHW = params.C * params.H * params.W;
        }

        @Override
        public void execute(int n, int c) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n) {
            int nOffset = n * this.CHW;
            for (int c = 0; c < this.CRS; ++c) {
                int wOffset = c % this.S;
                int hOffset = c / this.S % this.R;
                int cInput = c / this.R / this.S;
                for (int h = 0; h < this.P; ++h) {
                    int hPadded = h + hOffset;
                    int outOffset = (c * this.P + h) * this.Q;
                    int inputOffset = nOffset + (cInput * this.H + hPadded) * this.W;
                    System.arraycopy(this.inputArray, inputOffset + wOffset, this.outputArray, outOffset, this.Q);
                    int w = this.Q - 1;
                    int wPadded = w + wOffset;
                    boolean assign = hPadded < this.H && wPadded < this.W;
                    this.outputArray[outOffset + w] = assign ? this.inputArray[inputOffset + wPadded] : 0.0;
                }
            }
        }
    }

    static class DenseIm2colWorkerStride1Pad0
    implements Im2colWorker {
        private final double[] inputArray;
        private final double[] outputArray;
        private final int S;
        private final int R;
        private final int P;
        private final int Q;
        private final int CHW;
        private final int H;
        private final int W;

        public DenseIm2colWorkerStride1Pad0(double[] inputArray, double[] outputArray, ConvolutionParameters params) {
            this.inputArray = inputArray;
            this.outputArray = outputArray;
            this.H = params.H;
            this.W = params.W;
            this.R = params.R;
            this.S = params.S;
            this.P = params.P;
            this.Q = params.Q;
            this.CHW = params.C * params.H * params.W;
        }

        @Override
        public void execute(int n) {
            throw new RuntimeException("Not supported");
        }

        @Override
        public void execute(int n, int cInput) {
            int nOffset = n * this.CHW;
            int RS = this.R * this.S;
            for (int rs = 0; rs < RS; ++rs) {
                int wOffset = rs % this.S;
                int hOffset = rs / this.S;
                for (int h = 0; h < this.P; ++h) {
                    int hPadded = h + hOffset;
                    int outOffset = (rs * this.P + h) * this.Q;
                    int inputOffset = nOffset + (cInput * this.H + hPadded) * this.W;
                    System.arraycopy(this.inputArray, inputOffset + wOffset, this.outputArray, outOffset, this.Q);
                    int w = this.Q - 1;
                    int wPadded = w + wOffset;
                    boolean assign = hPadded < this.H && wPadded < this.W;
                    this.outputArray[outOffset + w] = assign ? this.inputArray[inputOffset + wPadded] : 0.0;
                }
            }
        }
    }

    static interface Im2colWorker {
        public void execute(int var1);

        public void execute(int var1, int var2);

        public static Im2colWorker getWorker(MatrixBlock input, MatrixBlock out, ConvolutionParameters params, boolean allChannels, boolean trans) {
            if (!input.isInSparseFormat()) {
                boolean stride1Pad0 = params.stride_h == 1 && params.stride_w == 1 && params.pad_h == 0 && params.pad_w == 0;
                out.reset(out.rlen, out.clen, false);
                out.allocateDenseBlock();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Using DenseIm2colWorkerAllChannels operator to perform im2col (stride1pad0=" + stride1Pad0 + ", allChannels=" + allChannels + ")."));
                }
                if (allChannels && stride1Pad0 && !trans) {
                    return new DenseIm2colWorkerStride1Pad0AllChannels(input.getDenseBlock(), out.getDenseBlock(), params);
                }
                if (allChannels) {
                    return new DenseIm2colWorkerAllChannels(input.getDenseBlock(), out.getDenseBlock(), params, trans);
                }
                if (stride1Pad0) {
                    return new DenseIm2colWorkerStride1Pad0(input.getDenseBlock(), out.getDenseBlock(), params);
                }
                return new DenseIm2colWorker(input.getDenseBlock(), out.getDenseBlock(), params);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Using SparseIm2colWorker operator to perform im2col.");
            }
            out.reset(out.rlen, out.clen, true);
            out.allocateSparseRowsBlock();
            int estnnz = (int)Math.ceil(4.0 * input.getSparsity() * (double)out.clen);
            for (int r = 0; r < out.rlen; ++r) {
                out.getSparseBlock().allocate(r, Math.min(estnnz, out.clen));
            }
            return new SparseSparseIm2colWorkerAllChan(input, out, params, trans);
        }
    }
}

