/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.FrameWriter;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.util.MapReduceTool;

public class FrameWriterBinaryBlock
extends FrameWriter {
    @Override
    public final void writeFrameToHDFS(FrameBlock src, String fname, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        MapReduceTool.deleteFileIfExistOnHDFS(fname);
        if ((long)src.getNumRows() > rlen || (long)src.getNumColumns() > clen) {
            throw new IOException("Frame block [1:" + src.getNumRows() + ",1:" + src.getNumColumns() + "] out of overall frame range [1:" + rlen + ",1:" + clen + "].");
        }
        this.writeBinaryBlockFrameToHDFS(path, job, src, rlen, clen);
    }

    protected void writeBinaryBlockFrameToHDFS(Path path, JobConf job, FrameBlock src, long rlen, long clen) throws IOException, DMLRuntimeException {
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        int blen = ConfigurationManager.getBlocksize();
        FrameWriterBinaryBlock.writeBinaryBlockFrameToSequenceFile(path, job, fs, src, blen, 0, (int)rlen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeBinaryBlockFrameToSequenceFile(Path path, JobConf job, FileSystem fs, FrameBlock src, int blen, int rl, int ru) throws DMLRuntimeException, IOException {
        SequenceFile.Writer writer = null;
        writer = new SequenceFile.Writer(fs, (Configuration)job, path, LongWritable.class, FrameBlock.class);
        try {
            LongWritable index = new LongWritable();
            if (src.getNumRows() <= blen) {
                index.set(1L);
                writer.append((Writable)index, (Writable)src);
            } else {
                FrameBlock[] blocks = FrameWriterBinaryBlock.createFrameBlocksForReuse(src.getSchema(), src.getColumnNames(), src.getNumRows());
                for (int bi = rl; bi < ru; bi += blen) {
                    int len = Math.min(blen, src.getNumRows() - bi);
                    FrameBlock block = FrameWriterBinaryBlock.getFrameBlockForReuse(blocks);
                    src.sliceOperations(bi, bi + len - 1, 0, src.getNumColumns() - 1, block);
                    if (bi == 0) {
                        block.setColumnMetadata(src.getColumnMetadata());
                    }
                    index.set((long)(bi + 1));
                    writer.append((Writable)index, (Writable)block);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }
}

