/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.Arrays;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.MatrixBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public abstract class BuiltinUnaryCPInstruction
extends UnaryCPInstruction {
    protected BuiltinUnaryCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.BuiltinUnary, op, in, out, opcode, istr);
    }

    public static BuiltinUnaryCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = null;
        Builtin func = null;
        if (parts.length == 4) {
            opcode = parts[0];
            in.split(parts[1]);
            out.split(parts[2]);
            func = Builtin.getBuiltinFnObject(opcode);
            if (Arrays.asList("ucumk+", "ucum*", "ucummin", "ucummax").contains(opcode)) {
                return new MatrixBuiltinCPInstruction(new UnaryOperator(func, Integer.parseInt(parts[3])), in, out, opcode, str);
            }
            return new ScalarBuiltinCPInstruction(new SimpleOperator(func), in, out, opcode, str);
        }
        opcode = BuiltinUnaryCPInstruction.parseUnaryInstruction(str, in, out);
        func = Builtin.getBuiltinFnObject(opcode);
        if (in.getDataType() == Expression.DataType.SCALAR) {
            return new ScalarBuiltinCPInstruction(new SimpleOperator(func), in, out, opcode, str);
        }
        if (in.getDataType() == Expression.DataType.MATRIX) {
            return new MatrixBuiltinCPInstruction(new UnaryOperator(func), in, out, opcode, str);
        }
        return null;
    }
}

