/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.util.Cell;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.FastStringTokenizer;

public class StagingFileUtils {
    public static final int CELL_BUFFER_SIZE = 100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCellListToLocal(String fname, LinkedList<Cell> buffer) throws IOException {
        FileOutputStream fos = new FileOutputStream(fname, true);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(fos));
        try {
            StringBuilder sb = new StringBuilder();
            for (Cell c : buffer) {
                sb.append(c.getRow());
                sb.append(' ');
                sb.append(c.getCol());
                sb.append(' ');
                sb.append(c.getValue());
                sb.append('\n');
                out.write(sb.toString());
                sb.setLength(0);
            }
        }
        finally {
            IOUtilFunctions.closeSilently(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeKeyMappingToLocal(String fname, long[][] keys) throws IOException {
        FileOutputStream fos = new FileOutputStream(fname, true);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(fos));
        try {
            StringBuilder sb = new StringBuilder();
            for (long[] key : keys) {
                sb.append(key[0]);
                sb.append(' ');
                sb.append(key[1]);
                sb.append('\n');
                out.write(sb.toString());
                sb.setLength(0);
            }
        }
        finally {
            IOUtilFunctions.closeSilently(out);
        }
    }

    public static BufferedReader openKeyMap(String name) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(name);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        return in;
    }

    public static void nextKeyMap(BufferedReader in, HashMap<Integer, HashMap<Long, Long>> map, int bi, int blen) throws NumberFormatException, IOException {
        String value = null;
        FastStringTokenizer st = new FastStringTokenizer(' ');
        while ((value = in.readLine()) != null) {
            st.reset(value);
            long row1 = st.nextLong();
            long row2 = st.nextLong();
            int id = (int)row1 / blen;
            if (!map.containsKey(id)) {
                map.put(id, new HashMap());
            }
            map.get(id).put(row1, row2);
            if (id <= bi) continue;
            break;
        }
    }

    public static int nextSizedKeyMap(BufferedReader in, HashMap<Integer, HashMap<Long, Long>> map, int blen, int size) throws NumberFormatException, IOException {
        map.clear();
        String value = null;
        int len = 0;
        FastStringTokenizer st = new FastStringTokenizer(' ');
        while ((value = in.readLine()) != null) {
            st.reset(value);
            long row1 = st.nextLong();
            long row2 = st.nextLong();
            int id = (int)row1 / blen;
            if (!map.containsKey(id)) {
                map.put(id, new HashMap());
            }
            map.get(id).put(row1, row2);
            if (++len < size) continue;
            break;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<Cell> readCellListFromLocal(String fname) throws IOException {
        FileInputStream fis = new FileInputStream(fname);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        LinkedList<Cell> buffer = new LinkedList<Cell>();
        try {
            String value = null;
            FastStringTokenizer st = new FastStringTokenizer(' ');
            while ((value = in.readLine()) != null) {
                st.reset(value);
                long row = st.nextLong();
                long col = st.nextLong();
                double lvalue = st.nextDouble();
                Cell c = new Cell(row, col, lvalue);
                buffer.addLast(c);
            }
        }
        finally {
            IOUtilFunctions.closeSilently(in);
        }
        return buffer;
    }

    public static MatrixBlock readCellList2BlockFromLocal(String fname, int brlen, int bclen) throws IOException, DMLRuntimeException {
        return StagingFileUtils.readCellList2BlockFromLocal(fname, brlen, bclen, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MatrixBlock readCellList2BlockFromLocal(String fname, int brlen, int bclen, boolean sparse) throws IOException, DMLRuntimeException {
        MatrixBlock tmp = new MatrixBlock(brlen, bclen, sparse);
        if (!sparse) {
            tmp.allocateDenseBlockUnsafe(brlen, bclen);
        }
        FileInputStream fis = new FileInputStream(fname);
        BufferedReader in = new BufferedReader(new InputStreamReader(fis));
        FastStringTokenizer st = new FastStringTokenizer(' ');
        try {
            String value = null;
            if (sparse) {
                while ((value = in.readLine()) != null) {
                    st.reset(value);
                    int row = st.nextInt();
                    int col = st.nextInt();
                    double lvalue = st.nextDouble();
                    tmp.quickSetValue(row, col, lvalue);
                }
            } else {
                while ((value = in.readLine()) != null) {
                    st.reset(value);
                    int row = st.nextInt();
                    int col = st.nextInt();
                    double lvalue = st.nextDouble();
                    tmp.setValueDenseUnsafe(row, col, lvalue);
                }
                tmp.recomputeNonZeros();
            }
        }
        finally {
            IOUtilFunctions.closeSilently(in);
        }
        tmp.examSparsity();
        return tmp;
    }
}

