/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;

public abstract class ColGroup
implements Serializable {
    private static final long serialVersionUID = 2439785418908671481L;
    protected int[] _colIndexes;
    protected int _numRows;

    protected ColGroup(int[] colIndices, int numRows) {
        this._colIndexes = colIndices;
        this._numRows = numRows;
    }

    protected ColGroup(List<Integer> colIndicesList, int numRows) {
        this._colIndexes = new int[colIndicesList.size()];
        int i = 0;
        for (Integer index : colIndicesList) {
            this._colIndexes[i++] = index;
        }
        this._numRows = numRows;
    }

    public int[] getColIndices() {
        return this._colIndexes;
    }

    public int getColIndex(int colNum) {
        return this._colIndexes[colNum];
    }

    public int getNumRows() {
        return this._numRows;
    }

    public int getNumCols() {
        return this._colIndexes.length;
    }

    public abstract CompressionType getCompType();

    public void shiftColIndices(int offset) {
        int i = 0;
        while (i < this._colIndexes.length) {
            int n = i++;
            this._colIndexes[n] = this._colIndexes[n] + offset;
        }
    }

    public long estimateInMemorySize() {
        long size = 24L;
        return this._colIndexes == null ? size : size + 32L + (long)(4 * this._colIndexes.length);
    }

    public abstract void decompressToBlock(MatrixBlock var1, int var2, int var3);

    public abstract void decompressToBlock(MatrixBlock var1, int[] var2);

    public abstract void decompressToBlock(MatrixBlock var1, int var2);

    public abstract void write(DataOutput var1) throws IOException;

    public abstract void readFields(DataInput var1) throws IOException;

    public abstract long getExactSizeOnDisk();

    public abstract double get(int var1, int var2);

    public abstract void rightMultByVector(MatrixBlock var1, MatrixBlock var2, int var3, int var4) throws DMLRuntimeException;

    public abstract void leftMultByRowVector(MatrixBlock var1, MatrixBlock var2) throws DMLRuntimeException;

    public abstract ColGroup scalarOperation(ScalarOperator var1) throws DMLRuntimeException;

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, MatrixBlock var2) throws DMLRuntimeException;

    public abstract Iterator<IJV> getIterator(int var1, int var2, boolean var3, boolean var4);

    public abstract ColGroupRowIterator getRowIterator(int var1, int var2);

    protected abstract void countNonZerosPerRow(int[] var1, int var2, int var3);

    protected abstract class ColGroupRowIterator {
        protected ColGroupRowIterator() {
        }

        public abstract void next(double[] var1, int var2, int var3, boolean var4);
    }

    public static enum CompressionType {
        UNCOMPRESSED,
        RLE_BITMAP,
        OLE_BITMAP,
        DDC1,
        DDC2;

    }
}

