/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class UnaryCP
extends Lop {
    public static final String CAST_AS_SCALAR_OPCODE = "castdts";
    public static final String CAST_AS_MATRIX_OPCODE = "castdtm";
    public static final String CAST_AS_FRAME_OPCODE = "castdtf";
    public static final String CAST_AS_DOUBLE_OPCODE = "castvtd";
    public static final String CAST_AS_INT_OPCODE = "castvti";
    public static final String CAST_AS_BOOLEAN_OPCODE = "castvtb";
    OperationTypes operation;

    public UnaryCP(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.UnaryCP, dt, vt);
        this.operation = op;
        this.addInput(input);
        input.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    public UnaryCP(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt) {
        this(input, op, dt, vt, LopProperties.ExecType.CP);
    }

    @Override
    public String toString() {
        return "Operation: " + (Object)((Object)this.operation);
    }

    private String getOpCode() throws LopsException {
        switch (this.operation) {
            case NOT: {
                return "!";
            }
            case ABS: {
                return "abs";
            }
            case SIN: {
                return "sin";
            }
            case COS: {
                return "cos";
            }
            case TAN: {
                return "tan";
            }
            case ASIN: {
                return "asin";
            }
            case ACOS: {
                return "acos";
            }
            case ATAN: {
                return "atan";
            }
            case SINH: {
                return "sinh";
            }
            case COSH: {
                return "cosh";
            }
            case TANH: {
                return "tanh";
            }
            case SQRT: {
                return "sqrt";
            }
            case LOG: {
                return "log";
            }
            case ROUND: {
                return "round";
            }
            case EXP: {
                return "exp";
            }
            case PRINT: {
                return "print";
            }
            case CAST_AS_MATRIX: {
                return CAST_AS_MATRIX_OPCODE;
            }
            case CAST_AS_FRAME: {
                return CAST_AS_FRAME_OPCODE;
            }
            case STOP: {
                return "stop";
            }
            case CEIL: {
                return "ceil";
            }
            case FLOOR: {
                return "floor";
            }
            case CUMSUM: {
                return "ucumk+";
            }
            case CAST_AS_SCALAR: {
                return CAST_AS_SCALAR_OPCODE;
            }
            case CAST_AS_DOUBLE: {
                return CAST_AS_DOUBLE_OPCODE;
            }
            case CAST_AS_INT: {
                return CAST_AS_INT_OPCODE;
            }
            case CAST_AS_BOOLEAN: {
                return CAST_AS_BOOLEAN_OPCODE;
            }
            case NROW: {
                return "nrow";
            }
            case NCOL: {
                return "ncol";
            }
            case LENGTH: {
                return "length";
            }
            case SOFTMAX: {
                return "softmax";
            }
        }
        throw new LopsException(this.printErrorLocation() + "Unknown operation: " + (Object)((Object)this.operation));
    }

    @Override
    public String getInstructions(String input, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpCode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    public static enum OperationTypes {
        NOT,
        ABS,
        SIN,
        COS,
        TAN,
        ASIN,
        ACOS,
        ATAN,
        SQRT,
        LOG,
        EXP,
        SINH,
        COSH,
        TANH,
        CAST_AS_SCALAR,
        CAST_AS_MATRIX,
        CAST_AS_FRAME,
        CAST_AS_DOUBLE,
        CAST_AS_INT,
        CAST_AS_BOOLEAN,
        PRINT,
        NROW,
        NCOL,
        LENGTH,
        ROUND,
        STOP,
        CEIL,
        FLOOR,
        CUMSUM,
        SOFTMAX;

    }
}

