/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Transform
extends Lop {
    private OperationTypes operation = null;
    private boolean _bSortIndInMem = false;
    private int _numThreads = 1;

    public Transform(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this(input, op, dt, vt, et, 1);
    }

    public Transform(Lop[] inputs, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this(inputs, op, dt, vt, et, 1);
    }

    public Transform(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Transform, dt, vt);
        this.init(new Lop[]{input}, op, dt, vt, et);
        this._numThreads = k;
    }

    public Transform(Lop[] inputs, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Transform, dt, vt);
        this.init(inputs, op, dt, vt, et);
        this._numThreads = k;
    }

    public Transform(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt) {
        super(Lop.Type.Transform, dt, vt);
        this.init(new Lop[]{input}, op, dt, vt, LopProperties.ExecType.MR);
    }

    public Transform(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, boolean bSortIndInMem) {
        super(Lop.Type.Transform, dt, vt);
        this._bSortIndInMem = bSortIndInMem;
        this.init(new Lop[]{input}, op, dt, vt, et);
    }

    public Transform(Lop[] inputs, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, boolean bSortIndInMem) {
        super(Lop.Type.Transform, dt, vt);
        this._bSortIndInMem = bSortIndInMem;
        this.init(inputs, op, dt, vt, et);
    }

    private void init(Lop[] input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        for (Lop in : input) {
            this.addInput(in);
            in.addOutput(this);
        }
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            this.lps.addCompatibility(JobType.CSV_REBLOCK);
            this.lps.addCompatibility(JobType.MMCJ);
            this.lps.addCompatibility(JobType.MMRJ);
            if (op == OperationTypes.Reshape) {
                this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
            } else {
                this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.MapOrReduce, breaksAlignment, aligner, definesMRJob);
            }
        } else {
            breaksAlignment = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this.operation);
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    private String getOpcode() {
        switch (this.operation) {
            case Transpose: {
                return "r'";
            }
            case Rev: {
                return "rev";
            }
            case Diag: {
                return "rdiag";
            }
            case Reshape: {
                return "rshape";
            }
            case Sort: {
                return "rsort";
            }
        }
        throw new UnsupportedOperationException(this.printErrorLocation() + "Instruction is not defined for Transform operation " + (Object)((Object)this.operation));
    }

    @Override
    public String getInstructions(String input1, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.CP && this.operation == OperationTypes.Transpose) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String input4, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        String[] inputX = new String[]{input2, input3, input4};
        for (int i = 1; i <= inputX.length; ++i) {
            Lop ltmp = this.getInputs().get(i);
            sb.append("\u00b0");
            sb.append(ltmp.prepScalarInputOperand(this.getExecType()));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.SPARK && this.operation == OperationTypes.Sort) {
            sb.append("\u00b0");
            sb.append(this._bSortIndInMem);
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index, int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int input_index4, int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        Lop input2 = this.getInputs().get(1);
        String rowsString = input2.prepScalarLabel();
        sb.append("\u00b0");
        sb.append(rowsString);
        Lop input3 = this.getInputs().get(2);
        String colsString = input3.prepScalarLabel();
        sb.append("\u00b0");
        sb.append(colsString);
        Lop input4 = this.getInputs().get(3);
        String byrowString = input4.prepScalarLabel();
        if (input4.getExecLocation() == LopProperties.ExecLocation.Data && !((Data)input4).isLiteral() || input4.getExecLocation() != LopProperties.ExecLocation.Data) {
            throw new LopsException(this.printErrorLocation() + "Parameter 'byRow' must be a literal for a matrix operation.");
        }
        sb.append("\u00b0");
        sb.append(byrowString);
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }

    public static enum OperationTypes {
        Transpose,
        Diag,
        Reshape,
        Sort,
        Rev;

    }
}

