/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.ipa;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.ipa.FunctionCallGraph;
import org.apache.sysml.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysml.hops.ipa.IPAPass;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;

public class IPAPassRemoveConstantBinaryOps
extends IPAPass {
    @Override
    public boolean isApplicable() {
        return true;
    }

    @Override
    public void rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) throws HopsException {
        HashMap<String, Hop> mOnes = new HashMap<String, Hop>();
        for (StatementBlock sb : prog.getStatementBlocks()) {
            for (String var : sb.variablesUpdated().getVariableNames()) {
                if (!mOnes.containsKey(var)) continue;
                mOnes.remove(var);
            }
            if (!mOnes.isEmpty()) {
                IPAPassRemoveConstantBinaryOps.rRemoveConstantBinaryOp(sb, mOnes);
            }
            if (sb instanceof IfStatementBlock || sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) continue;
            IPAPassRemoveConstantBinaryOps.collectMatrixOfOnes(sb.getHops(), mOnes);
        }
    }

    private static void collectMatrixOfOnes(ArrayList<Hop> roots, HashMap<String, Hop> mOnes) {
        if (roots == null) {
            return;
        }
        for (Hop root : roots) {
            if (!(root instanceof DataOp) || ((DataOp)root).getDataOpType() != Hop.DataOpTypes.TRANSIENTWRITE || !(root.getInput().get(0) instanceof DataGenOp) || ((DataGenOp)root.getInput().get(0)).getOp() != Hop.DataGenMethod.RAND || !((DataGenOp)root.getInput().get(0)).hasConstantValue(1.0)) continue;
            mOnes.put(root.getName(), root.getInput().get(0));
        }
    }

    private static void rRemoveConstantBinaryOp(StatementBlock sb, HashMap<String, Hop> mOnes) throws HopsException {
        block11: {
            block10: {
                if (!(sb instanceof IfStatementBlock)) break block10;
                IfStatementBlock isb = (IfStatementBlock)sb;
                IfStatement istmt = (IfStatement)isb.getStatement(0);
                for (StatementBlock c : istmt.getIfBody()) {
                    IPAPassRemoveConstantBinaryOps.rRemoveConstantBinaryOp(c, mOnes);
                }
                if (istmt.getElseBody() == null) break block11;
                for (StatementBlock c : istmt.getElseBody()) {
                    IPAPassRemoveConstantBinaryOps.rRemoveConstantBinaryOp(c, mOnes);
                }
                break block11;
            }
            if (sb instanceof WhileStatementBlock) {
                WhileStatementBlock wsb = (WhileStatementBlock)sb;
                WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
                for (StatementBlock c : wstmt.getBody()) {
                    IPAPassRemoveConstantBinaryOps.rRemoveConstantBinaryOp(c, mOnes);
                }
            } else if (sb instanceof ForStatementBlock) {
                ForStatementBlock fsb = (ForStatementBlock)sb;
                ForStatement fstmt = (ForStatement)fsb.getStatement(0);
                for (StatementBlock c : fstmt.getBody()) {
                    IPAPassRemoveConstantBinaryOps.rRemoveConstantBinaryOp(c, mOnes);
                }
            } else if (sb.getHops() != null) {
                Hop.resetVisitStatus(sb.getHops());
                for (Hop hop : sb.getHops()) {
                    IPAPassRemoveConstantBinaryOps.rRemoveConstantBinaryOp(hop, mOnes);
                }
            }
        }
    }

    private static void rRemoveConstantBinaryOp(Hop hop, HashMap<String, Hop> mOnes) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof BinaryOp && ((BinaryOp)hop).getOp() == Hop.OpOp2.MULT && !((BinaryOp)hop).isOuterVectorOperator() && hop.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hop.getInput().get(1) instanceof DataOp && mOnes.containsKey(hop.getInput().get(1).getName())) {
            HopRewriteUtils.removeChildReferenceByPos(hop, hop.getInput().get(1), 1);
            HopRewriteUtils.addChildReference(hop, new LiteralOp(1L), 1);
        }
        for (Hop c : hop.getInput()) {
            IPAPassRemoveConstantBinaryOps.rRemoveConstantBinaryOp(c, mOnes);
        }
        hop.setVisited();
    }
}

